/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.dal.cluster;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v2.exception.DbClusterNodeRecoverSeqnoException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoverSeqnoProcess {
    private static final Logger logger = LoggerFactory.getLogger(RecoverSeqnoProcess.class);
    public static final List<String> COMMON_ARGS = Arrays.asList("--no-defaults", "--console", "--wsrep_on=ON", "--wsrep-recover", "--wsrep_cluster_address=gcomm://");
    public static final String BASE_DIR_ARG_FORMAT = "--basedir=%s";
    public static final String DATA_DIR_ARG_FORMAT = "--datadir=%s";
    public static final String PORT_ARG_FORMAT = "--port=%s";
    public static final String SOCKER_ARG_FORMAT = "--socket=%s";
    public static final Pattern SEQNO_RECOVERED_OUTPUT_PATTERN = Pattern.compile(".*WSREP:\\s*Recovered\\s*position\\s*:\\s*[\\w-]+:(\\d+)");
    protected String baseDir;
    protected String dataDir;
    protected String port;
    protected String socket;
    protected String dbClusterLibLocation;
    protected String clusterName;
    protected String nodeAddress;
    protected List<String> additionalArgs;
    protected File workingDir;
    protected String cmd = "./mysqld";

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
        this.workingDir = new File(baseDir, "bin");
    }

    public void setDataDir(String dataDir) {
        this.dataDir = dataDir;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setSocket(String socket) {
        this.socket = socket;
    }

    public void setDbClusterLibLocation(String dbClusterLibLocation) {
        this.dbClusterLibLocation = dbClusterLibLocation;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setNodeAddress(String nodeAddress) {
        this.nodeAddress = nodeAddress;
    }

    public void setAdditionalArgs(List<String> additionalArgs) {
        this.additionalArgs = additionalArgs;
    }

    public long run() throws DbClusterNodeRecoverSeqnoException {
        Process process;
        LinkedList<String> args = new LinkedList<String>();
        args.add(this.cmd);
        args.addAll(COMMON_ARGS);
        args.add(String.format("--wsrep_provider=%s", this.dbClusterLibLocation));
        args.add(String.format("--wsrep_cluster_name=%s", this.clusterName));
        args.add(String.format("--wsrep_node_address=%s", this.nodeAddress));
        args.add(String.format(BASE_DIR_ARG_FORMAT, this.baseDir));
        args.add(String.format(DATA_DIR_ARG_FORMAT, this.dataDir));
        args.add(String.format(PORT_ARG_FORMAT, this.port));
        args.add(String.format(SOCKER_ARG_FORMAT, this.socket));
        args.addAll(this.additionalArgs);
        Long seqno = null;
        ProcessBuilder processBuilder = new ProcessBuilder(args);
        processBuilder.directory(this.workingDir);
        processBuilder.redirectErrorStream(true);
        logger.info("Recovering local DB cluster node seqno (cmd {})", (Object)StringUtils.join(args, (char)' '));
        try {
            process = processBuilder.start();
            process.waitFor();
        }
        catch (Exception e) {
            throw new DbClusterNodeRecoverSeqnoException("Error while running " + this.cmd + " process to recover DB cluster node seqno", e);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                Matcher seqnoRecoveredOutputMatcher;
                logger.info("{}: {}", (Object)this.cmd, (Object)line);
                if (seqno != null || !(seqnoRecoveredOutputMatcher = SEQNO_RECOVERED_OUTPUT_PATTERN.matcher(line.trim())).matches()) continue;
                seqno = new Long(seqnoRecoveredOutputMatcher.group(1));
            }
        }
        catch (Exception e) {
            throw new DbClusterNodeRecoverSeqnoException("Error while reading output of " + this.cmd + " process to recover DB cluster node seqno", e);
        }
        if (process.exitValue() != 0) {
            throw new DbClusterNodeRecoverSeqnoException("Command " + this.cmd + " exited with non-success status " + process.exitValue());
        }
        if (seqno == null) {
            throw new DbClusterNodeRecoverSeqnoException("No DB cluster node seqno found, check the process output for errors");
        }
        logger.info("DB cluster node seqno: {}", seqno);
        return seqno;
    }
}

