/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.deployment;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.interpol.ConfigurationInterpolator;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.collections.MapUtils;
import org.craftercms.commons.rest.RestTemplate;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.deployment.Deployer;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.web.client.RestClientException;

public abstract class AbstractDeployer
implements Deployer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDeployer.class);
    protected RestTemplate restTemplate = new RestTemplate();
    protected StudioConfiguration studioConfiguration;

    public AbstractDeployer() {
        this.restTemplate.setErrorResponseType(Map.class);
        this.restTemplate.init();
    }

    @Required
    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    protected void doCreateTarget(String site, String environment, String searchEngine, String template, boolean replace, boolean disableDeployCron, String localRepoPath, String repoUrl, HierarchicalConfiguration<ImmutableNode> additionalParams) throws IllegalStateException, RestClientException {
        String requestUrl = this.getCreateTargetUrl();
        Map<String, Object> requestBody = this.getCreateTargetRequestBody(site, environment, searchEngine, template, replace, disableDeployCron, localRepoPath, repoUrl, additionalParams);
        try {
            RequestEntity requestEntity = RequestEntity.post((URI)new URI(requestUrl)).contentType(MediaType.APPLICATION_JSON).body(requestBody);
            logger.debug("Calling create target API: {0}", requestEntity);
            this.restTemplate.exchange(requestEntity, Map.class);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Invalid format of create target URL: " + requestUrl, e);
        }
    }

    protected void doDeleteTarget(String site, String environment) {
        String requestUrl = this.getDeleteTargetUrl(site, environment);
        try {
            RequestEntity requestEntity = RequestEntity.post((URI)new URI(requestUrl)).contentType(MediaType.APPLICATION_JSON).build();
            logger.debug("Calling delete target API: {0}", requestEntity);
            this.restTemplate.exchange(requestEntity, Map.class);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Invalid format of create target URL: " + requestUrl, e);
        }
    }

    protected Map<String, Object> getCreateTargetRequestBody(String site, String environment, String searchEngine, String template, boolean replace, boolean disableDeployCron, String localRepoPath, String repoUrl, HierarchicalConfiguration<ImmutableNode> additionalParams) {
        LinkedHashMap<String, Object> requestBody = new LinkedHashMap<String, Object>();
        requestBody.put("env", environment);
        requestBody.put("site_name", site);
        requestBody.put("template_name", template);
        requestBody.put("replace", replace);
        requestBody.put("disable_deploy_cron", disableDeployCron);
        if (StringUtils.equals((CharSequence)"CrafterSearch", (CharSequence)searchEngine)) {
            requestBody.put("use_crafter_search", true);
        }
        if (StringUtils.isNotEmpty((CharSequence)localRepoPath)) {
            requestBody.put("local_repo_path", localRepoPath);
        }
        if (StringUtils.isNotEmpty((CharSequence)repoUrl)) {
            requestBody.put("repo_url", repoUrl);
        }
        if (additionalParams != null) {
            this.addAdditionalParams(requestBody, additionalParams);
        }
        return requestBody;
    }

    protected void addAdditionalParams(Map<String, Object> params, HierarchicalConfiguration<ImmutableNode> additionalParams) {
        this.addChildParams(params, (ImmutableNode)additionalParams.getNodeModel().getNodeHandler().getRootNode(), additionalParams.getInterpolator());
    }

    protected void addChildParams(Map<String, Object> childParams, ImmutableNode parentNode, ConfigurationInterpolator interpolator) {
        for (ImmutableNode childParamNode : parentNode.getChildren()) {
            if (childParamNode.getChildren().isEmpty()) {
                Object value = interpolator.interpolate(childParamNode.getValue());
                MapUtils.add(childParams, (Object)childParamNode.getNodeName(), (Object)value);
                continue;
            }
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            this.addChildParams(params, childParamNode, interpolator);
            MapUtils.add(childParams, (Object)childParamNode.getNodeName(), params);
        }
    }

    protected String getRepoUrl(String configKey, String site) {
        String repoUrl = this.studioConfiguration.getProperty(configKey);
        if (StringUtils.isNotEmpty((CharSequence)repoUrl)) {
            repoUrl = repoUrl.replaceAll("\\{siteName\\}", site);
            try {
                return new URI(repoUrl).normalize().toString();
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("Invalid format of URL for config key '" + configKey + "': " + repoUrl, e);
            }
        }
        return "";
    }

    protected abstract String getCreateTargetUrl();

    protected abstract String getDeleteTargetUrl(String var1, String var2);
}

