/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.deployment;

import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.deployment.Deployer;
import org.craftercms.studio.impl.v2.deployment.AbstractDeployer;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.client.RestClientException;

public class CompositeDeployer
implements Deployer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDeployer.class);
    private List<Deployer> deployers;

    @Required
    public void setDeployers(List<Deployer> deployers) {
        this.deployers = deployers;
    }

    @Override
    public void createTargets(String site, String searchEngine) throws RestClientException {
        if (CollectionUtils.isNotEmpty(this.deployers)) {
            try {
                for (Deployer deployer : this.deployers) {
                    deployer.createTargets(site, searchEngine);
                }
            }
            catch (Exception e) {
                for (Deployer deployer : this.deployers) {
                    try {
                        deployer.deleteTargets(site);
                    }
                    catch (Exception ex) {
                        logger.debug("Error while rolling back targets for site {0}: {1}", site, ex);
                    }
                }
                throw e;
            }
        }
    }

    @Override
    public void deleteTargets(String site) throws RestClientException {
        if (CollectionUtils.isNotEmpty(this.deployers)) {
            for (Deployer deployer : this.deployers) {
                deployer.deleteTargets(site);
            }
        }
    }
}

