/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.deployment;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.craftercms.commons.rest.RestServiceException;
import org.craftercms.studio.api.v1.ebus.EventListener;
import org.craftercms.studio.api.v1.ebus.PreviewEventContext;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.event.EventService;
import org.craftercms.studio.impl.v2.deployment.AbstractDeployer;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.web.client.RestClientException;

public class PreviewDeployer
extends AbstractDeployer
implements BeanNameAware {
    private static final Logger logger = LoggerFactory.getLogger(PreviewDeployer.class);
    private static final String METHOD_PREVIEW_SYNC_LISTENER = "onPreviewSync";
    private static final String ENV_PREVIEW = "preview";
    private static final String ENV_AUTHORING = "authoring";
    protected EventService eventService;
    protected String beanName;

    @Required
    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void subscribeToPreviewSyncEvents() {
        try {
            Method subscribeMethod = PreviewDeployer.class.getMethod(METHOD_PREVIEW_SYNC_LISTENER, PreviewEventContext.class);
            this.eventService.subscribe("studio.event.previewSync", this.beanName, subscribeMethod);
        }
        catch (NoSuchMethodException e) {
            logger.error("Could not subscribe to preview sync events", e, new Object[0]);
        }
    }

    @EventListener(value={"studio.event.previewSync"})
    public void onPreviewSync(PreviewEventContext context) {
        this.doDeployment(context.getSite(), ENV_AUTHORING, false);
        this.doDeployment(context.getSite(), ENV_PREVIEW, context.isWaitTillDeploymentIsDone());
    }

    @Override
    public void createTargets(String site, String searchEngine) throws RestClientException {
        this.doCreateAuthTarget(site);
        this.doCreatePreviewTarget(site, searchEngine);
    }

    @Override
    public void deleteTargets(String site) throws RestClientException {
        this.doDeleteTarget(site, ENV_AUTHORING);
        this.doDeleteTarget(site, ENV_PREVIEW);
    }

    protected void doDeployment(String site, String environment, boolean waitTillDone) {
        String requestUrl = this.getDeployTargetUrl(site, environment);
        Map<String, Boolean> requestBody = Collections.singletonMap("wait_till_done", waitTillDone);
        try {
            RequestEntity requestEntity = RequestEntity.post((URI)new URI(requestUrl)).contentType(MediaType.APPLICATION_JSON).body(requestBody);
            logger.debug("Calling deployment API: {0}", requestEntity);
            this.restTemplate.exchange(requestEntity, Map.class);
        }
        catch (RestServiceException e) {
            logger.error("Preview sync request for site " + site + " returned error response: " + (Object)((Object)e), new Object[0]);
        }
        catch (Exception e) {
            logger.error("Error while sending preview sync request for site " + site, e, new Object[0]);
        }
    }

    protected void doCreateAuthTarget(String site) throws IllegalStateException, RestClientException {
        String repoUrl = this.getRepoUrl("studio.preview.repoUrl", site);
        String template = this.studioConfiguration.getProperty("studio.authoring.templateName");
        boolean replace = this.studioConfiguration.getProperty("studio.authoring.replace", Boolean.class, false);
        boolean disableCron = this.studioConfiguration.getProperty("studio.authoring.disableDeployCron", Boolean.class, false);
        this.doCreateTarget(site, ENV_AUTHORING, "Elasticsearch", template, replace, disableCron, null, repoUrl, null);
    }

    protected void doCreatePreviewTarget(String site, String searchEngine) throws IllegalStateException, RestClientException {
        String repoUrl = this.getRepoUrl("studio.preview.repoUrl", site);
        String template = this.studioConfiguration.getProperty("studio.preview.templateName");
        boolean replace = this.studioConfiguration.getProperty("studio.preview.replace", Boolean.class, false);
        boolean disableCron = this.studioConfiguration.getProperty("studio.preview.disableDeployCron", Boolean.class, false);
        this.doCreateTarget(site, ENV_PREVIEW, searchEngine, template, replace, disableCron, null, repoUrl, null);
    }

    protected String getDeployTargetUrl(String site, String environment) {
        return this.studioConfiguration.getProperty("studio.preview.defaultPreviewDeployerUrl").replaceAll("\\{siteName\\}", site).replaceAll("\\{siteEnv\\}", environment);
    }

    @Override
    protected String getCreateTargetUrl() {
        return this.studioConfiguration.getProperty("studio.preview.createTargetUrl");
    }

    @Override
    protected String getDeleteTargetUrl(String site, String environment) {
        return this.studioConfiguration.getProperty("studio.preview.deleteTargetUrl").replaceAll("\\{siteName\\}", site).replaceAll("\\{siteEnv\\}", environment);
    }
}

