/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.deployment;

import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.craftercms.studio.impl.v2.deployment.AbstractDeployer;
import org.springframework.web.client.RestClientException;

public class ServerlessDeliveryDeployer
extends AbstractDeployer {
    private static final String ENV_SERVERLESS_DELIVERY = "serverless-delivery";

    @Override
    public void createTargets(String site, String searchEngine) throws RestClientException {
        if (this.isServerlessDeliveryEnabled()) {
            String localRepoPath = this.getRepoUrl("studio.serverless.delivery.deployer.target.localRepoPath", site);
            String repoUrl = this.getRepoUrl("studio.serverless.delivery.deployer.target.remoteRepoUrl", site);
            String template = this.studioConfiguration.getProperty("studio.serverless.delivery.deployer.target.template");
            boolean replace = this.studioConfiguration.getProperty("studio.serverless.delivery.deployer.target.replace", Boolean.class, false);
            HierarchicalConfiguration<ImmutableNode> templateParams = this.studioConfiguration.getSubConfig("studio.serverless.delivery.deployer.target.template.params");
            this.doCreateTarget(site, ENV_SERVERLESS_DELIVERY, searchEngine, template, replace, false, localRepoPath, repoUrl, templateParams);
        }
    }

    @Override
    public void deleteTargets(String site) throws RestClientException {
        if (this.isServerlessDeliveryEnabled()) {
            this.doDeleteTarget(site, ENV_SERVERLESS_DELIVERY);
        }
    }

    @Override
    protected String getCreateTargetUrl() {
        return this.studioConfiguration.getProperty("studio.serverless.delivery.deployer.target.createUrl");
    }

    @Override
    protected String getDeleteTargetUrl(String site, String environment) {
        return this.studioConfiguration.getProperty("studio.serverless.delivery.deployer.target.deleteUrl").replaceAll("\\{siteName\\}", site).replaceAll("\\{siteEnv\\}", environment);
    }

    protected boolean isServerlessDeliveryEnabled() {
        return this.studioConfiguration.getProperty("studio.serverless.delivery.enabled", Boolean.class, false);
    }
}

