/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.job;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.dal.SiteFeed;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v2.dal.AuditLog;
import org.craftercms.studio.api.v2.dal.GitLog;
import org.craftercms.studio.api.v2.dal.RepoOperation;
import org.craftercms.studio.api.v2.repository.ContentRepository;
import org.craftercms.studio.api.v2.service.audit.internal.AuditServiceInternal;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.impl.v2.job.StudioClockTask;

public class StudioAuditLogProcessingTask
extends StudioClockTask {
    private static final Logger logger = LoggerFactory.getLogger(StudioAuditLogProcessingTask.class);
    private AuditServiceInternal auditServiceInternal;
    private ContentRepository contentRepository;
    private int batchSizeGitLog = 1000;
    private int batchSizeAudited = 100;
    private ContentService contentService;

    public StudioAuditLogProcessingTask(int executeEveryNCycles, int offset, StudioConfiguration studioConfiguration, SiteService siteService, AuditServiceInternal auditServiceInternal, ContentRepository contentRepository, int batchSizeGitLog, int batchSizeAudited, ContentService contentService) {
        super(executeEveryNCycles, offset, studioConfiguration, siteService);
        this.auditServiceInternal = auditServiceInternal;
        this.contentRepository = contentRepository;
        this.batchSizeGitLog = batchSizeGitLog;
        this.batchSizeAudited = batchSizeAudited;
        this.contentService = contentService;
    }

    @Override
    protected void executeInternal(String site) {
        try {
            try {
                String siteState = this.siteService.getSiteState(site);
                if (StringUtils.equals((CharSequence)siteState, (CharSequence)"CREATED")) {
                    this.processAuditLog(site);
                }
            }
            catch (Exception e) {
                logger.error("Failed to process audit log from repository for site " + site, e, new Object[0]);
            }
        }
        catch (Exception e) {
            logger.error("Failed to process audit log from repository for site " + site, e, new Object[0]);
        }
    }

    private void processAuditLog(String site) throws SiteNotFoundException {
        String lastSyncedCommit;
        logger.debug("Getting last verified commit for site: " + site, new Object[0]);
        SiteFeed siteFeed = this.siteService.getSite(site);
        if (this.checkSiteUuid(site, siteFeed.getSiteUuid()) && StringUtils.isNotEmpty((CharSequence)(lastSyncedCommit = this.siteService.getLastSyncedGitlogCommitId(site)))) {
            logger.debug("Update gitlog for site " + site + " from last synced commit " + lastSyncedCommit, new Object[0]);
            this.contentRepository.updateGitlog(site, lastSyncedCommit, this.batchSizeGitLog);
            this.processAuditLogFromRepo(site, this.batchSizeAudited);
        }
    }

    private void processAuditLogFromRepo(String siteId, int batchSize) throws SiteNotFoundException {
        List<GitLog> unauditedGitlogs = this.contentRepository.getUnauditedCommits(siteId, batchSize);
        if (unauditedGitlogs != null) {
            SiteFeed siteFeed = this.siteService.getSite(siteId);
            for (GitLog gl : unauditedGitlogs) {
                if (this.contentRepository.commitIdExists(siteId, gl.getCommitId())) {
                    String prevCommitId = gl.getCommitId() + "~1";
                    List<RepoOperation> operations = this.contentRepository.getOperationsFromDelta(siteId, prevCommitId, gl.getCommitId());
                    block7: for (RepoOperation repoOperation : operations) {
                        HashMap<String, String> activityInfo = new HashMap<String, String>();
                        switch (repoOperation.getAction()) {
                            case CREATE: 
                            case COPY: {
                                String contentClass = this.contentService.getContentTypeClass(siteId, repoOperation.getPath());
                                if (repoOperation.getPath().endsWith(".xml")) {
                                    activityInfo.put("contentType", contentClass);
                                }
                                logger.debug("Insert audit log for site: " + siteId + " path: " + repoOperation.getPath(), new Object[0]);
                                AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
                                auditLog.setOperation("CREATE");
                                auditLog.setOperationTimestamp(repoOperation.getDateTime());
                                auditLog.setSiteId(siteFeed.getId());
                                auditLog.setActorId(repoOperation.getAuthor());
                                auditLog.setActorDetails(repoOperation.getAuthor());
                                auditLog.setPrimaryTargetId(siteId + ":" + repoOperation.getPath());
                                auditLog.setPrimaryTargetType("Content Item");
                                auditLog.setPrimaryTargetValue(repoOperation.getPath());
                                auditLog.setPrimaryTargetSubtype(this.contentService.getContentTypeClass(siteId, repoOperation.getPath()));
                                auditLog.setOrigin("GIT");
                                this.auditServiceInternal.insertAuditLog(auditLog);
                                continue block7;
                            }
                            case UPDATE: {
                                String contentClass = this.contentService.getContentTypeClass(siteId, repoOperation.getPath());
                                if (repoOperation.getPath().endsWith(".xml")) {
                                    activityInfo.put("contentType", contentClass);
                                }
                                logger.debug("Insert audit log for site: " + siteId + " path: " + repoOperation.getPath(), new Object[0]);
                                AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
                                auditLog.setOperation("UPDATE");
                                auditLog.setOperationTimestamp(repoOperation.getDateTime());
                                auditLog.setSiteId(siteFeed.getId());
                                auditLog.setActorId(repoOperation.getAuthor());
                                auditLog.setActorDetails(repoOperation.getAuthor());
                                auditLog.setOrigin("GIT");
                                auditLog.setPrimaryTargetId(siteId + ":" + repoOperation.getPath());
                                auditLog.setPrimaryTargetType("Content Item");
                                auditLog.setPrimaryTargetValue(repoOperation.getPath());
                                auditLog.setPrimaryTargetSubtype(this.contentService.getContentTypeClass(siteId, repoOperation.getPath()));
                                this.auditServiceInternal.insertAuditLog(auditLog);
                                continue block7;
                            }
                            case DELETE: {
                                String contentClass = this.contentService.getContentTypeClass(siteId, repoOperation.getPath());
                                if (repoOperation.getPath().endsWith(".xml")) {
                                    activityInfo.put("contentType", contentClass);
                                }
                                logger.debug("Insert audit log for site: " + siteId + " path: " + repoOperation.getPath(), new Object[0]);
                                AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
                                auditLog.setOperation("DELETE");
                                auditLog.setOperationTimestamp(repoOperation.getDateTime());
                                auditLog.setSiteId(siteFeed.getId());
                                auditLog.setOrigin("GIT");
                                auditLog.setActorId(repoOperation.getAuthor());
                                auditLog.setActorDetails(repoOperation.getAuthor());
                                auditLog.setPrimaryTargetId(siteId + ":" + repoOperation.getPath());
                                auditLog.setPrimaryTargetType("Content Item");
                                auditLog.setPrimaryTargetValue(repoOperation.getPath());
                                auditLog.setPrimaryTargetSubtype(this.contentService.getContentTypeClass(siteId, repoOperation.getPath()));
                                this.auditServiceInternal.insertAuditLog(auditLog);
                                continue block7;
                            }
                            case MOVE: {
                                String contentClass = this.contentService.getContentTypeClass(siteId, repoOperation.getMoveToPath());
                                if (repoOperation.getMoveToPath().endsWith(".xml")) {
                                    activityInfo.put("contentType", contentClass);
                                }
                                logger.debug("Insert audit log for site: " + siteId + " path: " + repoOperation.getMoveToPath(), new Object[0]);
                                AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
                                auditLog.setOperation("MOVE");
                                auditLog.setOperationTimestamp(repoOperation.getDateTime());
                                auditLog.setSiteId(siteFeed.getId());
                                auditLog.setActorId(repoOperation.getAuthor());
                                auditLog.setActorDetails(repoOperation.getAuthor());
                                auditLog.setOrigin("GIT");
                                auditLog.setPrimaryTargetId(siteId + ":" + repoOperation.getMoveToPath());
                                auditLog.setPrimaryTargetType("Content Item");
                                auditLog.setPrimaryTargetValue(repoOperation.getMoveToPath());
                                auditLog.setPrimaryTargetSubtype(this.contentService.getContentTypeClass(siteId, repoOperation.getMoveToPath()));
                                this.auditServiceInternal.insertAuditLog(auditLog);
                                continue block7;
                            }
                        }
                        logger.error("Error: Unknown repo operation for site " + siteId + " operation: " + (Object)((Object)repoOperation.getAction()), new Object[0]);
                    }
                }
                this.contentRepository.markGitLogAudited(siteId, gl.getCommitId());
            }
        }
    }

    private boolean checkSiteUuid(String siteId, String siteUuid) {
        boolean toRet = false;
        try {
            Path path = Paths.get(this.studioConfiguration.getProperty("studio.repo.basePath"), this.studioConfiguration.getProperty("studio.repo.sitesRepoBasePath"), siteId, "site-uuid.txt");
            List<String> lines = Files.readAllLines(path);
            for (String line : lines) {
                if (StringUtils.startsWith((CharSequence)line, (CharSequence)"#") || !StringUtils.equals((CharSequence)line, (CharSequence)siteUuid)) continue;
                toRet = true;
                break;
            }
        }
        catch (IOException e) {
            logger.info("Invalid site UUID. Local copy will not be deleted", new Object[0]);
        }
        return toRet;
    }
}

