/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.job;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.impl.v2.job.StudioClockTask;
import org.eclipse.jgit.api.DeleteBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.RemoteRemoveCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;

public abstract class StudioClockClusterTask
extends StudioClockTask {
    private static final Logger logger = LoggerFactory.getLogger(StudioClockClusterTask.class);
    protected ContentRepository contentRepository;

    protected abstract Path buildRepoPath(String var1);

    public StudioClockClusterTask(int executeEveryNCycles, int offset, StudioConfiguration studioConfiguration, SiteService siteService, ContentRepository contentRepository) {
        super(executeEveryNCycles, offset, studioConfiguration, siteService);
        this.contentRepository = contentRepository;
    }

    protected void removeRemote(Git git, String remoteName) throws GitAPIException {
        RemoteRemoveCommand remoteRemoveCommand = git.remoteRemove();
        remoteRemoveCommand.setRemoteName(remoteName);
        remoteRemoveCommand.call();
        List resultRemoteBranches = git.branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call();
        ArrayList<String> branchesToDelete = new ArrayList<String>();
        for (Ref remoteBranchRef : resultRemoteBranches) {
            if (!remoteBranchRef.getName().startsWith("refs/remotes/" + remoteName)) continue;
            branchesToDelete.add(remoteBranchRef.getName());
        }
        if (CollectionUtils.isNotEmpty(branchesToDelete)) {
            DeleteBranchCommand delBranch = git.branchDelete();
            String[] array = new String[branchesToDelete.size()];
            delBranch.setBranchNames(branchesToDelete.toArray(array));
            delBranch.setForce(true);
            delBranch.call();
        }
    }
}

