/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.job;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.craftercms.studio.api.v1.dal.SiteFeed;
import org.craftercms.studio.api.v1.job.Job;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.service.GeneralLockService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v2.deployment.Deployer;
import org.craftercms.studio.api.v2.job.SiteJob;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.impl.v2.job.StudioClusterPublishedRepoSyncTask;
import org.craftercms.studio.impl.v2.job.StudioClusterSandboxRepoSyncTask;
import org.springframework.core.task.TaskExecutor;

public class StudioClockExecutor
implements Job {
    private static final Logger logger = LoggerFactory.getLogger(StudioClockExecutor.class);
    private static final ReentrantLock singleWorkerLock = new ReentrantLock();
    private static final Map<String, ReentrantLock> singleWorkerSiteTasksLockMap = new HashMap<String, ReentrantLock>();
    private static final Map<String, String> deletedSitesMap = new HashMap<String, String>();
    private static boolean stopSignaled = false;
    private static boolean running = false;
    private StudioConfiguration studioConfiguration;
    private TaskExecutor taskExecutor;
    private SiteService siteService;
    private ContentRepository contentRepository;
    private Deployer deployer;
    private GeneralLockService generalLockService;
    private List<Job> globalTasks;
    private List<SiteJob> siteTasks;
    private static int threadCounter = 0;

    public static synchronized void signalToStop() {
        stopSignaled = true;
    }

    public static synchronized void signalToStart() {
        stopSignaled = false;
    }

    public static synchronized boolean isRunning() {
        return running;
    }

    public static synchronized void setRunning(boolean isRunning) {
        running = isRunning;
    }

    public StudioClockExecutor(StudioConfiguration studioConfiguration, TaskExecutor taskExecutor, SiteService siteService, ContentRepository contentRepository, Deployer deployer, GeneralLockService generalLockService, List<Job> globalTasks, List<SiteJob> siteTasks) {
        this.studioConfiguration = studioConfiguration;
        this.taskExecutor = taskExecutor;
        this.siteService = siteService;
        this.contentRepository = contentRepository;
        this.deployer = deployer;
        this.generalLockService = generalLockService;
        this.globalTasks = globalTasks;
        this.siteTasks = siteTasks;
    }

    @Override
    public void execute() {
        ++threadCounter;
        if (!stopSignaled && singleWorkerLock.tryLock()) {
            try {
                StudioClockExecutor.setRunning(true);
                logger.debug("Executing tasks thread num " + threadCounter, new Object[0]);
                this.executeTasks();
            }
            catch (Exception e) {
                logger.error("Error executing Studio Clock Job", e, new Object[0]);
            }
            finally {
                StudioClockExecutor.setRunning(false);
                singleWorkerLock.unlock();
            }
        }
    }

    private void executeTasks() {
        for (Job job : this.globalTasks) {
            job.execute();
        }
        this.cleanupDeletedSites();
        List<String> sites = this.siteService.getAllCreatedSites();
        for (final String site : sites) {
            this.taskExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String tasksLock = "{site}_STUDIO_CLOCK_EXECUTOR_SITE_LOCK".replaceAll("\\{site\\}", site);
                    if (StudioClockExecutor.this.generalLockService.tryLock(tasksLock)) {
                        try {
                            for (SiteJob siteTask : StudioClockExecutor.this.siteTasks) {
                                siteTask.execute(site);
                            }
                        }
                        finally {
                            StudioClockExecutor.this.generalLockService.unlock(tasksLock);
                        }
                    }
                }
            });
        }
    }

    private void cleanupDeletedSites() {
        logger.debug("Remove local copies of deleted sites if present", new Object[0]);
        List<SiteFeed> deletedSites = this.siteService.getDeletedSites();
        deletedSites.forEach(siteFeed -> {
            String key = siteFeed.getSiteId() + ":" + siteFeed.getSiteUuid();
            if (!deletedSitesMap.containsKey(key)) {
                if (this.contentRepository.contentExists(siteFeed.getName(), "/") && this.checkSiteUuid(siteFeed.getSiteId(), siteFeed.getSiteUuid())) {
                    this.deployer.deleteTargets(siteFeed.getName());
                    this.destroySitePreviewContext(siteFeed.getName());
                    this.contentRepository.deleteSite(siteFeed.getName());
                }
                StudioClusterSandboxRepoSyncTask.remotesMap.remove(siteFeed.getSiteId());
                StudioClusterPublishedRepoSyncTask.remotesMap.remove(siteFeed.getSiteId());
                deletedSitesMap.put(key, siteFeed.getName());
            }
        });
    }

    private boolean checkSiteUuid(String siteId, String siteUuid) {
        boolean toRet = false;
        try {
            Path path = Paths.get(this.studioConfiguration.getProperty("studio.repo.basePath"), this.studioConfiguration.getProperty("studio.repo.sitesRepoBasePath"), siteId, "site-uuid.txt");
            List<String> lines = Files.readAllLines(path);
            for (String line : lines) {
                if (StringUtils.startsWith((CharSequence)line, (CharSequence)"#") || !StringUtils.equals((CharSequence)line, (CharSequence)siteUuid)) continue;
                toRet = true;
                break;
            }
        }
        catch (IOException e) {
            logger.info("Invalid site UUID. Local copy will not be deleted", new Object[0]);
        }
        return toRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean destroySitePreviewContext(String site) {
        boolean toReturn = true;
        String requestUrl = this.getDestroySitePreviewContextUrl(site);
        HttpGet getRequest = new HttpGet(requestUrl);
        RequestConfig requestConfig = RequestConfig.custom().setExpectContinueEnabled(true).build();
        getRequest.setConfig(requestConfig);
        CloseableHttpClient client = HttpClientBuilder.create().build();
        try {
            CloseableHttpResponse response = client.execute((HttpUriRequest)getRequest);
            if (response.getStatusLine().getStatusCode() != 200) {
                toReturn = false;
            }
        }
        catch (IOException e) {
            logger.error("Error while sending destroy preview context request for site " + site, e, new Object[0]);
            toReturn = false;
        }
        finally {
            getRequest.releaseConnection();
        }
        return toReturn;
    }

    private String getDestroySitePreviewContextUrl(String site) {
        String url = this.studioConfiguration.getProperty("studio.configuration.site.preview.destroy.context.url");
        url = url.replaceAll("\\{siteName\\}", site);
        return url;
    }
}

