/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.job;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v2.job.SiteJob;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

public abstract class StudioClockTask
implements SiteJob {
    private static final Logger logger = LoggerFactory.getLogger(StudioClockTask.class);
    private int executeEveryNCycles;
    protected Map<String, Integer> counters;
    protected int offset;
    protected StudioConfiguration studioConfiguration;
    protected SiteService siteService;

    public StudioClockTask(int executeEveryNCycles, int offset, StudioConfiguration studioConfiguration, SiteService siteService) {
        this.executeEveryNCycles = executeEveryNCycles;
        this.counters = new HashMap<String, Integer>();
        this.offset = offset;
        this.studioConfiguration = studioConfiguration;
        this.siteService = siteService;
    }

    protected synchronized boolean checkCycleCounter(String site) {
        if (!this.counters.containsKey(site)) {
            this.setCycleCounter(site, this.executeEveryNCycles);
        }
        int counter = this.counters.get(site);
        this.setCycleCounter(site, --counter);
        return counter <= 0;
    }

    protected synchronized void setCycleCounter(String site, int counter) {
        this.counters.put(site, counter);
    }

    protected abstract void executeInternal(String var1);

    @Override
    public final void execute(String site) {
        logger.debug("Task Clock for: " + this.getClass().getName() + " site: " + site + " counter: " + this.counters.get(site) + " execute every: " + this.executeEveryNCycles, new Object[0]);
        if (this.checkCycleCounter(site)) {
            try {
                long sleepTime = (long)(Math.random() * (double)this.offset);
                logger.debug("Sleeping for offset " + sleepTime + " milliseconds", new Object[0]);
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                logger.debug("Woke up from random offset", new Object[0]);
            }
            this.executeInternal(site);
            this.setCycleCounter(site, this.executeEveryNCycles);
        }
    }

    protected boolean validateRepository(Repository repository) throws IOException {
        for (Ref ref : repository.getRefDatabase().getRefs()) {
            if (ref.getObjectId() == null) continue;
            return true;
        }
        return false;
    }
}

