/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.job;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.crypto.CryptoException;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteUrlException;
import org.craftercms.studio.api.v1.job.Job;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.service.GeneralLockService;
import org.craftercms.studio.api.v2.dal.ClusterMember;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.impl.v2.service.cluster.StudioClusterUtils;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.RemoteAddCommand;
import org.eclipse.jgit.api.RemoteSetUrlCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.URIish;

public class StudioClusterGlobalRepoSyncTask
implements Job {
    private static final Logger logger = LoggerFactory.getLogger(StudioClusterGlobalRepoSyncTask.class);
    private static Map<String, String> existingRemotes = new HashMap<String, String>();
    private int executeEveryNCycles;
    private int counter;
    private StudioClusterUtils studioClusterUtils;
    private StudioConfiguration studioConfiguration;
    private ContentRepository contentRepository;
    private GeneralLockService generalLockService;

    public StudioClusterGlobalRepoSyncTask(int executeEveryNCycles, StudioClusterUtils studioClusterUtils, StudioConfiguration studioConfiguration, ContentRepository contentRepository, GeneralLockService generalLockService) {
        this.executeEveryNCycles = executeEveryNCycles;
        this.counter = executeEveryNCycles;
        this.studioClusterUtils = studioClusterUtils;
        this.studioConfiguration = studioConfiguration;
        this.contentRepository = contentRepository;
        this.generalLockService = generalLockService;
    }

    private synchronized boolean checkCycleCounter() {
        return --this.counter <= 0;
    }

    @Override
    public void execute() {
        if (this.checkCycleCounter()) {
            this.executeInternal();
            this.counter = this.executeEveryNCycles;
        }
    }

    private void executeInternal() {
        long startTime;
        block7: {
            startTime = System.currentTimeMillis();
            logger.debug("Worker starts syncing cluster node global repo", new Object[0]);
            try {
                HierarchicalConfiguration<ImmutableNode> registrationData = this.studioClusterUtils.getClusterConfiguration();
                if (registrationData == null || registrationData.isEmpty()) break block7;
                String localAddress = this.studioClusterUtils.getClusterNodeLocalAddress();
                List<ClusterMember> clusterNodes = this.studioClusterUtils.getClusterNodes(localAddress);
                logger.debug("Check if global repository exists", new Object[0]);
                boolean success = true;
                if (!this.checkIfRepoExists()) {
                    success = this.cloneRepository(clusterNodes);
                }
                if (!success) break block7;
                try {
                    logger.debug("Add remotes for global repository", new Object[0]);
                    this.addRemotes(clusterNodes);
                }
                catch (CryptoException | ServiceLayerException | InvalidRemoteUrlException e) {
                    logger.error("Error while adding remotes on cluster node for global repo", (Exception)e, new Object[0]);
                }
                try {
                    logger.debug("Update content for global repo", new Object[0]);
                    this.updateContent(clusterNodes);
                }
                catch (IOException | CryptoException | ServiceLayerException e) {
                    logger.error("Error while updating content for global repo on cluster node.", (Exception)e, new Object[0]);
                }
            }
            catch (CryptoException | ServiceLayerException e) {
                logger.error("Error while cloning global repository from other nodes", (Exception)e, new Object[0]);
            }
        }
        long duration = System.currentTimeMillis() - startTime;
        logger.debug("Worker finished syncing cluster node for global repo", new Object[0]);
        logger.debug("Worker performed cluster node sync for global repo in " + duration + "ms", new Object[0]);
        logger.debug("Finished Cluster Node Sync task for global repo", new Object[0]);
    }

    private boolean checkIfRepoExists() {
        String firstCommitId = this.contentRepository.getRepoFirstCommitId("");
        return !StringUtils.isEmpty((CharSequence)firstCommitId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private boolean cloneRepository(List<ClusterMember> clusterNodes) throws CryptoException, ServiceLayerException {
        boolean cloned = false;
        int idx = 0;
        String gitLockKey = "GLOBAL_REPOSITORY_GIT_LOCK";
        if (!this.generalLockService.tryLock(gitLockKey)) {
            logger.debug("Failed to get lock " + gitLockKey, new Object[0]);
            return cloned;
        }
        try {
            while (!cloned) {
                if (idx >= clusterNodes.size()) return cloned;
                ClusterMember remoteNode = clusterNodes.get(idx++);
                logger.debug("Cloning global repository from " + remoteNode.getLocalAddress(), new Object[0]);
                Path siteSandboxPath = Paths.get(this.studioConfiguration.getProperty("studio.repo.basePath"), this.studioConfiguration.getProperty("studio.repo.globalRepoPath"));
                File localPath = siteSandboxPath.toFile();
                localPath.delete();
                logger.debug("Cloning from " + remoteNode.getGitUrl() + " to " + localPath, new Object[0]);
                CloneCommand cloneCommand = Git.cloneRepository();
                Git cloneResult = null;
                try {
                    Path tempKey = Files.createTempFile(UUID.randomUUID().toString(), ".tmp", new FileAttribute[0]);
                    logger.debug("Add user credentials if provided", new Object[0]);
                    this.studioClusterUtils.configureAuthenticationForCommand(remoteNode, cloneCommand, tempKey);
                    String cloneUrl = remoteNode.getGitUrl().replace("/sites/{siteId}", "/global");
                    logger.debug("Executing clone command", new Object[0]);
                    cloneResult = cloneCommand.setURI(cloneUrl).setRemote(remoteNode.getGitRemoteName()).setDirectory(localPath).setCloneAllBranches(true).call();
                    Files.deleteIfExists(tempKey);
                    cloned = true;
                }
                catch (InvalidRemoteException e) {
                    logger.error("Invalid remote repository: " + remoteNode.getGitRemoteName() + " (" + remoteNode.getGitUrl() + ")", (Exception)((Object)e), new Object[0]);
                }
                catch (TransportException e) {
                    if (StringUtils.endsWithIgnoreCase((CharSequence)e.getMessage(), (CharSequence)"not authorized")) {
                        logger.error("Bad credentials or read only repository: " + remoteNode.getGitRemoteName() + " (" + remoteNode.getGitUrl() + ")", (Exception)((Object)e), new Object[0]);
                        continue;
                    }
                    logger.error("Remote repository not found: " + remoteNode.getGitRemoteName() + " (" + remoteNode.getGitUrl() + ")", (Exception)((Object)e), new Object[0]);
                }
                catch (IOException | GitAPIException e) {
                    logger.error("Error while creating repository for site with path" + siteSandboxPath.toString(), (Exception)e, new Object[0]);
                }
                finally {
                    if (cloneResult == null) continue;
                    cloneResult.close();
                }
            }
            return cloned;
        }
        finally {
            this.generalLockService.unlock(gitLockKey);
        }
    }

    protected void addRemotes(List<ClusterMember> clusterNodes) throws InvalidRemoteUrlException, ServiceLayerException, CryptoException {
        logger.debug("Add cluster members as remotes to local sandbox repository", new Object[0]);
        for (ClusterMember member : clusterNodes) {
            if (existingRemotes != null && existingRemotes.containsKey(member.getGitRemoteName())) continue;
            try {
                if (existingRemotes == null) {
                    existingRemotes = new HashMap<String, String>();
                }
                String remoteUrl = member.getGitUrl().replace("/sites/{siteId}", "/global");
                this.addRemoteRepository(member, remoteUrl);
                existingRemotes.put(member.getGitRemoteName(), "");
            }
            catch (IOException e) {
                logger.error("Failed to open repository", e, new Object[0]);
            }
        }
    }

    protected void addRemoteRepository(ClusterMember member, String remoteUrl) throws IOException, InvalidRemoteUrlException, ServiceLayerException {
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        Repository repo = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(Paths.get(this.studioConfiguration.getProperty("studio.repo.basePath"), this.studioConfiguration.getProperty("studio.repo.globalRepoPath")).resolve(".git").toFile())).readEnvironment()).findGitDir()).build();
        try (Git git = new Git(repo);){
            StoredConfig storedConfig = repo.getConfig();
            Set remotes = storedConfig.getSubsections("remote");
            if (remotes.contains(member.getGitRemoteName().replaceFirst("cluster_node_", ""))) {
                try {
                    this.studioClusterUtils.removeRemote(git, member.getGitRemoteName().replaceFirst("cluster_node_", ""));
                }
                catch (GitAPIException e) {
                    logger.debug("Error while cleaning remote repositories for global repo", new Object[]{e});
                }
            }
            if (remotes.contains(member.getGitRemoteName())) {
                logger.debug("Remote " + member.getGitRemoteName() + " already exists for global repo", new Object[0]);
                String storedRemoteUrl = storedConfig.getString("remote", member.getGitRemoteName(), "url");
                if (!StringUtils.equals((CharSequence)storedRemoteUrl, (CharSequence)remoteUrl)) {
                    RemoteSetUrlCommand remoteSetUrlCommand = git.remoteSetUrl();
                    remoteSetUrlCommand.setName(member.getGitRemoteName());
                    remoteSetUrlCommand.setUri(new URIish(remoteUrl));
                    remoteSetUrlCommand.call();
                }
            } else {
                logger.debug("Add " + member.getLocalAddress() + " as remote to sandbox", new Object[0]);
                RemoteAddCommand remoteAddCommand = git.remoteAdd();
                remoteAddCommand.setName(member.getGitRemoteName());
                remoteAddCommand.setUri(new URIish(remoteUrl));
                remoteAddCommand.call();
            }
        }
        catch (URISyntaxException e) {
            logger.error("Remote URL is invalid " + remoteUrl, e, new Object[0]);
            throw new InvalidRemoteUrlException();
        }
        catch (GitAPIException e) {
            logger.error("Error while adding remote " + member.getGitRemoteName() + " (url: " + remoteUrl + ") for global repo", (Exception)((Object)e), new Object[0]);
            throw new ServiceLayerException("Error while adding remote " + member.getGitRemoteName() + " (url: " + remoteUrl + ") for global repo", (Exception)((Object)e));
        }
    }

    protected void updateContent(List<ClusterMember> clusterNodes) throws IOException, CryptoException, ServiceLayerException {
        logger.debug("Update global repo", new Object[0]);
        Path siteSandboxPath = Paths.get(this.studioConfiguration.getProperty("studio.repo.basePath"), this.studioConfiguration.getProperty("studio.repo.globalRepoPath")).resolve(".git");
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        Repository repo = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(siteSandboxPath.toFile())).readEnvironment()).findGitDir()).build();
        try (Git git = new Git(repo);){
            logger.debug("Update content from each active cluster memeber", new Object[0]);
            for (ClusterMember remoteNode : clusterNodes) {
                this.updateBranch(git, remoteNode);
            }
        }
        catch (GitAPIException e) {
            logger.error("Error while syncing cluster node global repo content", (Exception)((Object)e), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBranch(Git git, ClusterMember remoteNode) throws CryptoException, GitAPIException, IOException, ServiceLayerException {
        if (this.generalLockService.tryLock("GLOBAL_REPOSITORY_GIT_LOCK")) {
            try {
                Path tempKey = Files.createTempFile(UUID.randomUUID().toString(), ".tmp", new FileAttribute[0]);
                PullCommand pullCommand = git.pull();
                pullCommand.setRemote(remoteNode.getGitRemoteName());
                pullCommand = this.studioClusterUtils.configureAuthenticationForCommand(remoteNode, pullCommand, tempKey);
                pullCommand.call();
                Files.delete(tempKey);
            }
            finally {
                this.generalLockService.unlock("GLOBAL_REPOSITORY_GIT_LOCK");
            }
        } else {
            logger.debug("Failed to get lock GLOBAL_REPOSITORY_GIT_LOCK", new Object[0]);
        }
    }
}

