/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.job;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.crypto.CryptoException;
import org.craftercms.commons.crypto.TextEncryptor;
import org.craftercms.studio.api.v1.constant.GitRepositories;
import org.craftercms.studio.api.v1.dal.SiteFeed;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteUrlException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.service.GeneralLockService;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v2.dal.ClusterDAO;
import org.craftercms.studio.api.v2.dal.ClusterMember;
import org.craftercms.studio.api.v2.dal.ClusterSiteRecord;
import org.craftercms.studio.api.v2.repository.RetryingRepositoryOperationFacade;
import org.craftercms.studio.api.v2.service.security.internal.UserServiceInternal;
import org.craftercms.studio.api.v2.utils.GitRepositoryHelper;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.impl.v2.job.StudioClockClusterTask;
import org.craftercms.studio.impl.v2.service.cluster.StudioClusterUtils;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.RemoteAddCommand;
import org.eclipse.jgit.api.RemoteSetUrlCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.URIish;

public class StudioClusterPublishedRepoSyncTask
extends StudioClockClusterTask {
    private static final Logger logger = LoggerFactory.getLogger(StudioClusterPublishedRepoSyncTask.class);
    protected static final Map<String, Map<String, String>> remotesMap = new HashMap<String, Map<String, String>>();
    private StudioClusterUtils studioClusterUtils;
    private ClusterDAO clusterDao;
    private ServicesConfig servicesConfig;
    private SecurityService securityService;
    private UserServiceInternal userServiceInternal;
    private TextEncryptor encryptor;
    private GeneralLockService generalLockService;
    private RetryingRepositoryOperationFacade retryingRepositoryOperationFacade;

    public StudioClusterPublishedRepoSyncTask(int executeEveryNCycles, int offset, StudioClusterUtils studioClusterUtils, StudioConfiguration studioConfiguration, ContentRepository contentRepository, SiteService siteService, ClusterDAO clusterDao, ServicesConfig servicesConfig, SecurityService securityService, UserServiceInternal userServiceInternal, TextEncryptor encryptor, GeneralLockService generalLockService, RetryingRepositoryOperationFacade retryingRepositoryOperationFacade) {
        super(executeEveryNCycles, offset, studioConfiguration, siteService, contentRepository);
        this.studioClusterUtils = studioClusterUtils;
        this.clusterDao = clusterDao;
        this.servicesConfig = servicesConfig;
        this.securityService = securityService;
        this.userServiceInternal = userServiceInternal;
        this.encryptor = encryptor;
        this.generalLockService = generalLockService;
        this.retryingRepositoryOperationFacade = retryingRepositoryOperationFacade;
    }

    @Override
    protected void executeInternal(String siteId) {
        long startTime;
        block12: {
            startTime = System.currentTimeMillis();
            logger.debug("Worker starts syncing cluster node published for site " + siteId, new Object[0]);
            try {
                HierarchicalConfiguration<ImmutableNode> registrationData = this.studioClusterUtils.getClusterConfiguration();
                if (registrationData == null || registrationData.isEmpty()) break block12;
                String localAddress = this.studioClusterUtils.getClusterNodeLocalAddress();
                ClusterMember localNode = this.clusterDao.getMemberByLocalAddress(localAddress);
                List<ClusterMember> clusterNodes = this.studioClusterUtils.getClusterNodes(localAddress);
                SiteFeed siteFeed = this.siteService.getSite(siteId);
                List<ClusterSiteRecord> clusterSiteRecords = this.clusterDao.getSiteStateAcrossCluster(siteId);
                Optional<ClusterSiteRecord> localNodeRecord = clusterSiteRecords.stream().filter(x -> x.getClusterNodeId() == localNode.getId() && StringUtils.equals((CharSequence)x.getState(), (CharSequence)"CREATED")).findFirst();
                if (!localNodeRecord.isPresent()) {
                    return;
                }
                long nodesCreated = clusterSiteRecords.stream().filter(x -> StringUtils.equals((CharSequence)x.getState(), (CharSequence)"CREATED")).count();
                if (nodesCreated < 1L) {
                    return;
                }
                logger.debug("Check if site " + siteId + " exists in local repository", new Object[0]);
                boolean success = true;
                int publishedReposCreated = clusterSiteRecords.stream().mapToInt(ClusterSiteRecord::getPublishedRepoCreated).sum();
                if (publishedReposCreated > 0 || siteFeed.getPublishedRepoCreated() > 0) {
                    boolean siteCheck = this.checkIfSiteRepoExists(siteId);
                    if (!siteCheck) {
                        success = this.createSite(localNode.getId(), siteFeed.getId(), siteId, siteFeed.getSandboxBranch());
                    } else {
                        this.clusterDao.setPublishedRepoCreated(localNode.getId(), siteFeed.getId());
                    }
                } else {
                    success = false;
                }
                if (!success) break block12;
                try {
                    logger.debug("Add remotes for site " + siteId, new Object[0]);
                    this.addRemotes(siteId, clusterNodes);
                }
                catch (CryptoException | ServiceLayerException | InvalidRemoteUrlException e) {
                    logger.error("Error while adding remotes on cluster node for site " + siteId, new Object[0]);
                }
                try {
                    logger.debug("Update content for site " + siteId, new Object[0]);
                    this.updateContent(siteFeed.getId(), siteId, clusterNodes, clusterSiteRecords);
                }
                catch (IOException | CryptoException | ServiceLayerException e) {
                    logger.error("Error while updating content for site " + siteId + " on cluster node.", (Exception)e, new Object[0]);
                }
            }
            catch (SiteNotFoundException e) {
                logger.error("Error while executing Cluster Node Sync Published for site " + siteId, e, new Object[0]);
            }
        }
        long duration = System.currentTimeMillis() - startTime;
        logger.debug("Worker finished syncing cluster node for site " + siteId, new Object[0]);
        logger.debug("Worker performed cluster node sync for site " + siteId + " in " + duration + "ms", new Object[0]);
        logger.debug("Finished Cluster Node Sync task for site " + siteId, new Object[0]);
    }

    protected boolean checkIfSiteRepoExists(String siteId) {
        boolean toRet = false;
        String firstCommitId = this.contentRepository.getRepoFirstCommitId(siteId);
        if (!StringUtils.isEmpty((CharSequence)firstCommitId)) {
            Repository repo = null;
            FileRepositoryBuilder builder = new FileRepositoryBuilder();
            try {
                repo = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setMustExist(true)).setGitDir(this.buildRepoPath(siteId).resolve(".git").toFile())).readEnvironment()).findGitDir()).build();
            }
            catch (IOException e) {
                logger.info("Failed to open PUBLISHED repo for site " + siteId, new Object[0]);
            }
            toRet = Objects.nonNull(repo) && repo.getObjectDatabase().exists();
        }
        return toRet;
    }

    @Override
    protected Path buildRepoPath(String siteId) {
        return Paths.get(this.studioConfiguration.getProperty("studio.repo.basePath"), this.studioConfiguration.getProperty("studio.repo.sitesRepoBasePath"), siteId, this.studioConfiguration.getProperty("studio.repo.sitePublishedPath"));
    }

    protected boolean createSite(long localNodeId, long sId, String siteId, String sandboxBranch) {
        boolean result = true;
        if (result) {
            try {
                logger.debug("Create " + GitRepositories.PUBLISHED.name() + " repository from remote for site " + siteId, new Object[0]);
                GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
                result = helper.createPublishedRepository(siteId, sandboxBranch);
                if (result) {
                    this.clusterDao.setPublishedRepoCreated(localNodeId, sId);
                }
            }
            catch (CryptoException e) {
                logger.error("Error while creating site on cluster node for site : " + siteId + ". Rolling back.", (Exception)((Object)e), new Object[0]);
                result = false;
            }
            if (!result) {
                remotesMap.remove(siteId);
                this.contentRepository.deleteSite(siteId);
            }
        }
        return result;
    }

    protected void addRemotes(String siteId, List<ClusterMember> clusterNodes) throws InvalidRemoteUrlException, ServiceLayerException, CryptoException {
        Map<String, String> existingRemotes = remotesMap.get(siteId);
        logger.debug("Add cluster members as remotes to local published repository", new Object[0]);
        for (ClusterMember member : clusterNodes) {
            if (existingRemotes != null && existingRemotes.containsKey(member.getGitRemoteName())) continue;
            try {
                if (existingRemotes == null) {
                    existingRemotes = new HashMap<String, String>();
                    remotesMap.put(siteId, existingRemotes);
                }
                String remoteUrl = member.getGitUrl().replace("{siteId}", siteId) + "/" + this.studioConfiguration.getProperty("studio.repo.sitePublishedPath");
                this.addRemoteRepository(siteId, member, remoteUrl);
                existingRemotes.put(member.getGitRemoteName(), "");
            }
            catch (IOException e) {
                logger.error("Failed to open repository", e, new Object[0]);
            }
        }
    }

    protected void addRemoteRepository(String siteId, ClusterMember member, String remoteUrl) throws IOException, InvalidRemoteUrlException, ServiceLayerException {
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        Repository repo = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(this.buildRepoPath(siteId).resolve(".git").toFile())).readEnvironment()).findGitDir()).build();
        try (Git git = new Git(repo);){
            StoredConfig storedConfig = repo.getConfig();
            Set remotes = storedConfig.getSubsections("remote");
            if (remotes.contains(member.getGitRemoteName().replaceFirst("cluster_node_", ""))) {
                try {
                    this.removeRemote(git, member.getGitRemoteName().replaceFirst("cluster_node_", ""));
                }
                catch (GitAPIException e) {
                    logger.debug("Error while cleaning up remote repository", new Object[]{e});
                }
            }
            if (remotes.contains(member.getGitRemoteName())) {
                logger.debug("Remote " + member.getGitRemoteName() + " already exists for PUBLISHED repo for site " + siteId, new Object[0]);
                String storedRemoteUrl = storedConfig.getString("remote", member.getGitRemoteName(), "url");
                if (!StringUtils.equals((CharSequence)storedRemoteUrl, (CharSequence)remoteUrl)) {
                    RemoteSetUrlCommand remoteSetUrlCommand = git.remoteSetUrl();
                    remoteSetUrlCommand.setName(member.getGitRemoteName());
                    remoteSetUrlCommand.setUri(new URIish(remoteUrl));
                    remoteSetUrlCommand.call();
                }
            } else {
                logger.debug("Add " + member.getLocalAddress() + " as remote to PUBLISHED", new Object[0]);
                RemoteAddCommand remoteAddCommand = git.remoteAdd();
                remoteAddCommand.setName(member.getGitRemoteName());
                remoteAddCommand.setUri(new URIish(remoteUrl));
                remoteAddCommand.call();
            }
        }
        catch (URISyntaxException e) {
            logger.error("Remote URL is invalid " + remoteUrl, e, new Object[0]);
            throw new InvalidRemoteUrlException();
        }
        catch (GitAPIException e) {
            logger.error("Error while adding remote " + member.getGitRemoteName() + " (url: " + remoteUrl + ") for site " + siteId, (Exception)((Object)e), new Object[0]);
            throw new ServiceLayerException("Error while adding remote " + member.getGitRemoteName() + " (url: " + remoteUrl + ") for site " + siteId, (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateContent(long sId, String siteId, List<ClusterMember> clusterNodes, List<ClusterSiteRecord> clusterSiteRecords) throws IOException, CryptoException, ServiceLayerException {
        block23: {
            logger.debug("Update published repo for site " + siteId, new Object[0]);
            Path siteSandboxPath = this.buildRepoPath(siteId).resolve(".git");
            FileRepositoryBuilder builder = new FileRepositoryBuilder();
            Repository repo = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(siteSandboxPath.toFile())).readEnvironment()).findGitDir()).build();
            String gitLockKey = "{site}_PUBLISHED_REPOSITORY_GIT_LOCK".replaceAll("\\{site\\}", siteId);
            logger.debug("Git Lock Key: " + gitLockKey, new Object[0]);
            try (Git git = new Git(repo);){
                Set<String> environments = this.getAllPublishingEnvironments(siteId);
                logger.debug("Update published repo from all active cluster members", new Object[0]);
                if (this.generalLockService.tryLock(gitLockKey)) {
                    try {
                        for (ClusterMember remoteNode : clusterNodes) {
                            ClusterSiteRecord csr = this.clusterDao.getClusterSiteRecord(remoteNode.getId(), sId);
                            if (!Objects.nonNull(csr) || csr.getPublishedRepoCreated() <= 0) continue;
                            try {
                                logger.debug("Fetch from cluster member " + remoteNode.getLocalAddress(), new Object[0]);
                                Path tempKey = Files.createTempFile(UUID.randomUUID().toString(), ".tmp", new FileAttribute[0]);
                                FetchCommand fetch = git.fetch().setRemote(remoteNode.getGitRemoteName());
                                fetch = this.studioClusterUtils.configureAuthenticationForCommand(remoteNode, fetch, tempKey);
                                fetch.call();
                                Files.delete(tempKey);
                            }
                            catch (GitAPIException e) {
                                logger.error("Error while fetching published repo for site " + siteId + " from remote " + remoteNode.getGitRemoteName(), new Object[0]);
                                logger.error(e.getMessage(), new Object[0]);
                            }
                        }
                        for (String branch : environments) {
                            for (ClusterMember remoteNode : clusterNodes) {
                                ClusterSiteRecord csr = this.clusterDao.getClusterSiteRecord(remoteNode.getId(), sId);
                                if (!Objects.nonNull(csr) || csr.getPublishedRepoCreated() <= 0) continue;
                                try {
                                    this.updatePublishedBranch(siteId, git, remoteNode, branch);
                                }
                                catch (GitAPIException e) {
                                    logger.error("Error while updating published repo for site " + siteId + " from remote " + remoteNode.getGitRemoteName() + " environment " + branch, new Object[0]);
                                    logger.error(e.getMessage(), new Object[0]);
                                }
                            }
                        }
                        break block23;
                    }
                    finally {
                        this.generalLockService.unlock(gitLockKey);
                    }
                }
                logger.debug("Failed to get lock " + gitLockKey, new Object[0]);
            }
        }
    }

    private Set<String> getAllPublishingEnvironments(String site) {
        HashSet<String> environments = new HashSet<String>();
        environments.add(this.servicesConfig.getLiveEnvironment(site));
        if (this.servicesConfig.isStagingEnvironmentEnabled(site)) {
            environments.add(this.servicesConfig.getStagingEnvironment(site));
        }
        return environments;
    }

    private void updatePublishedBranch(String siteId, Git git, ClusterMember remoteNode, String branch) throws CryptoException, GitAPIException, IOException, ServiceLayerException {
        logger.debug("Update published environment " + branch + " from " + remoteNode.getLocalAddress() + " for site " + siteId, new Object[0]);
        Path tempKey = Files.createTempFile(UUID.randomUUID().toString(), ".tmp", new FileAttribute[0]);
        Repository repo = git.getRepository();
        Ref ref = repo.exactRef("refs/heads/" + branch);
        boolean createBranch = ref == null;
        logger.debug("Checkout " + branch, new Object[0]);
        CheckoutCommand checkoutCommand = git.checkout().setName(branch).setCreateBranch(createBranch);
        if (createBranch) {
            checkoutCommand.setStartPoint(remoteNode.getGitRemoteName() + "/" + branch);
        }
        checkoutCommand.call();
        PullCommand pullCommand = git.pull();
        pullCommand.setRemote(remoteNode.getGitRemoteName());
        pullCommand.setRemoteBranchName(branch);
        pullCommand = this.studioClusterUtils.configureAuthenticationForCommand(remoteNode, pullCommand, tempKey);
        pullCommand.call();
        Files.delete(tempKey);
    }
}

