/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.job;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.crypto.CryptoException;
import org.craftercms.studio.api.v1.constant.GitRepositories;
import org.craftercms.studio.api.v1.dal.SiteFeed;
import org.craftercms.studio.api.v1.ebus.PreviewEventContext;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteUrlException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.service.GeneralLockService;
import org.craftercms.studio.api.v1.service.deployment.DeploymentService;
import org.craftercms.studio.api.v1.service.event.EventService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v2.dal.ClusterDAO;
import org.craftercms.studio.api.v2.dal.ClusterMember;
import org.craftercms.studio.api.v2.dal.ClusterSiteRecord;
import org.craftercms.studio.api.v2.dal.RemoteRepository;
import org.craftercms.studio.api.v2.deployment.Deployer;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.impl.v2.job.StudioClockClusterTask;
import org.craftercms.studio.impl.v2.service.cluster.StudioClusterUtils;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.RemoteAddCommand;
import org.eclipse.jgit.api.RemoteSetUrlCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.URIish;

public class StudioClusterSandboxRepoSyncTask
extends StudioClockClusterTask {
    private static final Logger logger = LoggerFactory.getLogger(StudioClusterSandboxRepoSyncTask.class);
    protected static final Map<String, Map<String, String>> remotesMap = new HashMap<String, Map<String, String>>();
    private StudioClusterUtils studioClusterUtils;
    private Deployer deployer;
    private DeploymentService deploymentService;
    private EventService eventService;
    private ClusterDAO clusterDao;
    private GeneralLockService generalLockService;

    public StudioClusterSandboxRepoSyncTask(int executeEveryNCycles, int offset, StudioClusterUtils studioClusterUtils, StudioConfiguration studioConfiguration, ContentRepository contentRepository, Deployer deployer, SiteService siteService, DeploymentService deploymentService, EventService eventService, ClusterDAO clusterDao, GeneralLockService generalLockService) {
        super(executeEveryNCycles, offset, studioConfiguration, siteService, contentRepository);
        this.studioClusterUtils = studioClusterUtils;
        this.deployer = deployer;
        this.deploymentService = deploymentService;
        this.eventService = eventService;
        this.clusterDao = clusterDao;
        this.generalLockService = generalLockService;
    }

    @Override
    protected void executeInternal(String siteId) {
        long startTime;
        block9: {
            startTime = System.currentTimeMillis();
            logger.debug("Worker starts syncing cluster node sandbox for site " + siteId, new Object[0]);
            try {
                HierarchicalConfiguration<ImmutableNode> registrationData = this.studioClusterUtils.getClusterConfiguration();
                if (registrationData == null || registrationData.isEmpty()) break block9;
                String localAddress = this.studioClusterUtils.getClusterNodeLocalAddress();
                ClusterMember localNode = this.clusterDao.getMemberByLocalAddress(localAddress);
                List<ClusterMember> clusterNodes = this.studioClusterUtils.getClusterNodes(localAddress);
                SiteFeed siteFeed = this.siteService.getSite(siteId);
                List<ClusterSiteRecord> clusterSiteRecords = this.clusterDao.getSiteStateAcrossCluster(siteId);
                long nodesCreated = clusterSiteRecords.stream().filter(x -> StringUtils.equals((CharSequence)x.getState(), (CharSequence)"CREATED")).count();
                if (nodesCreated < 1L && !StringUtils.equals((CharSequence)siteFeed.getState(), (CharSequence)"CREATED")) {
                    return;
                }
                logger.debug("Check if site " + siteId + " exists in local repository", new Object[0]);
                boolean success = true;
                boolean siteCheck = this.checkIfSiteRepoExists(siteId);
                if (!siteCheck) {
                    success = this.createSite(localNode.getId(), siteFeed.getId(), siteId, siteFeed.getSiteUuid(), siteFeed.getSearchEngine(), clusterNodes, clusterSiteRecords);
                }
                if (success && this.clusterDao.existsClusterSiteSyncRepo(localNode.getId(), siteFeed.getId()) < 1) {
                    String commitId = this.contentRepository.getRepoLastCommitId(siteId);
                    this.clusterDao.insertClusterSiteSyncRepo(localNode.getId(), siteFeed.getId(), commitId, commitId, siteFeed.getLastSyncedGitlogCommitId());
                    this.clusterDao.setSiteState(localNode.getId(), siteFeed.getId(), "CREATED");
                    this.addSiteUuidFile(siteId, siteFeed.getSiteUuid());
                }
                if (!success) break block9;
                this.syncRemoteRepositories(siteId, localAddress);
                boolean syncRequired = this.isSyncRequired(siteId, siteFeed.getLastCommitId());
                if (!syncRequired) break block9;
                try {
                    logger.debug("Add remotes for site " + siteId, new Object[0]);
                    this.addRemotes(siteId, clusterNodes);
                }
                catch (ServiceLayerException | InvalidRemoteUrlException e) {
                    logger.error("Error while adding remotes on cluster node for site " + siteId, new Object[0]);
                }
                try {
                    logger.debug("Update content for site " + siteId, new Object[0]);
                    this.updateContent(localNode.getId(), siteFeed.getId(), siteId, siteFeed.getSandboxBranch(), clusterNodes);
                }
                catch (IOException | CryptoException | ServiceLayerException e) {
                    logger.error("Error while updating content for site " + siteId + " on cluster node.", (Exception)e, new Object[0]);
                }
            }
            catch (IOException | SiteNotFoundException e) {
                logger.error("Error while executing Cluster Node Sync Sandbox for site " + siteId, e, new Object[0]);
            }
        }
        long duration = System.currentTimeMillis() - startTime;
        logger.debug("Worker finished syncing cluster node for site " + siteId, new Object[0]);
        logger.debug("Worker performed cluster node sync for site " + siteId + " in " + duration + "ms", new Object[0]);
        logger.debug("Finished Cluster Node Sync task for site " + siteId, new Object[0]);
    }

    protected boolean checkIfSiteRepoExists(String siteId) {
        boolean toRet = false;
        String firstCommitId = this.contentRepository.getRepoFirstCommitId(siteId);
        if (!StringUtils.isEmpty((CharSequence)firstCommitId)) {
            toRet = true;
        }
        return toRet;
    }

    private boolean createSite(long localNodeId, long sId, String siteId, String siteUuid, String searchEngine, List<ClusterMember> clusterNodes, List<ClusterSiteRecord> clusterSiteRecords) {
        boolean result = true;
        logger.debug("Create Deployer targets site " + siteId, new Object[0]);
        try {
            this.deployer.createTargets(siteId, searchEngine);
        }
        catch (Exception e) {
            result = false;
            logger.error("Error while creating Deployer targets on cluster node for site : " + siteId, e, new Object[0]);
        }
        if (result) {
            try {
                logger.debug("Create site from remote for site " + siteId, new Object[0]);
                result = this.createSiteFromRemote(siteId, localNodeId, clusterSiteRecords);
                if (result) {
                    String commitId = this.contentRepository.getRepoLastCommitId(siteId);
                    this.clusterDao.insertClusterSiteSyncRepo(localNodeId, sId, commitId, commitId, commitId);
                    this.clusterDao.setSiteState(localNodeId, sId, "CREATED");
                    this.addSiteUuidFile(siteId, siteUuid);
                    this.deploymentService.syncAllContentToPreview(siteId, true);
                }
            }
            catch (IOException | CryptoException | ServiceLayerException e) {
                logger.error("Error while creating site on cluster node for site : " + siteId + ". Rolling back.", (Exception)e, new Object[0]);
                result = false;
            }
            if (result) {
                this.clusterDao.setSiteState(localNodeId, sId, "CREATED");
            } else {
                remotesMap.remove(siteId);
                this.contentRepository.deleteSite(siteId);
                try {
                    this.deployer.deleteTargets(siteId);
                }
                catch (Exception e) {
                    logger.error("Error while rolling back/deleting site: " + siteId + " ID: " + siteId + " on cluster node. This means the site's Deployer targets are still present, but the site was not successfully created.", new Object[0]);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean createSiteFromRemote(String siteId, long localNodeId, List<ClusterSiteRecord> clusterSiteRecords) throws CryptoException, ServiceLayerException {
        boolean cloned = false;
        boolean idx = false;
        String gitLockKey = "{site}_SANDBOX_REPOSITORY_GIT_LOCK".replaceAll("\\{site\\}", siteId);
        if (this.generalLockService.tryLock(gitLockKey)) {
            try {
                Optional<ClusterSiteRecord> csr = clusterSiteRecords.stream().filter(x -> StringUtils.equals((CharSequence)x.getState(), (CharSequence)"CREATED") && x.getClusterNodeId() != localNodeId).findFirst();
                if (!csr.isPresent()) return cloned;
                ClusterMember remoteNode = this.clusterDao.getMemberById(csr.get().getClusterNodeId());
                logger.debug("Cloning " + GitRepositories.SANDBOX.toString() + " repository for site " + siteId + " from " + remoteNode.getLocalAddress(), new Object[0]);
                Path siteSandboxPath = this.buildRepoPath(siteId);
                File localPath = siteSandboxPath.toFile();
                logger.debug("Cloning from " + remoteNode.getGitUrl() + " to " + localPath, new Object[0]);
                CloneCommand cloneCommand = Git.cloneRepository();
                try (Git cloneResult = null;){
                    if (localPath.exists()) {
                        FileUtils.forceDelete((File)localPath);
                    }
                    Path tempKey = Files.createTempFile(UUID.randomUUID().toString(), ".tmp", new FileAttribute[0]);
                    logger.debug("Add user credentials if provided", new Object[0]);
                    this.studioClusterUtils.configureAuthenticationForCommand(remoteNode, cloneCommand, tempKey);
                    String cloneUrl = remoteNode.getGitUrl().replace("{siteId}", siteId);
                    cloneUrl = cloneUrl + "/" + this.studioConfiguration.getProperty("studio.repo.siteSandboxPath");
                    logger.debug("Executing clone command", new Object[0]);
                    Git gitClone = cloneResult = cloneCommand.setURI(cloneUrl).setRemote(remoteNode.getGitRemoteName()).setDirectory(localPath).setCloneAllBranches(true).call();
                    Files.deleteIfExists(tempKey);
                    cloned = this.validateRepository(gitClone.getRepository());
                    return cloned;
                }
            }
            finally {
                this.generalLockService.unlock(gitLockKey);
            }
        } else {
            logger.debug("Failed to get lock " + gitLockKey, new Object[0]);
        }
        return cloned;
    }

    @Override
    protected Path buildRepoPath(String siteId) {
        return Paths.get(this.studioConfiguration.getProperty("studio.repo.basePath"), this.studioConfiguration.getProperty("studio.repo.sitesRepoBasePath"), siteId, this.studioConfiguration.getProperty("studio.repo.siteSandboxPath"));
    }

    private void addSiteUuidFile(String site, String siteUuid) throws IOException {
        Path path = Paths.get(this.studioConfiguration.getProperty("studio.repo.basePath"), this.studioConfiguration.getProperty("studio.repo.sitesRepoBasePath"), site, "site-uuid.txt");
        String toWrite = "# THIS IS A SYSTEM FILE. PLEASE DO NOT EDIT NOR DELETE IT!!!\n" + siteUuid;
        Files.write(path, toWrite.getBytes(), new OpenOption[0]);
    }

    private void syncRemoteRepositories(String siteId, String localAddress) {
        List<RemoteRepository> remoteRepositories = this.clusterDao.getMissingClusterNodeRemoteRepositories(localAddress, siteId);
        if (CollectionUtils.isNotEmpty(remoteRepositories)) {
            ClusterMember currentNode = this.clusterDao.getMemberByLocalAddress(localAddress);
            for (RemoteRepository remoteRepository : remoteRepositories) {
                try {
                    this.addRemoteRepository(siteId, remoteRepository);
                    this.clusterDao.addClusterRemoteRepository(currentNode.getId(), remoteRepository.getId());
                }
                catch (IOException | ServiceLayerException | InvalidRemoteUrlException e) {
                    logger.error("Error while adding remote " + remoteRepository.getRemoteName() + " (url: " + remoteRepository.getRemoteUrl() + ") for site " + siteId, e, new Object[0]);
                }
            }
        }
    }

    protected void addRemoteRepository(String siteId, RemoteRepository remoteRepository) throws IOException, InvalidRemoteUrlException, ServiceLayerException {
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        Repository repo = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(this.buildRepoPath(siteId).resolve(".git").toFile())).readEnvironment()).findGitDir()).build();
        try (Git git = new Git(repo);){
            logger.debug("Add " + remoteRepository.getRemoteName() + " as remote to SANDBOX", new Object[0]);
            RemoteAddCommand remoteAddCommand = git.remoteAdd();
            remoteAddCommand.setName(remoteRepository.getRemoteName());
            remoteAddCommand.setUri(new URIish(remoteRepository.getRemoteUrl()));
            remoteAddCommand.call();
        }
        catch (URISyntaxException e) {
            logger.error("Remote URL is invalid " + remoteRepository.getRemoteUrl(), e, new Object[0]);
            throw new InvalidRemoteUrlException();
        }
        catch (GitAPIException e) {
            logger.error("Error while adding remote " + remoteRepository.getRemoteName() + " (url: " + remoteRepository.getRemoteUrl() + ") for site " + siteId, (Exception)((Object)e), new Object[0]);
            throw new ServiceLayerException("Error while adding remote " + remoteRepository.getRemoteName() + " (url: " + remoteRepository.getRemoteUrl() + ") for site " + siteId, (Exception)((Object)e));
        }
    }

    private boolean isSyncRequired(String siteId, String siteDatabaseLastCommitId) {
        boolean syncRequired = true;
        String lastCommitIdRepo = this.contentRepository.getRepoLastCommitId(siteId);
        if (StringUtils.isNotEmpty((CharSequence)siteDatabaseLastCommitId) && StringUtils.equals((CharSequence)lastCommitIdRepo, (CharSequence)siteDatabaseLastCommitId)) {
            syncRequired = false;
        }
        return syncRequired;
    }

    protected void addRemotes(String siteId, List<ClusterMember> clusterNodes) throws InvalidRemoteUrlException, ServiceLayerException {
        Map<String, String> existingRemotes = remotesMap.get(siteId);
        logger.debug("Add cluster members as remotes to local sandbox repository", new Object[0]);
        for (ClusterMember member : clusterNodes) {
            if (existingRemotes != null && existingRemotes.containsKey(member.getGitRemoteName())) continue;
            try {
                if (existingRemotes == null) {
                    existingRemotes = new HashMap<String, String>();
                    remotesMap.put(siteId, existingRemotes);
                }
                String remoteUrl = member.getGitUrl().replace("{siteId}", siteId) + "/" + this.studioConfiguration.getProperty("studio.repo.siteSandboxPath");
                this.addRemoteRepository(siteId, member, remoteUrl);
                existingRemotes.put(member.getGitRemoteName(), "");
            }
            catch (IOException e) {
                logger.error("Failed to open repository", e, new Object[0]);
            }
        }
    }

    private void addRemoteRepository(String siteId, ClusterMember member, String remoteUrl) throws IOException, InvalidRemoteUrlException, ServiceLayerException {
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        Repository repo = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(this.buildRepoPath(siteId).resolve(".git").toFile())).readEnvironment()).findGitDir()).build();
        try (Git git = new Git(repo);){
            StoredConfig storedConfig = repo.getConfig();
            Set remotes = storedConfig.getSubsections("remote");
            if (remotes.contains(member.getGitRemoteName().replaceFirst("cluster_node_", ""))) {
                try {
                    this.removeRemote(git, member.getGitRemoteName().replaceFirst("cluster_node_", ""));
                }
                catch (GitAPIException e) {
                    logger.debug("Error while cleaning up remote repository", new Object[]{e});
                }
            }
            if (remotes.contains(member.getGitRemoteName())) {
                logger.debug("Remote " + member.getGitRemoteName() + " already exists for SANDBOX repo for site " + siteId, new Object[0]);
                String storedRemoteUrl = storedConfig.getString("remote", member.getGitRemoteName(), "url");
                if (!StringUtils.equals((CharSequence)storedRemoteUrl, (CharSequence)remoteUrl)) {
                    RemoteSetUrlCommand remoteSetUrlCommand = git.remoteSetUrl();
                    remoteSetUrlCommand.setName(member.getGitRemoteName());
                    remoteSetUrlCommand.setUri(new URIish(remoteUrl));
                    remoteSetUrlCommand.call();
                }
            } else {
                logger.debug("Add " + member.getLocalAddress() + " as remote to SANDBOX", new Object[0]);
                RemoteAddCommand remoteAddCommand = git.remoteAdd();
                remoteAddCommand.setName(member.getGitRemoteName());
                remoteAddCommand.setUri(new URIish(remoteUrl));
                remoteAddCommand.call();
            }
        }
        catch (URISyntaxException e) {
            logger.error("Remote URL is invalid " + remoteUrl, e, new Object[0]);
            throw new InvalidRemoteUrlException();
        }
        catch (GitAPIException e) {
            logger.error("Error while adding remote " + member.getGitRemoteName() + " (url: " + remoteUrl + ") for site " + siteId, (Exception)((Object)e), new Object[0]);
            throw new ServiceLayerException("Error while adding remote " + member.getGitRemoteName() + " (url: " + remoteUrl + ") for site " + siteId, (Exception)((Object)e));
        }
    }

    protected void updateContent(long localNodeId, long sId, String siteId, String sandboxBranchName, List<ClusterMember> clusterNodes) throws IOException, CryptoException, ServiceLayerException {
        logger.debug("Update sandbox for site " + siteId, new Object[0]);
        Path siteSandboxPath = this.buildRepoPath(siteId).resolve(".git");
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        Repository repo = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(siteSandboxPath.toFile())).readEnvironment()).findGitDir()).build();
        Map<String, String> remoteLastSyncCommits = remotesMap.get(siteId);
        if (remoteLastSyncCommits == null || remoteLastSyncCommits.isEmpty()) {
            remoteLastSyncCommits = new HashMap<String, String>();
            remotesMap.put(siteId, remoteLastSyncCommits);
        }
        try (Git git = new Git(repo);){
            logger.debug("Update content from each active cluster memeber", new Object[0]);
            for (ClusterMember remoteNode : clusterNodes) {
                ClusterSiteRecord csr = this.clusterDao.getClusterSiteRecord(remoteNode.getId(), sId);
                if (!Objects.nonNull(csr) || !StringUtils.equals((CharSequence)csr.getState(), (CharSequence)"CREATED")) continue;
                this.updateBranch(siteId, git, remoteNode, sandboxBranchName);
            }
            String updatedCommitId = this.contentRepository.getRepoLastCommitId(siteId);
            this.clusterDao.updateNodeLastCommitId(localNodeId, sId, updatedCommitId);
            PreviewEventContext context = new PreviewEventContext();
            context.setSite(siteId);
            this.eventService.publish("studio.event.previewSync", context);
        }
        catch (GitAPIException e) {
            logger.error("Error while syncing cluster node content for site " + siteId, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBranch(String siteId, Git git, ClusterMember remoteNode, String sandboxBranchName) throws CryptoException, GitAPIException, IOException, ServiceLayerException {
        String gitLockKey = "{site}_SANDBOX_REPOSITORY_GIT_LOCK".replaceAll("\\{site\\}", siteId);
        Path tempKey = Files.createTempFile(UUID.randomUUID().toString(), ".tmp", new FileAttribute[0]);
        if (this.generalLockService.tryLock(gitLockKey)) {
            try {
                PullCommand pullCommand = git.pull();
                pullCommand.setRemote(remoteNode.getGitRemoteName());
                pullCommand.setRemoteBranchName(sandboxBranchName);
                pullCommand = this.studioClusterUtils.configureAuthenticationForCommand(remoteNode, pullCommand, tempKey);
                pullCommand.call();
            }
            finally {
                this.generalLockService.unlock(gitLockKey);
            }
        } else {
            logger.debug("Failed to get lock " + gitLockKey, new Object[0]);
        }
        Files.delete(tempKey);
    }
}

