/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.job;

import java.text.SimpleDateFormat;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.dal.PublishRequest;
import org.craftercms.studio.api.v1.dal.SiteFeed;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.deployment.DeploymentException;
import org.craftercms.studio.api.v1.service.deployment.PublishingManager;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v1.to.DeploymentItemTO;
import org.craftercms.studio.api.v2.dal.AuditLog;
import org.craftercms.studio.api.v2.dal.AuditLogParameter;
import org.craftercms.studio.api.v2.repository.ContentRepository;
import org.craftercms.studio.api.v2.service.audit.internal.AuditServiceInternal;
import org.craftercms.studio.api.v2.service.notification.NotificationService;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.impl.v2.job.StudioClockTask;
import org.craftercms.studio.impl.v2.service.cluster.StudioClusterUtils;
import org.springframework.jdbc.UncategorizedSQLException;

public class StudioPublisherTask
extends StudioClockTask {
    private static final Logger logger = LoggerFactory.getLogger(StudioPublisherTask.class);
    protected static final Map<String, Integer> retryCounter = new HashMap<String, Integer>();
    protected static final Set<String> dbErrorNotifiedSites = new HashSet<String>();
    private StudioConfiguration studioConfiguration;
    private SiteService siteService;
    private ContentRepository contentRepository;
    private PublishingManager publishingManager;
    private ServicesConfig servicesConfig;
    private NotificationService notificationService;
    private AuditServiceInternal auditServiceInternal;
    private int maxRetryCounter;
    private StudioClusterUtils studioClusterUtils;

    public StudioPublisherTask(int executeEveryNCycles, int offset, StudioConfiguration studioConfiguration, SiteService siteService, ContentRepository contentRepository, PublishingManager publishingManager, ServicesConfig servicesConfig, NotificationService notificationService, AuditServiceInternal auditServiceInternal, int maxRetryCounter, StudioClusterUtils studioClusterUtils) {
        super(executeEveryNCycles, offset, studioConfiguration, siteService);
        this.studioConfiguration = studioConfiguration;
        this.siteService = siteService;
        this.contentRepository = contentRepository;
        this.publishingManager = publishingManager;
        this.servicesConfig = servicesConfig;
        this.notificationService = notificationService;
        this.auditServiceInternal = auditServiceInternal;
        this.maxRetryCounter = maxRetryCounter;
        this.studioClusterUtils = studioClusterUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeInternal(String siteId) {
        String siteState = this.siteService.getSiteState(siteId);
        if (!StringUtils.equals((CharSequence)siteState, (CharSequence)"CREATED")) {
            return;
        }
        String env = null;
        String lockOwnerId = this.studioClusterUtils.getLockOwnerId();
        int lockTTL = this.studioClusterUtils.getLockTTL();
        try {
            logger.debug("Try to lock site " + siteId + " for publishing by lock owner " + lockOwnerId, new Object[0]);
            if (this.siteService.tryLockPublishingForSite(siteId, lockOwnerId, lockTTL)) {
                if (this.contentRepository.repositoryExists(siteId) && this.siteService.isPublishingEnabled(siteId)) {
                    if (!this.publishingManager.isPublishingBlocked(siteId)) {
                        try {
                            if (!retryCounter.containsKey(siteId)) {
                                retryCounter.put(siteId, this.maxRetryCounter);
                            }
                            Set<String> environments = this.getAllPublishingEnvironments(siteId);
                            Iterator<String> iterator = environments.iterator();
                            while (iterator.hasNext()) {
                                String environment;
                                env = environment = iterator.next();
                                logger.debug("Processing content ready for deployment for site \"{0}\"", siteId);
                                List<PublishRequest> itemsToDeploy = this.publishingManager.getItemsReadyForDeployment(siteId, environment);
                                while (CollectionUtils.isNotEmpty(itemsToDeploy)) {
                                    logger.debug("Deploying " + itemsToDeploy.size() + " items for site " + siteId, new Object[0]);
                                    this.publishingManager.markItemsProcessing(siteId, environment, itemsToDeploy);
                                    List commitIds = itemsToDeploy.stream().map(PublishRequest::getCommitId).distinct().collect(Collectors.toList());
                                    boolean allCommitsPresent = true;
                                    StringBuilder sbMissingCommits = new StringBuilder();
                                    for (String commit : commitIds) {
                                        boolean commitPresent;
                                        if (!StringUtils.isNotEmpty((CharSequence)commit) || (commitPresent = this.contentRepository.commitIdExists(siteId, commit))) continue;
                                        sbMissingCommits.append(commit).append("; ");
                                        logger.debug("Commit with ID: " + commit + " is not present in local repo for site " + siteId + ". Publisher task will skip this cycle.", new Object[0]);
                                        allCommitsPresent = false;
                                    }
                                    if (allCommitsPresent) {
                                        logger.info("Starting publishing on environment " + environment + " for site " + siteId, new Object[0]);
                                        logger.debug("Site \"{0}\" has {1} items ready for deployment", siteId, itemsToDeploy.size());
                                        this.doPublishing(siteId, itemsToDeploy, environment);
                                        retryCounter.remove(siteId);
                                        dbErrorNotifiedSites.remove(siteId);
                                        this.siteService.updatePublishingLockHeartbeatForSite(siteId);
                                        itemsToDeploy = this.publishingManager.getItemsReadyForDeployment(siteId, environment);
                                        continue;
                                    }
                                    this.publishingManager.markItemsReady(siteId, environment, itemsToDeploy);
                                    int retriesLeft = retryCounter.get(siteId) - 1;
                                    itemsToDeploy = null;
                                    if (retriesLeft > 0) {
                                        retryCounter.put(siteId, retriesLeft);
                                        logger.info("Following commits are not present in local repository " + sbMissingCommits.toString() + " Publisher task will retry in next cycle. Number of retries left: " + retriesLeft, new Object[0]);
                                        continue;
                                    }
                                    retryCounter.remove(siteId);
                                    this.siteService.enablePublishing(siteId, false);
                                    throw new DeploymentException("Deployment failed after " + this.maxRetryCounter + " retries. Following commits are not present in local repository " + sbMissingCommits.toString());
                                }
                            }
                        }
                        catch (UncategorizedSQLException dbErr) {
                            logger.error("DB error while executing deployment to environment store", (Exception)((Object)dbErr), new Object[0]);
                            if (!dbErrorNotifiedSites.add(siteId)) {
                                this.notificationService.notifyDeploymentError(siteId, dbErr);
                            }
                            this.publishingManager.resetProcessingQueue(siteId, env);
                        }
                        catch (Exception err) {
                            logger.error("Error while executing deployment to environment store for site: " + siteId, err, new Object[0]);
                            this.publishingManager.resetProcessingQueue(siteId, env);
                            this.notificationService.notifyDeploymentError(siteId, err);
                        }
                    } else {
                        logger.info("Publishing is blocked for site " + siteId, new Object[0]);
                    }
                } else {
                    logger.debug("Publishing is disabled for site {0}", siteId);
                }
            }
        }
        catch (UncategorizedSQLException dbErr) {
            logger.error("DB error while executing deployment to environment store", (Exception)((Object)dbErr), new Object[0]);
            if (!dbErrorNotifiedSites.add(siteId)) {
                this.notificationService.notifyDeploymentError(siteId, dbErr);
            }
            this.publishingManager.resetProcessingQueue(siteId, env);
        }
        catch (Exception err) {
            logger.error("Error while executing deployment to environment store", err, new Object[0]);
            this.notificationService.notifyDeploymentError(siteId, err);
            this.publishingManager.resetProcessingQueue(siteId, env);
        }
        finally {
            logger.debug("Unlocking publishing for site " + siteId + " by lock owner " + lockOwnerId, new Object[0]);
            this.siteService.unlockPublishingForSite(siteId, lockOwnerId);
        }
    }

    private void doPublishing(String siteId, List<PublishRequest> itemsToDeploy, String environment) throws DeploymentException, ServiceLayerException {
        String author = itemsToDeploy.get(0).getUser();
        StringBuilder sbComment = new StringBuilder();
        ArrayList<DeploymentItemTO> completeDeploymentItemList = new ArrayList<DeploymentItemTO>();
        HashSet<String> processedPaths = new HashSet<String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
        String currentPackageId = "";
        try {
            String status;
            String statusMessage;
            logger.debug("Mark items as processing for site \"{0}\"", siteId);
            HashSet<String> packageIds = new HashSet<String>();
            int idx = 0;
            for (PublishRequest item : itemsToDeploy) {
                ++idx;
                if (!StringUtils.equals((CharSequence)currentPackageId, (CharSequence)item.getPackageId())) {
                    currentPackageId = item.getPackageId();
                }
                statusMessage = this.studioConfiguration.getProperty("studio.job.deployContentToEnvironment.status.message.publishing");
                statusMessage = statusMessage.replace("{package_id}", currentPackageId).replace("{datetime}", ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ofPattern(sdf.toPattern()))).replace("{x}", Integer.toString(idx)).replace("{y}", Integer.toString(itemsToDeploy.size()));
                this.siteService.updatePublishingStatusMessage(siteId, "publishing", statusMessage);
                this.processPublishingRequest(siteId, environment, item, completeDeploymentItemList, processedPaths);
                if (!packageIds.add(item.getPackageId())) continue;
                sbComment.append(item.getSubmissionComment()).append("\n");
            }
            this.deploy(siteId, environment, completeDeploymentItemList, author, sbComment.toString());
            StringBuilder sbPackIds = new StringBuilder("Package(s): ");
            for (String packageId : packageIds) {
                sbPackIds.append(packageId).append(";");
            }
            this.generateWorkflowActivity(siteId, environment, packageIds, author, "PUBLISHED");
            this.publishingManager.markItemsCompleted(siteId, environment, itemsToDeploy);
            logger.debug("Mark deployment completed for processed items for site \"{0}\"", siteId);
            logger.info("Finished publishing environment " + environment + " for site " + siteId, new Object[0]);
            if (this.publishingManager.isPublishingQueueEmpty(siteId)) {
                status = "ready";
                statusMessage = this.studioConfiguration.getProperty("studio.job.deployContentToEnvironment.status.message.ready");
                statusMessage = statusMessage.replace("{package_id}", currentPackageId).replace("{datetime}", ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ofPattern(sdf.toPattern()))).replace("{package_size}", Integer.toString(itemsToDeploy.size()));
            } else {
                status = "queued";
                statusMessage = this.studioConfiguration.getProperty("studio.job.deployContentToEnvironment.status.message.queued");
            }
            this.siteService.updatePublishingStatusMessage(siteId, status, statusMessage);
        }
        catch (DeploymentException err) {
            logger.error("Error while executing deployment to environment store for site \"{0}\", number of items \"{1}\"", err, siteId, itemsToDeploy.size());
            this.publishingManager.markItemsReady(siteId, environment, itemsToDeploy);
            this.siteService.enablePublishing(siteId, false);
            String statusMessage = this.studioConfiguration.getProperty("studio.job.deployContentToEnvironment.status.message.error");
            this.siteService.updatePublishingStatusMessage(siteId, "error", statusMessage);
            throw err;
        }
        catch (Exception err) {
            logger.error("Unexpected error while executing deployment to environment store for site \"{0}\", number of items \"{1}\"", err, siteId, itemsToDeploy.size());
            this.publishingManager.markItemsReady(siteId, environment, itemsToDeploy);
            this.siteService.enablePublishing(siteId, false);
            String statusMessage = this.studioConfiguration.getProperty("studio.job.deployContentToEnvironment.status.message.error");
            this.siteService.updatePublishingStatusMessage(siteId, "error", statusMessage);
            throw err;
        }
    }

    private void processPublishingRequest(String siteId, String environment, PublishRequest item, List<DeploymentItemTO> completeDeploymentItemList, Set<String> processedPaths) throws ServiceLayerException, DeploymentException {
        ArrayList<DeploymentItemTO> missingDependencies = new ArrayList<DeploymentItemTO>();
        HashSet<String> missingDependenciesPaths = new HashSet<String>();
        try {
            ArrayList<DeploymentItemTO> deploymentItemList = new ArrayList<DeploymentItemTO>();
            logger.debug("Processing [{0}] content item for site \"{1}\"", item.getPath(), siteId);
            DeploymentItemTO deploymentItem = this.publishingManager.processItem(item);
            if (deploymentItem != null) {
                deploymentItemList.add(deploymentItem);
            }
            logger.debug("Processing COMPLETE [{0}] content item for site \"{1}\"", item.getPath(), siteId);
            if (this.isMandatoryDependenciesCheckEnabled()) {
                logger.debug("Processing Mandatory Deps [{0}] content item for site \"{1}\"", item.getPath(), siteId);
                missingDependencies.addAll(this.publishingManager.processMandatoryDependencies(item, processedPaths, missingDependenciesPaths));
                logger.debug("Processing Mandatory Dependencies COMPLETE [{0}] content item for site \"{1}\"", item.getPath(), siteId);
            }
            deploymentItemList.addAll(missingDependencies);
            completeDeploymentItemList.addAll(deploymentItemList);
        }
        catch (DeploymentException err) {
            logger.error("Error while executing deployment to environment store for site \"{0}\",", err, siteId);
            this.publishingManager.markItemsReady(siteId, environment, Arrays.asList(item));
            this.siteService.enablePublishing(siteId, false);
            String statusMessage = this.studioConfiguration.getProperty("studio.job.deployContentToEnvironment.status.message.error");
            this.siteService.updatePublishingStatusMessage(siteId, "error", statusMessage);
            throw err;
        }
        catch (Exception err) {
            logger.error("Unexpected error while executing deployment to environment store for site \"{0}\", ", err, siteId);
            this.publishingManager.markItemsReady(siteId, environment, Arrays.asList(item));
            this.siteService.enablePublishing(siteId, false);
            String statusMessage = this.studioConfiguration.getProperty("studio.job.deployContentToEnvironment.status.message.error");
            this.siteService.updatePublishingStatusMessage(siteId, "error", statusMessage);
            throw err;
        }
    }

    private void deploy(String site, String environment, List<DeploymentItemTO> items, String author, String comment) throws DeploymentException, SiteNotFoundException {
        String liveEnvironment;
        logger.debug("Deploying " + items.size() + " item(s)", new Object[0]);
        SiteFeed siteFeed = this.siteService.getSite(site);
        if (this.servicesConfig.isStagingEnvironmentEnabled(site) && StringUtils.equals((CharSequence)(liveEnvironment = this.servicesConfig.getLiveEnvironment(site)), (CharSequence)environment)) {
            String stagingEnvironment = this.servicesConfig.getStagingEnvironment(site);
            this.contentRepository.publish(site, siteFeed.getSandboxBranch(), items, stagingEnvironment, author, comment);
        }
        this.contentRepository.publish(site, siteFeed.getSandboxBranch(), items, environment, author, comment);
    }

    protected void generateWorkflowActivity(String site, String environment, Set<String> packageIds, String username, String operation) throws SiteNotFoundException {
        SiteFeed siteFeed = this.siteService.getSite(site);
        AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
        auditLog.setOperation(operation);
        auditLog.setActorId(username);
        auditLog.setSiteId(siteFeed.getId());
        auditLog.setPrimaryTargetId(site + ":" + environment);
        auditLog.setPrimaryTargetType("Content Item");
        auditLog.setPrimaryTargetValue(environment);
        ArrayList<AuditLogParameter> auditLogParameters = new ArrayList<AuditLogParameter>();
        for (String packageId : packageIds) {
            AuditLogParameter auditLogParameter = new AuditLogParameter();
            auditLogParameter.setTargetId(site + ":" + environment);
            auditLogParameter.setTargetType("Content Item");
            auditLogParameter.setTargetValue(packageId);
            auditLogParameters.add(auditLogParameter);
        }
        auditLog.setParameters(auditLogParameters);
        this.auditServiceInternal.insertAuditLog(auditLog);
    }

    private boolean isMandatoryDependenciesCheckEnabled() {
        boolean toReturn = Boolean.parseBoolean(this.studioConfiguration.getProperty("studio.job.deployContentToEnvironment.mandatoryDependenciesCheckEnabled"));
        return toReturn;
    }

    private Set<String> getAllPublishingEnvironments(String site) {
        HashSet<String> environments = new HashSet<String>();
        environments.add(this.servicesConfig.getLiveEnvironment(site));
        if (this.servicesConfig.isStagingEnvironmentEnabled(site)) {
            environments.add(this.servicesConfig.getStagingEnvironment(site));
        }
        return environments;
    }
}

