/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.job;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.dal.SiteFeed;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.deployment.DeploymentService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v2.dal.GitLog;
import org.craftercms.studio.api.v2.repository.ContentRepository;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.impl.v2.job.StudioClockTask;

public class StudioSyncRepositoryTask
extends StudioClockTask {
    private static final Logger logger = LoggerFactory.getLogger(StudioSyncRepositoryTask.class);
    private static int threadCounter = 0;
    private ContentRepository contentRepository;
    private DeploymentService deploymentService;

    public StudioSyncRepositoryTask(int executeEveryNCycles, int offset, StudioConfiguration studioConfiguration, SiteService siteService, ContentRepository contentRepository, DeploymentService deploymentService) {
        super(executeEveryNCycles, offset, studioConfiguration, siteService);
        this.contentRepository = contentRepository;
        this.deploymentService = deploymentService;
        ++threadCounter;
    }

    @Override
    protected void executeInternal(String site) {
        try {
            try {
                logger.debug("Executing sync repository thread ID = " + threadCounter + "; " + Thread.currentThread().getId(), new Object[0]);
                String siteState = this.siteService.getSiteState(site);
                if (StringUtils.equals((CharSequence)siteState, (CharSequence)"CREATED")) {
                    this.syncRepository(site);
                }
            }
            catch (Exception e) {
                logger.error("Failed to sync database from repository for site " + site, e, new Object[0]);
            }
        }
        catch (Exception e) {
            logger.error("Failed to sync database from repository for site " + site, e, new Object[0]);
        }
    }

    private void syncRepository(String site) throws SiteNotFoundException, IOException {
        String lastProcessedCommit;
        logger.debug("Getting last verified commit for site: " + site, new Object[0]);
        SiteFeed siteFeed = this.siteService.getSite(site);
        if (this.checkSiteUuid(site, siteFeed.getSiteUuid()) && StringUtils.isNotEmpty((CharSequence)(lastProcessedCommit = this.siteService.getLastVerifiedGitlogCommitId(site)))) {
            logger.debug("Syncing database with repository for site " + site + " from last processed commit " + lastProcessedCommit, new Object[0]);
            GitLog gl = this.contentRepository.getGitLog(site, lastProcessedCommit);
            if (Objects.nonNull(gl)) {
                List<GitLog> unprocessedCommitIds = this.contentRepository.getUnprocessedCommits(site, gl.getId());
                if (unprocessedCommitIds != null && unprocessedCommitIds.size() > 0) {
                    this.siteService.syncDatabaseWithRepoUnprocessedCommits(site, unprocessedCommitIds);
                    GitLog gitLog = unprocessedCommitIds.get(0);
                    String commitBeforeUnprocessedCommit = this.contentRepository.getPreviousCommitId(site, gitLog.getCommitId());
                    this.siteService.syncDatabaseWithRepo(site, commitBeforeUnprocessedCommit);
                    unprocessedCommitIds.forEach(x -> this.contentRepository.markGitLogVerifiedProcessed(site, x.getCommitId()));
                    try {
                        logger.debug("Sync preview for site " + site, new Object[0]);
                        this.deploymentService.syncAllContentToPreview(site, false);
                    }
                    catch (ServiceLayerException e) {
                        logger.error("Error synchronizing preview with repository for site: " + site, e, new Object[0]);
                    }
                } else {
                    String lastRepoCommitId = this.contentRepository.getRepoLastCommitId(site);
                    GitLog gl2 = this.contentRepository.getGitLog(site, lastRepoCommitId);
                    if (Objects.nonNull(gl2) && !StringUtils.equals((CharSequence)lastRepoCommitId, (CharSequence)lastProcessedCommit)) {
                        this.siteService.updateLastVerifiedGitlogCommitId(site, lastRepoCommitId);
                        this.contentRepository.markGitLogProcessedBeforeMarker(site, gl2.getId(), 1);
                    } else {
                        this.contentRepository.markGitLogProcessedBeforeMarker(site, gl.getId(), 1);
                    }
                }
            }
        }
    }

    private boolean checkSiteUuid(String siteId, String siteUuid) {
        boolean toRet = false;
        try {
            Path path = Paths.get(this.studioConfiguration.getProperty("studio.repo.basePath"), this.studioConfiguration.getProperty("studio.repo.sitesRepoBasePath"), siteId, "site-uuid.txt");
            List<String> lines = Files.readAllLines(path);
            for (String line : lines) {
                if (StringUtils.startsWith((CharSequence)line, (CharSequence)"#") || !StringUtils.equals((CharSequence)line, (CharSequence)siteUuid)) continue;
                toRet = true;
                break;
            }
        }
        catch (IOException e) {
            logger.info("Invalid site UUID. Local copy will not be deleted", new Object[0]);
        }
        return toRet;
    }
}

