/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.repository;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.iterators.ReverseListIterator;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.crypto.CryptoException;
import org.craftercms.commons.crypto.TextEncryptor;
import org.craftercms.studio.api.v1.constant.GitRepositories;
import org.craftercms.studio.api.v1.dal.DeploymentSyncHistory;
import org.craftercms.studio.api.v1.dal.SiteFeedMapper;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteRepositoryCredentialsException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteRepositoryException;
import org.craftercms.studio.api.v1.exception.repository.RemoteRepositoryNotFoundException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.GeneralLockService;
import org.craftercms.studio.api.v1.service.content.ObjectMetadataManager;
import org.craftercms.studio.api.v1.service.deployment.DeploymentException;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v1.to.DeploymentItemTO;
import org.craftercms.studio.api.v1.util.filter.DmFilterWrapper;
import org.craftercms.studio.api.v2.annotation.RetryingOperation;
import org.craftercms.studio.api.v2.dal.ClusterDAO;
import org.craftercms.studio.api.v2.dal.ClusterMember;
import org.craftercms.studio.api.v2.dal.GitLog;
import org.craftercms.studio.api.v2.dal.GitLogDAO;
import org.craftercms.studio.api.v2.dal.PublishingHistoryItem;
import org.craftercms.studio.api.v2.dal.RemoteRepository;
import org.craftercms.studio.api.v2.dal.RemoteRepositoryDAO;
import org.craftercms.studio.api.v2.dal.RepoOperation;
import org.craftercms.studio.api.v2.dal.RetryingOperationFacade;
import org.craftercms.studio.api.v2.dal.User;
import org.craftercms.studio.api.v2.repository.ContentRepository;
import org.craftercms.studio.api.v2.repository.RetryingRepositoryOperationFacade;
import org.craftercms.studio.api.v2.service.deployment.DeploymentHistoryProvider;
import org.craftercms.studio.api.v2.service.security.internal.UserServiceInternal;
import org.craftercms.studio.api.v2.utils.GitRepositoryHelper;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.impl.v1.repository.git.GitContentRepositoryConstants;
import org.craftercms.studio.impl.v2.utils.RingBuffer;
import org.craftercms.studio.impl.v2.utils.StudioUtils;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.DeleteBranchCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.RemoteRemoveCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.api.TagCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.AndRevFilter;
import org.eclipse.jgit.revwalk.filter.AuthorRevFilter;
import org.eclipse.jgit.revwalk.filter.CommitTimeRevFilter;
import org.eclipse.jgit.revwalk.filter.MessageRevFilter;
import org.eclipse.jgit.revwalk.filter.NotRevFilter;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.springframework.dao.DuplicateKeyException;

public class GitContentRepository
implements ContentRepository,
DeploymentHistoryProvider {
    private static final Logger logger = LoggerFactory.getLogger(GitContentRepository.class);
    private StudioConfiguration studioConfiguration;
    private GitLogDAO gitLogDao;
    private SiteFeedMapper siteFeedMapper;
    private UserServiceInternal userServiceInternal;
    private SecurityService securityService;
    private RemoteRepositoryDAO remoteRepositoryDAO;
    private TextEncryptor encryptor;
    private ClusterDAO clusterDao;
    private GeneralLockService generalLockService;
    private SiteService siteService;
    private ObjectMetadataManager objectMetadataManager;
    private StudioUtils studioUtils;
    private RetryingOperationFacade retryingOperationFacade;
    private RetryingRepositoryOperationFacade retryingRepositoryOperationFacade;

    @Override
    public List<String> getSubtreeItems(String site, String path) {
        ArrayList<String> retItems;
        block37: {
            String rootPath;
            retItems = new ArrayList<String>();
            if (path.endsWith("/index.xml")) {
                int lastIdx = path.lastIndexOf("/index.xml");
                rootPath = path.substring(0, lastIdx);
            } else {
                rootPath = path;
            }
            try {
                GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
                Repository repo = helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
                RevTree tree = helper.getTreeForLastCommit(repo);
                try (TreeWalk tw = TreeWalk.forPath((Repository)repo, (String)helper.getGitPath(rootPath), (RevTree)tree);){
                    if (tw != null) {
                        ObjectLoader loader = repo.open((AnyObjectId)tw.getObjectId(0));
                        if (loader.getType() == 2) {
                            tw.enterSubtree();
                            tw.setRecursive(true);
                            while (tw.next()) {
                                String name = tw.getNameString();
                                String childPath = "/" + tw.getPathString();
                                if (ArrayUtils.contains((Object[])GitContentRepositoryConstants.IGNORE_FILES, (Object)name) || childPath.equals(path)) continue;
                                retItems.add(childPath);
                            }
                            tw.close();
                        } else {
                            logger.debug("Object is not tree for site: " + site + " path: " + path + " - it does not have children", new Object[0]);
                        }
                        break block37;
                    }
                    String gitPath = helper.getGitPath(rootPath);
                    if (!StringUtils.isEmpty((CharSequence)gitPath) && !gitPath.equals(".")) break block37;
                    try (TreeWalk treeWalk = new TreeWalk(repo);){
                        treeWalk.addTree((AnyObjectId)tree);
                        treeWalk.setRecursive(true);
                        while (treeWalk.next()) {
                            String name = treeWalk.getNameString();
                            String childPath = "/" + treeWalk.getPathString();
                            if (ArrayUtils.contains((Object[])GitContentRepositoryConstants.IGNORE_FILES, (Object)name) || childPath.equals(path)) continue;
                            retItems.add(childPath);
                        }
                    }
                    catch (IOException e) {
                        logger.error("Error while getting children for site: " + site + " path: " + path, e, new Object[0]);
                    }
                }
                catch (IOException e) {
                    logger.error("Error while getting children for site: " + site + " path: " + path, e, new Object[0]);
                }
            }
            catch (IOException | CryptoException e) {
                logger.error("Failed to create RevTree for site: " + site + " path: " + path, (Exception)e, new Object[0]);
            }
        }
        return retItems;
    }

    @Override
    public List<RepoOperation> getOperations(String site, String commitIdFrom, String commitIdTo) {
        ArrayList<RepoOperation> operations;
        block63: {
            operations = new ArrayList<RepoOperation>();
            try {
                GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
                Repository repository = helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
                if (repository == null) break block63;
                try {
                    boolean fromEmptyRepo = StringUtils.isEmpty((CharSequence)commitIdFrom);
                    String firstCommitId = this.getRepoFirstCommitId(site);
                    if (fromEmptyRepo) {
                        commitIdFrom = firstCommitId;
                    }
                    Repository repo = helper.getRepository(site, GitRepositories.SANDBOX);
                    ObjectId objCommitIdFrom = repo.resolve(commitIdFrom);
                    ObjectId objCommitIdTo = repo.resolve(commitIdTo);
                    ObjectId objFirstCommitId = repo.resolve(firstCommitId);
                    try (Git git = new Git(repo);){
                        if (fromEmptyRepo) {
                            try (RevWalk walk = new RevWalk(repo);){
                                RevCommit firstCommit = walk.parseCommit((AnyObjectId)objFirstCommitId);
                                try (ObjectReader reader = repo.newObjectReader();){
                                    CanonicalTreeParser firstCommitTreeParser = new CanonicalTreeParser();
                                    firstCommitTreeParser.reset();
                                    long startDiffMark1 = logger.isDebugEnabled() ? System.currentTimeMillis() : 0L;
                                    List diffEntries = git.diff().setOldTree((AbstractTreeIterator)firstCommitTreeParser).setNewTree(null).call();
                                    if (logger.isDebugEnabled()) {
                                        logger.debug("Diff from " + objFirstCommitId.getName() + " to null  finished in " + (System.currentTimeMillis() - startDiffMark1) / 1000L + " seconds", new Object[0]);
                                        logger.debug("Number of diff entries " + diffEntries.size(), new Object[0]);
                                    }
                                    operations.addAll(this.processDiffEntry(git, diffEntries, firstCommit.getId()));
                                }
                            }
                        }
                        if (objCommitIdFrom.equals((AnyObjectId)objCommitIdTo)) break block63;
                        Iterable commits = git.log().addRange((AnyObjectId)objCommitIdFrom, (AnyObjectId)objCommitIdTo).call();
                        ObjectId prevCommitId = objCommitIdFrom;
                        ObjectId nextCommitId = objCommitIdFrom;
                        String author = "";
                        Iterator iterator = commits.iterator();
                        ArrayList<RevCommit> revCommits = new ArrayList<RevCommit>();
                        while (iterator.hasNext()) {
                            RevCommit commit = (RevCommit)iterator.next();
                            revCommits.add(commit);
                        }
                        ReverseListIterator reverseIterator = new ReverseListIterator(revCommits);
                        while (reverseIterator.hasNext()) {
                            RevCommit commit = (RevCommit)reverseIterator.next();
                            if (StringUtils.contains((CharSequence)commit.getFullMessage(), (CharSequence)this.studioConfiguration.getProperty("studio.repo.syncDB.commitMessage.noProcessing"))) {
                                prevCommitId = commit.getId();
                                logger.debug("Skipping commitId: " + prevCommitId.getName() + " for site " + site + " because it is marked not to be processed.", new Object[0]);
                                GitLog gitLog = this.getGitLog(site, prevCommitId.getName());
                                if (gitLog != null) {
                                    this.markGitLogVerifiedProcessed(site, prevCommitId.getName());
                                } else {
                                    this.insertGitLog(site, prevCommitId.getName(), 1);
                                }
                                this.updateLastVerifiedGitlogCommitId(site, prevCommitId.getName());
                                continue;
                            }
                            nextCommitId = commit.getId();
                            if (commit.getAuthorIdent() != null) {
                                author = commit.getAuthorIdent().getName();
                            }
                            if (StringUtils.isEmpty((CharSequence)author)) {
                                author = commit.getCommitterIdent().getName();
                            }
                            RevTree prevTree = helper.getTreeForCommit(repo, prevCommitId.getName());
                            RevTree nextTree = helper.getTreeForCommit(repo, nextCommitId.getName());
                            if (prevTree == null || nextTree == null) continue;
                            ObjectReader reader = repo.newObjectReader();
                            Throwable throwable = null;
                            try {
                                CanonicalTreeParser prevCommitTreeParser = new CanonicalTreeParser();
                                CanonicalTreeParser nextCommitTreeParser = new CanonicalTreeParser();
                                prevCommitTreeParser.reset(reader, (AnyObjectId)prevTree.getId());
                                nextCommitTreeParser.reset(reader, (AnyObjectId)nextTree.getId());
                                long startDiffMark2 = logger.isDebugEnabled() ? System.currentTimeMillis() : 0L;
                                List diffEntries = git.diff().setOldTree((AbstractTreeIterator)prevCommitTreeParser).setNewTree((AbstractTreeIterator)nextCommitTreeParser).call();
                                if (logger.isDebugEnabled()) {
                                    logger.debug("Diff from " + objCommitIdFrom.getName() + " to " + objCommitIdTo.getName() + " finished in " + (System.currentTimeMillis() - startDiffMark2) / 1000L + " seconds", new Object[0]);
                                    logger.debug("Number of diff entries " + diffEntries.size(), new Object[0]);
                                }
                                operations.addAll(this.processDiffEntry(git, diffEntries, nextCommitId));
                                prevCommitId = nextCommitId;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (reader == null) continue;
                                if (throwable != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                reader.close();
                            }
                        }
                    }
                    catch (GitAPIException e) {
                        logger.error("Error getting operations for site " + site + " from commit ID: " + commitIdFrom + " to commit ID: " + commitIdTo, (Exception)((Object)e), new Object[0]);
                    }
                }
                catch (IOException e) {
                    logger.error("Error getting operations for site " + site + " from commit ID: " + commitIdFrom + " to commit ID: " + commitIdTo, e, new Object[0]);
                }
            }
            catch (CryptoException e) {
                logger.error("Error getting operations for site " + site + " from commit ID: " + commitIdFrom + " to commit ID: " + commitIdTo, (Exception)((Object)e), new Object[0]);
            }
        }
        return operations;
    }

    @Override
    public List<RepoOperation> getOperationsFromDelta(String site, String commitIdFrom, String commitIdTo) {
        ArrayList<RepoOperation> operations;
        block58: {
            operations = new ArrayList<RepoOperation>();
            try {
                GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
                Repository repository = helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
                if (repository == null) break block58;
                try {
                    boolean fromEmptyRepo = StringUtils.isEmpty((CharSequence)commitIdFrom);
                    String firstCommitId = this.getRepoFirstCommitId(site);
                    if (fromEmptyRepo) {
                        commitIdFrom = firstCommitId;
                    }
                    Repository repo = helper.getRepository(site, GitRepositories.SANDBOX);
                    ObjectId objCommitIdFrom = repo.resolve(commitIdFrom);
                    ObjectId objCommitIdTo = repo.resolve(commitIdTo);
                    if (!Objects.nonNull(objCommitIdFrom) || !Objects.nonNull(objCommitIdTo)) break block58;
                    ObjectId objFirstCommitId = repo.resolve(firstCommitId);
                    try (Git git = new Git(repo);){
                        List diffEntries;
                        if (fromEmptyRepo) {
                            try (RevWalk walk = new RevWalk(repo);){
                                RevCommit firstCommit = walk.parseCommit((AnyObjectId)objFirstCommitId);
                                try (ObjectReader reader = repo.newObjectReader();){
                                    CanonicalTreeParser firstCommitTreeParser = new CanonicalTreeParser();
                                    firstCommitTreeParser.reset();
                                    long startDiffMark1 = logger.isDebugEnabled() ? System.currentTimeMillis() : 0L;
                                    diffEntries = git.diff().setOldTree((AbstractTreeIterator)firstCommitTreeParser).setNewTree(null).call();
                                    if (logger.isDebugEnabled()) {
                                        logger.debug("Diff from " + objFirstCommitId.getName() + " to null finished in " + (System.currentTimeMillis() - startDiffMark1) / 1000L + " seconds", new Object[0]);
                                        logger.debug("Number of diff entries " + diffEntries.size(), new Object[0]);
                                    }
                                    operations.addAll(this.processDiffEntry(git, diffEntries, firstCommit.getId()));
                                }
                            }
                        }
                        if (objCommitIdFrom.equals((AnyObjectId)objCommitIdTo)) break block58;
                        RevTree fromTree = helper.getTreeForCommit(repo, objCommitIdFrom.getName());
                        RevTree toTree = helper.getTreeForCommit(repo, objCommitIdTo.getName());
                        if (fromTree == null || toTree == null) break block58;
                        try (ObjectReader reader = repo.newObjectReader();){
                            CanonicalTreeParser fromCommitTreeParser = new CanonicalTreeParser();
                            CanonicalTreeParser toCommitTreeParser = new CanonicalTreeParser();
                            fromCommitTreeParser.reset(reader, (AnyObjectId)fromTree.getId());
                            toCommitTreeParser.reset(reader, (AnyObjectId)toTree.getId());
                            long startDiffMark2 = logger.isDebugEnabled() ? System.currentTimeMillis() : 0L;
                            diffEntries = git.diff().setOldTree((AbstractTreeIterator)fromCommitTreeParser).setNewTree((AbstractTreeIterator)toCommitTreeParser).call();
                            if (logger.isDebugEnabled()) {
                                logger.debug("Diff from " + objCommitIdFrom.getName() + " to " + objCommitIdTo.getName() + " finished in " + (System.currentTimeMillis() - startDiffMark2) / 1000L + " seconds", new Object[0]);
                                logger.debug("Number of diff entries " + diffEntries.size(), new Object[0]);
                            }
                            operations.addAll(this.processDiffEntry(git, diffEntries, objCommitIdTo));
                        }
                    }
                    catch (GitAPIException e) {
                        logger.error("Error getting operations for site " + site + " from commit ID: " + commitIdFrom + " to commit ID: " + commitIdTo, (Exception)((Object)e), new Object[0]);
                    }
                }
                catch (IOException e) {
                    logger.error("Error getting operations for site " + site + " from commit ID: " + commitIdFrom + " to commit ID: " + commitIdTo, e, new Object[0]);
                }
            }
            catch (CryptoException e) {
                logger.error("Error getting operations for site " + site + " from commit ID: " + commitIdFrom + " to commit ID: " + commitIdTo, (Exception)((Object)e), new Object[0]);
            }
        }
        return operations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRepoFirstCommitId(String site) {
        String toReturn;
        block21: {
            toReturn = "";
            try {
                GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
                Repository repository = helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
                if (repository == null) break block21;
                Repository repository2 = repository;
                synchronized (repository2) {
                    Repository repo = helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
                    if (repo != null) {
                        try (RevWalk rw = new RevWalk(repo);){
                            ObjectId head = repo.resolve("HEAD");
                            if (head != null) {
                                RevCommit root = rw.parseCommit((AnyObjectId)head);
                                rw.sort(RevSort.REVERSE);
                                rw.markStart(root);
                                RevCommit first = rw.next();
                                toReturn = first.getName();
                                logger.debug("getRepoFirstCommitId for site: " + site + " First commit ID: " + toReturn, new Object[0]);
                            }
                        }
                        catch (IOException e) {
                            logger.error("Error getting first commit ID for site " + site, e, new Object[0]);
                        }
                    }
                }
            }
            catch (CryptoException e) {
                logger.error("Error getting first commit ID for site " + site, (Exception)((Object)e), new Object[0]);
            }
        }
        return toReturn;
    }

    private List<RepoOperation> processDiffEntry(Git git, List<DiffEntry> diffEntries, ObjectId commitId) throws GitAPIException, IOException {
        int size = diffEntries.size();
        logger.debug("Processing " + size + " diff entries", new Object[0]);
        long startMark = logger.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        ArrayList<RepoOperation> toReturn = new ArrayList<RepoOperation>();
        int idx = 0;
        for (DiffEntry diffEntry : diffEntries) {
            logger.debug("Processing " + ++idx + " of " + size + " diff entries", new Object[0]);
            long startProcessEntryMark = logger.isDebugEnabled() ? System.currentTimeMillis() : 0L;
            String pathNew = "/" + diffEntry.getNewPath();
            String pathOld = "/" + diffEntry.getOldPath();
            if (ArrayUtils.contains((Object[])GitContentRepositoryConstants.IGNORE_FILES, (Object)FilenameUtils.getName((String)pathNew)) || ArrayUtils.contains((Object[])GitContentRepositoryConstants.IGNORE_FILES, (Object)FilenameUtils.getName((String)pathOld))) continue;
            RepoOperation repoOperation = null;
            Iterable iterable = null;
            RevCommit revCommit = null;
            ZonedDateTime commitTime = null;
            String author = null;
            try (Repository repo = git.getRepository();
                 RevWalk revWalk = new RevWalk(repo);){
                revCommit = revWalk.parseCommit((AnyObjectId)commitId);
            }
            if (revCommit == null) {
                iterable = git.log().setMaxCount(1).call();
                revCommit = (RevCommit)iterable.iterator().next();
            }
            commitTime = Instant.ofEpochSecond(revCommit.getCommitTime()).atZone(ZoneOffset.UTC);
            author = revCommit.getAuthorIdent().getName();
            switch (diffEntry.getChangeType()) {
                case ADD: {
                    repoOperation = new RepoOperation(RepoOperation.Action.CREATE, pathNew, commitTime, null, revCommit.getId().getName());
                    break;
                }
                case MODIFY: {
                    repoOperation = new RepoOperation(RepoOperation.Action.UPDATE, pathNew, commitTime, null, revCommit.getId().getName());
                    break;
                }
                case DELETE: {
                    repoOperation = new RepoOperation(RepoOperation.Action.DELETE, pathOld, commitTime, null, revCommit.getId().getName());
                    break;
                }
                case RENAME: {
                    repoOperation = new RepoOperation(RepoOperation.Action.MOVE, pathOld, commitTime, pathNew, commitId.getName());
                    break;
                }
                case COPY: {
                    repoOperation = new RepoOperation(RepoOperation.Action.COPY, pathNew, commitTime, null, commitId.getName());
                    break;
                }
                default: {
                    logger.error("Error: Unknown git operation " + diffEntry.getChangeType(), new Object[0]);
                }
            }
            if (repoOperation != null && !repoOperation.getPath().endsWith(".keep")) {
                repoOperation.setAuthor(StringUtils.isEmpty((CharSequence)author) ? "N/A" : author);
                toReturn.add(repoOperation);
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Finished processing " + idx + " of " + size + " entries in " + (System.currentTimeMillis() - startProcessEntryMark) / 1000L + " seconds", new Object[0]);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Finished processing " + size + " diff entries in " + (System.currentTimeMillis() - startMark) / 1000L + " seconds", new Object[0]);
        }
        return toReturn;
    }

    @Override
    public GitLog getGitLog(String siteId, String commitId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("siteId", siteId);
        params.put("commitId", commitId);
        return this.gitLogDao.getGitLog(params);
    }

    @Override
    public void markGitLogVerifiedProcessed(String siteId, String commitId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("siteId", siteId);
        params.put("commitId", commitId);
        params.put("processed", 1);
        this.retryingOperationFacade.markGitLogProcessed(params);
    }

    @Override
    @RetryingOperation
    public void markGitLogVerifiedProcessedBulk(String siteId, List<String> commitIds) {
        if (CollectionUtils.isNotEmpty(commitIds)) {
            int batchSize = this.studioUtils.getBulkOperationsBatchSize();
            ArrayList<List<String>> partitions = new ArrayList<List<String>>();
            for (int i = 0; i < commitIds.size(); i += batchSize) {
                partitions.add(commitIds.subList(i, Math.min(i + batchSize, commitIds.size())));
            }
            for (List list : partitions) {
                this.gitLogDao.markGitLogProcessedBulk(siteId, list);
            }
        }
    }

    @Override
    @RetryingOperation
    public void insertGitLog(String siteId, String commitId, int processed) {
        this.insertGitLog(siteId, commitId, processed, 0);
    }

    @Override
    @RetryingOperation
    public void insertGitLog(String siteId, String commitId, int processed, int audited) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("siteId", siteId);
        params.put("commitId", commitId);
        params.put("processed", processed);
        params.put("audited", audited);
        try {
            this.gitLogDao.insertGitLog(params);
        }
        catch (DuplicateKeyException e) {
            logger.debug("Failed to insert commit id: " + commitId + " for site: " + siteId + " into gitlog table, because it is duplicate entry. Marking it as not processed so it can be processed by sync database task.", new Object[0]);
            params = new HashMap();
            params.put("siteId", siteId);
            params.put("commitId", commitId);
            params.put("processed", 0);
            this.gitLogDao.markGitLogProcessed(params);
        }
    }

    private void updateLastVerifiedGitlogCommitId(String site, String commitId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("siteId", site);
        params.put("commitId", commitId);
        this.siteFeedMapper.updateLastVerifiedGitlogCommitId(params);
    }

    @Override
    public List<PublishingHistoryItem> getPublishingHistory(String siteId, String environment, String pathRegex, String publisher, ZonedDateTime fromDate, ZonedDateTime toDate, int limit) {
        ArrayList<PublishingHistoryItem> toRet;
        block25: {
            toRet = new ArrayList<PublishingHistoryItem>();
            try {
                GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
                Repository publishedRepo = helper.getRepository(siteId, GitRepositories.PUBLISHED);
                if (publishedRepo == null) break block25;
                int counter = 0;
                try (Git git = new Git(publishedRepo);){
                    List environments = git.branchList().call();
                    for (int i = 0; i < environments.size() && counter < limit; ++i) {
                        Ref env = (Ref)environments.get(i);
                        String environmentGit = env.getName();
                        environmentGit = environmentGit.replace("refs/heads/", "");
                        if ((!StringUtils.isBlank((CharSequence)environment) || StringUtils.equals((CharSequence)"master", (CharSequence)environmentGit)) && !StringUtils.equals((CharSequence)environment, (CharSequence)environmentGit)) continue;
                        ArrayList<RevFilter> filters = new ArrayList<RevFilter>();
                        if (fromDate != null) {
                            filters.add(CommitTimeRevFilter.after((long)fromDate.toInstant().toEpochMilli()));
                        }
                        if (toDate != null) {
                            filters.add(CommitTimeRevFilter.before((long)toDate.toInstant().toEpochMilli()));
                        } else {
                            filters.add(CommitTimeRevFilter.before((long)ZonedDateTime.now().toInstant().toEpochMilli()));
                        }
                        filters.add(NotRevFilter.create((RevFilter)MessageRevFilter.create((String)"Initial commit.")));
                        if (StringUtils.isNotEmpty((CharSequence)publisher)) {
                            User user = this.userServiceInternal.getUserByIdOrUsername(-1L, publisher);
                            filters.add(AuthorRevFilter.create((String)helper.getAuthorIdent(user).getName()));
                        }
                        Iterable branchLog = git.log().add((AnyObjectId)env.getObjectId()).setRevFilter(AndRevFilter.create(filters)).call();
                        Iterator iterator = branchLog.iterator();
                        while (iterator.hasNext() && counter < limit) {
                            RevCommit revCommit = (RevCommit)iterator.next();
                            List<String> files = helper.getFilesInCommit(publishedRepo, revCommit);
                            for (int j = 0; j < files.size() && counter < limit; ++j) {
                                String file = files.get(j);
                                Path path = Paths.get(file, new String[0]);
                                String fileName = path.getFileName().toString();
                                if (ArrayUtils.contains((Object[])GitContentRepositoryConstants.IGNORE_FILES, (Object)fileName)) continue;
                                boolean addFile = false;
                                if (StringUtils.isNotEmpty((CharSequence)pathRegex)) {
                                    Pattern pattern = Pattern.compile(pathRegex);
                                    Matcher matcher = pattern.matcher(file);
                                    addFile = matcher.matches();
                                } else {
                                    addFile = true;
                                }
                                if (!addFile) continue;
                                PublishingHistoryItem phi = new PublishingHistoryItem();
                                phi.setSiteId(siteId);
                                phi.setPath(file);
                                phi.setPublishedDate(Instant.ofEpochSecond(revCommit.getCommitTime()).atZone(ZoneOffset.UTC));
                                phi.setPublisher(revCommit.getAuthorIdent().getName());
                                phi.setEnvironment(environmentGit.replace("refs/heads/", ""));
                                toRet.add(phi);
                                ++counter;
                            }
                        }
                    }
                    git.close();
                    toRet.sort((o1, o2) -> o2.getPublishedDate().compareTo(o1.getPublishedDate()));
                }
                catch (IOException | ServiceLayerException | UserNotFoundException | GitAPIException e1) {
                    logger.error("Error while getting deployment history for site " + siteId, (Exception)e1, new Object[0]);
                }
            }
            catch (CryptoException e) {
                e.printStackTrace();
            }
        }
        return toRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createSiteFromBlueprint(String blueprintLocation, String site, String sandboxBranch, Map<String, String> params) {
        boolean toReturn;
        String gitLockKey = "{site}_SANDBOX_REPOSITORY_GIT_LOCK".replaceAll("\\{site\\}", site);
        this.generalLockService.lock(gitLockKey);
        try {
            GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
            toReturn = helper.createSandboxRepository(site, sandboxBranch);
            if (toReturn) {
                toReturn = helper.copyContentFromBlueprint(blueprintLocation, site);
            }
            if (toReturn) {
                toReturn = helper.updateSiteNameConfigVar(site);
            }
            if (toReturn) {
                toReturn = helper.replaceParameters(site, params);
            }
            if (toReturn) {
                toReturn = helper.addGitIgnoreFile(site);
            }
            if (toReturn) {
                toReturn = helper.performInitialCommit(site, helper.getCommitMessage("studio.repo.initialCommit.commitMessage"), sandboxBranch);
            }
        }
        catch (CryptoException e) {
            logger.error("Error creating site from blueprint", (Exception)((Object)e), new Object[0]);
            toReturn = false;
        }
        finally {
            this.generalLockService.unlock(gitLockKey);
        }
        return toReturn;
    }

    @Override
    public List<DeploymentSyncHistory> getDeploymentHistory(String site, List<String> environmentNames, ZonedDateTime fromDate, ZonedDateTime toDate, DmFilterWrapper dmFilterWrapper, String filterType, int numberOfItems) {
        ArrayList<DeploymentSyncHistory> toRet;
        block17: {
            toRet = new ArrayList<DeploymentSyncHistory>();
            try {
                GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
                Repository publishedRepo = helper.getRepository(site, GitRepositories.PUBLISHED);
                if (!Objects.nonNull(publishedRepo)) break block17;
                int counter = 0;
                try (Git git = new Git(publishedRepo);){
                    List environments = git.branchList().call();
                    for (int i = 0; i < environments.size() && counter < numberOfItems; ++i) {
                        Ref env = (Ref)environments.get(i);
                        String environment = env.getName();
                        if (!environmentNames.contains(environment = environment.replace("refs/heads/", ""))) continue;
                        ArrayList<RevFilter> filters = new ArrayList<RevFilter>();
                        filters.add(CommitTimeRevFilter.after((long)fromDate.toInstant().toEpochMilli()));
                        filters.add(CommitTimeRevFilter.before((long)toDate.toInstant().toEpochMilli()));
                        filters.add(NotRevFilter.create((RevFilter)MessageRevFilter.create((String)"Initial commit.")));
                        Iterable branchLog = git.log().add((AnyObjectId)env.getObjectId()).setRevFilter(AndRevFilter.create(filters)).call();
                        Iterator iterator = branchLog.iterator();
                        while (iterator.hasNext() && counter < numberOfItems) {
                            RevCommit revCommit = (RevCommit)iterator.next();
                            List<String> files = helper.getFilesInCommit(publishedRepo, revCommit);
                            for (int j = 0; j < files.size() && counter < numberOfItems; ++j) {
                                String file = files.get(j);
                                Path path = Paths.get(file, new String[0]);
                                String fileName = path.getFileName().toString();
                                if (ArrayUtils.contains((Object[])GitContentRepositoryConstants.IGNORE_FILES, (Object)fileName) || !dmFilterWrapper.accept(site, file, filterType)) continue;
                                DeploymentSyncHistory dsh = new DeploymentSyncHistory();
                                dsh.setSite(site);
                                dsh.setPath(file);
                                dsh.setSyncDate(Instant.ofEpochSecond(revCommit.getCommitTime()).atZone(ZoneOffset.UTC));
                                dsh.setUser(revCommit.getAuthorIdent().getName());
                                dsh.setEnvironment(environment.replace("refs/heads/", ""));
                                toRet.add(dsh);
                                ++counter;
                            }
                        }
                    }
                    git.close();
                    toRet.sort((o1, o2) -> o2.getSyncDate().compareTo(o1.getSyncDate()));
                }
            }
            catch (IOException | CryptoException | GitAPIException e) {
                logger.error("Error while getting deployment history for site " + site, (Exception)e, new Object[0]);
            }
        }
        return toRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RetryingOperation
    public void publish(String site, String sandboxBranch, List<DeploymentItemTO> deploymentItems, String environment, String author, String comment) throws DeploymentException {
        if (CollectionUtils.isEmpty(deploymentItems)) {
            return;
        }
        String commitId = "";
        String gitLockKey = "{site}_PUBLISHED_REPOSITORY_GIT_LOCK".replaceAll("\\{site\\}", site);
        this.generalLockService.lock(gitLockKey);
        try {
            GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
            Repository repo = helper.getRepository(site, GitRepositories.PUBLISHED);
            boolean repoCreated = false;
            if (Objects.isNull(repo)) {
                helper.createPublishedRepository(site, sandboxBranch);
                repo = helper.getRepository(site, GitRepositories.PUBLISHED);
                repoCreated = Objects.nonNull(repo);
            }
            String path = "";
            String sandboxBranchName = sandboxBranch;
            if (StringUtils.isEmpty((CharSequence)sandboxBranchName)) {
                sandboxBranchName = this.studioConfiguration.getProperty("studio.repo.siteSandboxBranch");
            }
            Repository repository = repo;
            synchronized (repository) {
                try (Git git = new Git(repo);){
                    CheckoutCommand checkoutCommand;
                    String inProgressBranchName = environment + "_in_progress";
                    logger.debug("Fetch from sandbox for site " + site, new Object[0]);
                    FetchCommand fetchCommand = git.fetch();
                    this.retryingRepositoryOperationFacade.call(fetchCommand);
                    logger.debug("Checkout published/master branch for site " + site, new Object[0]);
                    try {
                        Ref ref;
                        String currentBranch = repo.getBranch();
                        if (currentBranch.endsWith("_in_progress")) {
                            ResetCommand resetCommand = git.reset().setMode(ResetCommand.ResetType.HARD);
                            this.retryingRepositoryOperationFacade.call(resetCommand);
                        }
                        boolean createBranch = (ref = repo.exactRef("refs/heads/" + sandboxBranchName)) == null;
                        CheckoutCommand checkoutCommand2 = git.checkout().setName(sandboxBranchName).setCreateBranch(createBranch);
                        this.retryingRepositoryOperationFacade.call(checkoutCommand2);
                        logger.debug("Delete in-progress branch, in case it was not cleaned up for site " + site, new Object[0]);
                        File[] deleteBranchCommand = git.branchDelete().setBranchNames(new String[]{inProgressBranchName}).setForce(true);
                        this.retryingRepositoryOperationFacade.call(deleteBranchCommand);
                        PullCommand pullCommand = git.pull().setRemote("origin").setRemoteBranchName(sandboxBranchName).setStrategy(MergeStrategy.THEIRS);
                        this.retryingRepositoryOperationFacade.call(pullCommand);
                    }
                    catch (RefNotFoundException e) {
                        logger.error("Failed to checkout published master and to pull content from sandbox for site " + site, (Exception)((Object)e), new Object[0]);
                        throw new DeploymentException("Failed to checkout published master and to pull content from sandbox for site " + site);
                    }
                    logger.debug("Checkout environment branch " + environment + " for site " + site, new Object[0]);
                    try {
                        checkoutCommand = git.checkout().setName(environment);
                        this.retryingRepositoryOperationFacade.call(checkoutCommand);
                    }
                    catch (RefNotFoundException e) {
                        File[] toDelete;
                        logger.info("Not able to find branch " + environment + " for site " + site + ". Creating new branch", new Object[0]);
                        CheckoutCommand checkoutCommand3 = git.checkout().setOrphan(true).setForceRefUpdate(true).setStartPoint(sandboxBranchName).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setName(environment);
                        this.retryingRepositoryOperationFacade.call(checkoutCommand3);
                        RmCommand rmcmd = git.rm();
                        for (File toDel : toDelete = repo.getWorkTree().listFiles()) {
                            if (repo.getDirectory().equals(toDel) || StringUtils.equals((CharSequence)toDel.getName(), (CharSequence)".gitignore")) continue;
                            rmcmd.addFilepattern(toDel.getName());
                        }
                        this.retryingRepositoryOperationFacade.call(rmcmd);
                        CommitCommand commitCommand = git.commit().setMessage(helper.getCommitMessage("studio.repo.initialCommit.commitMessage")).setAllowEmpty(true);
                        this.retryingRepositoryOperationFacade.call(commitCommand);
                    }
                    try {
                        logger.debug("Create in-progress branch for site " + site, new Object[0]);
                        checkoutCommand = git.checkout().setCreateBranch(true).setForceRefUpdate(true).setStartPoint(environment).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setName(inProgressBranchName);
                        this.retryingRepositoryOperationFacade.call(checkoutCommand);
                    }
                    catch (GitAPIException e) {
                        logger.error("Failed to create in-progress published branch for site " + site, new Object[0]);
                    }
                    HashSet<String> deployedCommits = new HashSet<String>();
                    HashSet<String> deployedPackages = new HashSet<String>();
                    logger.debug("Checkout deployed files started.", new Object[0]);
                    AddCommand addCommand = git.add();
                    for (DeploymentItemTO deploymentItem : deploymentItems) {
                        commitId = deploymentItem.getCommitId();
                        path = helper.getGitPath(deploymentItem.getPath());
                        if (Objects.isNull(commitId) || !this.commitIdExists(site, GitRepositories.PUBLISHED, commitId)) {
                            if (this.contentExists(site, path)) {
                                if (Objects.isNull(commitId)) {
                                    logger.warn("Commit ID is NULL for content " + path + ". Was the git repo reset at some point?", new Object[0]);
                                } else {
                                    logger.warn("Commit ID " + commitId + " does not exist for content " + path + ". Was the git repo reset at some point?", new Object[0]);
                                }
                                logger.info("Publishing content from HEAD for " + path, new Object[0]);
                                commitId = this.getRepoLastCommitId(site);
                            } else {
                                logger.warn("Skipping file " + path + " because commit id is null", new Object[0]);
                                continue;
                            }
                        }
                        logger.debug("Checking out file " + path + " from commit id " + commitId + " for site " + site, new Object[0]);
                        CheckoutCommand checkout = git.checkout();
                        checkout.setStartPoint(commitId).addPath(path);
                        this.retryingRepositoryOperationFacade.call(checkout);
                        if (deploymentItem.isMove() && !StringUtils.equals((CharSequence)deploymentItem.getPath(), (CharSequence)deploymentItem.getOldPath())) {
                            String oldPath = helper.getGitPath(deploymentItem.getOldPath());
                            RmCommand rmCommand = git.rm().addFilepattern(oldPath).setCached(false);
                            this.retryingRepositoryOperationFacade.call(rmCommand);
                            this.cleanUpMoveFolders(git, oldPath);
                        }
                        if (deploymentItem.isDelete()) {
                            String deletePath = helper.getGitPath(deploymentItem.getPath());
                            boolean isPage = deletePath.endsWith("/index.xml");
                            RmCommand rmCommand = git.rm().addFilepattern(deletePath).setCached(false);
                            this.retryingRepositoryOperationFacade.call(rmCommand);
                            Path parentToDelete = Paths.get(path, new String[0]).getParent();
                            this.deleteParentFolder(git, parentToDelete, isPage);
                        }
                        deployedCommits.add(commitId);
                        String packageId = deploymentItem.getPackageId();
                        if (StringUtils.isNotEmpty((CharSequence)packageId)) {
                            deployedPackages.add(deploymentItem.getPackageId());
                        }
                        addCommand.addFilepattern(path);
                        this.objectMetadataManager.updateLastPublishedDate(site, deploymentItem.getPath(), ZonedDateTime.now(ZoneOffset.UTC));
                    }
                    logger.debug("Checkout deployed files completed.", new Object[0]);
                    String commitMessage = this.studioConfiguration.getProperty("studio.repo.published.commitMessage");
                    logger.debug("Get Author Ident started.", new Object[0]);
                    User user = this.userServiceInternal.getUserByIdOrUsername(-1L, author);
                    PersonIdent authorIdent = helper.getAuthorIdent(user);
                    logger.debug("Get Author Ident completed.", new Object[0]);
                    logger.debug("Git add all published items started.", new Object[0]);
                    this.retryingRepositoryOperationFacade.call(addCommand);
                    logger.debug("Git add all published items completed.", new Object[0]);
                    commitMessage = commitMessage.replace("{username}", author);
                    commitMessage = commitMessage.replace("{datetime}", ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HHmmssSSSX")));
                    commitMessage = commitMessage.replace("{source}", "UI");
                    commitMessage = commitMessage.replace("{message}", comment);
                    StringBuilder sb = new StringBuilder();
                    for (String string : deployedCommits) {
                        sb.append(string).append(" ");
                    }
                    StringBuilder sbPackage = new StringBuilder();
                    for (String p : deployedPackages) {
                        sbPackage.append(p).append(" ");
                    }
                    commitMessage = commitMessage.replace("{commit_id}", sb.toString().trim());
                    commitMessage = commitMessage.replace("{package_id}", sbPackage.toString().trim());
                    logger.debug("Git commit all published items started.", new Object[0]);
                    String string = this.studioConfiguration.getProperty("studio.repo.commitMessagePrologue");
                    String postscript = this.studioConfiguration.getProperty("studio.repo.commitMessagePostscript");
                    StringBuilder sbCommitMessage = new StringBuilder();
                    if (StringUtils.isNotEmpty((CharSequence)string)) {
                        sbCommitMessage.append(string).append("\n\n");
                    }
                    sbCommitMessage.append(commitMessage);
                    if (StringUtils.isNotEmpty((CharSequence)postscript)) {
                        sbCommitMessage.append("\n\n").append(postscript);
                    }
                    CommitCommand commitCommand = git.commit().setMessage(sbCommitMessage.toString()).setAuthor(authorIdent);
                    RevCommit revCommit = (RevCommit)this.retryingRepositoryOperationFacade.call(commitCommand);
                    logger.debug("Git commit all published items completed.", new Object[0]);
                    int commitTime = revCommit.getCommitTime();
                    ZonedDateTime tagDate2 = Instant.ofEpochSecond(commitTime).atZone(ZoneOffset.UTC);
                    ZonedDateTime publishDate = ZonedDateTime.now(ZoneOffset.UTC);
                    String tagName2 = tagDate2.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HHmmssSSSX")) + "_published_on_" + publishDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HHmmssSSSX"));
                    logger.debug("Get Author Ident started.", new Object[0]);
                    PersonIdent authorIdent2 = helper.getAuthorIdent(user);
                    logger.debug("Get Author Ident completed.", new Object[0]);
                    logger.debug("Git tag started.", new Object[0]);
                    TagCommand tagCommand = git.tag().setTagger(authorIdent2).setName(tagName2).setMessage(commitMessage);
                    this.retryingRepositoryOperationFacade.call(tagCommand);
                    logger.debug("Git tag completed.", new Object[0]);
                    logger.debug("Checkout environment " + environment + " branch for site " + site, new Object[0]);
                    CheckoutCommand checkoutCommand4 = git.checkout().setName(environment);
                    this.retryingRepositoryOperationFacade.call(checkoutCommand4);
                    Ref branchRef = repo.findRef(inProgressBranchName);
                    logger.debug("Merge in-progress branch into environment " + environment + " for site " + site, new Object[0]);
                    MergeCommand mergeCommand = git.merge().setCommit(true).include(branchRef);
                    this.retryingRepositoryOperationFacade.call(mergeCommand);
                    logger.debug("Delete in-progress branch (clean up) for site " + site, new Object[0]);
                    DeleteBranchCommand deleteBranchCommand = git.branchDelete().setBranchNames(new String[]{inProgressBranchName}).setForce(true);
                    this.retryingRepositoryOperationFacade.call(deleteBranchCommand);
                    git.close();
                    if (repoCreated) {
                        this.siteService.setPublishedRepoCreated(site);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Error when publishing site " + site + " to environment " + environment, e, new Object[0]);
            throw new DeploymentException("Error when publishing site " + site + " to environment " + environment + " [commit ID = " + commitId + "]");
        }
        finally {
            this.generalLockService.unlock(gitLockKey);
        }
    }

    private void cleanUpMoveFolders(Git git, String path) throws GitAPIException, IOException {
        Path parentToDelete = Paths.get(path, new String[0]).getParent();
        boolean isPage = path.endsWith("/index.xml");
        this.deleteParentFolder(git, parentToDelete, isPage);
        Path testDelete = Paths.get(git.getRepository().getDirectory().getParent(), parentToDelete.toString());
        File testDeleteFile = testDelete.toFile();
        if (!testDeleteFile.exists()) {
            this.cleanUpMoveFolders(git, parentToDelete.toString());
        }
    }

    private String deleteParentFolder(Git git, Path parentFolder, boolean wasPage) throws GitAPIException, IOException {
        String parent;
        String toRet = parent = parentFolder.toString();
        try {
            GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
            String folderToDelete = helper.getGitPath(parent);
            Path toDelete = Paths.get(git.getRepository().getDirectory().getParent(), parent);
            if (Files.exists(toDelete, new LinkOption[0])) {
                List dirs = Files.walk(toDelete, new FileVisitOption[0]).filter(x -> !x.equals(toDelete)).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(y -> y.getFileName().toString()).collect(Collectors.toList());
                List files = Files.walk(toDelete, 1, new FileVisitOption[0]).filter(x -> !x.equals(toDelete)).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(y -> y.getFileName().toString()).collect(Collectors.toList());
                if (wasPage || CollectionUtils.isEmpty(dirs) && (CollectionUtils.isEmpty(files) || files.size() < 2 && ((String)files.get(0)).equals(".keep"))) {
                    if (CollectionUtils.isNotEmpty(dirs)) {
                        for (String child : dirs) {
                            Path childToDelete = Paths.get(folderToDelete, child);
                            this.deleteParentFolder(git, childToDelete, false);
                            RmCommand rmCommand = git.rm().addFilepattern(folderToDelete + "/" + child + "/" + "*").setCached(false);
                            this.retryingRepositoryOperationFacade.call(rmCommand);
                        }
                    }
                    if (CollectionUtils.isNotEmpty(files)) {
                        for (String child : files) {
                            RmCommand rmCommand = git.rm().addFilepattern(folderToDelete + "/" + child).setCached(false);
                            this.retryingRepositoryOperationFacade.call(rmCommand);
                        }
                    }
                }
            }
        }
        catch (CryptoException e) {
            logger.error("Error deleting parent folder " + parentFolder.toString(), (Exception)((Object)e), new Object[0]);
        }
        return toRet;
    }

    @Override
    public boolean repositoryExists(String site) {
        return this.commitIdExists(site, "HEAD");
    }

    @Override
    public boolean commitIdExists(String site, String commitId) {
        return this.commitIdExists(site, GitRepositories.SANDBOX, commitId);
    }

    @Override
    public boolean commitIdExists(String site, GitRepositories repoType, String commitId) {
        boolean toRet = false;
        try {
            GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
            try (Repository repo = helper.getRepository(site, repoType);){
                RevCommit revCommit;
                ObjectId objCommitId;
                if (repo != null && (objCommitId = repo.resolve(commitId)) != null && (revCommit = repo.parseCommit((AnyObjectId)objCommitId)) != null) {
                    toRet = true;
                }
            }
        }
        catch (IOException | CryptoException e) {
            logger.info("Commit ID " + commitId + " does not exist in " + (Object)((Object)repoType) + " for site " + site, new Object[0]);
        }
        return toRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createSiteCloneRemote(String siteId, String sandboxBranch, String remoteName, String remoteUrl, String remoteBranch, boolean singleBranch, String authenticationType, String remoteUsername, String remotePassword, String remoteToken, String remotePrivateKey, Map<String, String> params, boolean createAsOrphan) throws InvalidRemoteRepositoryException, InvalidRemoteRepositoryCredentialsException, RemoteRepositoryNotFoundException, ServiceLayerException {
        boolean toReturn;
        block12: {
            toReturn = false;
            logger.debug("Creating site " + siteId + " as a clone of remote repository " + remoteName + " (" + remoteUrl + ").", new Object[0]);
            String gitLockKey = "{site}_SANDBOX_REPOSITORY_GIT_LOCK".replaceAll("\\{site\\}", siteId);
            this.generalLockService.lock(gitLockKey);
            try {
                GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
                toReturn = helper.createSiteCloneRemoteGitRepo(siteId, sandboxBranch, remoteName, remoteUrl, remoteBranch, singleBranch, authenticationType, remoteUsername, remotePassword, remoteToken, remotePrivateKey, createAsOrphan);
                if (toReturn) {
                    try {
                        if (createAsOrphan) {
                            this.removeRemote(siteId, remoteName);
                        } else {
                            this.insertRemoteToDb(siteId, remoteName, remoteUrl, authenticationType, remoteUsername, remotePassword, remoteToken, remotePrivateKey);
                        }
                    }
                    catch (CryptoException e) {
                        throw new ServiceLayerException(e);
                    }
                    logger.debug("Update site name configuration variables for site " + siteId, new Object[0]);
                    toReturn = helper.updateSiteNameConfigVar(siteId);
                    if (toReturn) {
                        toReturn = helper.replaceParameters(siteId, params);
                    }
                    if (toReturn) {
                        logger.debug("Perform initial commit for site " + siteId, new Object[0]);
                        toReturn = helper.performInitialCommit(siteId, helper.getCommitMessage("studio.repo.initialCommit.commitMessage"), sandboxBranch);
                    }
                    break block12;
                }
                logger.error("Error while creating site " + siteId + " by cloning remote repository " + remoteName + " (" + remoteUrl + ").", new Object[0]);
            }
            catch (CryptoException e) {
                logger.error("Error while creating site " + siteId + " by cloning remote repository " + remoteName + " (" + remoteUrl + ").", (Exception)((Object)e), new Object[0]);
            }
            finally {
                this.generalLockService.unlock(gitLockKey);
            }
        }
        return toReturn;
    }

    @Override
    @RetryingOperation
    public boolean removeRemote(String siteId, String remoteName) {
        logger.debug("Remove remote " + remoteName + " from the sandbox repo for the site " + siteId, new Object[0]);
        try {
            GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
            Repository repo = helper.getRepository(siteId, GitRepositories.SANDBOX);
            try (Git git = new Git(repo);){
                RemoteRemoveCommand remoteRemoveCommand = git.remoteRemove();
                remoteRemoveCommand.setRemoteName(remoteName);
                this.retryingRepositoryOperationFacade.call(remoteRemoveCommand);
                List resultRemoteBranches = git.branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call();
                ArrayList<String> branchesToDelete = new ArrayList<String>();
                for (Ref remoteBranchRef : resultRemoteBranches) {
                    if (!remoteBranchRef.getName().startsWith("refs/remotes/" + remoteName)) continue;
                    branchesToDelete.add(remoteBranchRef.getName());
                }
                if (CollectionUtils.isNotEmpty(branchesToDelete)) {
                    DeleteBranchCommand delBranch = git.branchDelete();
                    String[] array = new String[branchesToDelete.size()];
                    delBranch.setBranchNames(branchesToDelete.toArray(array));
                    delBranch.setForce(true);
                    this.retryingRepositoryOperationFacade.call(delBranch);
                }
            }
            catch (GitAPIException e) {
                logger.error("Failed to remove remote " + remoteName + " for site " + siteId, (Exception)((Object)e), new Object[0]);
                return false;
            }
            logger.debug("Remove remote record from database for remote " + remoteName + " and site " + siteId, new Object[0]);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("siteId", siteId);
            params.put("remoteName", remoteName);
            this.remoteRepositoryDAO.deleteRemoteRepository(params);
            return true;
        }
        catch (CryptoException e) {
            logger.error("Failed to remove remote " + remoteName + " for site " + siteId, (Exception)((Object)e), new Object[0]);
            return false;
        }
    }

    private void insertRemoteToDb(String siteId, String remoteName, String remoteUrl, String authenticationType, String remoteUsername, String remotePassword, String remoteToken, String remotePrivateKey) throws CryptoException {
        logger.debug("Inserting remote " + remoteName + " for site " + siteId + " into database.", new Object[0]);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("siteId", siteId);
        params.put("remoteName", remoteName);
        params.put("remoteUrl", remoteUrl);
        params.put("authenticationType", authenticationType);
        params.put("remoteUsername", remoteUsername);
        if (StringUtils.isNotEmpty((CharSequence)remotePassword)) {
            logger.debug("Encrypt password before inserting to database", new Object[0]);
            String hashedPassword = this.encryptor.encrypt(remotePassword);
            params.put("remotePassword", hashedPassword);
        } else {
            params.put("remotePassword", remotePassword);
        }
        if (StringUtils.isNotEmpty((CharSequence)remoteToken)) {
            logger.debug("Encrypt token before inserting to database", new Object[0]);
            String hashedToken = this.encryptor.encrypt(remoteToken);
            params.put("remoteToken", hashedToken);
        } else {
            params.put("remoteToken", remoteToken);
        }
        if (StringUtils.isNotEmpty((CharSequence)remotePrivateKey)) {
            logger.debug("Encrypt private key before inserting to database", new Object[0]);
            String hashedPrivateKey = this.encryptor.encrypt(remotePrivateKey);
            params.put("remotePrivateKey", hashedPrivateKey);
        } else {
            params.put("remotePrivateKey", remotePrivateKey);
        }
        logger.debug("Insert site remote record into database", new Object[0]);
        this.remoteRepositoryDAO.insertRemoteRepository(params);
        params = new HashMap();
        params.put("siteId", siteId);
        params.put("remoteName", remoteName);
        RemoteRepository remoteRepository = this.remoteRepositoryDAO.getRemoteRepository(params);
        if (remoteRepository != null) {
            this.insertClusterRemoteRepository(remoteRepository);
        }
    }

    @RetryingOperation
    public void insertClusterRemoteRepository(RemoteRepository remoteRepository) {
        String localAddress;
        ClusterMember member;
        HierarchicalConfiguration<ImmutableNode> registrationData = this.studioConfiguration.getSubConfig("studio.clustering.node.registration");
        if (registrationData != null && !registrationData.isEmpty() && (member = this.clusterDao.getMemberByLocalAddress(localAddress = registrationData.getString("localAddress"))) != null) {
            this.clusterDao.addClusterRemoteRepository(member.getId(), remoteRepository.getId());
        }
    }

    @Override
    public boolean contentExists(String site, String path) {
        boolean toReturn;
        block19: {
            toReturn = false;
            try {
                GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
                Repository repo = helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
                if (repo == null) break block19;
                RevTree tree = helper.getTreeForLastCommit(repo);
                try (TreeWalk tw = TreeWalk.forPath((Repository)repo, (String)helper.getGitPath(path), (RevTree)tree);){
                    String gitPath;
                    if (tw != null && tw.getObjectId(0) != null) {
                        toReturn = true;
                        tw.close();
                    } else if (tw == null && (StringUtils.isEmpty((CharSequence)(gitPath = helper.getGitPath(path))) || gitPath.equals("."))) {
                        toReturn = true;
                    }
                }
                catch (IOException e) {
                    logger.info("Content not found for site: " + site + " path: " + path, e);
                }
            }
            catch (Exception e) {
                logger.error("Failed to create RevTree for site: " + site + " path: " + path, e, new Object[0]);
            }
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRepoLastCommitId(String site) {
        String toReturn;
        block6: {
            toReturn = "";
            try {
                GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
                Repository repository = helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
                if (repository == null) break block6;
                Repository repository2 = repository;
                synchronized (repository2) {
                    Repository repo = helper.getRepository(site, GitRepositories.SANDBOX);
                    ObjectId commitId = repo.resolve("HEAD");
                    if (commitId != null) {
                        toReturn = commitId.getName();
                    }
                }
            }
            catch (IOException | CryptoException e) {
                logger.error("Error getting last commit ID for site " + site, (Exception)e, new Object[0]);
            }
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLastEditCommitId(String siteId, String path) {
        String toReturn;
        block20: {
            toReturn = "";
            try {
                GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
                Repository repository = helper.getRepository(siteId, StringUtils.isEmpty((CharSequence)siteId) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
                if (repository == null) break block20;
                Repository repository2 = repository;
                synchronized (repository2) {
                    ObjectId head = repository.resolve("HEAD");
                    String gitPath = helper.getGitPath(path);
                    try (Git git = new Git(repository);){
                        Iterable commits = git.log().add((AnyObjectId)head).addPath(gitPath).call();
                        Iterator iterator = commits.iterator();
                        if (iterator.hasNext()) {
                            RevCommit revCommit = (RevCommit)iterator.next();
                            toReturn = revCommit.getName();
                        }
                    }
                    catch (IOException | GitAPIException e) {
                        logger.error("error while getting history for content item " + path, new Object[0]);
                    }
                }
            }
            catch (IOException | CryptoException e) {
                logger.error("Error getting last commit ID for site " + siteId + " path " + path, (Exception)e, new Object[0]);
            }
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getChangeSetPathsFromDelta(String site, String commitIdFrom, String commitIdTo) {
        Map<String, String> changeSet;
        block35: {
            changeSet = new TreeMap<String, String>();
            try {
                GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
                Repository repository = helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
                if (repository == null) break block35;
                Repository repository2 = repository;
                synchronized (repository2) {
                    block36: {
                        try {
                            boolean fromEmptyRepo = StringUtils.isEmpty((CharSequence)commitIdFrom);
                            String firstCommitId = this.getRepoFirstCommitId(site);
                            if (fromEmptyRepo) {
                                commitIdFrom = firstCommitId;
                            }
                            Repository repo = helper.getRepository(site, GitRepositories.SANDBOX);
                            ObjectId objCommitIdFrom = repo.resolve(commitIdFrom);
                            ObjectId objCommitIdTo = repo.resolve(commitIdTo);
                            try (Git git = new Git(repo);){
                                if (fromEmptyRepo) {
                                    CanonicalTreeParser firstCommitTreeParser = new CanonicalTreeParser();
                                    firstCommitTreeParser.reset();
                                    List diffEntries = git.diff().setOldTree((AbstractTreeIterator)firstCommitTreeParser).setNewTree(null).call();
                                    changeSet = this.getChangeSetFromDiff(diffEntries);
                                }
                                if (objCommitIdFrom.equals((AnyObjectId)objCommitIdTo)) break block36;
                                RevTree fromTree = helper.getTreeForCommit(repo, objCommitIdFrom.getName());
                                RevTree toTree = helper.getTreeForCommit(repo, objCommitIdTo.getName());
                                if (fromTree == null || toTree == null) break block36;
                                try (ObjectReader reader = repo.newObjectReader();){
                                    CanonicalTreeParser fromCommitTreeParser = new CanonicalTreeParser();
                                    CanonicalTreeParser toCommitTreeParser = new CanonicalTreeParser();
                                    fromCommitTreeParser.reset(reader, (AnyObjectId)fromTree.getId());
                                    toCommitTreeParser.reset(reader, (AnyObjectId)toTree.getId());
                                    List diffEntries = git.diff().setOldTree((AbstractTreeIterator)fromCommitTreeParser).setNewTree((AbstractTreeIterator)toCommitTreeParser).call();
                                    changeSet = this.getChangeSetFromDiff(diffEntries);
                                }
                            }
                            catch (GitAPIException e) {
                                logger.error("Error getting operations for site " + site + " from commit ID: " + commitIdFrom + " to commit ID: " + commitIdTo, (Exception)((Object)e), new Object[0]);
                            }
                        }
                        catch (IOException e) {
                            logger.error("Error getting operations for site " + site + " from commit ID: " + commitIdFrom + " to commit ID: " + commitIdTo, e, new Object[0]);
                        }
                    }
                }
            }
            catch (CryptoException e) {
                logger.error("Error getting operations for site " + site + " from commit ID: " + commitIdFrom + " to commit ID: " + commitIdTo, (Exception)((Object)e), new Object[0]);
            }
        }
        return changeSet;
    }

    private Map<String, String> getChangeSetFromDiff(List<DiffEntry> diffEntries) {
        TreeMap<String, String> toReturn = new TreeMap<String, String>();
        block6: for (DiffEntry diffEntry : diffEntries) {
            String pathNew = "/" + diffEntry.getNewPath();
            String pathOld = "/" + diffEntry.getOldPath();
            if (ArrayUtils.contains((Object[])GitContentRepositoryConstants.IGNORE_FILES, (Object)FilenameUtils.getName((String)pathNew)) || ArrayUtils.contains((Object[])GitContentRepositoryConstants.IGNORE_FILES, (Object)FilenameUtils.getName((String)pathOld))) continue;
            switch (diffEntry.getChangeType()) {
                case ADD: 
                case COPY: {
                    toReturn.put(pathNew, "C");
                    continue block6;
                }
                case MODIFY: {
                    toReturn.put(pathNew, "U");
                    continue block6;
                }
                case DELETE: {
                    toReturn.put(pathOld, "D");
                    continue block6;
                }
                case RENAME: {
                    toReturn.put(pathOld, pathNew);
                    continue block6;
                }
            }
            logger.error("Error: Unknown git operation " + diffEntry.getChangeType(), new Object[0]);
        }
        return toReturn;
    }

    @Override
    public void markGitLogAudited(String siteId, String commitId) {
        this.retryingOperationFacade.markGitLogAudited(siteId, commitId, 1);
    }

    @Override
    public void updateGitlog(String siteId, String lastProcessedCommitId, int batchSize) throws SiteNotFoundException {
        block25: {
            RingBuffer<RevCommit> commitIds = new RingBuffer<RevCommit>(batchSize);
            try {
                GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
                Repository repository = helper.getRepository(siteId, StringUtils.isEmpty((CharSequence)siteId) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
                if (repository == null) break block25;
                try {
                    ObjectId objCommitIdFrom = repository.resolve(lastProcessedCommitId);
                    ObjectId objCommitIdTo = repository.resolve("HEAD");
                    try (Git git = new Git(repository);){
                        if (!objCommitIdFrom.equals((AnyObjectId)objCommitIdTo)) {
                            Iterable commits = git.log().addRange((AnyObjectId)objCommitIdFrom, (AnyObjectId)objCommitIdTo).call();
                            String commitId = "";
                            for (RevCommit commit : commits) {
                                commitIds.write(commit);
                            }
                            ArrayList<String> batch = new ArrayList<String>();
                            RevCommit current = (RevCommit)commitIds.read();
                            while (current != null) {
                                ObjectId nextCommitId = current.getId();
                                commitId = nextCommitId.getName();
                                if (StringUtils.contains((CharSequence)current.getFullMessage(), (CharSequence)this.studioConfiguration.getProperty("studio.repo.syncDB.commitMessage.noProcessing"))) {
                                    logger.debug("Skipping commitId: " + commitId + " for site " + siteId + " because it is marked not to be processed.", new Object[0]);
                                } else {
                                    batch.add(0, commitId);
                                }
                                current = (RevCommit)commitIds.read();
                            }
                            if (batch.size() > 0) {
                                this.gitLogDao.insertIgnoreGitLogList(siteId, batch);
                                this.siteService.updateLastSyncedGitlogCommitId(siteId, (String)batch.get(batch.size() - 1));
                                this.siteService.updateLastCommitId(siteId, (String)batch.get(batch.size() - 1));
                                logger.debug("Inserted " + batch.size() + " git log commits for site " + siteId, new Object[0]);
                            } else {
                                this.siteService.updateLastSyncedGitlogCommitId(siteId, objCommitIdTo.getName());
                            }
                        }
                    }
                    catch (GitAPIException e) {
                        logger.error("Error getting commit ids for site " + siteId + " from commit ID: " + lastProcessedCommitId + " to HEAD", (Exception)((Object)e), new Object[0]);
                    }
                }
                catch (IOException e) {
                    logger.error("Error getting commit ids for site " + siteId + " from commit ID: " + lastProcessedCommitId + " to HEAD", e, new Object[0]);
                }
            }
            catch (CryptoException e) {
                logger.error("Error getting commit ids for site " + siteId + " from commit ID: " + lastProcessedCommitId + " to HEAD", (Exception)((Object)e), new Object[0]);
            }
        }
    }

    @Override
    public List<GitLog> getUnauditedCommits(String siteId, int batchSize) {
        return this.gitLogDao.getUnauditedCommits(siteId, batchSize);
    }

    @Override
    public List<GitLog> getUnprocessedCommits(String siteId, long marker) {
        return this.gitLogDao.getUnprocessedCommitsSinceMarker(siteId, marker);
    }

    @Override
    public void markGitLogProcessedBeforeMarker(String siteId, long marker, int processed) {
        this.retryingOperationFacade.markGitLogProcessedBeforeMarker(siteId, marker, processed, 0);
    }

    @Override
    public String getPreviousCommitId(String siteId, String commitId) {
        String toReturn;
        block18: {
            toReturn = "";
            try {
                GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
                Repository repository = helper.getRepository(siteId, StringUtils.isEmpty((CharSequence)siteId) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
                if (repository == null) break block18;
                ObjectId head = repository.resolve("HEAD");
                try (Git git = new Git(repository);){
                    Iterable commits = git.log().add((AnyObjectId)head).call();
                    Iterator iterator = commits.iterator();
                    boolean found = false;
                    while (!found || iterator.hasNext()) {
                        RevCommit revCommit = (RevCommit)iterator.next();
                        if (!StringUtils.equals((CharSequence)commitId, (CharSequence)revCommit.getName())) continue;
                        found = true;
                        if (!iterator.hasNext()) continue;
                        revCommit = (RevCommit)iterator.next();
                        toReturn = revCommit.getName();
                    }
                }
                catch (IOException | GitAPIException e) {
                    logger.error("Error while getting previous commit ID for " + commitId, new Object[0]);
                }
            }
            catch (IOException | CryptoException e) {
                logger.error("Error while getting previous commit ID for site " + siteId + " commit ID " + commitId, (Exception)e, new Object[0]);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Previous commit id for site " + siteId + " and commit id " + commitId + " is " + toReturn, new Object[0]);
        }
        return toReturn;
    }

    @Override
    public void upsertGitLogList(String siteId, List<String> commitIds, boolean processed, boolean audited) {
        this.gitLogDao.upsertGitLogList(siteId, commitIds, processed ? 1 : 0, audited ? 1 : 0);
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public GitLogDAO getGitLogDao() {
        return this.gitLogDao;
    }

    public void setGitLogDao(GitLogDAO gitLogDao) {
        this.gitLogDao = gitLogDao;
    }

    public SiteFeedMapper getSiteFeedMapper() {
        return this.siteFeedMapper;
    }

    public void setSiteFeedMapper(SiteFeedMapper siteFeedMapper) {
        this.siteFeedMapper = siteFeedMapper;
    }

    public UserServiceInternal getUserServiceInternal() {
        return this.userServiceInternal;
    }

    public void setUserServiceInternal(UserServiceInternal userServiceInternal) {
        this.userServiceInternal = userServiceInternal;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public RemoteRepositoryDAO getRemoteRepositoryDAO() {
        return this.remoteRepositoryDAO;
    }

    public void setRemoteRepositoryDAO(RemoteRepositoryDAO remoteRepositoryDAO) {
        this.remoteRepositoryDAO = remoteRepositoryDAO;
    }

    public void setEncryptor(TextEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    public ClusterDAO getClusterDao() {
        return this.clusterDao;
    }

    public void setClusterDao(ClusterDAO clusterDao) {
        this.clusterDao = clusterDao;
    }

    public GeneralLockService getGeneralLockService() {
        return this.generalLockService;
    }

    public void setGeneralLockService(GeneralLockService generalLockService) {
        this.generalLockService = generalLockService;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public ObjectMetadataManager getObjectMetadataManager() {
        return this.objectMetadataManager;
    }

    public void setObjectMetadataManager(ObjectMetadataManager objectMetadataManager) {
        this.objectMetadataManager = objectMetadataManager;
    }

    public StudioUtils getStudioUtils() {
        return this.studioUtils;
    }

    public void setStudioUtils(StudioUtils studioUtils) {
        this.studioUtils = studioUtils;
    }

    public RetryingOperationFacade getRetryingOperationFacade() {
        return this.retryingOperationFacade;
    }

    public void setRetryingOperationFacade(RetryingOperationFacade retryingOperationFacade) {
        this.retryingOperationFacade = retryingOperationFacade;
    }

    public RetryingRepositoryOperationFacade getRetryingRepositoryOperationFacade() {
        return this.retryingRepositoryOperationFacade;
    }

    public void setRetryingRepositoryOperationFacade(RetryingRepositoryOperationFacade retryingRepositoryOperationFacade) {
        this.retryingRepositoryOperationFacade = retryingRepositoryOperationFacade;
    }
}

