/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.repository.blob;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.commons.crypto.CryptoException;
import org.craftercms.commons.file.blob.Blob;
import org.craftercms.commons.lang.RegexUtils;
import org.craftercms.studio.api.v1.constant.GitRepositories;
import org.craftercms.studio.api.v1.dal.DeploymentSyncHistory;
import org.craftercms.studio.api.v1.exception.ContentNotFoundException;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteRepositoryCredentialsException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteRepositoryException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteUrlException;
import org.craftercms.studio.api.v1.exception.repository.RemoteRepositoryNotBareException;
import org.craftercms.studio.api.v1.exception.repository.RemoteRepositoryNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.RepositoryItem;
import org.craftercms.studio.api.v1.service.deployment.DeploymentException;
import org.craftercms.studio.api.v1.to.DeploymentItemTO;
import org.craftercms.studio.api.v1.to.RemoteRepositoryInfoTO;
import org.craftercms.studio.api.v1.to.VersionTO;
import org.craftercms.studio.api.v1.util.filter.DmFilterWrapper;
import org.craftercms.studio.api.v2.dal.GitLog;
import org.craftercms.studio.api.v2.dal.PublishingHistoryItem;
import org.craftercms.studio.api.v2.dal.RepoOperation;
import org.craftercms.studio.api.v2.exception.RepositoryLockedException;
import org.craftercms.studio.api.v2.repository.ContentRepository;
import org.craftercms.studio.api.v2.repository.blob.StudioBlobStore;
import org.craftercms.studio.api.v2.repository.blob.StudioBlobStoreResolver;
import org.craftercms.studio.api.v2.service.deployment.DeploymentHistoryProvider;
import org.craftercms.studio.impl.v2.repository.GitContentRepository;
import org.springframework.util.LinkedMultiValueMap;

public class BlobAwareContentRepository
implements org.craftercms.studio.api.v1.repository.ContentRepository,
DeploymentHistoryProvider,
ContentRepository {
    private static final Logger logger = LoggerFactory.getLogger(BlobAwareContentRepository.class);
    protected String fileExtension;
    protected String[] interceptedPaths;
    protected org.craftercms.studio.impl.v1.repository.git.GitContentRepository localRepositoryV1;
    protected GitContentRepository localRepositoryV2;
    protected StudioBlobStoreResolver blobStoreResolver;
    protected final ObjectMapper objectMapper = new XmlMapper().enable(SerializationFeature.INDENT_OUTPUT);

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public void setLocalRepositoryV1(org.craftercms.studio.impl.v1.repository.git.GitContentRepository localRepositoryV1) {
        this.localRepositoryV1 = localRepositoryV1;
    }

    public void setLocalRepositoryV2(GitContentRepository localRepositoryV2) {
        this.localRepositoryV2 = localRepositoryV2;
    }

    public void setBlobStoreResolver(StudioBlobStoreResolver blobStoreResolver) {
        this.blobStoreResolver = blobStoreResolver;
    }

    public void setInterceptedPaths(String[] interceptedPaths) {
        this.interceptedPaths = interceptedPaths;
    }

    protected String getOriginalPath(String path) {
        return StringUtils.removeEnd((String)path, (String)("." + this.fileExtension));
    }

    protected String getPointerPath(String siteId, String path) {
        return this.isFolder(siteId, path) ? path : StringUtils.appendIfMissing((String)path, (CharSequence)("." + this.fileExtension), (CharSequence[])new CharSequence[0]);
    }

    protected String getPathFromPointerPath(String siteId, String pointerPath) {
        return this.isFolder(siteId, pointerPath) ? pointerPath : StringUtils.removeEnd((String)pointerPath, (String)("." + this.fileExtension));
    }

    protected String normalize(String path) {
        return Paths.get(path, new String[0]).normalize().toString();
    }

    protected StudioBlobStore getBlobStore(String site, String ... paths) throws ServiceLayerException, ConfigurationException, IOException {
        if (StringUtils.isEmpty((CharSequence)site)) {
            return null;
        }
        if (ArrayUtils.isEmpty((Object[])paths)) {
            throw new IllegalArgumentException("At least one path needs to be provided");
        }
        for (String path : paths) {
            if (RegexUtils.matchesAny((String)path, (String[])this.interceptedPaths)) continue;
            logger.debug("Path {0} should not be intercepted, will be skipped", path);
            return null;
        }
        return (StudioBlobStore)this.blobStoreResolver.getByPaths(site, paths);
    }

    @Override
    public boolean contentExists(String site, String path) {
        logger.debug("Checking if {0} exists in site {1}", path, site);
        try {
            StudioBlobStore store;
            if (!this.isFolder(site, path) && (store = this.getBlobStore(site, path)) != null) {
                return store.contentExists(site, this.normalize(path));
            }
            return this.localRepositoryV1.contentExists(site, path);
        }
        catch (Exception e) {
            logger.error("Error checking if content {0} exist in site {1}", e, path, site);
            return false;
        }
    }

    @Override
    public InputStream getContent(String site, String path) {
        logger.debug("Getting content of {0} in site {1}", path, site);
        try {
            StudioBlobStore store;
            if (!this.isFolder(site, path) && (store = this.getBlobStore(site, path)) != null) {
                return store.getContent(site, this.normalize(path));
            }
            return this.localRepositoryV1.getContent(site, path);
        }
        catch (Exception e) {
            logger.error("Error getting content {0} in site {1}", e, path, site);
            return null;
        }
    }

    @Override
    public long getContentSize(String site, String path) {
        logger.debug("Getting size of {0} in site {1}", path, site);
        try {
            StudioBlobStore store = this.getBlobStore(site, path);
            if (store != null) {
                return store.getContentSize(site, this.normalize(path));
            }
            return this.localRepositoryV1.getContentSize(site, path);
        }
        catch (Exception e) {
            logger.error("Error getting size for content {0} in site {1}", e, path, site);
            return -1L;
        }
    }

    @Override
    public String writeContent(String site, String path, InputStream content) throws ServiceLayerException {
        logger.debug("Writing {0} in site {1}", path, site);
        try {
            StudioBlobStore store = this.getBlobStore(site, path);
            if (store != null) {
                store.writeContent(site, this.normalize(path), content);
                Blob reference = store.getReference(this.normalize(path));
                return this.localRepositoryV1.writeContent(site, this.getPointerPath(site, path), new ByteArrayInputStream(this.objectMapper.writeValueAsBytes((Object)reference)));
            }
            return this.localRepositoryV1.writeContent(site, path, content);
        }
        catch (RepositoryLockedException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Error writing content {0} in site {1}", e, path, site);
            throw new ServiceLayerException(e);
        }
    }

    @Override
    public String createFolder(String site, String path, String name) {
        logger.debug("Creating folder {0} in site {1}", path, site);
        try {
            StudioBlobStore store = this.getBlobStore(site, path);
            if (store != null) {
                store.createFolder(site, this.normalize(path), name);
            }
            return this.localRepositoryV1.createFolder(site, path, name);
        }
        catch (Exception e) {
            logger.error("Error creating folder {0} in site {1}", e, path, site);
            return null;
        }
    }

    @Override
    public String deleteContent(String site, String path, String approver) {
        logger.debug("Deleting {0} in site {1}", path, site);
        try {
            String result;
            StudioBlobStore store = this.getBlobStore(site, path);
            if (store != null && (result = store.deleteContent(site, this.normalize(path), approver)) != null) {
                return this.localRepositoryV1.deleteContent(site, this.getPointerPath(site, path), approver);
            }
            return this.localRepositoryV1.deleteContent(site, path, approver);
        }
        catch (Exception e) {
            logger.error("Error deleting content {0} in site {1}", e, path, site);
            return null;
        }
    }

    @Override
    public Map<String, String> moveContent(String site, String fromPath, String toPath, String newName) {
        logger.debug("Moving content from {0} to {1} in site {2}", fromPath, toPath, site);
        try {
            Map result;
            StudioBlobStore store = this.getBlobStore(site, fromPath, toPath);
            if (store != null && (result = store.moveContent(site, this.normalize(fromPath), this.normalize(toPath), newName)) != null) {
                boolean isFolder = this.isFolder(site, fromPath);
                Map<String, String> diskResult = this.localRepositoryV1.moveContent(site, isFolder ? fromPath : this.getPointerPath(site, fromPath), isFolder ? toPath : this.getPointerPath(site, toPath), newName);
                HashSet<String> keys = new HashSet<String>(diskResult.keySet());
                keys.forEach(k -> {
                    String val = (String)diskResult.get(k);
                    diskResult.put(this.getPathFromPointerPath(site, (String)k), val);
                });
                return diskResult;
            }
            return this.localRepositoryV1.moveContent(site, fromPath, toPath, newName);
        }
        catch (Exception e) {
            logger.error("Error moving content from {0} to {1} in site {2}", e, fromPath, toPath, site);
            return null;
        }
    }

    @Override
    public String copyContent(String site, String fromPath, String toPath) {
        logger.debug("Copying content from {0} to {1} in site {2}", fromPath, toPath, site);
        try {
            String result;
            StudioBlobStore store = this.getBlobStore(site, fromPath, toPath);
            if (store != null && (result = store.copyContent(site, this.normalize(fromPath), this.normalize(toPath))) != null) {
                boolean isFolder = this.isFolder(site, fromPath);
                return this.localRepositoryV1.copyContent(site, isFolder ? fromPath : this.getPointerPath(site, fromPath), isFolder ? toPath : this.getPointerPath(site, toPath));
            }
            return this.localRepositoryV1.copyContent(site, fromPath, toPath);
        }
        catch (Exception e) {
            logger.error("Error copying content from {0} to {1} in site {2}", e, fromPath, toPath, site);
            return null;
        }
    }

    @Override
    public RepositoryItem[] getContentChildren(String site, String path) {
        RepositoryItem[] children = this.localRepositoryV1.getContentChildren(site, path);
        return Stream.of(children).peek(item -> {
            item.name = this.getOriginalPath(item.name);
        }).collect(Collectors.toList()).toArray(new RepositoryItem[children.length]);
    }

    @Override
    public VersionTO[] getContentVersionHistory(String site, String path) {
        logger.debug("Getting version history for {0} in site {1}", path, site);
        try {
            StudioBlobStore store = this.getBlobStore(site, path);
            if (store != null) {
                return this.localRepositoryV1.getContentVersionHistory(site, this.getPointerPath(site, path));
            }
            return this.localRepositoryV1.getContentVersionHistory(site, path);
        }
        catch (Exception e) {
            logger.error("Error getting version history for {0} in site {1}", e, path, site);
            return null;
        }
    }

    @Override
    public String createVersion(String site, String path, boolean majorVersion) {
        return this.localRepositoryV1.createVersion(site, path, majorVersion);
    }

    @Override
    public String createVersion(String site, String path, String comment, boolean majorVersion) {
        return this.localRepositoryV1.createVersion(site, path, comment, majorVersion);
    }

    @Override
    public String revertContent(String site, String path, String version, boolean major, String comment) {
        return this.localRepositoryV1.revertContent(site, path, version, major, comment);
    }

    @Override
    public InputStream getContentVersion(String site, String path, String version) throws ContentNotFoundException {
        return this.localRepositoryV1.getContentVersion(site, path, version);
    }

    @Override
    public void lockItem(String site, String path) {
        this.localRepositoryV1.lockItem(site, path);
    }

    @Override
    public void lockItemForPublishing(String site, String path) {
        this.localRepositoryV1.lockItemForPublishing(site, path);
    }

    @Override
    public void unLockItem(String site, String path) {
        this.localRepositoryV1.unLockItem(site, path);
    }

    @Override
    public void unLockItemForPublishing(String site, String path) {
        this.localRepositoryV1.unLockItemForPublishing(site, path);
    }

    @Override
    public boolean isFolder(String siteId, String path) {
        return this.localRepositoryV1.isFolder(siteId, path);
    }

    @Override
    public boolean deleteSite(String siteId) {
        return this.localRepositoryV1.deleteSite(siteId);
    }

    @Override
    public void initialPublish(String site, String sandboxBranch, String environment, String author, String comment) throws DeploymentException, CryptoException {
        this.localRepositoryV1.initialPublish(site, sandboxBranch, environment, author, comment);
    }

    protected DeploymentItemTO mapDeploymentItem(DeploymentItemTO item) {
        DeploymentItemTO pointer = new DeploymentItemTO();
        pointer.setPath(this.getPointerPath(item.getSite(), item.getPath()));
        pointer.setSite(item.getSite());
        pointer.setCommitId(item.getCommitId());
        pointer.setMove(item.isMove());
        pointer.setDelete(item.isDelete());
        pointer.setOldPath(StringUtils.isEmpty((CharSequence)item.getOldPath()) ? item.getOldPath() : this.getPointerPath(item.getSite(), item.getOldPath()));
        pointer.setPackageId(item.getPackageId());
        return pointer;
    }

    @Override
    public String getRepoLastCommitId(String site) {
        return this.localRepositoryV1.getRepoLastCommitId(site);
    }

    @Override
    public String getRepoFirstCommitId(String site) {
        return this.localRepositoryV1.getRepoFirstCommitId(site);
    }

    @Override
    public List<String> getEditCommitIds(String site, String path, String commitIdFrom, String commitIdTo) {
        return this.localRepositoryV1.getEditCommitIds(site, path, commitIdFrom, commitIdTo);
    }

    @Override
    public void insertFullGitLog(String siteId, int processed) {
        this.localRepositoryV1.insertFullGitLog(siteId, processed);
    }

    @Override
    public void deleteGitLogForSite(String siteId) {
        this.localRepositoryV1.deleteGitLogForSite(siteId);
    }

    @Override
    public boolean createSitePushToRemote(String siteId, String remoteName, String remoteUrl, String authenticationType, String remoteUsername, String remotePassword, String remoteToken, String remotePrivateKey, boolean createAsOrphan) throws InvalidRemoteRepositoryException, InvalidRemoteRepositoryCredentialsException, RemoteRepositoryNotFoundException, RemoteRepositoryNotBareException, ServiceLayerException {
        return this.localRepositoryV1.createSitePushToRemote(siteId, remoteName, remoteUrl, authenticationType, remoteUsername, remotePassword, remoteToken, remotePrivateKey, createAsOrphan);
    }

    @Override
    public boolean addRemote(String siteId, String remoteName, String remoteUrl, String authenticationType, String remoteUsername, String remotePassword, String remoteToken, String remotePrivateKey) throws InvalidRemoteUrlException, ServiceLayerException {
        return this.localRepositoryV1.addRemote(siteId, remoteName, remoteUrl, authenticationType, remoteUsername, remotePassword, remoteToken, remotePrivateKey);
    }

    @Override
    public void removeRemoteRepositoriesForSite(String siteId) {
        this.localRepositoryV1.removeRemoteRepositoriesForSite(siteId);
    }

    @Override
    public List<RemoteRepositoryInfoTO> listRemote(String siteId, String sandboxBranch) throws ServiceLayerException, CryptoException {
        return this.localRepositoryV1.listRemote(siteId, sandboxBranch);
    }

    @Override
    public boolean pushToRemote(String siteId, String remoteName, String remoteBranch) throws ServiceLayerException, InvalidRemoteUrlException, CryptoException {
        return this.localRepositoryV1.pushToRemote(siteId, remoteName, remoteBranch);
    }

    @Override
    public boolean pullFromRemote(String siteId, String remoteName, String remoteBranch) throws ServiceLayerException, InvalidRemoteUrlException, CryptoException {
        return this.localRepositoryV1.pullFromRemote(siteId, remoteName, remoteBranch);
    }

    @Override
    public void resetStagingRepository(String siteId) throws ServiceLayerException, CryptoException {
        this.localRepositoryV1.resetStagingRepository(siteId);
    }

    @Override
    public void reloadRepository(String siteId) {
        this.localRepositoryV1.reloadRepository(siteId);
    }

    @Override
    public void cleanupRepositories(String siteId) {
        this.localRepositoryV1.cleanupRepositories(siteId);
    }

    @Override
    public List<DeploymentSyncHistory> getDeploymentHistory(String site, List<String> environmentNames, ZonedDateTime fromDate, ZonedDateTime toDate, DmFilterWrapper dmFilterWrapper, String filterType, int numberOfItems) {
        List<DeploymentSyncHistory> histories = this.localRepositoryV2.getDeploymentHistory(site, environmentNames, fromDate, toDate, dmFilterWrapper, filterType, numberOfItems);
        return histories.stream().peek(history -> history.setPath(this.getOriginalPath(history.getPath()))).collect(Collectors.toList());
    }

    @Override
    public boolean createSiteFromBlueprint(String blueprintLocation, String siteId, String sandboxBranch, Map<String, String> params) {
        return this.localRepositoryV2.createSiteFromBlueprint(blueprintLocation, siteId, sandboxBranch, params);
    }

    @Override
    public void publish(String site, String sandboxBranch, List<DeploymentItemTO> deploymentItems, String environment, String author, String comment) throws DeploymentException {
        logger.debug("Publishing items {0} to environment {1} in site {2}", deploymentItems, environment, site);
        LinkedHashMap<String, StudioBlobStore> stores = new LinkedHashMap<String, StudioBlobStore>();
        LinkedMultiValueMap items = new LinkedMultiValueMap();
        LinkedList<DeploymentItemTO> localItems = new LinkedList<DeploymentItemTO>();
        try {
            for (DeploymentItemTO item : deploymentItems) {
                StudioBlobStore store = this.getBlobStore(site, item.getPath());
                if (store != null) {
                    stores.putIfAbsent(store.getId(), store);
                    items.add((Object)store.getId(), (Object)item);
                    localItems.add(this.mapDeploymentItem(item));
                    continue;
                }
                localItems.add(item);
            }
            for (String storeId : stores.keySet()) {
                logger.debug("Publishing blobs to environment {0} using store {1} for site {2}", environment, storeId, site);
                ((StudioBlobStore)stores.get(storeId)).publish(site, sandboxBranch, (List)items.get((Object)storeId), environment, author, comment);
            }
            logger.debug("Publishing local files to environment {0} for site {1}", environment, site);
            this.localRepositoryV2.publish(site, sandboxBranch, localItems, environment, author, comment);
        }
        catch (Exception e) {
            throw new DeploymentException("Error during deployment to environment " + environment + " for site " + site, e);
        }
    }

    @Override
    public boolean commitIdExists(String site, String commitId) {
        return this.localRepositoryV2.commitIdExists(site, commitId);
    }

    @Override
    public boolean commitIdExists(String site, GitRepositories repoType, String commitId) {
        return this.localRepositoryV2.commitIdExists(site, repoType, commitId);
    }

    @Override
    public boolean createSiteCloneRemote(String siteId, String sandboxBranch, String remoteName, String remoteUrl, String remoteBranch, boolean singleBranch, String authenticationType, String remoteUsername, String remotePassword, String remoteToken, String remotePrivateKey, Map<String, String> params, boolean createAsOrphan) throws InvalidRemoteRepositoryException, InvalidRemoteRepositoryCredentialsException, RemoteRepositoryNotFoundException, ServiceLayerException {
        return this.localRepositoryV2.createSiteCloneRemote(siteId, sandboxBranch, remoteName, remoteUrl, remoteBranch, singleBranch, authenticationType, remoteUsername, remotePassword, remoteToken, remotePrivateKey, params, createAsOrphan);
    }

    @Override
    public boolean removeRemote(String siteId, String remoteName) {
        return this.localRepositoryV2.removeRemote(siteId, remoteName);
    }

    @Override
    public boolean repositoryExists(String site) {
        return this.localRepositoryV2.repositoryExists(site);
    }

    @Override
    public GitLog getGitLog(String siteId, String commitId) {
        return this.localRepositoryV2.getGitLog(siteId, commitId);
    }

    @Override
    public void markGitLogVerifiedProcessed(String siteId, String commitId) {
        this.localRepositoryV2.markGitLogVerifiedProcessed(siteId, commitId);
    }

    @Override
    public void insertGitLog(String siteId, String commitId, int processed) {
        this.localRepositoryV2.insertGitLog(siteId, commitId, processed);
    }

    @Override
    public void insertGitLog(String siteId, String commitId, int processed, int audited) {
        this.localRepositoryV2.insertGitLog(siteId, commitId, processed, audited);
    }

    @Override
    public List<String> getSubtreeItems(String site, String path) {
        return this.localRepositoryV2.getSubtreeItems(site, path).stream().map(this::getOriginalPath).collect(Collectors.toList());
    }

    @Override
    public List<RepoOperation> getOperations(String site, String commitIdFrom, String commitIdTo) {
        return this.localRepositoryV2.getOperations(site, commitIdFrom, commitIdTo).stream().peek(operation -> {
            operation.setPath(this.getOriginalPath(operation.getPath()));
            operation.setMoveToPath(this.getOriginalPath(operation.getMoveToPath()));
        }).collect(Collectors.toList());
    }

    @Override
    public List<RepoOperation> getOperationsFromDelta(String site, String commitIdFrom, String commitIdTo) {
        return this.localRepositoryV2.getOperationsFromDelta(site, commitIdFrom, commitIdTo).stream().peek(operation -> {
            operation.setPath(this.getOriginalPath(operation.getPath()));
            operation.setMoveToPath(this.getOriginalPath(operation.getMoveToPath()));
        }).collect(Collectors.toList());
    }

    @Override
    public List<PublishingHistoryItem> getPublishingHistory(String siteId, String environment, String path, String publisher, ZonedDateTime fromDate, ZonedDateTime toDate, int limit) {
        return this.localRepositoryV2.getPublishingHistory(siteId, environment, path, publisher, fromDate, toDate, limit);
    }

    @Override
    public String getLastEditCommitId(String siteId, String path) {
        return this.localRepositoryV2.getLastEditCommitId(siteId, path);
    }

    @Override
    public Map<String, String> getChangeSetPathsFromDelta(String site, String commitIdFrom, String commitIdTo) {
        Map<String, String> originalMap = this.localRepositoryV2.getChangeSetPathsFromDelta(site, commitIdFrom, commitIdTo);
        TreeMap<String, String> newMap = new TreeMap<String, String>();
        originalMap.forEach((key, value) -> newMap.put(this.getOriginalPath((String)key), this.getOriginalPath((String)value)));
        return newMap;
    }

    @Override
    public void markGitLogAudited(String siteId, String commitId) {
        this.localRepositoryV2.markGitLogAudited(siteId, commitId);
    }

    @Override
    public void updateGitlog(String siteId, String lastProcessedCommitId, int batchSize) throws SiteNotFoundException {
        this.localRepositoryV2.updateGitlog(siteId, lastProcessedCommitId, batchSize);
    }

    @Override
    public List<GitLog> getUnauditedCommits(String siteId, int batchSize) {
        return this.localRepositoryV2.getUnauditedCommits(siteId, batchSize);
    }

    @Override
    public List<GitLog> getUnprocessedCommits(String siteId, long marker) {
        return this.localRepositoryV2.getUnprocessedCommits(siteId, marker);
    }

    @Override
    public void markGitLogProcessedBeforeMarker(String siteId, long marker, int processed) {
        this.localRepositoryV2.markGitLogProcessedBeforeMarker(siteId, marker, processed);
    }

    @Override
    public void upsertGitLogList(String siteId, List<String> commitIds, boolean processed, boolean audited) {
        this.localRepositoryV2.upsertGitLogList(siteId, commitIds, processed, audited);
    }

    @Override
    public String getPreviousCommitId(String siteId, String commitId) {
        return this.localRepositoryV2.getPreviousCommitId(siteId, commitId);
    }

    @Override
    public void markGitLogVerifiedProcessedBulk(String siteId, List<String> commitIds) {
        this.localRepositoryV2.markGitLogVerifiedProcessedBulk(siteId, commitIds);
    }
}

