/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.repository.blob;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.stream.Stream;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.commons.config.ConfigurationProvider;
import org.craftercms.commons.file.blob.BlobStore;
import org.craftercms.commons.file.blob.impl.BlobStoreResolverImpl;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v2.repository.blob.StudioBlobStoreResolver;

public class StudioBlobStoreResolverImpl
extends BlobStoreResolverImpl
implements StudioBlobStoreResolver {
    public static final String CACHE_KEY_CONFIG = "_blob-store-config";
    public static final String CACHE_KEY_STORE = "_blob-store_";
    protected ContentRepository contentRepository;
    protected Ehcache cache;

    public void setContentRepository(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }

    public void setCache(Ehcache cache) {
        this.cache = cache;
    }

    @Override
    public BlobStore getByPaths(String site, String ... paths) throws ServiceLayerException, ConfigurationException {
        HierarchicalConfiguration config;
        this.logger.debug("Looking blob store for paths {} for site {}", (Object)Arrays.toString(paths), (Object)site);
        this.logger.debug("Checking cache for config");
        String cacheKey = site + CACHE_KEY_CONFIG;
        Element element = this.cache.get((Serializable)((Object)cacheKey));
        if (element == null || element.isExpired()) {
            this.logger.debug("Config not found in cache");
            try {
                config = this.getConfiguration(new ConfigurationProviderImpl(site));
                this.cache.put(new Element((Object)cacheKey, (Object)config));
            }
            catch (ConfigurationException e) {
                throw new RuntimeException("Error getting blob store configuration for site " + site, e);
            }
        } else {
            config = (HierarchicalConfiguration)element.getObjectValue();
        }
        if (config != null) {
            BlobStore blobStore;
            String storeId = this.findStoreId(config, store -> paths[0].matches(store.getString("pattern")));
            this.logger.debug("Checking cache for blob store {}", (Object)storeId);
            cacheKey = site + CACHE_KEY_STORE + storeId;
            element = this.cache.get((Serializable)((Object)cacheKey));
            if (element == null || element.isExpired()) {
                this.logger.debug("Blob store {} not found in cache", (Object)storeId);
                try {
                    blobStore = this.getById(config, storeId);
                    this.cache.put(new Element((Object)cacheKey, (Object)blobStore));
                }
                catch (ConfigurationException e) {
                    throw new RuntimeException("Error looking for blob store " + storeId, e);
                }
            } else {
                blobStore = (BlobStore)element.getObjectValue();
            }
            if (blobStore != null) {
                if (!Stream.of(paths).allMatch(arg_0 -> ((BlobStore)blobStore).isCompatible(arg_0))) {
                    throw new ServiceLayerException("Unsupported operation for paths " + Arrays.toString(paths));
                }
            }
            return blobStore;
        }
        return null;
    }

    private class ConfigurationProviderImpl
    implements ConfigurationProvider {
        private final String site;

        public ConfigurationProviderImpl(String site) {
            this.site = site;
        }

        public boolean configExists(String path) {
            return StudioBlobStoreResolverImpl.this.contentRepository.contentExists(this.site, path);
        }

        public InputStream getConfig(String path) throws IOException {
            try {
                return StudioBlobStoreResolverImpl.this.contentRepository.getContent(this.site, path);
            }
            catch (Exception e) {
                throw new IOException("Error reading file", e);
            }
        }
    }
}

