/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.repository.blob.s3;

import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.file.blob.Blob;
import org.craftercms.commons.file.blob.BlobStoreException;
import org.craftercms.commons.file.blob.impl.AbstractBlobStore;
import org.craftercms.commons.file.blob.impl.s3.AwsS3BlobStore;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.to.DeploymentItemTO;
import org.craftercms.studio.api.v2.repository.blob.StudioBlobStoreAdapter;
import org.craftercms.studio.impl.v1.service.aws.AwsUtils;

public class StudioAwsS3BlobStore
extends AwsS3BlobStore
implements StudioBlobStoreAdapter {
    private static final Logger logger = LoggerFactory.getLogger(StudioAwsS3BlobStore.class);
    public static final String OK = "OK";

    protected boolean isFolder(String path) {
        return StringUtils.isEmpty((CharSequence)FilenameUtils.getExtension((String)path));
    }

    protected String getFullKey(AbstractBlobStore.Mapping mapping, String path) {
        return mapping.target + "/" + this.getKey(mapping, path);
    }

    @Override
    public Blob getReference(String path) {
        AbstractBlobStore.Mapping mapping = this.getMapping(this.publishingTargetResolver.getPublishingTarget());
        try {
            ObjectMetadata metadata = this.getClient().getObjectMetadata(mapping.target, this.getKey(mapping, path));
            return new Blob(this.id, metadata.getETag());
        }
        catch (Exception e) {
            throw new BlobStoreException("Error creating reference for content at " + this.getFullKey(mapping, path), (Throwable)e);
        }
    }

    @Override
    public boolean contentExists(String site, String path) {
        AbstractBlobStore.Mapping mapping = this.getMapping(this.publishingTargetResolver.getPublishingTarget());
        logger.debug("Checking if content exists at {0}", this.getFullKey(mapping, path));
        try {
            return this.getClient().doesObjectExist(mapping.target, this.getKey(mapping, path));
        }
        catch (Exception e) {
            throw new BlobStoreException("Error checking if content exists at " + this.getFullKey(mapping, path), (Throwable)e);
        }
    }

    @Override
    public InputStream getContent(String site, String path) {
        AbstractBlobStore.Mapping previewMapping = this.getMapping(this.publishingTargetResolver.getPublishingTarget());
        logger.debug("Getting content at {0}", this.getFullKey(previewMapping, path));
        try {
            S3Object object = this.getClient().getObject(previewMapping.target, this.getKey(previewMapping, path));
            return object.getObjectContent();
        }
        catch (Exception e) {
            throw new BlobStoreException("Error getting content at " + this.getFullKey(previewMapping, path), (Throwable)e);
        }
    }

    @Override
    public long getContentSize(String site, String path) {
        AbstractBlobStore.Mapping previewMapping = this.getMapping(this.publishingTargetResolver.getPublishingTarget());
        logger.debug("Getting content size at {0}", this.getFullKey(previewMapping, path));
        try {
            ObjectMetadata metadata = this.getClient().getObjectMetadata(previewMapping.target, this.getKey(previewMapping, path));
            return metadata.getContentLength();
        }
        catch (Exception e) {
            throw new BlobStoreException("Error getting content size at " + this.getFullKey(previewMapping, path), (Throwable)e);
        }
    }

    @Override
    public String writeContent(String site, String path, InputStream content) throws ServiceLayerException {
        AbstractBlobStore.Mapping previewMapping = this.getMapping(this.publishingTargetResolver.getPublishingTarget());
        logger.debug("Uploading content to {0}", this.getFullKey(previewMapping, path));
        try {
            AwsUtils.uploadStream(previewMapping.target, this.getKey(previewMapping, path), this.getClient(), 0x500000, path, content);
            return OK;
        }
        catch (Exception e) {
            throw new BlobStoreException("Error uploading content at " + this.getFullKey(previewMapping, path), (Throwable)e);
        }
    }

    @Override
    public String createFolder(String site, String path, String name) {
        return OK;
    }

    @Override
    public String deleteContent(String site, String path, String approver) {
        AbstractBlobStore.Mapping previewMapping = this.getMapping(this.publishingTargetResolver.getPublishingTarget());
        logger.debug("Deleting content at {0}", this.getFullKey(previewMapping, path));
        if (!this.isFolder(path)) {
            try {
                this.getClient().deleteObject(previewMapping.target, this.getKey(previewMapping, path));
            }
            catch (Exception e) {
                throw new BlobStoreException("Error deleting content at " + this.getFullKey(previewMapping, path), (Throwable)e);
            }
        }
        ListObjectsV2Request request = new ListObjectsV2Request().withBucketName(previewMapping.target).withPrefix(StringUtils.appendIfMissing((String)this.getKey(previewMapping, path), (CharSequence)"/", (CharSequence[])new CharSequence[0]));
        do {
            try {
                ListObjectsV2Result result = this.getClient().listObjectsV2(request);
                request.setContinuationToken(result.getContinuationToken());
                Object[] keys = result.getObjectSummaries().stream().map(S3ObjectSummary::getKey).collect(Collectors.toList()).toArray(new String[0]);
                if (!ArrayUtils.isNotEmpty((Object[])keys)) continue;
                logger.debug("Deleting contents at {0} from bucket {1}", Arrays.toString(keys), previewMapping.target);
                try {
                    this.getClient().deleteObjects(new DeleteObjectsRequest(previewMapping.target).withKeys((String[])keys));
                }
                catch (Exception e) {
                    throw new BlobStoreException("Error deleting contents at " + Arrays.toString(keys) + " from bucket " + previewMapping.target, (Throwable)e);
                }
            }
            catch (Exception e) {
                throw new BlobStoreException("Error listing content at " + this.getFullKey(previewMapping, path), (Throwable)e);
            }
        } while (StringUtils.isNotEmpty((CharSequence)request.getContinuationToken()));
        return OK;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map<String, String> moveContent(String site, String fromPath, String toPath, String newName) {
        AbstractBlobStore.Mapping previewMapping = this.getMapping(this.publishingTargetResolver.getPublishingTarget());
        logger.debug("Moving content from {0} to {1}", this.getFullKey(previewMapping, fromPath), this.getFullKey(previewMapping, toPath));
        if (!StringUtils.isEmpty((CharSequence)newName)) throw new UnsupportedOperationException();
        if (this.isFolder(fromPath)) {
            ListObjectsV2Request request = new ListObjectsV2Request().withBucketName(previewMapping.target).withPrefix(StringUtils.appendIfMissing((String)this.getKey(previewMapping, fromPath), (CharSequence)"/", (CharSequence[])new CharSequence[0]));
            do {
                try {
                    Object[] keys;
                    ListObjectsV2Result result = this.getClient().listObjectsV2(request);
                    request.setContinuationToken(result.getContinuationToken());
                    for (String string : keys = result.getObjectSummaries().stream().map(S3ObjectSummary::getKey).collect(Collectors.toList()).toArray(new String[0])) {
                        String filePath = Paths.get(this.getKey(previewMapping, fromPath), new String[0]).relativize(Paths.get(string, new String[0])).toString();
                        logger.debug("Moving content from {0} to {1}", this.getFullKey(previewMapping, string), this.getFullKey(previewMapping, toPath + "/" + filePath));
                        try {
                            this.getClient().copyObject(previewMapping.target, string, previewMapping.target, this.getKey(previewMapping, toPath + "/" + filePath));
                        }
                        catch (Exception e) {
                            throw new BlobStoreException("Error copying content from " + this.getFullKey(previewMapping, string) + " to " + this.getFullKey(previewMapping, toPath + "/" + filePath), (Throwable)e);
                        }
                    }
                    try {
                        this.getClient().deleteObjects(new DeleteObjectsRequest(previewMapping.target).withKeys((String[])keys));
                    }
                    catch (Exception e) {
                        throw new BlobStoreException("Error deleting content at " + Arrays.toString(keys) + " from bucket " + previewMapping.target, (Throwable)e);
                    }
                }
                catch (Exception e) {
                    throw new BlobStoreException("Error listing content at " + this.getFullKey(previewMapping, fromPath), (Throwable)e);
                }
            } while (StringUtils.isNotEmpty((CharSequence)request.getContinuationToken()));
            return Collections.emptyMap();
        }
        try {
            this.getClient().copyObject(previewMapping.target, this.getKey(previewMapping, fromPath), previewMapping.target, this.getKey(previewMapping, toPath));
            this.getClient().deleteObject(previewMapping.target, this.getKey(previewMapping, fromPath));
            return Collections.emptyMap();
        }
        catch (Exception e) {
            throw new BlobStoreException("Error moving content from " + this.getFullKey(previewMapping, fromPath) + " to " + this.getFullKey(previewMapping, toPath), (Throwable)e);
        }
    }

    @Override
    public String copyContent(String site, String fromPath, String toPath) {
        AbstractBlobStore.Mapping previewMapping = this.getMapping(this.publishingTargetResolver.getPublishingTarget());
        logger.debug("Copying content from {0} to {1}", this.getFullKey(previewMapping, fromPath), this.getFullKey(previewMapping, toPath));
        if (this.isFolder(fromPath)) {
            ListObjectsV2Request request = new ListObjectsV2Request().withBucketName(previewMapping.target).withPrefix(StringUtils.appendIfMissing((String)this.getKey(previewMapping, fromPath), (CharSequence)"/", (CharSequence[])new CharSequence[0]));
            do {
                try {
                    String[] keys;
                    ListObjectsV2Result result = this.getClient().listObjectsV2(request);
                    request.setContinuationToken(result.getContinuationToken());
                    for (String key : keys = result.getObjectSummaries().stream().map(S3ObjectSummary::getKey).collect(Collectors.toList()).toArray(new String[0])) {
                        String filePath = Paths.get(this.getKey(previewMapping, fromPath), new String[0]).relativize(Paths.get(key, new String[0])).toString();
                        logger.debug("Copying content from {0} to {1}", this.getFullKey(previewMapping, key), this.getFullKey(previewMapping, toPath + "/" + filePath));
                        try {
                            this.getClient().copyObject(previewMapping.target, key, previewMapping.target, this.getKey(previewMapping, toPath + "/" + filePath));
                        }
                        catch (Exception e) {
                            throw new BlobStoreException("Error copying content from " + this.getFullKey(previewMapping, key) + " to " + this.getFullKey(previewMapping, toPath + "/" + filePath), (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    throw new BlobStoreException("Error listing content at " + this.getFullKey(previewMapping, fromPath), (Throwable)e);
                }
            } while (StringUtils.isNotEmpty((CharSequence)request.getContinuationToken()));
        } else {
            try {
                this.getClient().copyObject(previewMapping.target, this.getKey(previewMapping, fromPath), previewMapping.target, this.getKey(previewMapping, toPath));
            }
            catch (Exception e) {
                throw new BlobStoreException("Error copying content from " + this.getFullKey(previewMapping, fromPath) + " to " + this.getFullKey(previewMapping, toPath), (Throwable)e);
            }
        }
        return OK;
    }

    @Override
    public void publish(String site, String sandboxBranch, List<DeploymentItemTO> deploymentItems, String environment, String author, String comment) {
        AbstractBlobStore.Mapping previewMapping = this.getMapping(this.publishingTargetResolver.getPublishingTarget());
        AbstractBlobStore.Mapping envMapping = this.getMapping(environment);
        logger.debug("Publishing content from bucket {0} to bucket {1}", previewMapping.target, envMapping.target);
        for (DeploymentItemTO item : deploymentItems) {
            if (item.isDelete()) {
                logger.debug("Deleting content at {0}", this.getFullKey(envMapping, item.getPath()));
                try {
                    this.getClient().deleteObject(envMapping.target, this.getKey(envMapping, item.getPath()));
                    if (!StringUtils.isNotEmpty((CharSequence)item.getOldPath())) continue;
                    logger.debug("Deleting content at {0}", this.getFullKey(envMapping, item.getOldPath()));
                    this.getClient().deleteObject(envMapping.target, this.getKey(envMapping, item.getOldPath()));
                    continue;
                }
                catch (Exception e) {
                    throw new BlobStoreException("Error deleting content at " + this.getFullKey(previewMapping, item.getPath()), (Throwable)e);
                }
            }
            if (item.isMove()) {
                logger.debug("Moving content from {0} to {1}", this.getFullKey(envMapping, item.getOldPath()), this.getFullKey(envMapping, item.getPath()));
                try {
                    this.getClient().copyObject(envMapping.target, this.getKey(envMapping, item.getOldPath()), envMapping.target, this.getKey(envMapping, item.getPath()));
                    this.getClient().deleteObject(envMapping.target, this.getKey(envMapping, item.getOldPath()));
                    continue;
                }
                catch (Exception e) {
                    throw new BlobStoreException("Error moving content from " + this.getFullKey(envMapping, item.getOldPath()) + " to " + this.getFullKey(envMapping, item.getPath()), (Throwable)e);
                }
            }
            logger.debug("Copying content from {0} to {1}", this.getFullKey(previewMapping, item.getPath()), this.getFullKey(envMapping, item.getPath()));
            try {
                this.getClient().copyObject(previewMapping.target, this.getKey(previewMapping, item.getPath()), envMapping.target, this.getKey(envMapping, item.getPath()));
            }
            catch (Exception e) {
                throw new BlobStoreException("Error copying content from " + this.getFullKey(previewMapping, item.getPath()) + " to " + this.getFullKey(envMapping, item.getPath()), (Throwable)e);
            }
        }
    }
}

