/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.security;

import java.util.ArrayList;
import java.util.UUID;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.studio.api.v1.dal.SiteFeed;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.exception.security.AuthenticationSystemException;
import org.craftercms.studio.api.v1.exception.security.UserAlreadyExistsException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v2.dal.AuditLog;
import org.craftercms.studio.api.v2.dal.Group;
import org.craftercms.studio.api.v2.dal.User;
import org.craftercms.studio.api.v2.dal.UserGroup;
import org.craftercms.studio.api.v2.service.audit.internal.AuditServiceInternal;
import org.craftercms.studio.api.v2.service.security.internal.GroupServiceInternal;
import org.craftercms.studio.api.v2.service.security.internal.UserServiceInternal;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.impl.v1.util.SessionTokenUtils;
import org.craftercms.studio.impl.v2.service.security.Authentication;
import org.craftercms.studio.model.AuthenticationType;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.saml.SAMLAuthenticationProvider;

public class StudioSAMLAuthenticationProvider
extends SAMLAuthenticationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(StudioSAMLAuthenticationProvider.class);
    private SiteService siteService;
    private StudioConfiguration studioConfiguration;
    private UserServiceInternal userServiceInternal;
    private GroupServiceInternal groupServiceInternal;
    private AuditServiceInternal auditServiceInternal;
    private String logoutUrl;

    public org.springframework.security.core.Authentication authenticate(org.springframework.security.core.Authentication authentication) throws AuthenticationException {
        org.springframework.security.core.Authentication a = super.authenticate(authentication);
        User samlUser = (User)a.getDetails();
        try {
            AuditLog auditLog;
            User user;
            SiteFeed siteFeed = this.siteService.getSite(this.studioConfiguration.getProperty("studio.configuration.global.systemSite"));
            if (this.userServiceInternal.userExists(-1L, samlUser.getUsername())) {
                user = this.userServiceInternal.getUserByIdOrUsername(-1L, samlUser.getUsername());
                user.setFirstName(samlUser.getFirstName());
                user.setLastName(samlUser.getLastName());
                user.setEmail(samlUser.getEmail());
                if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{samlUser.getFirstName(), samlUser.getLastName(), samlUser.getEmail()})) {
                    LOGGER.debug("If user already exists in studio DB, update details.", new Object[0]);
                    try {
                        this.userServiceInternal.updateUser(user);
                        auditLog = this.auditServiceInternal.createAuditLogEntry();
                        auditLog.setOperation("UPDATE");
                        auditLog.setActorId(samlUser.getUsername());
                        auditLog.setSiteId(siteFeed.getId());
                        auditLog.setPrimaryTargetId(samlUser.getUsername());
                        auditLog.setPrimaryTargetType("User");
                        auditLog.setPrimaryTargetValue(user.getUsername());
                        this.auditServiceInternal.insertAuditLog(auditLog);
                    }
                    catch (Exception e) {
                        LOGGER.debug("Error updating user " + samlUser.getUsername() + " with data from SAML SSO", e);
                        throw new AuthenticationSystemException("Error updating user " + samlUser.getUsername() + " with data from SAML SSO", e);
                    }
                }
            } else {
                LOGGER.debug("User does not exist in studio db. Adding user " + samlUser.getUsername(), new Object[0]);
                try {
                    user = new User();
                    user.setUsername(samlUser.getUsername());
                    user.setPassword(UUID.randomUUID().toString());
                    user.setFirstName(samlUser.getFirstName());
                    user.setLastName(samlUser.getLastName());
                    user.setEmail(samlUser.getEmail());
                    user.setExternallyManaged(true);
                    user.setEnabled(true);
                    this.userServiceInternal.createUser(user);
                    auditLog = this.auditServiceInternal.createAuditLogEntry();
                    auditLog.setOperation("CREATE");
                    auditLog.setSiteId(siteFeed.getId());
                    auditLog.setActorId(samlUser.getUsername());
                    auditLog.setPrimaryTargetId(samlUser.getUsername());
                    auditLog.setPrimaryTargetType("User");
                    auditLog.setPrimaryTargetValue(user.getUsername());
                    this.auditServiceInternal.insertAuditLog(auditLog);
                }
                catch (ServiceLayerException | UserAlreadyExistsException e) {
                    LOGGER.debug("Error adding user " + samlUser.getUsername() + " from SAML SSO ", e);
                    throw new AuthenticationSystemException("Error adding user " + samlUser.getUsername() + " from SAML SSO", e);
                }
            }
            LOGGER.debug("Update user groups in database.", new Object[0]);
            if (CollectionUtils.isNotEmpty(samlUser.getGroups())) {
                for (UserGroup userGroup : samlUser.getGroups()) {
                    Group g = userGroup.getGroup();
                    try {
                        this.upsertUserGroup(g.getGroupName(), samlUser.getUsername());
                    }
                    catch (Exception e) {
                        LOGGER.error("Error updating user group " + g.getGroupName() + " with data from SAML SSO", e, new Object[0]);
                    }
                }
            }
            String token = this.createToken(samlUser);
            this.storeAuthentication(new Authentication(samlUser.getUsername(), token, AuthenticationType.SAML, this.logoutUrl));
            if (a.isAuthenticated()) {
                auditLog = this.auditServiceInternal.createAuditLogEntry();
                auditLog.setOperation("LOGIN");
                auditLog.setActorId(samlUser.getUsername());
                auditLog.setSiteId(siteFeed.getId());
                auditLog.setPrimaryTargetId(samlUser.getUsername());
                auditLog.setPrimaryTargetType("User");
                auditLog.setPrimaryTargetValue(samlUser.getUsername());
                this.auditServiceInternal.insertAuditLog(auditLog);
                LOGGER.info("User " + samlUser.getUsername() + " logged in using SAML SSO authentication", new Object[0]);
            } else {
                auditLog = this.auditServiceInternal.createAuditLogEntry();
                auditLog.setOperation("LOGIN_FAILED");
                auditLog.setActorId(samlUser.getUsername());
                auditLog.setSiteId(siteFeed.getId());
                auditLog.setPrimaryTargetId(StringUtils.isEmpty((CharSequence)samlUser.getUsername()) ? "" : samlUser.getUsername());
                auditLog.setPrimaryTargetType("User");
                auditLog.setPrimaryTargetValue(samlUser.getUsername());
                this.auditServiceInternal.insertAuditLog(auditLog);
                LOGGER.info("Failed to authenticate user " + samlUser.getUsername() + " using SAML SSO authentication", new Object[0]);
            }
        }
        catch (ServiceLayerException | AuthenticationSystemException | UserNotFoundException e) {
            LOGGER.error("Unable to authenticate user using SAML SSO", e, new Object[0]);
        }
        return a;
    }

    protected String createToken(User user) {
        int timeout = this.studioConfiguration.getProperty("studio.security.sessionTimeout", Integer.class);
        String token = SessionTokenUtils.createToken(user.getUsername(), timeout);
        return token;
    }

    protected void storeAuthentication(Authentication authentication) {
        RequestContext context = RequestContext.getCurrent();
        if (context != null) {
            HttpSession httpSession = context.getRequest().getSession();
            httpSession.setAttribute("studio_authentication", (Object)authentication);
        }
    }

    protected boolean upsertUserGroup(String groupName, String username) throws SiteNotFoundException {
        SiteFeed siteFeed = this.siteService.getSite(this.studioConfiguration.getProperty("studio.configuration.global.systemSite"));
        try {
            if (!this.groupServiceInternal.groupExists(-1L, groupName)) {
                this.groupServiceInternal.createGroup(1L, groupName, "Externally managed group - " + groupName);
            }
            if (!this.userServiceInternal.isUserMemberOfGroup(username, groupName)) {
                Group group = this.groupServiceInternal.getGroupByName(groupName);
                if (group != null) {
                    ArrayList<String> usernames = new ArrayList<String>();
                    usernames.add(username);
                    this.groupServiceInternal.addGroupMembers(group.getId(), new ArrayList<Long>(), usernames);
                    try {
                        AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
                        auditLog.setOperation("ADD_MEMBERS");
                        auditLog.setSiteId(siteFeed.getId());
                        auditLog.setActorId(username);
                        auditLog.setPrimaryTargetId(group.getGroupName() + ":" + username);
                        auditLog.setPrimaryTargetType("User");
                        auditLog.setPrimaryTargetValue(username);
                        this.auditServiceInternal.insertAuditLog(auditLog);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unknown database error", e, new Object[0]);
                    }
                } else {
                    LOGGER.error("Group " + groupName + " not found", new Object[0]);
                }
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Error creating group", e, new Object[0]);
            return false;
        }
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public UserServiceInternal getUserServiceInternal() {
        return this.userServiceInternal;
    }

    public void setUserServiceInternal(UserServiceInternal userServiceInternal) {
        this.userServiceInternal = userServiceInternal;
    }

    public AuditServiceInternal getAuditServiceInternal() {
        return this.auditServiceInternal;
    }

    public void setAuditServiceInternal(AuditServiceInternal auditServiceInternal) {
        this.auditServiceInternal = auditServiceInternal;
    }

    public GroupServiceInternal getGroupServiceInternal() {
        return this.groupServiceInternal;
    }

    public void setGroupServiceInternal(GroupServiceInternal groupServiceInternal) {
        this.groupServiceInternal = groupServiceInternal;
    }

    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    public void setLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
    }
}

