/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.audit;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.security.permissions.DefaultPermission;
import org.craftercms.commons.security.permissions.annotations.HasPermission;
import org.craftercms.commons.security.permissions.annotations.ProtectedResourceId;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.deployment.DeploymentService;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v2.dal.AuditLog;
import org.craftercms.studio.api.v2.service.audit.AuditService;
import org.craftercms.studio.api.v2.service.audit.internal.AuditServiceInternal;

public class AuditServiceImpl
implements AuditService {
    private static final Logger logger = LoggerFactory.getLogger(AuditServiceImpl.class);
    private AuditServiceInternal auditServiceInternal;
    private SiteService siteService;
    private ContentService contentService;
    private DeploymentService deploymentService;
    private SecurityService securityService;

    public AuditServiceImpl(AuditServiceInternal auditServiceInternal, SiteService siteService, ContentService contentService, DeploymentService deploymentService, SecurityService securityService) {
        this.auditServiceInternal = auditServiceInternal;
        this.siteService = siteService;
        this.contentService = contentService;
        this.deploymentService = deploymentService;
        this.securityService = securityService;
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="audit_log")
    public List<AuditLog> getAuditLogForSite(@ProtectedResourceId(value="siteId") String site, int offset, int limit, String user, List<String> actions) throws SiteNotFoundException {
        if (StringUtils.isNotEmpty((CharSequence)site) && !this.siteService.exists(site)) {
            throw new SiteNotFoundException("Site " + site + " not found.");
        }
        return this.auditServiceInternal.getAuditLogForSite(site, offset, limit, user, actions);
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="audit_log")
    public int getAuditLogForSiteTotal(@ProtectedResourceId(value="siteId") String site, String user, List<String> actions) throws SiteNotFoundException {
        if (StringUtils.isNotEmpty((CharSequence)site) && !this.siteService.exists(site)) {
            throw new SiteNotFoundException();
        }
        return this.auditServiceInternal.getAuditLogForSiteTotal(site, user, actions);
    }

    @Override
    public List<AuditLog> getAuditLog(String siteId, String siteName, int offset, int limit, String user, List<String> operations, boolean includeParameters, ZonedDateTime dateFrom, ZonedDateTime dateTo, String target, String origin, String clusterNodeId, String sort, String order) {
        return this.auditServiceInternal.getAuditLog(siteId, siteName, offset, limit, user, operations, includeParameters, dateFrom, dateTo, target, origin, clusterNodeId, sort, order);
    }

    @Override
    public int getAuditLogTotal(String siteId, String siteName, String user, List<String> operations, boolean includeParameters, ZonedDateTime dateFrom, ZonedDateTime dateTo, String target, String origin, String clusterNodeId) {
        return this.auditServiceInternal.getAuditLogTotal(siteId, siteName, user, operations, includeParameters, dateFrom, dateTo, target, origin, clusterNodeId);
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="audit_log")
    public AuditLog getAuditLogEntry(long auditLogId) {
        return this.auditServiceInternal.getAuditLogEntry(auditLogId);
    }

    @Override
    public List<ContentItemTO> getUserActivities(String site, int limit, String sort, boolean ascending, boolean excludeLive, String filterType) throws ServiceLayerException {
        int startPos = 0;
        ArrayList<ContentItemTO> contentItems = new ArrayList<ContentItemTO>();
        boolean hasMoreItems = true;
        String user = this.securityService.getCurrentUser();
        while (contentItems.size() < limit && hasMoreItems) {
            int remainingItems = limit - contentItems.size();
            hasMoreItems = this.getActivityFeeds(user, site, startPos, limit, filterType, excludeLive, contentItems, remainingItems);
            startPos += limit;
        }
        if (contentItems.size() > limit) {
            return contentItems.subList(0, limit);
        }
        return contentItems;
    }

    protected boolean getActivityFeeds(String user, String site, int startPos, int size, String filterType, boolean hideLiveItems, List<ContentItemTO> contentItems, int remainingItem) {
        List<AuditLog> activityFeeds = this.auditServiceInternal.selectUserFeedEntries(user, site, startPos, size, filterType, hideLiveItems);
        boolean hasMoreItems = true;
        if (activityFeeds.size() < size) {
            hasMoreItems = false;
        }
        if (activityFeeds != null && activityFeeds.size() > 0) {
            for (int index = 0; index < activityFeeds.size() && remainingItem != 0; --remainingItem, ++index) {
                AuditLog auditLog = activityFeeds.get(index);
                String id = auditLog.getPrimaryTargetValue();
                ContentItemTO item = this.createActivityItem(site, auditLog, id);
                contentItems.add(item);
            }
        }
        logger.debug("Total Item post live filter : " + contentItems.size() + " hasMoreItems : " + hasMoreItems, new Object[0]);
        return hasMoreItems;
    }

    protected ContentItemTO createActivityItem(String site, AuditLog auditLog, String id) {
        try {
            ZonedDateTime editedDate;
            ContentItemTO item = this.contentService.getContentItem(site, id, 0);
            if (item == null || item.isDeleted()) {
                item = this.contentService.createDummyDmContentItemForDeletedNode(site, id);
                String modifier = auditLog.getActorId();
                if (modifier != null && !modifier.isEmpty()) {
                    item.user = modifier;
                }
                item.contentType = auditLog.getPrimaryTargetSubtype();
                item.setLockOwner("");
            }
            item.eventDate = (editedDate = auditLog.getOperationTimestamp()) != null ? editedDate.withZoneSameInstant(ZoneOffset.UTC) : editedDate;
            return item;
        }
        catch (Exception e) {
            logger.error("Error fetching content item for [" + id + "]", e.getMessage());
            return null;
        }
    }
}

