/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.audit.internal;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.objectstate.State;
import org.craftercms.studio.api.v2.dal.AuditDAO;
import org.craftercms.studio.api.v2.dal.AuditLog;
import org.craftercms.studio.api.v2.service.audit.internal.AuditServiceInternal;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;

public class AuditServiceInternalImpl
implements AuditServiceInternal {
    private static final Logger logger = LoggerFactory.getLogger(AuditServiceInternalImpl.class);
    private AuditDAO auditDao;
    private StudioConfiguration studioConfiguration;

    public AuditServiceInternalImpl(AuditDAO auditDao, StudioConfiguration studioConfiguration) {
        this.auditDao = auditDao;
        this.studioConfiguration = studioConfiguration;
    }

    @Override
    public List<AuditLog> getAuditLogForSite(String site, int offset, int limit, String user, List<String> actions) throws SiteNotFoundException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("siteId", site);
        params.put("offset", offset);
        params.put("limit", limit);
        if (StringUtils.isNotEmpty((CharSequence)user)) {
            params.put("username", user);
        }
        if (CollectionUtils.isNotEmpty(actions)) {
            params.put("actions", actions);
        }
        return this.auditDao.getAuditLogForSite(params);
    }

    @Override
    public int getAuditLogForSiteTotal(String site, String user, List<String> actions) throws SiteNotFoundException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("siteId", site);
        if (StringUtils.isNotEmpty((CharSequence)user)) {
            params.put("username", user);
        }
        if (CollectionUtils.isNotEmpty(actions)) {
            params.put("actions", actions);
        }
        return this.auditDao.getAuditLogForSiteTotal(params);
    }

    @Override
    public List<AuditLog> getAuditLog(String siteId, String siteName, int offset, int limit, String user, List<String> operations, boolean includeParameters, ZonedDateTime dateFrom, ZonedDateTime dateTo, String target, String origin, String clusterNodeId, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("offset", offset);
        params.put("limit", limit);
        if (StringUtils.isNotEmpty((CharSequence)siteId)) {
            params.put("siteId", siteId);
        }
        if (StringUtils.isNotEmpty((CharSequence)siteName)) {
            params.put("siteName", siteName);
        }
        if (StringUtils.isNotEmpty((CharSequence)user)) {
            params.put("username", user);
        }
        if (CollectionUtils.isNotEmpty(operations)) {
            params.put("operations", operations);
        }
        if (dateFrom != null) {
            params.put("dateFrom", dateFrom);
        }
        if (dateTo != null) {
            params.put("dateTo", dateTo);
        }
        if (StringUtils.isNotEmpty((CharSequence)target)) {
            params.put("target", target);
        }
        if (StringUtils.isNotEmpty((CharSequence)origin)) {
            if (StringUtils.equalsIgnoreCase((CharSequence)origin, (CharSequence)"API")) {
                params.put("origin", "API");
            } else if (StringUtils.equalsIgnoreCase((CharSequence)origin, (CharSequence)"GIT")) {
                params.put("origin", "GIT");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)clusterNodeId)) {
            params.put("clusterNodeId", clusterNodeId);
        }
        if (StringUtils.isNotEmpty((CharSequence)sort) && StringUtils.equalsIgnoreCase((CharSequence)sort, (CharSequence)"date")) {
            params.put("sort", "operation_timestamp");
        }
        if (StringUtils.isNotEmpty((CharSequence)order)) {
            if (StringUtils.equalsIgnoreCase((CharSequence)"DESC", (CharSequence)order)) {
                params.put("order", "DESC");
            } else {
                params.put("order", "ASC");
            }
        }
        params.put("includeParameters", includeParameters);
        return this.auditDao.getAuditLog(params);
    }

    @Override
    public int getAuditLogTotal(String siteId, String siteName, String user, List<String> operations, boolean includeParameters, ZonedDateTime dateFrom, ZonedDateTime dateTo, String target, String origin, String clusterNodeId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((CharSequence)siteId)) {
            params.put("siteId", siteId);
        }
        if (StringUtils.isNotEmpty((CharSequence)siteName)) {
            params.put("siteName", siteName);
        }
        if (StringUtils.isNotEmpty((CharSequence)user)) {
            params.put("username", user);
        }
        if (CollectionUtils.isNotEmpty(operations)) {
            params.put("operations", operations);
        }
        if (dateFrom != null) {
            params.put("dateFrom", dateFrom);
        }
        if (dateTo != null) {
            params.put("dateTo", dateTo);
        }
        if (StringUtils.isNotEmpty((CharSequence)target)) {
            params.put("target", target);
        }
        if (StringUtils.isNotEmpty((CharSequence)origin)) {
            if (StringUtils.equalsIgnoreCase((CharSequence)origin, (CharSequence)"API")) {
                params.put("origin", "API");
            } else if (StringUtils.equalsIgnoreCase((CharSequence)origin, (CharSequence)"GIT")) {
                params.put("origin", "GIT");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)clusterNodeId)) {
            params.put("clusterNodeId", clusterNodeId);
        }
        params.put("includeParameters", includeParameters);
        return this.auditDao.getAuditLogTotal(params);
    }

    @Override
    public int getAuditDashboardTotal(String siteId, String user, List<String> operations, ZonedDateTime dateFrom, ZonedDateTime dateTo, String target) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((CharSequence)siteId)) {
            params.put("siteId", siteId);
        }
        if (StringUtils.isNotEmpty((CharSequence)user)) {
            params.put("username", user);
        }
        if (CollectionUtils.isNotEmpty(operations)) {
            params.put("operations", operations);
        }
        if (dateFrom != null) {
            params.put("dateFrom", dateFrom);
        }
        if (dateTo != null) {
            params.put("dateTo", dateTo);
        }
        if (StringUtils.isNotEmpty((CharSequence)target)) {
            params.put("target", target);
        }
        return this.auditDao.getAuditDashboardTotal(params);
    }

    @Override
    public List<AuditLog> getAuditDashboard(String siteId, int offset, int limit, String user, List<String> operations, ZonedDateTime dateFrom, ZonedDateTime dateTo, String target, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("offset", offset);
        params.put("limit", limit);
        if (StringUtils.isNotEmpty((CharSequence)siteId)) {
            params.put("siteId", siteId);
        }
        if (StringUtils.isNotEmpty((CharSequence)user)) {
            params.put("username", user);
        }
        if (CollectionUtils.isNotEmpty(operations)) {
            params.put("operations", operations);
        }
        if (dateFrom != null) {
            params.put("dateFrom", dateFrom);
        }
        if (dateTo != null) {
            params.put("dateTo", dateTo);
        }
        if (StringUtils.isNotEmpty((CharSequence)target)) {
            params.put("target", target);
        }
        if (StringUtils.isNotEmpty((CharSequence)sort)) {
            String sortParam = "";
            switch (sort) {
                case "site": {
                    sortParam = "site_name";
                    break;
                }
                case "actor": {
                    sortParam = "actor_id";
                    break;
                }
                case "operation": {
                    sortParam = "operation";
                    break;
                }
                case "operationTimestamp": {
                    sortParam = "operation_timestamp";
                    break;
                }
                case "target": {
                    sortParam = "primary_target_value";
                    break;
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)sortParam)) {
                params.put("sort", sortParam);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)order)) {
            if (StringUtils.equalsIgnoreCase((CharSequence)"DESC", (CharSequence)order)) {
                params.put("order", "DESC");
            } else {
                params.put("order", "ASC");
            }
        }
        return this.auditDao.getAuditDashboard(params);
    }

    @Override
    public AuditLog getAuditLogEntry(long auditLogId) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("id", auditLogId);
        return this.auditDao.getAuditLogEntry(params);
    }

    @Override
    public boolean insertAuditLog(AuditLog auditLog) {
        int result = this.auditDao.insertAuditLog(auditLog);
        if (CollectionUtils.isNotEmpty(auditLog.getParameters())) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("auditId", auditLog.getId());
            params.put("parameters", auditLog.getParameters());
            this.auditDao.insertAuditLogParams(params);
        }
        return result > 0;
    }

    @Override
    public AuditLog createAuditLogEntry() {
        AuditLog auditLog = new AuditLog();
        String clusterNodeId = "";
        HierarchicalConfiguration<ImmutableNode> clusterNodeData = this.studioConfiguration.getSubConfig("studio.clustering.node.registration");
        if (clusterNodeData != null && !clusterNodeData.isEmpty()) {
            clusterNodeId = clusterNodeData.getString("localAddress");
        }
        auditLog.setOrganizationId(1L);
        auditLog.setOrigin("API");
        auditLog.setClusterNodeId(clusterNodeId);
        return auditLog;
    }

    @Override
    public List<AuditLog> selectUserFeedEntries(String user, String siteId, int offset, int limit, String contentType, boolean hideLiveItems) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", user);
        params.put("siteId", siteId);
        params.put("offset", offset);
        params.put("limit", limit);
        params.put("operations", Arrays.asList("CREATE", "DELETE", "UPDATE", "MOVE"));
        params.put("targetType", "Content Item");
        if (StringUtils.isNotEmpty((CharSequence)contentType) && !contentType.toLowerCase().equals("all")) {
            params.put("contentType", contentType.toLowerCase());
        }
        if (hideLiveItems) {
            ArrayList<String> statesValues = new ArrayList<String>();
            for (State state : State.LIVE_STATES) {
                statesValues.add(state.name());
            }
            params.put("states", statesValues);
            return this.auditDao.selectUserFeedEntriesHideLive(params);
        }
        return this.auditDao.selectUserFeedEntries(params);
    }

    @Override
    public void deleteAuditLogForSite(long siteId) {
        this.auditDao.deleteAuditLogForSite(siteId);
    }
}

