/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.aws.mediaconvert;

import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.mediaconvert.AWSMediaConvert;
import com.amazonaws.services.mediaconvert.AWSMediaConvertClientBuilder;
import com.amazonaws.services.mediaconvert.model.CmafGroupSettings;
import com.amazonaws.services.mediaconvert.model.CreateJobRequest;
import com.amazonaws.services.mediaconvert.model.CreateJobResult;
import com.amazonaws.services.mediaconvert.model.DashIsoGroupSettings;
import com.amazonaws.services.mediaconvert.model.FileGroupSettings;
import com.amazonaws.services.mediaconvert.model.GetJobTemplateRequest;
import com.amazonaws.services.mediaconvert.model.HlsGroupSettings;
import com.amazonaws.services.mediaconvert.model.Input;
import com.amazonaws.services.mediaconvert.model.JobSettings;
import com.amazonaws.services.mediaconvert.model.JobTemplate;
import com.amazonaws.services.mediaconvert.model.MsSmoothGroupSettings;
import com.amazonaws.services.mediaconvert.model.OutputGroupType;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3URI;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.config.profiles.aws.AbstractAwsProfile;
import org.craftercms.commons.file.stores.S3Utils;
import org.craftercms.commons.security.permissions.DefaultPermission;
import org.craftercms.commons.security.permissions.annotations.HasPermission;
import org.craftercms.commons.security.permissions.annotations.ProtectedResourceId;
import org.craftercms.commons.validation.annotations.param.ValidateStringParam;
import org.craftercms.studio.api.v1.aws.mediaconvert.MediaConvertProfile;
import org.craftercms.studio.api.v1.exception.AwsException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.aws.AbstractAwsService;
import org.craftercms.studio.api.v2.service.aws.mediaconvert.AwsMediaConvertService;
import org.craftercms.studio.impl.v1.service.aws.AwsUtils;
import org.craftercms.studio.model.aws.mediaconvert.MediaConvertResult;
import org.springframework.beans.factory.annotation.Required;

public class AwsMediaConvertServiceImpl
extends AbstractAwsService<MediaConvertProfile>
implements AwsMediaConvertService {
    private static final Logger logger = LoggerFactory.getLogger(AwsMediaConvertServiceImpl.class);
    protected int partSize = 0x500000;
    protected String delimiter;
    protected String urlPattern;
    protected String hlsExtension;
    protected String dashExtension;
    protected String smoothExtension;

    public void setPartSize(int partSize) {
        this.partSize = partSize;
    }

    @Required
    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    @Required
    public void setUrlPattern(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    @Required
    public void setHlsExtension(String hlsExtension) {
        this.hlsExtension = hlsExtension;
    }

    @Required
    public void setDashExtension(String dashExtension) {
        this.dashExtension = dashExtension;
    }

    @Required
    public void setSmoothExtension(String smoothExtension) {
        this.smoothExtension = smoothExtension;
    }

    protected AmazonS3 getS3Client(MediaConvertProfile profile) {
        return S3Utils.createClient((AbstractAwsProfile)profile, (boolean)false);
    }

    protected AWSMediaConvert getMediaConvertClient(MediaConvertProfile profile) {
        return (AWSMediaConvert)((AWSMediaConvertClientBuilder)((AWSMediaConvertClientBuilder)AWSMediaConvertClientBuilder.standard().withCredentials(profile.getCredentialsProvider())).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(profile.getEndpoint(), profile.getRegion()))).build();
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="s3 write")
    public MediaConvertResult uploadVideo(@ValidateStringParam @ProtectedResourceId(value="siteId") String site, @ValidateStringParam String inputProfileId, @ValidateStringParam String outputProfileId, @ValidateStringParam String filename, InputStream content) throws AwsException {
        MediaConvertProfile profile = (MediaConvertProfile)((Object)this.getProfile(site, inputProfileId));
        AmazonS3 s3Client = this.getS3Client(profile);
        AWSMediaConvert mediaConvertClient = this.getMediaConvertClient(profile);
        logger.info("Starting upload of file {0} for site {1}", filename, site);
        AwsUtils.uploadStream(profile.getInputPath(), filename, s3Client, this.partSize, filename, content);
        logger.info("Upload of file {0} for site {1} complete", filename, site);
        String originalName = FilenameUtils.getBaseName((String)filename);
        JobTemplate jobTemplate = mediaConvertClient.getJobTemplate(new GetJobTemplateRequest().withName(profile.getTemplate())).getJobTemplate();
        JobSettings jobSettings = new JobSettings().withInputs(new Input[]{new Input().withFileInput(AwsUtils.getS3Url(profile.getInputPath(), filename))});
        CreateJobRequest createJobRequest = new CreateJobRequest().withJobTemplate(profile.getTemplate()).withSettings(jobSettings).withRole(profile.getRole()).withQueue(profile.getQueue());
        logger.info("Starting transcode job of file {0} for site {1}", filename, site);
        CreateJobResult createJobResult = mediaConvertClient.createJob(createJobRequest);
        logger.debug("Job {0} started", createJobResult.getJob().getArn());
        return this.buildResult(jobTemplate, createJobResult, outputProfileId, originalName);
    }

    protected MediaConvertResult buildResult(JobTemplate jobTemplate, CreateJobResult createJobResult, String outputProfileId, String originalName) {
        LinkedList<String> urls = new LinkedList<String>();
        jobTemplate.getSettings().getOutputGroups().forEach(outputGroup -> {
            logger.debug("Adding urls from group {0}", outputGroup.getName());
            OutputGroupType type = OutputGroupType.valueOf((String)outputGroup.getOutputGroupSettings().getType());
            switch (type) {
                case FILE_GROUP_SETTINGS: {
                    FileGroupSettings fileSettings = outputGroup.getOutputGroupSettings().getFileGroupSettings();
                    outputGroup.getOutputs().forEach(output -> this.addUrl(urls, outputProfileId, fileSettings.getDestination(), originalName, output.getNameModifier(), output.getExtension()));
                    break;
                }
                case HLS_GROUP_SETTINGS: {
                    HlsGroupSettings hlsSettings = outputGroup.getOutputGroupSettings().getHlsGroupSettings();
                    this.addUrl(urls, outputProfileId, hlsSettings.getDestination(), originalName, "", this.hlsExtension);
                    break;
                }
                case DASH_ISO_GROUP_SETTINGS: {
                    DashIsoGroupSettings dashSettings = outputGroup.getOutputGroupSettings().getDashIsoGroupSettings();
                    this.addUrl(urls, outputProfileId, dashSettings.getDestination(), originalName, "", this.dashExtension);
                    break;
                }
                case MS_SMOOTH_GROUP_SETTINGS: {
                    MsSmoothGroupSettings smoothSettings = outputGroup.getOutputGroupSettings().getMsSmoothGroupSettings();
                    this.addUrl(urls, outputProfileId, smoothSettings.getDestination(), originalName, "", this.smoothExtension);
                    break;
                }
                case CMAF_GROUP_SETTINGS: {
                    CmafGroupSettings cmafSettings = outputGroup.getOutputGroupSettings().getCmafGroupSettings();
                    this.addUrl(urls, outputProfileId, cmafSettings.getDestination(), originalName, "", this.hlsExtension);
                    this.addUrl(urls, outputProfileId, cmafSettings.getDestination(), originalName, "", this.dashExtension);
                    break;
                }
            }
        });
        MediaConvertResult result = new MediaConvertResult();
        result.setJobId(createJobResult.getJob().getId());
        result.setJobArn(createJobResult.getJob().getArn());
        result.setUrls(urls);
        return result;
    }

    protected void addUrl(List<String> urls, String outputProfileId, String destination, String originalName, String modifier, String extension) {
        String url = StringUtils.appendIfMissing((String)destination, (CharSequence)this.delimiter, (CharSequence[])new CharSequence[0]) + originalName + modifier + "." + extension;
        url = this.createUrl(outputProfileId, url);
        urls.add(url);
        logger.debug("Added url {0}", url);
    }

    protected String createUrl(String profileId, String fullUri) {
        AmazonS3URI uri = new AmazonS3URI(fullUri);
        return String.format(this.urlPattern, profileId, uri.getKey());
    }
}

