/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.aws.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.internal.Mimetypes;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.aws.S3ClientCachingFactory;
import org.craftercms.commons.config.profiles.aws.AbstractAwsProfile;
import org.craftercms.commons.config.profiles.aws.S3Profile;
import org.craftercms.commons.security.permissions.DefaultPermission;
import org.craftercms.commons.security.permissions.annotations.HasPermission;
import org.craftercms.commons.security.permissions.annotations.ProtectedResourceId;
import org.craftercms.commons.validation.annotations.param.ValidateStringParam;
import org.craftercms.studio.api.v1.exception.AwsException;
import org.craftercms.studio.api.v1.service.aws.AbstractAwsService;
import org.craftercms.studio.api.v2.service.aws.s3.AwsS3Service;
import org.craftercms.studio.impl.v1.service.aws.AwsUtils;
import org.craftercms.studio.model.aws.s3.S3Item;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;

public class AwsS3ServiceImpl
extends AbstractAwsService<S3Profile>
implements AwsS3Service {
    public static final String ITEM_FILTER = "item";
    protected S3ClientCachingFactory clientFactory;
    protected int partSize = 0x500000;
    protected String delimiter;
    protected String urlPattern;

    @Required
    public void setClientFactory(S3ClientCachingFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public void setPartSize(int partSize) {
        this.partSize = partSize;
    }

    @Required
    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    @Required
    public void setUrlPattern(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    protected AmazonS3 getS3Client(S3Profile profile) {
        return (AmazonS3)this.clientFactory.getClient((AbstractAwsProfile)profile);
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="s3 write")
    public S3Item uploadItem(@ValidateStringParam(name="siteId") @ProtectedResourceId(value="siteId") String siteId, @ValidateStringParam(name="profileId") String profileId, @ValidateStringParam(name="path") String path, @ValidateStringParam(name="filename") String filename, InputStream content) throws AwsException {
        S3Profile profile = (S3Profile)this.getProfile(siteId, profileId);
        AmazonS3 s3Client = this.getS3Client(profile);
        String inputBucket = profile.getBucketName();
        String key = StringUtils.isNotEmpty((CharSequence)path) ? this.normalizePrefix(path) + filename : filename;
        AwsUtils.uploadStream(inputBucket, key, s3Client, this.partSize, filename, content);
        return new S3Item(filename, this.createUrl(profileId, key), false);
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="s3 read")
    public List<S3Item> listItems(@ValidateStringParam(name="siteId") @ProtectedResourceId(value="siteId") String siteId, @ValidateStringParam(name="profileId") String profileId, @ValidateStringParam(name="path") String path, @ValidateStringParam(name="type") String type) throws AwsException {
        ListObjectsV2Result result;
        S3Profile profile = (S3Profile)this.getProfile(siteId, profileId);
        AmazonS3 client = this.getS3Client(profile);
        LinkedList<S3Item> items = new LinkedList<S3Item>();
        Mimetypes mimetypes = Mimetypes.getInstance();
        MimeType filerType = StringUtils.isEmpty((CharSequence)type) || StringUtils.equals((CharSequence)type, (CharSequence)ITEM_FILTER) ? MimeTypeUtils.ALL : new MimeType(type);
        String prefix = StringUtils.isEmpty((CharSequence)path) ? path : this.normalizePrefix(path);
        ListObjectsV2Request request = new ListObjectsV2Request().withBucketName(profile.getBucketName()).withPrefix(prefix).withDelimiter(this.delimiter);
        do {
            result = client.listObjectsV2(request);
            result.getCommonPrefixes().stream().map(p -> new S3Item(StringUtils.removeEnd((String)StringUtils.removeStart((String)p, (String)prefix), (String)this.delimiter), (String)p, true)).forEach(items::add);
            result.getObjectSummaries().stream().filter(o -> !StringUtils.equals((CharSequence)o.getKey(), (CharSequence)prefix) && MimeType.valueOf((String)mimetypes.getMimetype(o.getKey())).isCompatibleWith(filerType)).map(o -> new S3Item(StringUtils.removeStart((String)o.getKey(), (String)prefix), this.createUrl(profileId, o.getKey()), false)).forEach(items::add);
            request.setContinuationToken(result.getNextContinuationToken());
        } while (result.isTruncated());
        return items;
    }

    protected String createUrl(String profileId, String key) {
        return String.format(this.urlPattern, profileId, key);
    }

    protected String normalizePrefix(String prefix) {
        return StringUtils.stripStart((String)StringUtils.appendIfMissing((String)prefix, (CharSequence)this.delimiter, (CharSequence[])new CharSequence[0]), (String)this.delimiter);
    }
}

