/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.cluster;

import java.util.ArrayList;
import java.util.List;
import org.craftercms.commons.security.permissions.DefaultPermission;
import org.craftercms.commons.security.permissions.annotations.HasPermission;
import org.craftercms.studio.api.v1.dal.SiteFeed;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v2.dal.AuditLog;
import org.craftercms.studio.api.v2.dal.AuditLogParameter;
import org.craftercms.studio.api.v2.dal.ClusterMember;
import org.craftercms.studio.api.v2.service.audit.internal.AuditServiceInternal;
import org.craftercms.studio.api.v2.service.cluster.ClusterManagementService;
import org.craftercms.studio.api.v2.service.cluster.internal.ClusterManagementServiceInternal;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;

public class ClusterManagementServiceImpl
implements ClusterManagementService {
    private ClusterManagementServiceInternal clusterManagementServiceInternal;
    private ContentRepository contentRepository;
    private SiteService siteService;
    private StudioConfiguration studioConfiguration;
    private AuditServiceInternal auditServiceInternal;
    private SecurityService securityService;

    @Override
    @HasPermission(type=DefaultPermission.class, action="read_cluster")
    public List<ClusterMember> getAllMemebers() {
        return this.clusterManagementServiceInternal.getAllMembers();
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="delete_cluster")
    public boolean removeMembers(List<Long> memberIds) throws SiteNotFoundException {
        List<ClusterMember> members = this.getAllMemebers();
        boolean toRet = this.clusterManagementServiceInternal.removeMembers(memberIds);
        if (toRet) {
            SiteFeed siteFeed = this.siteService.getSite(this.studioConfiguration.getProperty("studio.configuration.global.systemSite"));
            AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
            auditLog.setSiteId(siteFeed.getId());
            auditLog.setOperation("REMOVE_CLUSTER_NODE");
            auditLog.setActorId(this.securityService.getCurrentUser());
            auditLog.setPrimaryTargetId(siteFeed.getSiteId());
            auditLog.setPrimaryTargetType("Cluster Node");
            auditLog.setPrimaryTargetValue(siteFeed.getName());
            ArrayList<AuditLogParameter> paramters = new ArrayList<AuditLogParameter>();
            for (ClusterMember m : members) {
                AuditLogParameter paramter = new AuditLogParameter();
                paramter.setTargetId(Long.toString(m.getId()));
                paramter.setTargetType("Cluster Node");
                paramter.setTargetValue(m.getLocalAddress());
                paramters.add(paramter);
            }
            auditLog.setParameters(paramters);
            this.auditServiceInternal.insertAuditLog(auditLog);
        }
        return toRet;
    }

    public ClusterManagementServiceInternal getClusterManagementServiceInternal() {
        return this.clusterManagementServiceInternal;
    }

    public void setClusterManagementServiceInternal(ClusterManagementServiceInternal clusterManagementServiceInternal) {
        this.clusterManagementServiceInternal = clusterManagementServiceInternal;
    }

    public ContentRepository getContentRepository() {
        return this.contentRepository;
    }

    public void setContentRepository(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public AuditServiceInternal getAuditServiceInternal() {
        return this.auditServiceInternal;
    }

    public void setAuditServiceInternal(AuditServiceInternal auditServiceInternal) {
        this.auditServiceInternal = auditServiceInternal;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }
}

