/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.cluster;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.crypto.CryptoException;
import org.craftercms.commons.crypto.TextEncryptor;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.annotation.RetryingOperation;
import org.craftercms.studio.api.v2.dal.ClusterDAO;
import org.craftercms.studio.api.v2.dal.ClusterMember;
import org.craftercms.studio.api.v2.dal.MetaDAO;
import org.craftercms.studio.api.v2.service.cluster.ClusterNodeRegistration;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;

public class ClusterNodeRegistrationImpl
implements ClusterNodeRegistration {
    private static final Logger logger = LoggerFactory.getLogger(ClusterNodeRegistrationImpl.class);
    private ClusterDAO clusterDao;
    private MetaDAO metaDao;
    private StudioConfiguration studioConfiguration;
    private TextEncryptor encryptor;

    public void init() {
        logger.debug("Autoregister cluster if cluster node is configured", new Object[0]);
        HierarchicalConfiguration<ImmutableNode> registrationData = this.getConfiguration();
        ClusterMember clusterMember = new ClusterMember();
        if (registrationData != null && !registrationData.isEmpty()) {
            try {
                logger.debug("Collect and populate data for cluster node registration", new Object[0]);
                clusterMember.setLocalAddress(registrationData.getString("localAddress"));
                Path path = Paths.get(this.studioConfiguration.getProperty("studio.repo.basePath"), this.studioConfiguration.getProperty("studio.repo.sitesRepoBasePath"));
                String authenticationType = registrationData.getString("authenticationType");
                String username = registrationData.getString("username");
                String password = registrationData.getString("password");
                String token = registrationData.getString("token");
                String privateKey = registrationData.getString("privateKey");
                String gitUrl = this.studioConfiguration.getProperty("studio.clustering.sync.urlFormat");
                gitUrl = StringUtils.isEmpty((CharSequence)username) ? gitUrl.replace("{username}@", "") : gitUrl.replace("{username}", username);
                gitUrl = gitUrl.replace("{localAddress}", clusterMember.getLocalAddress()).replace("{absolutePath}", path.toAbsolutePath().normalize().toString()) + "/{siteId}";
                clusterMember.setGitUrl(gitUrl);
                clusterMember.setState(ClusterMember.State.ACTIVE);
                clusterMember.setGitRemoteName(this.getGitRemoteName(clusterMember));
                clusterMember.setGitAuthType(authenticationType.toLowerCase());
                clusterMember.setGitUsername(username);
                if (StringUtils.isEmpty((CharSequence)password)) {
                    clusterMember.setGitPassword(password);
                } else {
                    String hashedPassword = this.encryptor.encrypt(password);
                    clusterMember.setGitPassword(hashedPassword);
                }
                if (StringUtils.isEmpty((CharSequence)token)) {
                    clusterMember.setGitToken(token);
                } else {
                    String hashedToken = this.encryptor.encrypt(token);
                    clusterMember.setGitToken(hashedToken);
                }
                if (StringUtils.isEmpty((CharSequence)privateKey)) {
                    clusterMember.setGitPrivateKey(privateKey);
                } else {
                    String hashedPrivateKey = this.encryptor.encrypt(privateKey);
                    clusterMember.setGitPrivateKey(hashedPrivateKey);
                }
                clusterMember.setAvailable(1);
                logger.debug("Register cluster member", new Object[0]);
                this.registerClusterNode(clusterMember);
            }
            catch (CryptoException e) {
                logger.error("Failed to register cluster member", new Object[0]);
            }
        }
    }

    private HierarchicalConfiguration<ImmutableNode> getConfiguration() {
        return this.studioConfiguration.getSubConfig("studio.clustering.node.registration");
    }

    public void destroy() {
        HierarchicalConfiguration<ImmutableNode> registrationData = this.getConfiguration();
        if (registrationData != null && !registrationData.isEmpty()) {
            this.removeClusterNode(registrationData.getString("localAddress"));
            try {
                logger.debug("Waiting 10 seconds to propagate update", new Object[0]);
                Thread.sleep(10000L);
                logger.debug("Done waiting 10 seconds to propagate update", new Object[0]);
            }
            catch (InterruptedException e) {
                logger.debug("Interrupted while waiting for 10 seconds to propagate cluster update on shutdown", e);
            }
        }
    }

    @Override
    public boolean isRegistered(String localAddress) {
        if (StringUtils.isNotEmpty((CharSequence)localAddress)) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("localAddress", localAddress);
            int cnt = this.clusterDao.countRegistrations(params);
            return cnt > 0;
        }
        return false;
    }

    @Override
    public boolean registerClusterNode(ClusterMember clusterMember) {
        ClusterMember existingRecord = this.clusterDao.getMemberByLocalAddress(clusterMember.getLocalAddress());
        int result = 0;
        if (Objects.isNull(existingRecord)) {
            result = this.clusterDao.addMember(clusterMember);
        } else {
            clusterMember.setId(existingRecord.getId());
            result = this.clusterDao.updateMember(clusterMember);
        }
        return result > 0;
    }

    @Override
    @RetryingOperation
    public boolean removeClusterNode(String localAddress) {
        logger.info("Remove cluster node " + localAddress, new Object[0]);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("localAddress", localAddress);
        int result = this.clusterDao.removeMemberByLocalAddress(params);
        return result > 0;
    }

    private String getGitRemoteName(ClusterMember clusterMember) {
        return "cluster_node_" + clusterMember.getLocalAddress().replace(":", "_");
    }

    public ClusterDAO getClusterDao() {
        return this.clusterDao;
    }

    public void setClusterDao(ClusterDAO clusterDao) {
        this.clusterDao = clusterDao;
    }

    public MetaDAO getMetaDao() {
        return this.metaDao;
    }

    public void setMetaDao(MetaDAO metaDao) {
        this.metaDao = metaDao;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public void setEncryptor(TextEncryptor encryptor) {
        this.encryptor = encryptor;
    }
}

