/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.cluster;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.crypto.CryptoException;
import org.craftercms.commons.crypto.TextEncryptor;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.dal.ClusterDAO;
import org.craftercms.studio.api.v2.dal.ClusterMember;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.eclipse.jgit.api.DeleteBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.RemoteRemoveCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.util.FS;

public class StudioClusterUtils {
    private static final Logger logger = LoggerFactory.getLogger(StudioClusterUtils.class);
    private static final String NON_SSH_GIT_URL_REGEX = "(file|https?|git)://.+";
    private static final String PROP_STRICT_HOST_KEY_CHECKING = "StrictHostKeyChecking";
    private static final String PROP_STRICT_HOST_KEY_CHECKING_VALUE = "no";
    private TextEncryptor encryptor;
    private ClusterDAO clusterDao;
    private StudioConfiguration studioConfiguration;

    public StudioClusterUtils(ClusterDAO clusterDao, StudioConfiguration studioConfiguration, TextEncryptor encryptor) {
        this.clusterDao = clusterDao;
        this.studioConfiguration = studioConfiguration;
        this.encryptor = encryptor;
    }

    public HierarchicalConfiguration<ImmutableNode> getClusterConfiguration() {
        return this.studioConfiguration.getSubConfig("studio.clustering.node.registration");
    }

    public String getClusterNodeLocalAddress() {
        HierarchicalConfiguration<ImmutableNode> registrationData = this.getClusterConfiguration();
        String localAddress = "";
        if (registrationData != null && !registrationData.isEmpty()) {
            localAddress = registrationData.getString("localAddress");
        }
        return localAddress;
    }

    public List<ClusterMember> getClusterNodes(String localAddress) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("localAddress", localAddress);
        params.put("state", ClusterMember.State.ACTIVE.toString());
        return this.clusterDao.getOtherMembers(params);
    }

    public void removeRemote(Git git, String remoteName) throws GitAPIException {
        RemoteRemoveCommand remoteRemoveCommand = git.remoteRemove();
        remoteRemoveCommand.setRemoteName(remoteName);
        remoteRemoveCommand.call();
        List resultRemoteBranches = git.branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call();
        ArrayList<String> branchesToDelete = new ArrayList<String>();
        for (Ref remoteBranchRef : resultRemoteBranches) {
            if (!remoteBranchRef.getName().startsWith("refs/remotes/" + remoteName)) continue;
            branchesToDelete.add(remoteBranchRef.getName());
        }
        if (CollectionUtils.isNotEmpty(branchesToDelete)) {
            DeleteBranchCommand delBranch = git.branchDelete();
            String[] array = new String[branchesToDelete.size()];
            delBranch.setBranchNames(branchesToDelete.toArray(array));
            delBranch.setForce(true);
            delBranch.call();
        }
    }

    public <T extends TransportCommand> T configureAuthenticationForCommand(ClusterMember remoteNode, T gitCommand, Path tempKey) throws CryptoException, IOException, ServiceLayerException {
        boolean sshProtocol = !remoteNode.getGitUrl().matches(NON_SSH_GIT_URL_REGEX);
        switch (remoteNode.getGitAuthType()) {
            case "none": {
                logger.debug("No authentication", new Object[0]);
                break;
            }
            case "basic": {
                logger.debug("Basic Authentication", new Object[0]);
                this.configureBasicAuthentication(remoteNode, gitCommand, this.encryptor, sshProtocol);
                break;
            }
            case "token": {
                logger.debug("Token based Authentication", new Object[0]);
                this.configureTokenAuthentication(remoteNode, gitCommand, this.encryptor, sshProtocol);
                break;
            }
            case "key": {
                if (!sshProtocol) {
                    throw new ServiceLayerException("Can't do private key authentication with non-ssh URLs");
                }
                logger.debug("Private Key Authentication", new Object[0]);
                this.configurePrivateKeyAuthentication(remoteNode, gitCommand, this.encryptor, tempKey);
                break;
            }
            default: {
                throw new ServiceLayerException("Unsupported authentication type " + remoteNode.getGitAuthType());
            }
        }
        return gitCommand;
    }

    private <T extends TransportCommand> void configureBasicAuthentication(ClusterMember remoteNode, T gitCommand, TextEncryptor encryptor, boolean sshProtocol) throws CryptoException {
        final String password = encryptor.decrypt(remoteNode.getGitPassword());
        UsernamePasswordCredentialsProvider credentialsProvider = new UsernamePasswordCredentialsProvider(remoteNode.getGitUsername(), password);
        if (sshProtocol) {
            gitCommand.setTransportConfigCallback(transport -> {
                SshTransport sshTransport = (SshTransport)transport;
                sshTransport.setSshSessionFactory((SshSessionFactory)new StrictHostCheckingOffSshSessionFactory(){

                    @Override
                    protected void configure(OpenSshConfig.Host host, Session session) {
                        super.configure(host, session);
                        session.setPassword(password);
                    }
                });
            });
        }
        gitCommand.setCredentialsProvider((CredentialsProvider)credentialsProvider);
    }

    private <T extends TransportCommand> void configureTokenAuthentication(ClusterMember remoteNode, T gitCommand, TextEncryptor encryptor, boolean sshProtocol) throws CryptoException {
        UsernamePasswordCredentialsProvider credentialsProvider = new UsernamePasswordCredentialsProvider(encryptor.decrypt(remoteNode.getGitToken()), "");
        if (sshProtocol) {
            gitCommand.setTransportConfigCallback(transport -> {
                SshTransport sshTransport = (SshTransport)transport;
                sshTransport.setSshSessionFactory((SshSessionFactory)new StrictHostCheckingOffSshSessionFactory());
            });
        }
        gitCommand.setCredentialsProvider((CredentialsProvider)credentialsProvider);
    }

    private <T extends TransportCommand> void configurePrivateKeyAuthentication(ClusterMember remoteNode, T gitCommand, TextEncryptor encryptor, final Path tempKey) throws CryptoException, IOException {
        String privateKey = encryptor.decrypt(remoteNode.getGitPrivateKey());
        try {
            Files.write(tempKey, privateKey.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IOException("Failed to write private key for SSH connection to temp location", e);
        }
        tempKey.toFile().deleteOnExit();
        gitCommand.setTransportConfigCallback(transport -> {
            SshTransport sshTransport = (SshTransport)transport;
            sshTransport.setSshSessionFactory((SshSessionFactory)new StrictHostCheckingOffSshSessionFactory(){

                protected JSch createDefaultJSch(FS fs) throws JSchException {
                    JSch defaultJSch = super.createDefaultJSch(fs);
                    defaultJSch.addIdentity(tempKey.toAbsolutePath().toString());
                    return defaultJSch;
                }
            });
        });
    }

    public String getLockOwnerId() {
        HierarchicalConfiguration<ImmutableNode> clusterConfig = this.studioConfiguration.getSubConfig("studio.clustering.node.registration");
        String clusterNodeId = "";
        if (Objects.nonNull(clusterConfig)) {
            clusterNodeId = clusterConfig.getString("localAddress");
        }
        if (StringUtils.isEmpty((CharSequence)clusterNodeId)) {
            try {
                clusterNodeId = InetAddress.getLocalHost().toString();
            }
            catch (UnknownHostException e) {
                clusterNodeId = "STANDALONE STUDIO";
            }
        }
        return clusterNodeId;
    }

    public int getLockTTL() {
        return this.studioConfiguration.getProperty("studio.publishing.siteLock.ttl", Integer.class);
    }

    private static class StrictHostCheckingOffSshSessionFactory
    extends JschConfigSessionFactory {
        private StrictHostCheckingOffSshSessionFactory() {
        }

        protected void configure(OpenSshConfig.Host hc, Session session) {
            Properties config = new Properties();
            config.put(StudioClusterUtils.PROP_STRICT_HOST_KEY_CHECKING, StudioClusterUtils.PROP_STRICT_HOST_KEY_CHECKING_VALUE);
            session.setConfig(config);
        }
    }
}

