/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.cluster;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.annotation.RetryingOperation;
import org.craftercms.studio.api.v2.dal.ClusterDAO;
import org.craftercms.studio.api.v2.dal.ClusterMember;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;

public class StudioNodeActivityCheckJob
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(StudioNodeActivityCheckJob.class);
    private StudioConfiguration studioConfiguration;
    private ClusterDAO clusterDao;
    private static final ReentrantLock singleWorkerLock = new ReentrantLock();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        if (singleWorkerLock.tryLock()) {
            try {
                List<ClusterMember> inactiveMembersToRemove;
                List<ClusterMember> staleMembers = this.getMembersWithStaleHeartbeat();
                if (CollectionUtils.isNotEmpty(staleMembers)) {
                    this.setStaleMembersInactive(staleMembers);
                }
                if (!CollectionUtils.isNotEmpty(inactiveMembersToRemove = this.getInactiveMembersForRemoval())) return;
                this.removeInactiveMembers(inactiveMembersToRemove);
                return;
            }
            catch (Exception error) {
                logger.error("Error while executing node activity check job", error, new Object[0]);
                return;
            }
            finally {
                singleWorkerLock.unlock();
            }
        } else {
            logger.debug("Another worker is checking cluster nodes activity. Skipping cycle.", new Object[0]);
        }
    }

    @RetryingOperation
    public void setStaleMembersInactive(List<ClusterMember> staleMembers) {
        staleMembers.forEach(member -> {
            member.setState(ClusterMember.State.INACTIVE);
            this.clusterDao.updateMember((ClusterMember)member);
        });
    }

    private List<ClusterMember> getMembersWithStaleHeartbeat() {
        HierarchicalConfiguration<ImmutableNode> registrationData = this.getConfiguration();
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("heartbeatStaleLimit", this.getHeartbeatStalePeriod());
        return this.clusterDao.getMembersWithStaleHeartbeat(params);
    }

    private List<ClusterMember> getInactiveMembersForRemoval() {
        HierarchicalConfiguration<ImmutableNode> registrationData = this.getConfiguration();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("inactivityLimit", this.getInactivityPeriod() + this.getHeartbeatStalePeriod());
        params.put("inactiveState", (Object)ClusterMember.State.INACTIVE);
        return this.clusterDao.getInactiveMembersWithStaleHeartbeat(params);
    }

    @RetryingOperation
    public void removeInactiveMembers(List<ClusterMember> inactiveMembersToRemove) {
        List idsToRemove = inactiveMembersToRemove.stream().map(ClusterMember::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(idsToRemove)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("memberIds", idsToRemove);
            params.put("inactiveState", (Object)ClusterMember.State.INACTIVE);
            int n = this.clusterDao.removeMembers(params);
        }
    }

    private HierarchicalConfiguration<ImmutableNode> getConfiguration() {
        return this.studioConfiguration.getSubConfig("studio.clustering.node.registration");
    }

    private int getInactivityPeriod() {
        return Integer.parseInt(this.studioConfiguration.getProperty("studio.clustering.inactivity.timeLimit"));
    }

    private int getHeartbeatStalePeriod() {
        return Integer.parseInt(this.studioConfiguration.getProperty("studio.clustering.heartbeatStale.timeLimit"));
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public ClusterDAO getClusterDao() {
        return this.clusterDao;
    }

    public void setClusterDao(ClusterDAO clusterDAO) {
        this.clusterDao = clusterDAO;
    }
}

