/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.cluster;

import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.annotation.RetryingOperation;
import org.craftercms.studio.api.v2.dal.ClusterDAO;
import org.craftercms.studio.api.v2.dal.ClusterMember;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;

public class StudioNodeHeartbeatJob
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(StudioNodeHeartbeatJob.class);
    private StudioConfiguration studioConfiguration;
    private ClusterDAO clusterDAO;
    private static final ReentrantLock singleWorkerLock = new ReentrantLock();

    @Override
    public void run() {
        if (singleWorkerLock.tryLock()) {
            try {
                this.updateHeartbeat();
            }
            catch (Exception error) {
                logger.error("Error during execution of node heartbeat job", error, new Object[0]);
            }
            finally {
                singleWorkerLock.unlock();
            }
        } else {
            logger.debug("Another worker is updating heartbeat. Skipping cycle.", new Object[0]);
        }
    }

    @RetryingOperation
    public void updateHeartbeat() {
        HierarchicalConfiguration<ImmutableNode> registrationData = this.getConfiguration();
        if (registrationData != null && !registrationData.isEmpty()) {
            String localAddress = registrationData.getString("localAddress");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("localAddress", localAddress);
            params.put("state", ClusterMember.State.ACTIVE.toString());
            logger.debug("Update heartbeat for cluster member with local address: " + localAddress, new Object[0]);
            this.clusterDAO.updateHeartbeat(params);
        }
    }

    private HierarchicalConfiguration<ImmutableNode> getConfiguration() {
        return this.studioConfiguration.getSubConfig("studio.clustering.node.registration");
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public ClusterDAO getClusterDAO() {
        return this.clusterDAO;
    }

    public void setClusterDAO(ClusterDAO clusterDAO) {
        this.clusterDAO = clusterDAO;
    }
}

