/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.cmis;

import java.io.InputStream;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.activation.MimetypesFileTypeMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.io.FilenameUtils;
import org.craftercms.commons.security.permissions.DefaultPermission;
import org.craftercms.commons.security.permissions.annotations.HasPermission;
import org.craftercms.commons.security.permissions.annotations.ProtectedResourceId;
import org.craftercms.studio.api.v1.exception.CmisPathNotFoundException;
import org.craftercms.studio.api.v1.exception.CmisRepositoryNotFoundException;
import org.craftercms.studio.api.v1.exception.CmisTimeoutException;
import org.craftercms.studio.api.v1.exception.CmisUnavailableException;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.StudioPathNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v2.dal.CmisContentItem;
import org.craftercms.studio.api.v2.dal.DataSourceRepository;
import org.craftercms.studio.api.v2.exception.configuration.ConfigurationException;
import org.craftercms.studio.api.v2.service.cmis.CmisService;
import org.craftercms.studio.api.v2.service.config.ConfigurationService;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.model.rest.CmisUploadItem;

public class CmisServiceImpl
implements CmisService {
    private static final Logger logger = LoggerFactory.getLogger(CmisServiceImpl.class);
    private static final String REPOSITORY_CONFIG_KEY = "repositories";
    private static final String ID_PROPERTY = "id";
    private static final String TYPE_PROPERTY = "type";
    private static final String URL_PROPERTY = "url";
    private static final String USERNAME_PROPERTY = "username";
    private static final String PASSWORD_PROPERTY = "password";
    private static final String BASE_PATH_PROPERTY = "base-path";
    private static final String DOWNLOAD_URL_REGEX_PROPERTY = "download-url-regex";
    private static final String USE_SSL_PROPERTY = "use-ssl";
    private static final String MIME_TYPE_FOLDER = "folder";
    private static final String CMIS_SEARCH_QUERY = "select * from cmis:document where IN_TREE('{folderId}') and cmis:name like '%{searchTerm}%'";
    private static final String CMIS_SEARCH_QUERY_FOLDER_ID_VARIABLE = "{folderId}";
    private static final String CMIS_SEARCH_QUERY_SEARCH_TERM_VARIABLE = "{searchTerm}";
    private static final String ITEM_ID = "{item_id}";
    protected StudioConfiguration studioConfiguration;
    protected ContentService contentService;
    protected ConfigurationService configurationService;

    public CmisServiceImpl(StudioConfiguration studioConfiguration, ContentService contentService, ConfigurationService configurationService) {
        this.studioConfiguration = studioConfiguration;
        this.contentService = contentService;
        this.configurationService = configurationService;
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="list_cmis")
    public List<CmisContentItem> list(@ProtectedResourceId(value="siteId") String siteId, String cmisRepo, String path) throws CmisRepositoryNotFoundException, CmisUnavailableException, CmisTimeoutException, ConfigurationException {
        String contentPath;
        CmisObject cmisObject;
        ArrayList<CmisContentItem> items = new ArrayList<CmisContentItem>();
        DataSourceRepository repositoryConfig = this.getConfiguration(siteId, cmisRepo);
        Session session = this.createCMISSession(repositoryConfig);
        if (session != null && (cmisObject = session.getObjectByPath(contentPath = Paths.get(repositoryConfig.getBasePath(), path).toString())) != null && BaseTypeId.CMIS_FOLDER.equals((Object)cmisObject.getBaseTypeId())) {
            Folder folder = (Folder)cmisObject;
            ItemIterable iterable = folder.getChildren();
            for (CmisObject cmisItem : iterable) {
                CmisContentItem item = new CmisContentItem();
                item.setItemName(cmisItem.getName());
                if (BaseTypeId.CMIS_DOCUMENT.equals((Object)cmisItem.getBaseTypeId())) {
                    Document cmisDoc = (Document)cmisItem;
                    item.setItemPath((String)cmisDoc.getPaths().get(0));
                    item.setMimeType(cmisDoc.getContentStreamMimeType());
                    String contentId = cmisDoc.getId();
                    StringTokenizer st = new StringTokenizer(contentId, ";");
                    if (st.hasMoreTokens()) {
                        item.setItemId(st.nextToken());
                    }
                    item.setSize(cmisDoc.getContentStreamLength());
                    items.add(item);
                    continue;
                }
                if (!BaseTypeId.CMIS_FOLDER.equals((Object)cmisItem.getBaseTypeId())) continue;
                Folder cmisFolder = (Folder)cmisItem;
                item.setItemId(cmisFolder.getId());
                item.setItemPath(cmisFolder.getPath());
                item.setMimeType(MIME_TYPE_FOLDER);
                item.setSize(-1L);
                items.add(item);
            }
        }
        return items;
    }

    private DataSourceRepository getConfiguration(String site, String cmisRepo) throws CmisRepositoryNotFoundException, ConfigurationException {
        HierarchicalConfiguration<?> config = this.configurationService.getXmlConfiguration(site, this.getConfigLocation());
        HierarchicalConfiguration repo = config.childConfigurationsAt(REPOSITORY_CONFIG_KEY).stream().filter(r -> cmisRepo.equals(r.getString(ID_PROPERTY))).findFirst().orElseThrow(CmisRepositoryNotFoundException::new);
        DataSourceRepository repositoryConfig = new DataSourceRepository();
        repositoryConfig.setId(repo.getString(ID_PROPERTY));
        repositoryConfig.setType(repo.getString(TYPE_PROPERTY));
        repositoryConfig.setUrl(repo.getString(URL_PROPERTY));
        repositoryConfig.setUsername(repo.getString(USERNAME_PROPERTY));
        repositoryConfig.setPassword(repo.getString(PASSWORD_PROPERTY));
        repositoryConfig.setBasePath(repo.getString(BASE_PATH_PROPERTY));
        repositoryConfig.setDownloadUrlRegex(repo.getString(DOWNLOAD_URL_REGEX_PROPERTY));
        repositoryConfig.setUseSsl(repo.getBoolean(USE_SSL_PROPERTY, false));
        return repositoryConfig;
    }

    private Session createCMISSession(DataSourceRepository config) throws CmisUnavailableException, CmisTimeoutException {
        if (config.isUseSsl()) {
            SSLContext sc = null;
            try {
                sc = this.getSSLContext();
                HostnameVerifier hv = (hostname, session) -> true;
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                HttpsURLConnection.setDefaultHostnameVerifier(hv);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                logger.error("Error initializing SSL context", e, new Object[0]);
            }
        }
        SessionFactoryImpl sessionFactory = SessionFactoryImpl.newInstance();
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("org.apache.chemistry.opencmis.user", config.getUsername());
        parameter.put("org.apache.chemistry.opencmis.password", config.getPassword());
        parameter.put("org.apache.chemistry.opencmis.binding.atompub.url", config.getUrl());
        parameter.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.ATOMPUB.value());
        parameter.put("org.apache.chemistry.opencmis.binding.cookies", "true");
        List repositories = new ArrayList();
        repositories = sessionFactory.getRepositories(parameter);
        Repository repository = (Repository)repositories.get(0);
        parameter.put("org.apache.chemistry.opencmis.session.repository.id", repository.getId());
        Session session2 = null;
        try {
            session2 = sessionFactory.createSession(parameter);
        }
        catch (CmisConnectionException e) {
            throw new CmisTimeoutException(e);
        }
        catch (CmisBaseException e) {
            throw new CmisUnavailableException(e);
        }
        return session2;
    }

    private SSLContext getSSLContext() throws KeyManagementException, NoSuchAlgorithmException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        return sc;
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="search_cmis")
    public List<CmisContentItem> search(@ProtectedResourceId(value="siteId") String siteId, String cmisRepo, String searchTerm, String path) throws CmisRepositoryNotFoundException, CmisUnavailableException, CmisTimeoutException, ConfigurationException {
        String contentPath;
        CmisObject cmisObject;
        ArrayList<CmisContentItem> toRet = new ArrayList<CmisContentItem>();
        DataSourceRepository repositoryConfig = this.getConfiguration(siteId, cmisRepo);
        Session session = this.createCMISSession(repositoryConfig);
        if (session != null && (cmisObject = session.getObjectByPath(contentPath = Paths.get(repositoryConfig.getBasePath(), path).toString())) != null && BaseTypeId.CMIS_FOLDER.equals((Object)cmisObject.getBaseTypeId())) {
            String queryString = CMIS_SEARCH_QUERY.replace(CMIS_SEARCH_QUERY_FOLDER_ID_VARIABLE, cmisObject.getId()).replace(CMIS_SEARCH_QUERY_SEARCH_TERM_VARIABLE, searchTerm);
            ItemIterable result = session.query(queryString, false);
            for (QueryResult qr : result) {
                CmisContentItem item = new CmisContentItem();
                String contentId = qr.getPropertyById("cmis:objectId").getFirstValue().toString();
                StringTokenizer st = new StringTokenizer(contentId, ";");
                if (st.hasMoreTokens()) {
                    item.setItemId(st.nextToken());
                }
                CmisObject qrObject = session.getObject(item.getItemId());
                Document cmisDoc = (Document)qrObject;
                item.setItemName(cmisDoc.getName());
                item.setItemPath((String)cmisDoc.getPaths().get(0));
                item.setMimeType(cmisDoc.getContentStreamMimeType());
                item.setSize(cmisDoc.getContentStreamLength());
                toRet.add(item);
            }
        }
        return toRet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @HasPermission(type=DefaultPermission.class, action="clone_content_cmis")
    public void cloneContent(@ProtectedResourceId(value="siteId") String siteId, String cmisRepoId, String cmisPath, @ProtectedResourceId(value="path") String studioPath) throws StudioPathNotFoundException, CmisRepositoryNotFoundException, CmisUnavailableException, CmisTimeoutException, CmisPathNotFoundException, ServiceLayerException {
        if (!this.contentService.contentExists(siteId, studioPath)) {
            throw new StudioPathNotFoundException("Studio repository path does not exist for site " + siteId + " (path: " + studioPath + ")");
        }
        DataSourceRepository repositoryConfig = this.getConfiguration(siteId, cmisRepoId);
        logger.debug("Create new CMIS session", new Object[0]);
        Session session = this.createCMISSession(repositoryConfig);
        if (session == null) throw new CmisUnauthorizedException();
        String contentPath = Paths.get(repositoryConfig.getBasePath(), cmisPath).toString();
        logger.debug("Find object for CMIS path: " + contentPath, new Object[0]);
        CmisObject cmisObject = session.getObjectByPath(contentPath);
        if (cmisObject == null) throw new CmisPathNotFoundException();
        if (BaseTypeId.CMIS_FOLDER.equals((Object)cmisObject.getBaseTypeId())) {
            throw new CmisPathNotFoundException();
        }
        if (!BaseTypeId.CMIS_DOCUMENT.equals((Object)cmisObject.getBaseTypeId())) return;
        Document cmisDoc = (Document)cmisObject;
        String fileName = cmisDoc.getName();
        String savePath = studioPath + "/" + fileName;
        ContentStream cs = cmisDoc.getContentStream();
        logger.debug("Save CMIS file to: " + savePath, new Object[0]);
        this.contentService.writeContent(siteId, savePath, cs.getStream());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @HasPermission(type=DefaultPermission.class, action="upload_content_cmis")
    public CmisUploadItem uploadContent(@ProtectedResourceId(value="siteId") String siteId, String cmisRepoId, String cmisPath, String filename, InputStream content) throws CmisUnavailableException, CmisTimeoutException, CmisRepositoryNotFoundException, CmisPathNotFoundException, ConfigurationException {
        DataSourceRepository repositoryConfig = this.getConfiguration(siteId, cmisRepoId);
        CmisUploadItem cmisUploadItem = new CmisUploadItem();
        logger.debug("Create new CMIS session", new Object[0]);
        Session session = this.createCMISSession(repositoryConfig);
        if (session == null) throw new CmisUnauthorizedException();
        String contentPath = Paths.get(repositoryConfig.getBasePath(), cmisPath).toString();
        logger.debug("Find object for CMIS path: " + contentPath, new Object[0]);
        CmisObject cmisObject = session.getObjectByPath(contentPath);
        if (cmisObject == null) throw new CmisPathNotFoundException();
        if (BaseTypeId.CMIS_FOLDER.equals((Object)cmisObject.getBaseTypeId())) {
            CmisObject docObject = null;
            try {
                docObject = session.getObjectByPath(Paths.get(contentPath, filename).toString());
            }
            catch (CmisBaseException e) {
                logger.debug("File " + filename + " does not exist at " + contentPath, new Object[0]);
            }
            MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap();
            String mimeType = mimeTypesMap.getContentType(filename);
            ContentStream contentStream = session.getObjectFactory().createContentStream(filename, -1L, mimeType, content);
            Folder folder = (Folder)cmisObject;
            cmisUploadItem.setName(filename);
            cmisUploadItem.setFolder(false);
            cmisUploadItem.setFileExtension(FilenameUtils.getExtension((String)filename));
            if (docObject != null) {
                Document doc = (Document)docObject;
                doc.setContentStream(contentStream, true);
                String contentId = doc.getId();
                StringTokenizer st = new StringTokenizer(contentId, ";");
                if (st.hasMoreTokens()) {
                    cmisUploadItem.setUrl(repositoryConfig.getDownloadUrlRegex().replace(ITEM_ID, st.nextToken()));
                }
                session.removeObjectFromCache(doc.getId());
            } else {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("cmis:objectTypeId", BaseTypeId.CMIS_DOCUMENT.value());
                properties.put("cmis:name", filename);
                Document newDoc = folder.createDocument(properties, contentStream, null);
                session.removeObjectFromCache(newDoc.getId());
                String contentId = newDoc.getId();
                StringTokenizer st = new StringTokenizer(contentId, ";");
                if (st.hasMoreTokens()) {
                    cmisUploadItem.setUrl(repositoryConfig.getDownloadUrlRegex().replace(ITEM_ID, st.nextToken()));
                }
            }
            session.clear();
            return cmisUploadItem;
        }
        if (!BaseTypeId.CMIS_DOCUMENT.equals((Object)cmisObject.getBaseTypeId())) return cmisUploadItem;
        throw new CmisPathNotFoundException();
    }

    private String getConfigLocation() {
        return this.studioConfiguration.getProperty("studio.configuration.site.dataSources.configLocation");
    }
}

