/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.configuration;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Paths;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.Cache;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.craftercms.commons.config.DisableClassLoadingConstructor;
import org.craftercms.commons.config.EncryptionAwareConfigurationReader;
import org.craftercms.commons.lang.UrlUtils;
import org.craftercms.commons.security.permissions.DefaultPermission;
import org.craftercms.commons.security.permissions.annotations.HasPermission;
import org.craftercms.commons.security.permissions.annotations.ProtectedResourceId;
import org.craftercms.studio.api.v1.dal.SiteFeed;
import org.craftercms.studio.api.v1.ebus.PreviewEventContext;
import org.craftercms.studio.api.v1.exception.ContentNotFoundException;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.content.ObjectMetadataManager;
import org.craftercms.studio.api.v1.service.event.EventService;
import org.craftercms.studio.api.v1.service.objectstate.ObjectStateService;
import org.craftercms.studio.api.v1.service.objectstate.TransitionEvent;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v1.to.VersionTO;
import org.craftercms.studio.api.v2.dal.AuditLog;
import org.craftercms.studio.api.v2.dal.ContentItemVersion;
import org.craftercms.studio.api.v2.exception.configuration.ConfigurationException;
import org.craftercms.studio.api.v2.exception.configuration.InvalidConfigurationException;
import org.craftercms.studio.api.v2.service.audit.internal.AuditServiceInternal;
import org.craftercms.studio.api.v2.service.config.ConfigurationService;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.model.rest.ConfigurationHistory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;
import org.xml.sax.SAXException;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;

public class ConfigurationServiceImpl
implements ConfigurationService {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationServiceImpl.class);
    public static final String PLACEHOLDER_TYPE = "type";
    public static final String PLACEHOLDER_NAME = "name";
    private ContentService contentService;
    private StudioConfiguration studioConfiguration;
    private AuditServiceInternal auditServiceInternal;
    private SiteService siteService;
    private SecurityService securityService;
    private ObjectMetadataManager objectMetadataManager;
    private ServicesConfig servicesConfig;
    private ObjectStateService objectStateService;
    private EventService eventService;
    private Cache configurationCache;
    private EncryptionAwareConfigurationReader configurationReader;

    @Override
    public Map<String, List<String>> geRoleMappings(String siteId) throws ConfigurationException {
        HashMap<String, List<String>> roleMappings = new HashMap<String, List<String>>();
        String roleMappingsConfigPath = this.getSiteRoleMappingsConfigPath(siteId);
        try {
            Element root;
            Document document = this.contentService.getContentAsDocument(siteId, roleMappingsConfigPath);
            if (document != null && (root = document.getRootElement()).getName().equals("role-mappings")) {
                List groupNodes = root.selectNodes("groups/group");
                for (Node node : groupNodes) {
                    String name = node.valueOf("@name");
                    if (!StringUtils.isNotEmpty((CharSequence)name)) continue;
                    List roleNodes = node.selectNodes("role");
                    ArrayList<String> roles = new ArrayList<String>();
                    for (Node roleNode : roleNodes) {
                        roles.add(roleNode.getText());
                    }
                    roleMappings.put(name, roles);
                }
            }
        }
        catch (DocumentException e) {
            throw new ConfigurationException("Error while reading role mappings file for site " + siteId + " @ " + roleMappingsConfigPath);
        }
        return roleMappings;
    }

    private String getSiteRoleMappingsConfigPath(String siteId) {
        return UrlUtils.concat((String)this.getSiteConfigPath(siteId), (String)this.getSiteRoleMappingsConfigFileName());
    }

    private String getSiteConfigPath(String siteId) {
        String siteConfigPath = "";
        if (!StringUtils.isEmpty((CharSequence)this.studioConfiguration.getProperty("studio.configuration.environment.active"))) {
            siteConfigPath = this.studioConfiguration.getProperty("studio.configuration.site.multiEnvironment.configBasePath").replaceAll("\\{environment\\}", this.studioConfiguration.getProperty("studio.configuration.environment.active"));
            if (!this.contentService.contentExists(siteId, siteConfigPath + "/" + this.getSiteRoleMappingsConfigFileName())) {
                siteConfigPath = this.studioConfiguration.getProperty("studio.configuration.site.configBasePath").replaceFirst("\\{site\\}", siteId);
            }
        } else {
            siteConfigPath = this.studioConfiguration.getProperty("studio.configuration.site.configBasePath").replaceFirst("\\{site\\}", siteId);
        }
        return siteConfigPath;
    }

    private String getSiteRoleMappingsConfigFileName() {
        return this.studioConfiguration.getProperty("studio.configuration.site.roleMappingsFileName");
    }

    @Override
    public String getConfigurationAsString(@ProtectedResourceId(value="siteId") String siteId, String module, String path, String environment) {
        return this.getEnvironmentConfiguration(siteId, module, path, environment);
    }

    @Override
    public Document getConfigurationAsDocument(@ProtectedResourceId(value="siteId") String siteId, String module, String path, String environment) throws DocumentException, IOException {
        String content = this.getEnvironmentConfiguration(siteId, module, path, environment);
        Document retDocument = null;
        if (StringUtils.isNotEmpty((CharSequence)content)) {
            SAXReader saxReader = new SAXReader();
            try {
                saxReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                saxReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
                saxReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            }
            catch (SAXException ex) {
                logger.error("Unable to turn off external entity loading, this could be a security risk.", ex, new Object[0]);
            }
            try (InputStream is = IOUtils.toInputStream((String)content);){
                retDocument = saxReader.read(is);
            }
        }
        return retDocument;
    }

    @Override
    public HierarchicalConfiguration<?> getXmlConfiguration(String siteId, String path) throws ConfigurationException {
        if (this.contentService.contentExists(siteId, path)) {
            try {
                return this.configurationReader.readXmlConfiguration(this.contentService.getContent(siteId, path));
            }
            catch (Exception e) {
                throw new ConfigurationException("Error loading configuration", e);
            }
        }
        return new XMLConfiguration();
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="write_global_configuration")
    public String getGlobalConfiguration(@ProtectedResourceId(value="path") String path) {
        return this.contentService.getContentAsString("", path);
    }

    private String getDefaultConfiguration(String siteId, String module, String path) {
        String configBasePath = this.studioConfiguration.getProperty("studio.configuration.site.configBasePathPattern").replaceAll("\\{module\\}", module);
        String configPath = Paths.get(configBasePath, path).toString();
        return this.contentService.getContentAsString(siteId, configPath);
    }

    private String getEnvironmentConfiguration(String siteId, String module, String path, String environment) {
        if (!StringUtils.isEmpty((CharSequence)environment)) {
            String configBasePath = this.studioConfiguration.getProperty("studio.configuration.site.multiEnvironment.configBasePathPattern").replaceAll("\\{module\\}", module).replaceAll("\\{environment\\}", environment);
            String configPath = Paths.get(configBasePath, path).toString();
            if (this.contentService.contentExists(siteId, configPath)) {
                return this.contentService.getContentAsString(siteId, configPath);
            }
        }
        return this.getDefaultConfiguration(siteId, module, path);
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="write_configuration")
    public void writeConfiguration(@ProtectedResourceId(value="siteId") String siteId, String module, String path, String environment, InputStream content) throws ServiceLayerException {
        this.writeEnvironmentConfiguration(siteId, module, path, environment, content);
        PreviewEventContext context = new PreviewEventContext();
        context.setSite(siteId);
        this.eventService.publish("studio.event.previewSync", context);
    }

    @Override
    public Resource getPluginFile(String siteId, String type, String name, String filename) throws ContentNotFoundException {
        String basePath = this.servicesConfig.getPluginFolderPattern(siteId);
        if (StringUtils.isEmpty((CharSequence)basePath)) {
            throw new IllegalStateException(String.format("Site '%s' does not have an plugin folder pattern configured", siteId));
        }
        if (!StringUtils.contains((CharSequence)basePath, (CharSequence)PLACEHOLDER_TYPE) || !StringUtils.contains((CharSequence)basePath, (CharSequence)PLACEHOLDER_NAME)) {
            throw new IllegalStateException(String.format("Plugin folder pattern for site '%s' does not contain all required placeholders", basePath));
        }
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(PLACEHOLDER_TYPE, type);
        values.put(PLACEHOLDER_NAME, name);
        basePath = StrSubstitutor.replace((Object)basePath, values);
        String filePath = UrlUtils.concat((String)basePath, (String)filename);
        return this.contentService.getContentAsResource(siteId, filePath);
    }

    private void writeDefaultConfiguration(String siteId, String module, String path, InputStream content) throws ServiceLayerException {
        String configBasePath = this.studioConfiguration.getProperty("studio.configuration.site.configBasePathPattern").replaceAll("\\{module\\}", module);
        String configPath = Paths.get(configBasePath, path).toString();
        this.contentService.writeContent(siteId, configPath, content);
        String currentUser = this.securityService.getCurrentUser();
        this.objectStateService.transition(siteId, configPath, TransitionEvent.SAVE);
        this.updateMetadata(siteId, configPath, currentUser);
        this.generateAuditLog(siteId, configPath, currentUser);
    }

    protected InputStream validate(InputStream content, String filename) throws ServiceLayerException {
        String extension = FilenameUtils.getExtension((String)filename);
        if (StringUtils.isEmpty((CharSequence)extension)) {
            return content;
        }
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)content);
            switch (extension.toLowerCase()) {
                case "xml": {
                    try {
                        DocumentHelper.parseText((String)new String(bytes));
                        break;
                    }
                    catch (Exception e) {
                        throw new InvalidConfigurationException("Invalid XML file", e);
                    }
                }
                case "yaml": 
                case "yml": {
                    try {
                        Yaml yaml = new Yaml((BaseConstructor)new DisableClassLoadingConstructor());
                        Map map = (Map)yaml.load((InputStream)new ByteArrayInputStream(bytes));
                        break;
                    }
                    catch (Exception e) {
                        throw new InvalidConfigurationException("Invalid YAML file", e);
                    }
                }
            }
            return new ByteArrayInputStream(bytes);
        }
        catch (IOException e) {
            throw new ServiceLayerException("Error validating configuration", e);
        }
    }

    private void writeEnvironmentConfiguration(String siteId, String module, String path, String environment, InputStream content) throws ServiceLayerException {
        if (!StringUtils.isEmpty((CharSequence)environment)) {
            String configBasePath = this.studioConfiguration.getProperty("studio.configuration.site.multiEnvironment.configBasePathPattern").replaceAll("\\{module\\}", module).replaceAll("\\{environment\\}", environment);
            if (this.contentService.contentExists(siteId, configBasePath)) {
                String configPath = Paths.get(configBasePath, path).toString();
                this.contentService.writeContent(siteId, configPath, content);
                String currentUser = this.securityService.getCurrentUser();
                this.objectStateService.transition(siteId, configPath, TransitionEvent.SAVE);
                this.updateMetadata(siteId, configPath, currentUser);
                this.generateAuditLog(siteId, configPath, currentUser);
            } else {
                this.writeDefaultConfiguration(siteId, module, path, content);
            }
        } else {
            this.writeDefaultConfiguration(siteId, module, path, content);
        }
    }

    private void updateMetadata(String siteId, String path, String user) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("modifier", user);
        properties.put("modified", ZonedDateTime.now(ZoneOffset.UTC));
        properties.put("lockOwner", "");
        if (!this.objectMetadataManager.metadataExist(siteId, path)) {
            this.objectMetadataManager.insertNewObjectMetadata(siteId, path);
        }
        this.objectMetadataManager.setObjectMetadata(siteId, path, properties);
    }

    private void generateAuditLog(String siteId, String path, String user) throws SiteNotFoundException {
        SiteFeed siteFeed = this.siteService.getSite(siteId);
        AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
        auditLog.setOperation("UPDATE");
        auditLog.setSiteId(siteFeed.getId());
        auditLog.setActorId(user);
        auditLog.setPrimaryTargetId(siteId + ":" + path);
        auditLog.setPrimaryTargetType("Content Item");
        auditLog.setPrimaryTargetValue(path);
        auditLog.setPrimaryTargetSubtype("configuration");
        this.auditServiceInternal.insertAuditLog(auditLog);
    }

    @Override
    public ConfigurationHistory getConfigurationHistory(@ProtectedResourceId(value="siteId") String siteId, String module, String path, String environment) {
        VersionTO[] versionTOS;
        String configBasePath;
        String configPath = "";
        if (!StringUtils.isEmpty((CharSequence)environment)) {
            configBasePath = this.studioConfiguration.getProperty("studio.configuration.site.multiEnvironment.configBasePathPattern").replaceAll("\\{module\\}", module).replaceAll("\\{environment\\}", environment);
            configPath = Paths.get(configBasePath, path).toString();
            if (!this.contentService.contentExists(siteId, configPath)) {
                configBasePath = this.studioConfiguration.getProperty("studio.configuration.site.configBasePathPattern").replaceAll("\\{module\\}", module);
                configPath = Paths.get(configBasePath, path).toString();
            }
        } else {
            configBasePath = this.studioConfiguration.getProperty("studio.configuration.site.configBasePathPattern").replaceAll("\\{module\\}", module);
            configPath = Paths.get(configBasePath, path).toString();
        }
        ConfigurationHistory configurationHistory = new ConfigurationHistory();
        configurationHistory.setItem(this.contentService.getContentItem(siteId, configPath));
        ArrayList<ContentItemVersion> versions = new ArrayList<ContentItemVersion>();
        for (VersionTO v : versionTOS = this.contentService.getContentItemVersionHistory(siteId, configPath)) {
            ContentItemVersion civ = new ContentItemVersion();
            civ.setVersionNumber(v.getVersionNumber());
            civ.setComment(v.getComment());
            civ.setLastModifiedDate(v.getLastModifiedDate());
            civ.setLastModifier(v.getLastModifier());
            versions.add(civ);
        }
        configurationHistory.setVersions(versions);
        return configurationHistory;
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="write_global_configuration")
    public void writeGlobalConfiguration(@ProtectedResourceId(value="path") String path, InputStream content) throws ServiceLayerException {
        this.contentService.writeContent("", path, this.validate(content, path));
        String currentUser = this.securityService.getCurrentUser();
        this.generateAuditLog(this.studioConfiguration.getProperty("studio.configuration.global.systemSite"), path, currentUser);
        this.configurationCache.remove((Serializable)((Object)path));
    }

    @Required
    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    @Required
    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    @Required
    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    public AuditServiceInternal getAuditServiceInternal() {
        return this.auditServiceInternal;
    }

    public void setAuditServiceInternal(AuditServiceInternal auditServiceInternal) {
        this.auditServiceInternal = auditServiceInternal;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public ObjectMetadataManager getObjectMetadataManager() {
        return this.objectMetadataManager;
    }

    public void setObjectMetadataManager(ObjectMetadataManager objectMetadataManager) {
        this.objectMetadataManager = objectMetadataManager;
    }

    public ObjectStateService getObjectStateService() {
        return this.objectStateService;
    }

    public void setObjectStateService(ObjectStateService objectStateService) {
        this.objectStateService = objectStateService;
    }

    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    public void setConfigurationCache(Cache configurationCache) {
        this.configurationCache = configurationCache;
    }

    public void setConfigurationReader(EncryptionAwareConfigurationReader configurationReader) {
        this.configurationReader = configurationReader;
    }
}

