/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.content;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.craftercms.commons.security.permissions.DefaultPermission;
import org.craftercms.commons.security.permissions.annotations.HasPermission;
import org.craftercms.commons.security.permissions.annotations.ProtectedResourceId;
import org.craftercms.studio.api.v1.dal.SiteFeed;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.exception.security.AuthenticationException;
import org.craftercms.studio.api.v1.service.deployment.DeploymentException;
import org.craftercms.studio.api.v1.service.deployment.DeploymentService;
import org.craftercms.studio.api.v1.service.objectstate.ObjectStateService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v2.dal.AuditLog;
import org.craftercms.studio.api.v2.dal.AuditLogParameter;
import org.craftercms.studio.api.v2.dal.QuickCreateItem;
import org.craftercms.studio.api.v2.service.audit.internal.AuditServiceInternal;
import org.craftercms.studio.api.v2.service.content.ContentService;
import org.craftercms.studio.api.v2.service.content.internal.ContentServiceInternal;
import org.craftercms.studio.api.v2.service.content.internal.ContentTypeServiceInternal;
import org.craftercms.studio.api.v2.service.dependency.internal.DependencyServiceInternal;
import org.craftercms.studio.api.v2.service.security.UserService;
import org.craftercms.studio.model.AuthenticatedUser;
import org.craftercms.studio.permissions.CompositePermission;

public class ContentServiceImpl
implements ContentService {
    private ContentServiceInternal contentServiceInternal;
    private ContentTypeServiceInternal contentTypeServiceInternal;
    private DependencyServiceInternal dependencyServiceInternal;
    private DeploymentService deploymentService;
    private ObjectStateService objectStateService;
    private UserService userService;
    private SiteService siteService;
    private AuditServiceInternal auditServiceInternal;

    @Override
    public List<QuickCreateItem> getQuickCreatableContentTypes(String siteId) {
        return this.contentTypeServiceInternal.getQuickCreatableContentTypes(siteId);
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="delete_content")
    public List<String> getChildItems(@ProtectedResourceId(value="siteId") String siteId, @ProtectedResourceId(value="path") String path) {
        List<String> subtreeItems = this.contentServiceInternal.getSubtreeItems(siteId, path);
        ArrayList<String> childItems = new ArrayList<String>();
        childItems.addAll(subtreeItems);
        childItems.addAll(this.dependencyServiceInternal.getItemSpecificDependencies(siteId, path));
        childItems.addAll(this.dependencyServiceInternal.getItemSpecificDependencies(siteId, subtreeItems));
        return childItems;
    }

    @Override
    @HasPermission(type=CompositePermission.class, action="delete_content")
    public List<String> getChildItems(@ProtectedResourceId(value="siteId") String siteId, @ProtectedResourceId(value="pathList") List<String> paths) {
        List<String> subtreeItems = this.contentServiceInternal.getSubtreeItems(siteId, paths);
        ArrayList<String> childItems = new ArrayList<String>();
        childItems.addAll(subtreeItems);
        childItems.addAll(this.dependencyServiceInternal.getItemSpecificDependencies(siteId, paths));
        childItems.addAll(this.dependencyServiceInternal.getItemSpecificDependencies(siteId, subtreeItems));
        return childItems;
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="delete_content")
    public boolean deleteContent(@ProtectedResourceId(value="siteId") String siteId, @ProtectedResourceId(value="path") String path, String submissionComment) throws ServiceLayerException, AuthenticationException, DeploymentException {
        ArrayList<String> contentToDelete = new ArrayList<String>();
        contentToDelete.addAll(this.getChildItems(siteId, path));
        contentToDelete.add(path);
        this.objectStateService.setSystemProcessingBulk(siteId, contentToDelete, true);
        AuthenticatedUser currentUser = this.userService.getCurrentUser();
        this.deploymentService.delete(siteId, contentToDelete, currentUser.getUsername(), ZonedDateTime.now(ZoneOffset.UTC), submissionComment);
        this.objectStateService.setSystemProcessingBulk(siteId, contentToDelete, false);
        this.insertDeleteContentApprovedActivity(siteId, currentUser.getUsername(), contentToDelete);
        return true;
    }

    @Override
    @HasPermission(type=CompositePermission.class, action="delete_content")
    public boolean deleteContent(@ProtectedResourceId(value="siteId") String siteId, @ProtectedResourceId(value="pathList") List<String> paths, String submissionComment) throws ServiceLayerException, AuthenticationException, DeploymentException {
        ArrayList<String> contentToDelete = new ArrayList<String>();
        contentToDelete.addAll(this.getChildItems(siteId, paths));
        contentToDelete.addAll(paths);
        this.objectStateService.setSystemProcessingBulk(siteId, contentToDelete, true);
        AuthenticatedUser currentUser = this.userService.getCurrentUser();
        this.deploymentService.delete(siteId, contentToDelete, currentUser.getUsername(), ZonedDateTime.now(ZoneOffset.UTC), submissionComment);
        this.objectStateService.setSystemProcessingBulk(siteId, contentToDelete, false);
        this.insertDeleteContentApprovedActivity(siteId, currentUser.getUsername(), contentToDelete);
        return true;
    }

    private void insertDeleteContentApprovedActivity(String siteId, String aprover, List<String> contentToDelete) throws SiteNotFoundException {
        SiteFeed siteFeed = this.siteService.getSite(siteId);
        AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
        auditLog.setOperation("APPROVE");
        auditLog.setActorId(aprover);
        auditLog.setSiteId(siteFeed.getId());
        auditLog.setPrimaryTargetId(siteId);
        auditLog.setPrimaryTargetType("Site");
        auditLog.setPrimaryTargetValue(siteId);
        ArrayList<AuditLogParameter> auditLogParameters = new ArrayList<AuditLogParameter>();
        for (String itemToDelete : contentToDelete) {
            AuditLogParameter auditLogParameter = new AuditLogParameter();
            auditLogParameter.setTargetId(siteId + ":" + itemToDelete);
            auditLogParameter.setTargetType("Content Item");
            auditLogParameter.setTargetValue(itemToDelete);
            auditLogParameters.add(auditLogParameter);
        }
        auditLog.setParameters(auditLogParameters);
        this.auditServiceInternal.insertAuditLog(auditLog);
    }

    public ContentServiceInternal getContentServiceInternal() {
        return this.contentServiceInternal;
    }

    public void setContentServiceInternal(ContentServiceInternal contentServiceInternal) {
        this.contentServiceInternal = contentServiceInternal;
    }

    public ContentTypeServiceInternal getContentTypeServiceInternal() {
        return this.contentTypeServiceInternal;
    }

    public void setContentTypeServiceInternal(ContentTypeServiceInternal contentTypeServiceInternal) {
        this.contentTypeServiceInternal = contentTypeServiceInternal;
    }

    public DependencyServiceInternal getDependencyServiceInternal() {
        return this.dependencyServiceInternal;
    }

    public void setDependencyServiceInternal(DependencyServiceInternal dependencyServiceInternal) {
        this.dependencyServiceInternal = dependencyServiceInternal;
    }

    public DeploymentService getDeploymentService() {
        return this.deploymentService;
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public ObjectStateService getObjectStateService() {
        return this.objectStateService;
    }

    public void setObjectStateService(ObjectStateService objectStateService) {
        this.objectStateService = objectStateService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public AuditServiceInternal getAuditServiceInternal() {
        return this.auditServiceInternal;
    }

    public void setAuditServiceInternal(AuditServiceInternal auditServiceInternal) {
        this.auditServiceInternal = auditServiceInternal;
    }
}

