/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.content.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.craftercms.studio.api.v1.service.content.ContentTypeService;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.to.ContentTypeConfigTO;
import org.craftercms.studio.api.v2.dal.QuickCreateItem;
import org.craftercms.studio.api.v2.service.content.internal.ContentTypeServiceInternal;

public class ContentTypeServiceInternalImpl
implements ContentTypeServiceInternal {
    private ContentTypeService contentTypeService;
    private SecurityService securityService;

    @Override
    public List<QuickCreateItem> getQuickCreatableContentTypes(String siteId) {
        ArrayList<QuickCreateItem> toRet = new ArrayList<QuickCreateItem>();
        List<ContentTypeConfigTO> allContentTypes = this.contentTypeService.getAllContentTypes(siteId, true);
        List quickCreatable = allContentTypes.stream().filter(ct -> ct.isQuickCreate()).collect(Collectors.toList());
        for (ContentTypeConfigTO ctto : quickCreatable) {
            QuickCreateItem qci = new QuickCreateItem();
            qci.setSiteId(siteId);
            qci.setContentTypeId(ctto.getForm());
            qci.setLabel(ctto.getLabel());
            qci.setPath(ctto.getQuickCreatePath());
            Set<String> allowedPermission = this.securityService.getUserPermissions(siteId, ctto.getQuickCreatePath(), this.securityService.getCurrentUser(), null);
            if (!allowedPermission.contains("create content")) continue;
            toRet.add(qci);
        }
        return toRet;
    }

    public ContentTypeService getContentTypeService() {
        return this.contentTypeService;
    }

    public void setContentTypeService(ContentTypeService contentTypeService) {
        this.contentTypeService = contentTypeService;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }
}

