/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.dashboard;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.craftercms.commons.security.permissions.annotations.ProtectedResourceId;
import org.craftercms.studio.api.v1.dal.ItemMetadata;
import org.craftercms.studio.api.v1.service.content.ObjectMetadataManager;
import org.craftercms.studio.api.v2.dal.AuditLog;
import org.craftercms.studio.api.v2.dal.PublishingHistoryItem;
import org.craftercms.studio.api.v2.service.audit.internal.AuditServiceInternal;
import org.craftercms.studio.api.v2.service.dashboard.DashboardService;
import org.craftercms.studio.api.v2.service.publish.internal.PublishServiceInternal;
import org.craftercms.studio.model.rest.dashboard.ContentDashboardItem;
import org.craftercms.studio.model.rest.dashboard.PublishingDashboardItem;

public class DashboardServiceImpl
implements DashboardService {
    private ObjectMetadataManager objectMetadataManager;
    private AuditServiceInternal auditServiceInternal;
    private PublishServiceInternal publishServiceInternal;

    @Override
    public int getAuditDashboardTotal(@ProtectedResourceId(value="siteId") String siteId, String user, List<String> operations, ZonedDateTime dateFrom, ZonedDateTime dateTo, String target) {
        return this.auditServiceInternal.getAuditDashboardTotal(siteId, user, operations, dateFrom, dateTo, target);
    }

    @Override
    public List<AuditLog> getAuditDashboard(@ProtectedResourceId(value="siteId") String siteId, int offset, int limit, String user, List<String> operations, ZonedDateTime dateFrom, ZonedDateTime dateTo, String target, String sort, String order) {
        return this.auditServiceInternal.getAuditDashboard(siteId, offset, limit, user, operations, dateFrom, dateTo, target, sort, order);
    }

    @Override
    public int getContentDashboardTotal(@ProtectedResourceId(value="siteId") String siteId, String path, String modifier, String contentType, long state, ZonedDateTime dateFrom, ZonedDateTime dateTo) {
        return this.objectMetadataManager.getContentDashboardTotal(siteId, path, modifier, contentType, state, dateFrom, dateTo);
    }

    @Override
    public List<ContentDashboardItem> getContentDashboard(@ProtectedResourceId(value="siteId") String siteId, String path, String modifier, String contentType, long state, ZonedDateTime dateFrom, ZonedDateTime dateTo, String sortBy, String order, int offset, int limit) {
        return this.prepareContentDashboardResult(this.objectMetadataManager.getContentDashboard(siteId, path, modifier, contentType, state, dateFrom, dateTo, sortBy, order, offset, limit));
    }

    private List<ContentDashboardItem> prepareContentDashboardResult(List<ItemMetadata> itemMetadataList) {
        ArrayList<ContentDashboardItem> contentDashboardItemList = new ArrayList<ContentDashboardItem>();
        if (itemMetadataList != null && itemMetadataList.size() > 0) {
            for (ItemMetadata item : itemMetadataList) {
                ContentDashboardItem contentDashboardItem = new ContentDashboardItem();
                contentDashboardItem.setSiteId(item.getSite());
                contentDashboardItem.setPath(item.getPath());
                contentDashboardItem.setLabel(item.getName());
                contentDashboardItem.setModifier(item.getModifier());
                contentDashboardItem.setModifiedDate(item.getModified());
                contentDashboardItemList.add(contentDashboardItem);
            }
        }
        return contentDashboardItemList;
    }

    @Override
    public int getPublishingHistoryTotal(@ProtectedResourceId(value="siteId") String siteId, String environment, String path, String publisher, ZonedDateTime dateFrom, ZonedDateTime dateTo, String contentType, long state) {
        return this.publishServiceInternal.getPublishingHistoryTotal(siteId, environment, path, publisher, dateFrom, dateTo, contentType, state);
    }

    @Override
    public List<PublishingDashboardItem> getPublishingHistory(@ProtectedResourceId(value="siteId") String siteId, String environment, String path, String publisher, ZonedDateTime dateFrom, ZonedDateTime dateTo, String contentType, long state, String sortBy, String order, int offset, int limit) {
        List<PublishingHistoryItem> publishingHistoryItems = this.publishServiceInternal.getPublishingHistory(siteId, environment, path, publisher, dateFrom, dateTo, contentType, state, sortBy, order, offset, limit);
        return this.preparePublishingResult(publishingHistoryItems);
    }

    private List<PublishingDashboardItem> preparePublishingResult(List<PublishingHistoryItem> publishingHistory) {
        ArrayList<PublishingDashboardItem> publishingDashboardItems = new ArrayList<PublishingDashboardItem>();
        for (PublishingHistoryItem historyItem : publishingHistory) {
            PublishingDashboardItem dashboardItem = new PublishingDashboardItem();
            ItemMetadata itemMetadata = this.objectMetadataManager.getProperties(historyItem.getSiteId(), historyItem.getPath());
            dashboardItem.setSiteId(historyItem.getSiteId());
            dashboardItem.setPath(historyItem.getPath());
            dashboardItem.setLabel(itemMetadata.getName());
            dashboardItem.setEnvironment(historyItem.getEnvironment());
            dashboardItem.setPublishedDate(historyItem.getPublishedDate());
            dashboardItem.setPublisher(historyItem.getPublisher());
            publishingDashboardItems.add(dashboardItem);
        }
        return publishingDashboardItems;
    }

    public ObjectMetadataManager getObjectMetadataManager() {
        return this.objectMetadataManager;
    }

    public void setObjectMetadataManager(ObjectMetadataManager objectMetadataManager) {
        this.objectMetadataManager = objectMetadataManager;
    }

    public AuditServiceInternal getAuditServiceInternal() {
        return this.auditServiceInternal;
    }

    public void setAuditServiceInternal(AuditServiceInternal auditServiceInternal) {
        this.auditServiceInternal = auditServiceInternal;
    }

    public PublishServiceInternal getPublishServiceInternal() {
        return this.publishServiceInternal;
    }

    public void setPublishServiceInternal(PublishServiceInternal publishServiceInternal) {
        this.publishServiceInternal = publishServiceInternal;
    }
}

