/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.dependency;

import java.util.List;
import org.craftercms.commons.security.permissions.DefaultPermission;
import org.craftercms.commons.security.permissions.annotations.HasPermission;
import org.craftercms.commons.security.permissions.annotations.ProtectedResourceId;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v2.service.dependency.DependencyService;
import org.craftercms.studio.api.v2.service.dependency.internal.DependencyServiceInternal;
import org.craftercms.studio.permissions.CompositePermission;

public class DependencyServiceImpl
implements DependencyService {
    private DependencyServiceInternal dependencyServiceInternal;

    @Override
    public List<String> getSoftDependencies(@ProtectedResourceId(value="siteId") String siteId, String path) throws ServiceLayerException {
        List<String> toRet = this.dependencyServiceInternal.getSoftDependencies(siteId, path);
        toRet.remove(path);
        return this.dependencyServiceInternal.getSoftDependencies(siteId, path);
    }

    @Override
    public List<String> getSoftDependencies(@ProtectedResourceId(value="siteId") String siteId, List<String> paths) throws ServiceLayerException {
        List<String> toRet = this.dependencyServiceInternal.getSoftDependencies(siteId, paths);
        toRet.removeAll(paths);
        return toRet;
    }

    @Override
    public List<String> getHardDependencies(String site, String path) throws ServiceLayerException {
        return this.dependencyServiceInternal.getHardDependencies(site, path);
    }

    @Override
    public List<String> getHardDependencies(String site, List<String> paths) throws ServiceLayerException {
        return this.dependencyServiceInternal.getHardDependencies(site, paths);
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="delete_content")
    public List<String> getDependentItems(@ProtectedResourceId(value="siteId") String siteId, @ProtectedResourceId(value="path") String path) {
        return this.dependencyServiceInternal.getDependentItems(siteId, path);
    }

    @Override
    @HasPermission(type=CompositePermission.class, action="delete_content")
    public List<String> getDependentItems(@ProtectedResourceId(value="siteId") String siteId, @ProtectedResourceId(value="pathList") List<String> paths) {
        return this.dependencyServiceInternal.getDependentItems(siteId, paths);
    }

    public DependencyServiceInternal getDependencyServiceInternal() {
        return this.dependencyServiceInternal;
    }

    public void setDependencyServiceInternal(DependencyServiceInternal dependencyServiceInternal) {
        this.dependencyServiceInternal = dependencyServiceInternal;
    }
}

