/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.dependency.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.dal.ItemStateMapper;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.dependency.DependencyResolver;
import org.craftercms.studio.api.v1.service.objectstate.State;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v2.dal.DependencyDAO;
import org.craftercms.studio.api.v2.service.dependency.internal.DependencyServiceInternal;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.impl.v1.util.ContentUtils;

public class DependencyServiceInternalImpl
implements DependencyServiceInternal {
    private static final Logger logger = LoggerFactory.getLogger(DependencyServiceInternalImpl.class);
    private SiteService siteService;
    private StudioConfiguration studioConfiguration;
    private DependencyDAO dependencyDao;
    private ItemStateMapper itemStateMapper;
    private DependencyResolver dependencyResolver;
    private ServicesConfig servicesConfig;

    @Override
    public List<String> getSoftDependencies(String site, String path) throws ServiceLayerException {
        if (!this.siteService.exists(site)) {
            throw new SiteNotFoundException(site);
        }
        logger.debug("Get soft dependencies for site: " + site + " path:" + path, new Object[0]);
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(path);
        return this.getSoftDependencies(site, paths);
    }

    @Override
    public List<String> getSoftDependencies(String site, List<String> paths) throws ServiceLayerException {
        if (!this.siteService.exists(site)) {
            throw new SiteNotFoundException(site);
        }
        Map<String, String> toRet = this.calculateSoftDependencies(site, paths);
        return new ArrayList<String>(toRet.keySet());
    }

    private Map<String, String> calculateSoftDependencies(String site, List<String> paths) {
        HashSet toRet = new HashSet();
        HashSet<String> pathsParams = new HashSet<String>();
        logger.debug("Get all soft dependencies", new Object[0]);
        pathsParams.addAll(paths);
        boolean exitCondition = false;
        HashMap<String, String> softDeps = new HashMap<String, String>();
        for (String p : paths) {
            softDeps.put(p, p);
        }
        do {
            List<Map<String, String>> deps = this.getSoftDependenciesForListFromDB(site, pathsParams);
            ArrayList<String> targetPaths = new ArrayList<String>();
            for (Map<String, String> d : deps) {
                String srcPath = d.get("source_path");
                String targetPath = d.get("target_path");
                if (!softDeps.keySet().contains(targetPath) && !StringUtils.equals((CharSequence)targetPath, (CharSequence)((CharSequence)softDeps.get(srcPath)))) {
                    softDeps.put(targetPath, (String)softDeps.get(srcPath));
                }
                targetPaths.add(targetPath);
            }
            exitCondition = !toRet.addAll(targetPaths);
            pathsParams.clear();
            pathsParams.addAll(targetPaths);
        } while (!exitCondition);
        return softDeps;
    }

    private List<Map<String, String>> getSoftDependenciesForListFromDB(String site, Set<String> paths) {
        Collection onlyEditStates = CollectionUtils.removeAll(State.CHANGE_SET_STATES, State.NEW_STATES);
        return this.dependencyDao.getSoftDependenciesForList(site, paths, this.getItemSpecificDependenciesPatterns(), onlyEditStates);
    }

    protected List<String> getItemSpecificDependenciesPatterns() {
        StringTokenizer st = new StringTokenizer(this.studioConfiguration.getProperty("studio.configuration.dependency.itemSpecificPatterns"), ",");
        ArrayList<String> itemSpecificDependenciesPatterns = new ArrayList<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            itemSpecificDependenciesPatterns.add(st.nextToken().trim());
        }
        return itemSpecificDependenciesPatterns;
    }

    @Override
    public List<String> getHardDependencies(String site, String path) throws ServiceLayerException {
        if (!this.siteService.exists(site)) {
            throw new SiteNotFoundException(site);
        }
        logger.debug("Get hard dependencies for site: " + site + " path:" + path, new Object[0]);
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(path);
        return this.getHardDependencies(site, paths);
    }

    @Override
    public List<String> getHardDependencies(String site, List<String> paths) throws ServiceLayerException {
        if (!this.siteService.exists(site)) {
            throw new SiteNotFoundException(site);
        }
        Map<String, String> dependencies = this.calculateHardDependencies(site, paths);
        return new ArrayList<String>(dependencies.keySet());
    }

    private Map<String, String> calculateHardDependencies(String site, List<String> paths) {
        HashSet toRet = new HashSet();
        HashSet<String> pathsParams = new HashSet<String>();
        logger.debug("Get all hard dependencies", new Object[0]);
        pathsParams.addAll(paths);
        Set<String> mandatoryParents = this.getMandatoryParents(site, paths);
        ArrayList<String> mpAsList = new ArrayList<String>(mandatoryParents);
        HashMap<String, String> ancestors = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(mandatoryParents)) {
            pathsParams.addAll(mandatoryParents);
            Set<String> existingRenamedChildrenOfMandatoryParents = this.getExistingRenamedChildrenOfMandatoryParents(site, mpAsList);
            for (String p3 : existingRenamedChildrenOfMandatoryParents) {
                ancestors.put(p3, p3);
            }
            pathsParams.addAll(existingRenamedChildrenOfMandatoryParents);
        }
        boolean exitCondition = false;
        block1: for (String p : mandatoryParents) {
            String prefix = p.replace("/index.xml", "");
            for (String p2 : paths) {
                if (!p2.startsWith(prefix)) continue;
                ancestors.put(p, p2);
                continue block1;
            }
        }
        do {
            List<Map<String, String>> deps = this.calculateHardDependenciesForListFromDB(site, pathsParams);
            ArrayList<String> targetPaths = new ArrayList<String>();
            for (Map<String, String> d : deps) {
                String srcPath = d.get("source_path");
                String targetPath = d.get("target_path");
                if (!ancestors.keySet().contains(targetPath) && !StringUtils.equals((CharSequence)targetPath, (CharSequence)((CharSequence)ancestors.get(srcPath)))) {
                    ancestors.put(targetPath, (String)ancestors.get(srcPath));
                }
                targetPaths.add(targetPath);
            }
            exitCondition = !toRet.addAll(targetPaths);
            pathsParams.clear();
            pathsParams.addAll(targetPaths);
        } while (!exitCondition);
        return ancestors;
    }

    private Set<String> getMandatoryParents(String site, List<String> paths) {
        HashSet<String> toRet = new HashSet<String>();
        Set<String> possibleParents = this.calculatePossibleParents(paths);
        if (!possibleParents.isEmpty()) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("site", site);
            params.put("possibleParents", possibleParents);
            Collection onlyEditStates = CollectionUtils.removeAll(State.CHANGE_SET_STATES, State.NEW_STATES);
            params.put("editedStates", onlyEditStates);
            params.put("newStates", State.NEW_STATES);
            List<String> result = this.itemStateMapper.getMandatoryParentsForPublishing(params);
            toRet.addAll(result);
        }
        return toRet;
    }

    private Set<String> getExistingRenamedChildrenOfMandatoryParents(String site, List<String> paths) {
        HashSet<String> toRet = new HashSet<String>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("site", site);
        params.put("parents", paths);
        Collection onlyEditStates = CollectionUtils.removeAll(State.CHANGE_SET_STATES, State.NEW_STATES);
        params.put("editedStates", onlyEditStates);
        List<String> result = this.itemStateMapper.getExistingRenamedChildrenOfMandatoryParentsForPublishing(params);
        toRet.addAll(result);
        return toRet;
    }

    private Set<String> calculatePossibleParents(List<String> paths) {
        HashSet<String> possibleParents = new HashSet<String>();
        for (String path : paths) {
            StringTokenizer stPath = new StringTokenizer(path.replace("/index.xml", ""), "/");
            StringBuilder candidate = new StringBuilder("/");
            if (stPath.countTokens() <= 0) continue;
            do {
                String token = stPath.nextToken();
                if (!stPath.hasMoreTokens()) continue;
                candidate.append(token).append("/");
                possibleParents.add(candidate.toString() + "index.xml");
            } while (stPath.hasMoreTokens());
        }
        return possibleParents;
    }

    private List<Map<String, String>> calculateHardDependenciesForListFromDB(String site, Set<String> paths) {
        Collection onlyEditStates = CollectionUtils.removeAll(State.CHANGE_SET_STATES, State.NEW_STATES);
        return this.dependencyDao.getHardDependenciesForList(site, paths, this.getItemSpecificDependenciesPatterns(), onlyEditStates, State.NEW_STATES);
    }

    @Override
    public List<String> getDependentItems(String siteId, String path) {
        ArrayList<String> paths = new ArrayList<String>(1);
        paths.add(path);
        return this.getDependentItems(siteId, paths);
    }

    @Override
    public List<String> getDependentItems(String siteId, List<String> paths) {
        if (CollectionUtils.isEmpty(paths)) {
            return new ArrayList<String>();
        }
        return this.dependencyDao.getDependentItems(siteId, paths);
    }

    @Override
    public List<String> getItemSpecificDependencies(String siteId, String path) {
        ArrayList<String> paths = new ArrayList<String>(1);
        paths.add(path);
        return this.getItemSpecificDependencies(siteId, paths);
    }

    @Override
    public List<String> getItemSpecificDependencies(String siteId, List<String> paths) {
        if (CollectionUtils.isNotEmpty(paths)) {
            return this.dependencyDao.getItemSpecificDependencies(siteId, paths, this.getItemSpecificDependenciesPatterns());
        }
        return new ArrayList<String>();
    }

    @Override
    public Map<String, Set<String>> resolveDependnecies(String siteId, String path) {
        Map<String, Set<String>> dependencies = null;
        boolean isXml = path.endsWith(".xml");
        boolean isCss = path.endsWith(".css");
        boolean isJs = path.endsWith(".js");
        boolean isTemplate = ContentUtils.matchesPatterns(path, this.servicesConfig.getRenderingTemplatePatterns(siteId));
        if (isXml || isCss || isJs || isTemplate) {
            dependencies = this.dependencyResolver.resolve(siteId, path);
        }
        return dependencies;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public DependencyDAO getDependencyDao() {
        return this.dependencyDao;
    }

    public void setDependencyDao(DependencyDAO dependencyDao) {
        this.dependencyDao = dependencyDao;
    }

    public ItemStateMapper getItemStateMapper() {
        return this.itemStateMapper;
    }

    public void setItemStateMapper(ItemStateMapper itemStateMapper) {
        this.itemStateMapper = itemStateMapper;
    }

    public DependencyResolver getDependencyResolver() {
        return this.dependencyResolver;
    }

    public void setDependencyResolver(DependencyResolver dependencyResolver) {
        this.dependencyResolver = dependencyResolver;
    }

    public ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }
}

