/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.marketplace.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.monitoring.VersionInfo;
import org.craftercms.commons.plugin.model.Plugin;
import org.craftercms.commons.plugin.model.PluginDescriptor;
import org.craftercms.commons.plugin.model.Version;
import org.craftercms.commons.rest.RestTemplate;
import org.craftercms.studio.api.v1.exception.BlueprintNotFoundException;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteRepositoryCredentialsException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteRepositoryException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteUrlException;
import org.craftercms.studio.api.v1.exception.repository.RemoteRepositoryNotBareException;
import org.craftercms.studio.api.v1.exception.repository.RemoteRepositoryNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v2.exception.marketplace.MarketplaceException;
import org.craftercms.studio.api.v2.exception.marketplace.MarketplaceNotInitializedException;
import org.craftercms.studio.api.v2.exception.marketplace.MarketplaceUnreachableException;
import org.craftercms.studio.api.v2.service.marketplace.internal.MarketplaceServiceInternal;
import org.craftercms.studio.api.v2.service.site.internal.SitesServiceInternal;
import org.craftercms.studio.api.v2.service.system.InstanceService;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.model.rest.marketplace.CreateSiteRequest;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.util.UriComponentsBuilder;

public class MarketplaceServiceInternalImpl
implements MarketplaceServiceInternal,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(MarketplaceServiceInternalImpl.class);
    protected InstanceService instanceService;
    protected SiteService siteService;
    protected SitesServiceInternal sitesServiceInternal;
    protected StudioConfiguration studioConfiguration;
    protected RestTemplate restTemplate = new RestTemplate();
    protected ObjectMapper mapper = new ObjectMapper();
    protected HttpHeaders httpHeaders;
    protected String version;
    protected String edition;
    protected String url;
    protected boolean showPending = false;

    public MarketplaceServiceInternalImpl(InstanceService instanceService, SiteService siteService, SitesServiceInternal sitesServiceInternal, StudioConfiguration studioConfiguration) {
        this.instanceService = instanceService;
        this.siteService = siteService;
        this.sitesServiceInternal = sitesServiceInternal;
        this.studioConfiguration = studioConfiguration;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setShowPending(boolean showPending) {
        this.showPending = showPending;
    }

    public void afterPropertiesSet() throws IOException {
        VersionInfo versionInfo = VersionInfo.getVersion(MarketplaceServiceInternalImpl.class);
        if (versionInfo == null) {
            logger.warn("Marketplace service could not be initialized", new Object[0]);
            return;
        }
        String versionStr = versionInfo.getPackageVersion();
        this.version = Version.getVersion((String)versionStr);
        this.edition = Version.getEdition((String)versionStr);
        this.httpHeaders = new HttpHeaders();
        this.httpHeaders.set("x-studio-id", this.instanceService.getInstanceId());
        this.httpHeaders.set("x-studio-build", versionInfo.getPackageBuild());
        this.httpHeaders.set("x-studio-version", versionInfo.getPackageVersion());
        this.httpHeaders.set("x-java-version", versionInfo.getJavaVersion());
        this.httpHeaders.set("x-os-name", versionInfo.getOsName());
        this.httpHeaders.set("x-os-version", versionInfo.getOsVersion());
        this.httpHeaders.set("x-os-arch", versionInfo.getOsArch());
    }

    @Override
    public Map<String, Object> searchPlugins(String type, String keywords, boolean showIncompatible, long offset, long limit) throws MarketplaceException {
        this.validate();
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)this.url).path("/api/1/plugin/search").queryParam("version", new Object[]{this.version}).queryParam("edition", new Object[]{this.edition}).queryParam("showPending", new Object[]{this.showPending}).queryParam("showIncompatible", new Object[]{showIncompatible}).queryParam("offset", new Object[]{offset}).queryParam("limit", new Object[]{limit});
        if (StringUtils.isNotEmpty((CharSequence)type)) {
            builder.queryParam("type", new Object[]{type});
        }
        if (StringUtils.isNotEmpty((CharSequence)keywords)) {
            builder.queryParam("keywords", new Object[]{keywords});
        }
        HttpEntity request = new HttpEntity(null, (MultiValueMap)this.httpHeaders);
        try {
            ResponseEntity response = this.restTemplate.exchange(builder.build().toString(), HttpMethod.GET, request, (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, Object>>(){}, new Object[0]);
            return (Map)response.getBody();
        }
        catch (ResourceAccessException e) {
            throw new MarketplaceUnreachableException(this.url, (Exception)((Object)e));
        }
    }

    protected void validate() throws MarketplaceException {
        if (StringUtils.isEmpty((CharSequence)this.version)) {
            throw new MarketplaceNotInitializedException();
        }
    }

    protected Map<String, Object> getDescriptor(String id, Version version) throws MarketplaceException, BlueprintNotFoundException {
        this.validate();
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)this.url).path("/api/1/plugin").pathSegment(new String[]{id, String.format("%s.%s.%s", version.getMajor(), version.getMinor(), version.getPatch())}).queryParam("showPending", new Object[]{this.showPending});
        HttpEntity request = new HttpEntity(null, (MultiValueMap)this.httpHeaders);
        try {
            ResponseEntity response = this.restTemplate.exchange(builder.build().toString(), HttpMethod.GET, request, (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, Object>>(){}, new Object[0]);
            return (Map)response.getBody();
        }
        catch (ResourceAccessException e) {
            throw new MarketplaceUnreachableException(this.url, (Exception)((Object)e));
        }
        catch (IllegalArgumentException e) {
            throw new BlueprintNotFoundException(String.format("Blueprint not found in the Marketplace: %s %s.%s.%s", id, version.getMajor(), version.getMinor(), version.getPatch()));
        }
    }

    @Override
    public void createSite(CreateSiteRequest request) throws RemoteRepositoryNotFoundException, InvalidRemoteRepositoryException, RemoteRepositoryNotBareException, InvalidRemoteUrlException, ServiceLayerException, InvalidRemoteRepositoryCredentialsException {
        if (StringUtils.isEmpty((CharSequence)request.getSandboxBranch())) {
            request.setSandboxBranch(this.studioConfiguration.getProperty("studio.repo.siteSandboxBranch"));
        }
        if (StringUtils.isEmpty((CharSequence)request.getRemoteName())) {
            request.setRemoteName(this.studioConfiguration.getProperty("studio.repo.defaultRemoteName"));
        }
        Map<String, Object> result = this.getDescriptor(request.getBlueprintId(), request.getBlueprintVersion());
        Plugin plugin = (Plugin)this.mapper.convertValue(result, Plugin.class);
        this.sitesServiceInternal.validateBlueprintParameters(PluginDescriptor.of((Plugin)plugin), request.getSiteParams());
        this.siteService.createSiteWithRemoteOption(request.getSiteId(), request.getSandboxBranch(), request.getDescription(), request.getBlueprintId(), request.getRemoteName(), result.get("url").toString(), result.get("ref").toString(), false, "none", null, null, null, null, "clone", request.getSiteParams(), true);
    }
}

