/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.notification;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.craftercms.commons.mail.EmailUtils;
import org.craftercms.commons.validation.annotations.param.ValidateParams;
import org.craftercms.commons.validation.annotations.param.ValidateStringParam;
import org.craftercms.engine.exception.ConfigurationException;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v1.to.EmailMessageQueueTo;
import org.craftercms.studio.api.v1.to.EmailMessageTO;
import org.craftercms.studio.api.v1.to.EmailMessageTemplateTO;
import org.craftercms.studio.api.v1.to.MessageTO;
import org.craftercms.studio.api.v1.to.NotificationConfigTO;
import org.craftercms.studio.api.v2.service.config.ConfigurationService;
import org.craftercms.studio.api.v2.service.notification.NotificationMessageType;
import org.craftercms.studio.api.v2.service.notification.NotificationService;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.dom4j.Document;
import org.dom4j.Element;

public class NotificationServiceImpl
implements NotificationService {
    private static final Logger logger = LoggerFactory.getLogger(NotificationServiceImpl.class);
    private static final String NOTIFICATION_KEY_DEPLOYMENT_ERROR = "deploymentError";
    private static final String NOTIFICATION_KEY_CONTENT_APPROVED = "contentApproved";
    private static final String NOTIFICATION_KEY_SUBMITTED_FOR_REVIEW = "submittedForReview";
    private static final String NOTIFICATION_KEY_CONTENT_REJECTED = "contentRejected";
    private static final String NOTIFICATION_KEY_REPOSITORY_MERGE_CONFLICT = "repositoryMergeConflict";
    protected Map<String, Map<String, NotificationConfigTO>> notificationConfiguration = new HashMap<String, Map<String, NotificationConfigTO>>();
    protected ContentService contentService;
    protected EmailMessageQueueTo emailMessages;
    protected ServicesConfig servicesConfig;
    protected SiteService siteService;
    protected SecurityService securityService;
    private Configuration configuration;
    protected StudioConfiguration studioConfiguration;
    protected ConfigurationService configurationService;

    public void init() {
        this.configuration = new Configuration(Configuration.VERSION_2_3_23);
        this.configuration.setTimeZone(TimeZone.getTimeZone(this.getTemplateTimezone()));
        this.configuration.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapperBuilder(Configuration.VERSION_2_3_23).build());
    }

    @Override
    @ValidateParams
    public void notifyDeploymentError(@ValidateStringParam(name="site") String site, Throwable throwable, List<String> filesUnableToPublish, Locale locale) {
        try {
            NotificationConfigTO notificationConfig = this.getNotificationConfig(site, locale);
            HashMap<String, Object> templateModel = new HashMap<String, Object>();
            templateModel.put(NOTIFICATION_KEY_DEPLOYMENT_ERROR, throwable);
            templateModel.put("files", this.convertPathsToContent(site, filesUnableToPublish));
            this.notify(site, notificationConfig.getDeploymentFailureNotifications(), NOTIFICATION_KEY_DEPLOYMENT_ERROR, locale, templateModel);
        }
        catch (Throwable ex) {
            logger.error("Unable to Notify Error", ex);
        }
    }

    @Override
    @ValidateParams
    public void notifyDeploymentError(@ValidateStringParam(name="name") String name, Throwable throwable) {
        this.notifyDeploymentError(name, throwable, Collections.EMPTY_LIST, Locale.ENGLISH);
    }

    @Override
    @ValidateParams
    public void notifyContentApproval(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="submitter") String submitter, List<String> itemsSubmitted, @ValidateStringParam(name="approver") String approver, ZonedDateTime scheduleDate, Locale locale) {
        try {
            Map<String, Object> submitterUser = this.securityService.getUserProfile(submitter);
            HashMap<String, Object> templateModel = new HashMap<String, Object>();
            templateModel.put("files", this.convertPathsToContent(site, itemsSubmitted));
            templateModel.put("submitterUser", submitter);
            templateModel.put("approver", this.securityService.getUserProfile(approver));
            templateModel.put("scheduleDate", scheduleDate == null ? null : Date.from(scheduleDate.toInstant()));
            this.notify(site, Arrays.asList(submitterUser.get("email").toString()), NOTIFICATION_KEY_CONTENT_APPROVED, locale, templateModel);
        }
        catch (Throwable ex) {
            logger.error("Unable to Notify Content Approval", ex);
        }
    }

    @Override
    @ValidateParams
    public String getNotificationMessage(@ValidateStringParam(name="site") String site, NotificationMessageType type, @ValidateStringParam(name="key") String key, Locale locale, Pair<String, Object> ... params) {
        try {
            NotificationConfigTO notificationConfig = this.getNotificationConfig(site, locale);
            String message = null;
            switch (type) {
                case GeneralMessages: {
                    message = notificationConfig.getMessages().get(key);
                    break;
                }
                case EmailMessage: {
                    message = notificationConfig.getEmailMessageTemplates().get(key).getMessage();
                    break;
                }
                case CompleteMessages: {
                    message = notificationConfig.getCompleteMessages().get(key);
                    break;
                }
                case CannedMessages: {
                    message = this.getCannedMessage(notificationConfig.getCannedMessages(), key);
                    break;
                }
                default: {
                    logger.error("Requested notification message bundle not recognized: site: {0}, type: {1},key: {2}, locale {3}.", site, type.toString(), key, locale);
                }
            }
            if (message != null) {
                HashMap<String, Object> model = new HashMap<String, Object>();
                for (Pair<String, Object> param : params) {
                    model.put((String)param.getKey(), param.getValue());
                }
                model.put("siteName", site);
                return this.processMessage(key, message, model);
            }
        }
        catch (Throwable ex) {
            logger.error("Unable to get notification message from notification configuration for site: {0} type: {1} key: {2}, locale {3}.", (Exception)ex, new Object[]{site, type, key, locale});
            return "";
        }
        return "";
    }

    private String getCannedMessage(Map<String, List<MessageTO>> cannedMessages, String key) {
        List<MessageTO> messages;
        if (cannedMessages.containsKey(key) && !(messages = cannedMessages.get(key)).isEmpty()) {
            return messages.get(0).getBody();
        }
        return "";
    }

    @Override
    @ValidateParams
    public void notifyApprovesContentSubmission(@ValidateStringParam(name="name") String site, List<String> usersToNotify, List<String> itemsSubmitted, @ValidateStringParam(name="submitter") String submitter, ZonedDateTime scheduleDate, boolean isADelete, @ValidateStringParam(name="submissionComments") String submissionComments, Locale locale) {
        try {
            NotificationConfigTO notificationConfig = this.getNotificationConfig(site, locale);
            Map<String, Object> submitterUser = this.securityService.getUserProfile(submitter);
            HashMap<String, Object> templateModel = new HashMap<String, Object>();
            templateModel.put("files", this.convertPathsToContent(site, itemsSubmitted));
            templateModel.put("submitter", submitterUser);
            templateModel.put("scheduleDate", scheduleDate == null ? null : Date.from(scheduleDate.toInstant()));
            templateModel.put("isDeleted", isADelete);
            templateModel.put("submissionComments", submissionComments);
            if (usersToNotify == null) {
                this.notify(site, notificationConfig.getApproverEmails(), NOTIFICATION_KEY_SUBMITTED_FOR_REVIEW, locale, templateModel);
            } else {
                this.notify(site, usersToNotify, NOTIFICATION_KEY_SUBMITTED_FOR_REVIEW, locale, templateModel);
            }
        }
        catch (Throwable ex) {
            logger.error("Unable to notify content submission", ex);
        }
    }

    @Override
    @ValidateParams
    public void notify(@ValidateStringParam(name="site") String site, List<String> toUsers, @ValidateStringParam(name="key") String key, Locale locale, Pair<String, Object> ... params) {
        try {
            NotificationConfigTO notificationConfig = this.getNotificationConfig(site, locale);
            EmailMessageTemplateTO emailTemplate = notificationConfig.getEmailMessageTemplates().get(key);
            if (emailTemplate != null) {
                HashMap<String, Object> templateModel = new HashMap<String, Object>();
                templateModel.put("siteName", site);
                templateModel.put("liveUrl", this.servicesConfig.getLiveUrl(site));
                templateModel.put("authoringUrl", this.servicesConfig.getAuthoringUrl(site));
                for (Pair<String, Object> param : params) {
                    templateModel.put((String)param.getKey(), param.getValue());
                }
                String messageBody = this.processMessage(key, emailTemplate.getMessage(), templateModel);
                String subject = this.processMessage(key, emailTemplate.getSubject(), templateModel);
                this.sendEmail(messageBody, subject, toUsers);
            } else {
                logger.error("Unable to find " + key + " for language " + locale.getLanguage(), new Object[0]);
            }
        }
        catch (Throwable ex) {
            logger.error("Unable to notify ", ex);
        }
    }

    protected void notify(String site, List<String> toUsers, String key, Locale locale, Map<String, Object> params) {
        try {
            ArrayList<ImmutablePair> namedParams = new ArrayList<ImmutablePair>();
            for (String paramKey : params.keySet()) {
                namedParams.add(new ImmutablePair((Object)paramKey, params.get(paramKey)));
            }
            this.notify(site, toUsers, key, locale, namedParams.toArray(new Pair[params.size()]));
        }
        catch (Throwable ex) {
            logger.error("Unable to notify", ex);
        }
    }

    @Override
    @ValidateParams
    public void notifyContentRejection(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="submittedBy") String submittedBy, List<String> rejectedItems, @ValidateStringParam(name="rejectionReason") String rejectionReason, @ValidateStringParam(name="userThatRejects") String userThatRejects, Locale locale) {
        try {
            Map<String, Object> submitterUser;
            try {
                submitterUser = this.securityService.getUserProfile(submittedBy);
            }
            catch (ServiceLayerException | UserNotFoundException e) {
                logger.debug("User not found by username " + submittedBy, new Object[0]);
                submitterUser = this.securityService.getUserProfileByGitName(submittedBy);
            }
            if (Objects.nonNull(submitterUser) && !submitterUser.isEmpty()) {
                HashMap<String, Object> templateModel = new HashMap<String, Object>();
                templateModel.put("files", this.convertPathsToContent(site, rejectedItems));
                templateModel.put("submitter", submitterUser);
                templateModel.put("rejectionReason", rejectionReason);
                templateModel.put("userThatRejects", this.securityService.getUserProfile(userThatRejects));
                this.notify(site, Arrays.asList(submitterUser.get("email").toString()), NOTIFICATION_KEY_CONTENT_REJECTED, locale, templateModel);
            } else {
                logger.info("Unable to notify content rejection. User " + submittedBy + " not found.", new Object[0]);
            }
        }
        catch (Exception ex) {
            logger.error("Unable to notify content rejection", ex, new Object[0]);
        }
    }

    protected void loadConfig(String site) {
        if (this.notificationConfiguration == null) {
            this.notificationConfiguration = new HashMap<String, Map<String, NotificationConfigTO>>();
        }
        HashMap<String, NotificationConfigTO> siteNotificationConfig = new HashMap<String, NotificationConfigTO>();
        try {
            Document document = this.configurationService.getConfigurationAsDocument(site, "studio", this.getConfigPath(), this.studioConfiguration.getProperty("studio.configuration.environment.active"));
            if (document != null) {
                Element root = document.getRootElement();
                List languages = root.selectNodes("//lang");
                if (languages.isEmpty()) {
                    throw new ConfigurationException("Notification Configuration is a invalid xml file, missing at least one lang");
                }
                for (Element language : languages) {
                    String messagesLang = language.attributeValue("name");
                    if (StringUtils.isNotBlank((CharSequence)messagesLang)) {
                        if (!siteNotificationConfig.containsKey(messagesLang)) {
                            siteNotificationConfig.put(messagesLang, new NotificationConfigTO(site));
                        }
                        NotificationConfigTO configForLang = (NotificationConfigTO)siteNotificationConfig.get(messagesLang);
                        this.loadGenericMessage((Element)language.selectSingleNode("//generalMessages"), configForLang.getMessages());
                        this.loadGenericMessage((Element)language.selectSingleNode("//completeMessages"), configForLang.getCompleteMessages());
                        this.loadEmailTemplates((Element)language.selectSingleNode("//emailTemplates"), configForLang.getEmailMessageTemplates());
                        this.loadCannedMessages((Element)language.selectSingleNode("//cannedMessages"), configForLang.getCannedMessages());
                        this.loadEmailList(site, (Element)language.selectSingleNode("//deploymentFailureNotification"), configForLang.getDeploymentFailureNotifications());
                        this.loadEmailList(site, (Element)language.selectSingleNode("//approverEmails"), configForLang.getApproverEmails());
                        this.loadEmailList(site, (Element)language.selectSingleNode("//repositoryMergeConflictNotification"), configForLang.getRepositoryMergeConflictNotifications());
                        continue;
                    }
                    logger.error("A lang section does not have the 'name' attribute, ignoring", new Object[0]);
                }
            }
        }
        catch (Exception ex) {
            logger.error("Unable to read or load notification '" + this.getConfigPath() + "' configuration for " + site, ex, new Object[0]);
        }
        this.notificationConfiguration.put(site, siteNotificationConfig);
    }

    private void loadEmailList(String site, Element emailList, List<String> deploymentFailureNotifications) {
        if (emailList != null) {
            List emails = emailList.elements();
            if (!emails.isEmpty()) {
                for (Element emailNode : emails) {
                    String email = emailNode.getText();
                    if (!EmailUtils.validateEmail((String)email)) continue;
                    deploymentFailureNotifications.add(email);
                }
            } else {
                deploymentFailureNotifications.add(this.servicesConfig.getAdminEmailAddress(site));
            }
        } else {
            logger.error("Unable to read completed Messages (they don't exist)", new Object[0]);
        }
    }

    protected void loadGenericMessage(Element emailTemplates, Map<String, String> messageContainer) {
        if (emailTemplates != null) {
            List messages = emailTemplates.elements();
            if (!messages.isEmpty()) {
                for (Element message : messages) {
                    String messageKey = message.attributeValue("key");
                    String messageText = message.getText();
                    messageContainer.put(messageKey, messageText);
                }
            } else {
                logger.error("completed Messages is empty", new Object[0]);
            }
        } else {
            logger.error("Unable to read completed Messages (they don't exist)", new Object[0]);
        }
    }

    protected void loadEmailTemplates(Element emailTemplates, Map<String, EmailMessageTemplateTO> messageContainer) {
        if (emailTemplates != null) {
            List messages = emailTemplates.elements();
            if (!messages.isEmpty()) {
                for (Element message : messages) {
                    Element subjectNode = message.element("subject");
                    Element bodyNode = message.element("body");
                    String messageKey = message.attributeValue("key");
                    if (subjectNode != null && bodyNode != null) {
                        EmailMessageTemplateTO emailMessageTemplateTO = new EmailMessageTemplateTO(subjectNode.getText(), bodyNode.getText());
                        messageContainer.put(messageKey, emailMessageTemplateTO);
                        continue;
                    }
                    logger.error("Email message malformed", new Object[0]);
                }
            } else {
                logger.error("completed Messages is empty", new Object[0]);
            }
        } else {
            logger.error("Unable to read completed Messages (they don't exist)", new Object[0]);
        }
    }

    protected void loadCannedMessages(Element completedMessages, Map<String, List<MessageTO>> messageContainer) {
        if (completedMessages != null) {
            List messages = completedMessages.elements();
            if (!messages.isEmpty()) {
                for (Element message : messages) {
                    String messageKey = message.attributeValue("key");
                    String messageContent = message.getText();
                    String messageTitle = message.attributeValue("title");
                    if (!messageContainer.containsKey(messageKey)) {
                        messageContainer.put(messageKey, new ArrayList());
                    }
                    List<MessageTO> messageTOs = messageContainer.get(messageKey);
                    messageTOs.add(new MessageTO(messageTitle, messageContent, messageKey));
                }
            } else {
                logger.error("completed Messages is empty", new Object[0]);
            }
        } else {
            logger.error("Unable to read completed Messages (they don't exist)", new Object[0]);
        }
    }

    @Override
    @ValidateParams
    public void reloadConfiguration(@ValidateStringParam(name="site") String site) {
        this.loadConfig(site);
    }

    protected NotificationConfigTO getNotificationConfig(String site, Locale locale) {
        Map<String, NotificationConfigTO> siteNotificationConfig = this.notificationConfiguration.get(site);
        if (siteNotificationConfig == null || siteNotificationConfig.isEmpty()) {
            this.loadConfig(site);
            siteNotificationConfig = this.notificationConfiguration.get(site);
        }
        Locale realLocale = locale;
        if (locale == null) {
            realLocale = Locale.ENGLISH;
        }
        return siteNotificationConfig.get(realLocale.getLanguage());
    }

    protected void sendEmail(String message, String subject, List<String> sendTo) {
        EmailMessageTO emailMessage = new EmailMessageTO(subject, message, StringUtils.join(sendTo, (char)','));
        this.emailMessages.addEmailMessage(emailMessage);
    }

    protected String processMessage(String templateName, String message, Map<String, Object> templateModel) {
        StringWriter out = new StringWriter();
        try {
            Template t = new Template(templateName, (Reader)new StringReader(message), this.configuration);
            t.process(templateModel, (Writer)out);
            return out.toString();
        }
        catch (TemplateException | IOException ex) {
            logger.error("Unable to process notification message " + templateName, (Exception)ex, new Object[0]);
            return null;
        }
    }

    protected Set<ContentItemTO> convertPathsToContent(String site, List<String> listOfPaths) {
        HashSet<ContentItemTO> files = new HashSet<ContentItemTO>(listOfPaths.size());
        for (String path : listOfPaths) {
            files.add(this.contentService.getContentItem(site, path));
        }
        return files;
    }

    @Override
    @ValidateParams
    public void notifyRepositoryMergeConflict(@ValidateStringParam(name="site") String site, List<String> filesUnableToMerge, Locale locale) {
        try {
            NotificationConfigTO notificationConfig = this.getNotificationConfig(site, locale);
            HashMap<String, Object> templateModel = new HashMap<String, Object>();
            templateModel.put("files", filesUnableToMerge);
            this.notify(site, notificationConfig.getRepositoryMergeConflictNotifications(), NOTIFICATION_KEY_REPOSITORY_MERGE_CONFLICT, locale, templateModel);
        }
        catch (Throwable ex) {
            logger.error("Unable to Notify Error", ex);
        }
    }

    public String getConfigPath() {
        return this.studioConfiguration.getProperty("studio.notification.configurationFile");
    }

    public String getTemplateTimezone() {
        return this.studioConfiguration.getProperty("studio.notification.timezone");
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setEmailMessages(EmailMessageQueueTo emailMessages) {
        this.emailMessages = emailMessages;
    }

    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

