/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.publish;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.craftercms.commons.security.permissions.DefaultPermission;
import org.craftercms.commons.security.permissions.annotations.HasPermission;
import org.craftercms.commons.security.permissions.annotations.ProtectedResourceId;
import org.craftercms.studio.api.v1.dal.ItemMetadata;
import org.craftercms.studio.api.v1.dal.SiteFeed;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.content.ObjectMetadataManager;
import org.craftercms.studio.api.v1.service.objectstate.ObjectStateService;
import org.craftercms.studio.api.v1.service.objectstate.State;
import org.craftercms.studio.api.v1.service.objectstate.TransitionEvent;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v2.dal.AuditLog;
import org.craftercms.studio.api.v2.dal.AuditLogParameter;
import org.craftercms.studio.api.v2.dal.DeploymentHistoryGroup;
import org.craftercms.studio.api.v2.dal.DeploymentHistoryItem;
import org.craftercms.studio.api.v2.dal.PublishingHistoryItem;
import org.craftercms.studio.api.v2.dal.PublishingPackage;
import org.craftercms.studio.api.v2.dal.PublishingPackageDetails;
import org.craftercms.studio.api.v2.service.audit.internal.AuditServiceInternal;
import org.craftercms.studio.api.v2.service.publish.PublishService;
import org.craftercms.studio.api.v2.service.publish.internal.PublishServiceInternal;
import org.craftercms.studio.impl.v2.utils.StudioUtils;
import org.craftercms.studio.model.rest.dashboard.PublishingDashboardItem;

public class PublishServiceImpl
implements PublishService {
    private PublishServiceInternal publishServiceInternal;
    private SiteService siteService;
    private ObjectStateService objectStateService;
    private ObjectMetadataManager objectMetadataManager;
    private AuditServiceInternal auditServiceInternal;
    private SecurityService securityService;
    private StudioUtils studioUtils;
    private ServicesConfig servicesConfig;

    @Override
    @HasPermission(type=DefaultPermission.class, action="get_publishing_queue")
    public int getPublishingPackagesTotal(@ProtectedResourceId(value="siteId") String siteId, String environment, String path, List<String> states) throws SiteNotFoundException {
        if (!this.siteService.exists(siteId)) {
            throw new SiteNotFoundException(siteId);
        }
        return this.publishServiceInternal.getPublishingPackagesTotal(siteId, environment, path, states);
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="get_publishing_queue")
    public List<PublishingPackage> getPublishingPackages(@ProtectedResourceId(value="siteId") String siteId, String environment, String path, List<String> states, int offset, int limit) throws SiteNotFoundException {
        if (!this.siteService.exists(siteId)) {
            throw new SiteNotFoundException(siteId);
        }
        return this.publishServiceInternal.getPublishingPackages(siteId, environment, path, states, offset, limit);
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="get_publishing_queue")
    public PublishingPackageDetails getPublishingPackageDetails(@ProtectedResourceId(value="siteId") String siteId, String packageId) throws SiteNotFoundException {
        if (!this.siteService.exists(siteId)) {
            throw new SiteNotFoundException(siteId);
        }
        return this.publishServiceInternal.getPublishingPackageDetails(siteId, packageId);
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="cancel_publish")
    public void cancelPublishingPackages(@ProtectedResourceId(value="siteId") String siteId, List<String> packageIds) throws SiteNotFoundException {
        if (!this.siteService.exists(siteId)) {
            throw new SiteNotFoundException(siteId);
        }
        this.publishServiceInternal.cancelPublishingPackages(siteId, packageIds);
        ArrayList<AuditLogParameter> auditLogParameters = new ArrayList<AuditLogParameter>();
        for (String pId : packageIds) {
            PublishingPackageDetails packageDetails = this.publishServiceInternal.getPublishingPackageDetails(siteId, pId);
            ArrayList<String> paths = new ArrayList<String>();
            for (PublishingPackageDetails.PublishingPackageItem item : packageDetails.getItems()) {
                paths.add(item.getPath());
                ItemMetadata itemMetadata = this.objectMetadataManager.getProperties(siteId, item.getPath());
                if (itemMetadata != null) {
                    itemMetadata.setSubmittedBy("");
                    itemMetadata.setSendEmail(0);
                    itemMetadata.setSubmittedForDeletion(0);
                    itemMetadata.setSubmissionComment("");
                    itemMetadata.setLaunchDate(null);
                    itemMetadata.setSubmittedToEnvironment("");
                    this.objectMetadataManager.updateObjectMetadata(itemMetadata);
                }
                AuditLogParameter auditLogParameter = new AuditLogParameter();
                auditLogParameter.setTargetId(siteId + ":" + item.getPath());
                auditLogParameter.setTargetType("Content Item");
                auditLogParameter.setTargetValue(item.getPath());
                auditLogParameters.add(auditLogParameter);
            }
            this.objectStateService.transitionBulk(siteId, paths, TransitionEvent.REJECT, State.NEW_UNPUBLISHED_UNLOCKED);
            this.createAuditLogEntry(siteId, auditLogParameters);
        }
    }

    private void createAuditLogEntry(String siteId, List<AuditLogParameter> auditLogParameters) throws SiteNotFoundException {
        SiteFeed siteFeed = this.siteService.getSite(siteId);
        AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
        auditLog.setOperation("CANCEL_PUBLISHING_PACKAGE");
        auditLog.setActorId(this.securityService.getCurrentUser());
        auditLog.setSiteId(siteFeed.getId());
        auditLog.setPrimaryTargetId(siteId);
        auditLog.setPrimaryTargetType("Site");
        auditLog.setPrimaryTargetValue(siteId);
        auditLog.setParameters(auditLogParameters);
        this.auditServiceInternal.insertAuditLog(auditLog);
    }

    @Override
    public int getPublishingHistoryTotal(String siteId, String environment, String path, String publisher, ZonedDateTime dateFrom, ZonedDateTime dateTo, String contentType, long state) {
        return this.publishServiceInternal.getPublishingHistoryTotal(siteId, environment, path, publisher, dateFrom, dateTo, contentType, state);
    }

    @Override
    public List<PublishingDashboardItem> getPublishingHistory(String siteId, String environment, String path, String publisher, ZonedDateTime dateFrom, ZonedDateTime dateTo, String contentType, long state, String sortBy, String order, int offset, int limit) {
        List<PublishingHistoryItem> publishingHistoryItems = this.publishServiceInternal.getPublishingHistory(siteId, environment, path, publisher, dateFrom, dateTo, contentType, state, sortBy, order, offset, limit);
        return this.preparePublishingResult(publishingHistoryItems);
    }

    private List<PublishingDashboardItem> preparePublishingResult(List<PublishingHistoryItem> publishingHistory) {
        ArrayList<PublishingDashboardItem> publishingDashboardItems = new ArrayList<PublishingDashboardItem>();
        for (PublishingHistoryItem historyItem : publishingHistory) {
            PublishingDashboardItem dashboardItem = new PublishingDashboardItem();
            ItemMetadata itemMetadata = this.objectMetadataManager.getProperties(historyItem.getSiteId(), historyItem.getPath());
            dashboardItem.setSiteId(historyItem.getSiteId());
            dashboardItem.setPath(historyItem.getPath());
            dashboardItem.setLabel(itemMetadata.getName());
            dashboardItem.setEnvironment(historyItem.getEnvironment());
            dashboardItem.setPublishedDate(historyItem.getPublishedDate());
            dashboardItem.setPublisher(historyItem.getPublisher());
            publishingDashboardItems.add(dashboardItem);
        }
        return publishingDashboardItems;
    }

    @Override
    public List<DeploymentHistoryGroup> getDeploymentHistory(String siteId, int daysFromToday, int numberOfItems, String filterType) {
        ZonedDateTime toDate = ZonedDateTime.now(ZoneOffset.UTC);
        ZonedDateTime fromDate = toDate.minusDays(daysFromToday);
        List<String> environments = this.studioUtils.getEnvironmentNames(siteId);
        List<DeploymentHistoryItem> deploymentHistoryItems = this.publishServiceInternal.getDeploymentHistory(siteId, environments, fromDate, toDate, filterType, numberOfItems);
        ArrayList<DeploymentHistoryGroup> groups = new ArrayList<DeploymentHistoryGroup>();
        if (deploymentHistoryItems != null) {
            int count = 0;
            String timezone = this.servicesConfig.getDefaultTimezone(siteId);
            HashMap processedItems = new HashMap();
            for (int index = 0; index < deploymentHistoryItems.size() && count < numberOfItems; ++index) {
                ContentItemTO deployedItem;
                DeploymentHistoryItem entry = deploymentHistoryItems.get(index);
                String env = entry.getEnvironment();
                if (!processedItems.containsKey(env)) {
                    processedItems.put(env, new HashSet());
                }
                if (((Set)processedItems.get(env)).contains(entry.getPath()) || (deployedItem = this.studioUtils.getContentItemForDashboard(entry.getSite(), entry.getPath())) == null) continue;
                deployedItem.eventDate = entry.getDeploymentDate();
                deployedItem.endpoint = entry.getTarget();
                deployedItem.setUser(entry.getUser());
                deployedItem.setEndpoint(entry.getEnvironment());
                String deployedLabel = entry.getDeploymentDate().withZoneSameInstant(ZoneId.of(timezone)).format(DateTimeFormatter.ISO_OFFSET_DATE);
                if (groups.size() > 0) {
                    DeploymentHistoryGroup group = (DeploymentHistoryGroup)groups.get(groups.size() - 1);
                    String lastDeployedLabel = group.getInternalName();
                    if (lastDeployedLabel.equals(deployedLabel)) {
                        group.setNumOfChildren(group.getNumOfChildren() + 1);
                        group.getChildren().add(deployedItem);
                    } else {
                        groups.add(this.createDeploymentHistoryGroup(deployedLabel, deployedItem));
                    }
                } else {
                    groups.add(this.createDeploymentHistoryGroup(deployedLabel, deployedItem));
                }
                ((Set)processedItems.get(env)).add(entry.getPath());
            }
        }
        return groups;
    }

    private DeploymentHistoryGroup createDeploymentHistoryGroup(String deployedLabel, ContentItemTO item) {
        DeploymentHistoryGroup group = new DeploymentHistoryGroup();
        group.setInternalName(deployedLabel);
        List<ContentItemTO> taskItems = group.getChildren();
        if (taskItems == null) {
            taskItems = new ArrayList<ContentItemTO>();
            group.setChildren(taskItems);
        }
        taskItems.add(item);
        group.setNumOfChildren(taskItems.size());
        return group;
    }

    public PublishServiceInternal getPublishServiceInternal() {
        return this.publishServiceInternal;
    }

    public void setPublishServiceInternal(PublishServiceInternal publishServiceInternal) {
        this.publishServiceInternal = publishServiceInternal;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public ObjectStateService getObjectStateService() {
        return this.objectStateService;
    }

    public void setObjectStateService(ObjectStateService objectStateService) {
        this.objectStateService = objectStateService;
    }

    public ObjectMetadataManager getObjectMetadataManager() {
        return this.objectMetadataManager;
    }

    public void setObjectMetadataManager(ObjectMetadataManager objectMetadataManager) {
        this.objectMetadataManager = objectMetadataManager;
    }

    public AuditServiceInternal getAuditServiceInternal() {
        return this.auditServiceInternal;
    }

    public void setAuditServiceInternal(AuditServiceInternal auditServiceInternal) {
        this.auditServiceInternal = auditServiceInternal;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public StudioUtils getStudioUtils() {
        return this.studioUtils;
    }

    public void setStudioUtils(StudioUtils studioUtils) {
        this.studioUtils = studioUtils;
    }

    public ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }
}

