/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.repository;

import java.util.List;
import org.craftercms.commons.crypto.CryptoException;
import org.craftercms.commons.security.permissions.DefaultPermission;
import org.craftercms.commons.security.permissions.annotations.HasPermission;
import org.craftercms.commons.security.permissions.annotations.ProtectedResourceId;
import org.craftercms.studio.api.v1.constant.GitRepositories;
import org.craftercms.studio.api.v1.dal.SiteFeed;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteUrlException;
import org.craftercms.studio.api.v1.exception.repository.RemoteNotRemovableException;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v2.dal.AuditLog;
import org.craftercms.studio.api.v2.dal.DiffConflictedFile;
import org.craftercms.studio.api.v2.dal.RemoteRepository;
import org.craftercms.studio.api.v2.dal.RemoteRepositoryInfo;
import org.craftercms.studio.api.v2.dal.RepositoryStatus;
import org.craftercms.studio.api.v2.service.audit.internal.AuditServiceInternal;
import org.craftercms.studio.api.v2.service.repository.RepositoryManagementService;
import org.craftercms.studio.api.v2.service.repository.internal.RepositoryManagementServiceInternal;

public class RepositoryManagementServiceImpl
implements RepositoryManagementService {
    private RepositoryManagementServiceInternal repositoryManagementServiceInternal;
    private SiteService siteService;
    private AuditServiceInternal auditServiceInternal;
    private SecurityService securityService;

    @Override
    @HasPermission(type=DefaultPermission.class, action="add_remote")
    public boolean addRemote(@ProtectedResourceId(value="siteId") String siteId, RemoteRepository remoteRepository) throws ServiceLayerException, InvalidRemoteUrlException {
        boolean toRet = this.repositoryManagementServiceInternal.addRemote(siteId, remoteRepository);
        this.insertAddRemoteAuditLog(siteId, "ADD_REMOTE", remoteRepository.getRemoteName(), remoteRepository.getRemoteName());
        return toRet;
    }

    private void insertAddRemoteAuditLog(String siteId, String operation, String primaryTargetId, String primaryTargetValue) throws SiteNotFoundException {
        SiteFeed siteFeed = this.siteService.getSite(siteId);
        String user = this.securityService.getCurrentUser();
        AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
        auditLog.setOperation(operation);
        auditLog.setSiteId(siteFeed.getId());
        auditLog.setActorId(user);
        auditLog.setPrimaryTargetId(primaryTargetId);
        auditLog.setPrimaryTargetType("Remote Repository");
        auditLog.setPrimaryTargetValue(primaryTargetValue);
        this.auditServiceInternal.insertAuditLog(auditLog);
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="list_remotes")
    public List<RemoteRepositoryInfo> listRemotes(@ProtectedResourceId(value="siteId") String siteId) throws ServiceLayerException, CryptoException {
        SiteFeed siteFeed = this.siteService.getSite(siteId);
        return this.repositoryManagementServiceInternal.listRemotes(siteId, siteFeed.getSandboxBranch());
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="pull_from_remote")
    public boolean pullFromRemote(@ProtectedResourceId(value="siteId") String siteId, String remoteName, String remoteBranch, String mergeStrategy) throws InvalidRemoteUrlException, CryptoException, ServiceLayerException {
        boolean toRet = this.repositoryManagementServiceInternal.pullFromRemote(siteId, remoteName, remoteBranch, mergeStrategy);
        this.insertAddRemoteAuditLog(siteId, "PULL_FROM_REMOTE", remoteName + "/" + remoteBranch, remoteName + "/" + remoteBranch);
        return toRet;
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="push_to_remote")
    public boolean pushToRemote(@ProtectedResourceId(value="siteId") String siteId, String remoteName, String remoteBranch, boolean force) throws InvalidRemoteUrlException, ServiceLayerException, CryptoException {
        boolean toRet = this.repositoryManagementServiceInternal.pushToRemote(siteId, remoteName, remoteBranch, force);
        this.insertAddRemoteAuditLog(siteId, "PUSH_TO_REMOTE", remoteName + "/" + remoteBranch, remoteName + "/" + remoteBranch);
        return toRet;
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="rebuild_database")
    public void rebuildDatabase(@ProtectedResourceId(value="siteId") String siteId) {
        this.siteService.rebuildDatabase(siteId);
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="remove_remote")
    public boolean removeRemote(@ProtectedResourceId(value="siteId") String siteId, String remoteName) throws CryptoException, SiteNotFoundException, RemoteNotRemovableException {
        boolean toRet = this.repositoryManagementServiceInternal.removeRemote(siteId, remoteName);
        this.insertAddRemoteAuditLog(siteId, "REMOVE_REMOTE", remoteName, remoteName);
        return toRet;
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="site_status")
    public RepositoryStatus getRepositoryStatus(@ProtectedResourceId(value="siteId") String siteId) throws CryptoException, ServiceLayerException {
        return this.repositoryManagementServiceInternal.getRepositoryStatus(siteId);
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="resolve_conflict")
    public RepositoryStatus resolveConflict(@ProtectedResourceId(value="siteId") String siteId, @ProtectedResourceId(value="path") String path, String resolution) throws CryptoException, ServiceLayerException {
        boolean success = this.repositoryManagementServiceInternal.resolveConflict(siteId, path, resolution);
        if (success) {
            return this.repositoryManagementServiceInternal.getRepositoryStatus(siteId);
        }
        throw new ServiceLayerException("Failed to resolve conflict for site " + siteId + " path " + path);
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="site_diff_conflicted_file")
    public DiffConflictedFile getDiffForConflictedFile(@ProtectedResourceId(value="siteId") String siteId, @ProtectedResourceId(value="path") String path) throws ServiceLayerException, CryptoException {
        return this.repositoryManagementServiceInternal.getDiffForConflictedFile(siteId, path);
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="commit_resolution")
    public RepositoryStatus commitResolution(@ProtectedResourceId(value="siteId") String siteId, String commitMessage) throws CryptoException, ServiceLayerException {
        boolean success = this.repositoryManagementServiceInternal.commitResolution(siteId, commitMessage);
        if (success) {
            return this.repositoryManagementServiceInternal.getRepositoryStatus(siteId);
        }
        throw new ServiceLayerException("Failed to commit conflict resolution for site " + siteId);
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="cancel_failed_pull")
    public RepositoryStatus cancelFailedPull(@ProtectedResourceId(value="siteId") String siteId) throws ServiceLayerException, CryptoException {
        boolean success = this.repositoryManagementServiceInternal.cancelFailedPull(siteId);
        if (success) {
            return this.repositoryManagementServiceInternal.getRepositoryStatus(siteId);
        }
        throw new ServiceLayerException("Failed to cancel failed pull from remote for site " + siteId);
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="unlock_repository")
    public boolean unlockRepository(@ProtectedResourceId(value="siteId") String siteId, GitRepositories repositoryType) throws CryptoException {
        return this.repositoryManagementServiceInternal.unlockRepository(siteId, repositoryType);
    }

    public RepositoryManagementServiceInternal getRepositoryManagementServiceInternal() {
        return this.repositoryManagementServiceInternal;
    }

    public void setRepositoryManagementServiceInternal(RepositoryManagementServiceInternal repositoryManagementServiceInternal) {
        this.repositoryManagementServiceInternal = repositoryManagementServiceInternal;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public AuditServiceInternal getAuditServiceInternal() {
        return this.auditServiceInternal;
    }

    public void setAuditServiceInternal(AuditServiceInternal auditServiceInternal) {
        this.auditServiceInternal = auditServiceInternal;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }
}

