/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.repository.internal;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.crypto.CryptoException;
import org.craftercms.commons.crypto.TextEncryptor;
import org.craftercms.studio.api.v1.constant.GitRepositories;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteUrlException;
import org.craftercms.studio.api.v1.exception.repository.RemoteAlreadyExistsException;
import org.craftercms.studio.api.v1.exception.repository.RemoteNotRemovableException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.GeneralLockService;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v2.annotation.RetryingOperation;
import org.craftercms.studio.api.v2.dal.ClusterDAO;
import org.craftercms.studio.api.v2.dal.ClusterMember;
import org.craftercms.studio.api.v2.dal.DiffConflictedFile;
import org.craftercms.studio.api.v2.dal.GitLog;
import org.craftercms.studio.api.v2.dal.RemoteRepository;
import org.craftercms.studio.api.v2.dal.RemoteRepositoryDAO;
import org.craftercms.studio.api.v2.dal.RemoteRepositoryInfo;
import org.craftercms.studio.api.v2.dal.RepositoryStatus;
import org.craftercms.studio.api.v2.dal.User;
import org.craftercms.studio.api.v2.repository.ContentRepository;
import org.craftercms.studio.api.v2.repository.RetryingRepositoryOperationFacade;
import org.craftercms.studio.api.v2.service.notification.NotificationService;
import org.craftercms.studio.api.v2.service.repository.internal.RepositoryManagementServiceInternal;
import org.craftercms.studio.api.v2.service.security.internal.UserServiceInternal;
import org.craftercms.studio.api.v2.utils.GitRepositoryHelper;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.DeleteBranchCommand;
import org.eclipse.jgit.api.DiffCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.RemoteAddCommand;
import org.eclipse.jgit.api.RemoteRemoveCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class RepositoryManagementServiceInternalImpl
implements RepositoryManagementServiceInternal {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryManagementServiceInternalImpl.class);
    private static final String THEIRS = "theirs";
    private static final String OURS = "ours";
    private RemoteRepositoryDAO remoteRepositoryDao;
    private StudioConfiguration studioConfiguration;
    private NotificationService notificationService;
    private SecurityService securityService;
    private UserServiceInternal userServiceInternal;
    private org.craftercms.studio.api.v1.repository.ContentRepository contentRepository;
    private TextEncryptor encryptor;
    private ClusterDAO clusterDao;
    private GeneralLockService generalLockService;
    private SiteService siteService;
    private ContentRepository contentRepositoryV2;
    private RetryingRepositoryOperationFacade retryingRepositoryOperationFacade;
    private int batchSizeGitLog = 1000;

    public RepositoryManagementServiceInternalImpl(RemoteRepositoryDAO remoteRepositoryDao, StudioConfiguration studioConfiguration, NotificationService notificationService, SecurityService securityService, UserServiceInternal userServiceInternal, org.craftercms.studio.api.v1.repository.ContentRepository contentRepository, TextEncryptor encryptor, ClusterDAO clusterDao, GeneralLockService generalLockService, SiteService siteService, ContentRepository contentRepositoryV2, RetryingRepositoryOperationFacade retryingRepositoryOperationFacade, int batchSizeGitLog) {
        this.remoteRepositoryDao = remoteRepositoryDao;
        this.studioConfiguration = studioConfiguration;
        this.notificationService = notificationService;
        this.securityService = securityService;
        this.userServiceInternal = userServiceInternal;
        this.contentRepository = contentRepository;
        this.encryptor = encryptor;
        this.clusterDao = clusterDao;
        this.generalLockService = generalLockService;
        this.siteService = siteService;
        this.contentRepositoryV2 = contentRepositoryV2;
        this.retryingRepositoryOperationFacade = retryingRepositoryOperationFacade;
        this.batchSizeGitLog = batchSizeGitLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addRemote(String siteId, RemoteRepository remoteRepository) throws ServiceLayerException, InvalidRemoteUrlException {
        boolean isValid = false;
        String gitLockKey = "{site}_SANDBOX_REPOSITORY_GIT_LOCK".replaceAll("\\{site\\}", siteId);
        this.generalLockService.lock(gitLockKey);
        try {
            logger.debug("Add remote " + remoteRepository.getRemoteName() + " to the sandbox repo for the site " + siteId, new Object[0]);
            GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
            Repository repo = helper.getRepository(siteId, GitRepositories.SANDBOX);
            try (Git git = new Git(repo);){
                StoredConfig storedConfig = repo.getConfig();
                Set remotes = storedConfig.getSubsections("remote");
                if (remotes.contains(remoteRepository.getRemoteName())) {
                    throw new RemoteAlreadyExistsException(remoteRepository.getRemoteName());
                }
                RemoteAddCommand remoteAddCommand = git.remoteAdd();
                remoteAddCommand.setName(remoteRepository.getRemoteName());
                remoteAddCommand.setUri(new URIish(remoteRepository.getRemoteUrl()));
                this.retryingRepositoryOperationFacade.call(remoteAddCommand);
                try {
                    isValid = helper.isRemoteValid(git, remoteRepository.getRemoteName(), remoteRepository.getAuthenticationType(), remoteRepository.getRemoteUsername(), remoteRepository.getRemotePassword(), remoteRepository.getRemoteToken(), remoteRepository.getRemotePrivateKey());
                }
                finally {
                    if (!isValid) {
                        RemoteRemoveCommand remoteRemoveCommand = git.remoteRemove();
                        remoteRemoveCommand.setRemoteName(remoteRepository.getRemoteName());
                        this.retryingRepositoryOperationFacade.call(remoteRemoveCommand);
                        List resultRemoteBranches = git.branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call();
                        ArrayList<String> branchesToDelete = new ArrayList<String>();
                        for (Ref remoteBranchRef : resultRemoteBranches) {
                            if (!remoteBranchRef.getName().startsWith("refs/remotes/" + remoteRepository.getRemoteName())) continue;
                            branchesToDelete.add(remoteBranchRef.getName());
                        }
                        if (CollectionUtils.isNotEmpty(branchesToDelete)) {
                            DeleteBranchCommand delBranch = git.branchDelete();
                            String[] array = new String[branchesToDelete.size()];
                            delBranch.setBranchNames(branchesToDelete.toArray(array));
                            delBranch.setForce(true);
                            this.retryingRepositoryOperationFacade.call(delBranch);
                        }
                    }
                }
            }
            catch (URISyntaxException e) {
                logger.error("Remote URL is invalid " + remoteRepository.getRemoteUrl(), e, new Object[0]);
                throw new InvalidRemoteUrlException();
            }
            catch (IOException | GitAPIException e) {
                logger.error("Error while adding remote " + remoteRepository.getRemoteName() + " (url: " + remoteRepository.getRemoteUrl() + ") for site " + siteId, (Exception)e, new Object[0]);
                throw new ServiceLayerException("Error while adding remote " + remoteRepository.getRemoteName() + " (url: " + remoteRepository.getRemoteUrl() + ") for site " + siteId, (Exception)e);
            }
            if (isValid) {
                this.insertRemoteToDb(siteId, remoteRepository);
            }
        }
        catch (CryptoException e) {
            throw new ServiceLayerException(e);
        }
        finally {
            this.generalLockService.unlock(gitLockKey);
        }
        return isValid;
    }

    private void insertRemoteToDb(String siteId, RemoteRepository remoteRepository) throws CryptoException {
        logger.debug("Inserting remote " + remoteRepository.getRemoteName() + " for site " + siteId + " into database.", new Object[0]);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("siteId", siteId);
        params.put("remoteName", remoteRepository.getRemoteName());
        params.put("remoteUrl", remoteRepository.getRemoteUrl());
        params.put("authenticationType", remoteRepository.getAuthenticationType());
        params.put("remoteUsername", remoteRepository.getRemoteUsername());
        if (StringUtils.isNotEmpty((CharSequence)remoteRepository.getRemotePassword())) {
            logger.debug("Encrypt password before inserting to database", new Object[0]);
            String hashedPassword = this.encryptor.encrypt(remoteRepository.getRemotePassword());
            params.put("remotePassword", hashedPassword);
        } else {
            params.put("remotePassword", remoteRepository.getRemotePassword());
        }
        if (StringUtils.isNotEmpty((CharSequence)remoteRepository.getRemoteToken())) {
            logger.debug("Encrypt token before inserting to database", new Object[0]);
            String hashedToken = this.encryptor.encrypt(remoteRepository.getRemoteToken());
            params.put("remoteToken", hashedToken);
        } else {
            params.put("remoteToken", remoteRepository.getRemoteToken());
        }
        if (StringUtils.isNotEmpty((CharSequence)remoteRepository.getRemotePrivateKey())) {
            logger.debug("Encrypt private key before inserting to database", new Object[0]);
            String hashedPrivateKey = this.encryptor.encrypt(remoteRepository.getRemotePrivateKey());
            params.put("remotePrivateKey", hashedPrivateKey);
        } else {
            params.put("remotePrivateKey", remoteRepository.getRemotePrivateKey());
        }
        logger.debug("Insert site remote record into database", new Object[0]);
        this.remoteRepositoryDao.insertRemoteRepository(params);
    }

    @Override
    public List<RemoteRepositoryInfo> listRemotes(String siteId, String sandboxBranch) throws ServiceLayerException, CryptoException {
        List<RemoteRepositoryInfo> res = new ArrayList<RemoteRepositoryInfo>();
        HashMap<String, String> unreachableRemotes = new HashMap<String, String>();
        GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
        try (Repository repo = helper.getRepository(siteId, GitRepositories.SANDBOX);){
            try (Git git = new Git(repo);){
                List resultRemotes = git.remoteList().call();
                if (CollectionUtils.isNotEmpty((Collection)resultRemotes)) {
                    for (RemoteConfig conf : resultRemotes) {
                        try {
                            this.fetchRemote(siteId, git, conf);
                        }
                        catch (Exception e) {
                            logger.warn("Failed to fetch from remote repository " + conf.getName(), new Object[0]);
                            unreachableRemotes.put(conf.getName(), e.getMessage());
                        }
                    }
                    Map<String, List<String>> remoteBranches = this.getRemoteBranches(git);
                    String sandboxBranchName = sandboxBranch;
                    if (StringUtils.isEmpty((CharSequence)sandboxBranchName)) {
                        sandboxBranchName = this.studioConfiguration.getProperty("studio.repo.siteSandboxBranch");
                    }
                    res = this.getRemoteRepositoryInfo(resultRemotes, remoteBranches, unreachableRemotes, sandboxBranchName);
                }
            }
            catch (GitAPIException e) {
                logger.error("Error getting remote repositories for site " + siteId, (Exception)((Object)e), new Object[0]);
            }
        }
        return res;
    }

    private void fetchRemote(String siteId, Git git, RemoteConfig conf) throws CryptoException, IOException, ServiceLayerException, GitAPIException {
        GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
        RemoteRepository remoteRepository = this.getRemoteRepository(siteId, conf.getName());
        if (remoteRepository != null) {
            Path tempKey = Files.createTempFile(UUID.randomUUID().toString(), ".tmp", new FileAttribute[0]);
            FetchCommand fetchCommand = git.fetch().setRemote(conf.getName());
            fetchCommand = helper.setAuthenticationForCommand(fetchCommand, remoteRepository.getAuthenticationType(), remoteRepository.getRemoteUsername(), remoteRepository.getRemotePassword(), remoteRepository.getRemoteToken(), remoteRepository.getRemotePrivateKey(), tempKey, true);
            this.retryingRepositoryOperationFacade.call(fetchCommand);
        }
    }

    private RemoteRepository getRemoteRepository(String siteId, String remoteName) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("siteId", siteId);
        params.put("remoteName", remoteName);
        return this.remoteRepositoryDao.getRemoteRepository(params);
    }

    private Map<String, List<String>> getRemoteBranches(Git git) throws GitAPIException {
        List resultRemoteBranches = git.branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call();
        HashMap<String, List<String>> remoteBranches = new HashMap<String, List<String>>();
        for (Ref remoteBranchRef : resultRemoteBranches) {
            String branchFullName = remoteBranchRef.getName().replace("refs/remotes/", "");
            String remotePart = "";
            String branchNamePart = "";
            int slashIndex = branchFullName.indexOf("/");
            if (slashIndex > 0) {
                remotePart = branchFullName.substring(0, slashIndex);
                branchNamePart = branchFullName.substring(slashIndex + 1);
            }
            if (!remoteBranches.containsKey(remotePart)) {
                remoteBranches.put(remotePart, new ArrayList());
            }
            ((List)remoteBranches.get(remotePart)).add(branchNamePart);
        }
        return remoteBranches;
    }

    private List<RemoteRepositoryInfo> getRemoteRepositoryInfo(List<RemoteConfig> resultRemotes, Map<String, List<String>> remoteBranches, Map<String, String> unreachableRemotes, String sandboxBranchName) {
        ArrayList<RemoteRepositoryInfo> res = new ArrayList<RemoteRepositoryInfo>();
        for (RemoteConfig conf : resultRemotes) {
            List<String> branches;
            RemoteRepositoryInfo rri = new RemoteRepositoryInfo();
            rri.setName(conf.getName());
            if (MapUtils.isNotEmpty(unreachableRemotes) && unreachableRemotes.containsKey(conf.getName())) {
                rri.setReachable(false);
                rri.setUnreachableReason(unreachableRemotes.get(conf.getName()));
            }
            if (CollectionUtils.isEmpty(branches = remoteBranches.get(rri.getName()))) {
                branches = new ArrayList<String>();
                branches.add(sandboxBranchName);
            }
            rri.setBranches(branches);
            StringBuilder sbUrl = new StringBuilder();
            if (CollectionUtils.isNotEmpty((Collection)conf.getURIs())) {
                for (int i = 0; i < conf.getURIs().size(); ++i) {
                    sbUrl.append(((URIish)conf.getURIs().get(i)).toString());
                    if (i >= conf.getURIs().size() - 1) continue;
                    sbUrl.append(":");
                }
            }
            rri.setUrl(sbUrl.toString());
            StringBuilder sbFetch = new StringBuilder();
            if (CollectionUtils.isNotEmpty((Collection)conf.getFetchRefSpecs())) {
                for (int i = 0; i < conf.getFetchRefSpecs().size(); ++i) {
                    sbFetch.append(((RefSpec)conf.getFetchRefSpecs().get(i)).toString());
                    if (i >= conf.getFetchRefSpecs().size() - 1) continue;
                    sbFetch.append(":");
                }
            }
            rri.setFetch(sbFetch.toString());
            StringBuilder sbPushUrl = new StringBuilder();
            if (CollectionUtils.isNotEmpty((Collection)conf.getPushURIs())) {
                for (int i = 0; i < conf.getPushURIs().size(); ++i) {
                    sbPushUrl.append(((URIish)conf.getPushURIs().get(i)).toString());
                    if (i >= conf.getPushURIs().size() - 1) continue;
                    sbPushUrl.append(":");
                }
            } else {
                sbPushUrl.append(rri.getUrl());
            }
            rri.setPushUrl(sbPushUrl.toString());
            res.add(rri);
        }
        return res;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean pullFromRemote(String siteId, String remoteName, String remoteBranch, String mergeStrategy) throws InvalidRemoteUrlException, ServiceLayerException, CryptoException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<String> extractCommitIdsFromPullResult(String siteId, Repository repo, PullResult pullResult) {
        ArrayList<String> commitIds = new ArrayList<String>();
        ObjectId[] mergedCommits = pullResult.getMergeResult().getMergedCommits();
        for (int i = 0; i < mergedCommits.length; ++i) {
            try {
                RevCommit revCommit = repo.parseCommit((AnyObjectId)mergedCommits[i]);
                commitIds.addAll(this.processCommitId(siteId, revCommit));
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return commitIds;
    }

    private Set<String> processCommitId(String siteId, RevCommit revCommit) {
        HashSet<String> toRet = new HashSet<String>();
        LinkedList<RevCommit> commitIdsQueue = new LinkedList<RevCommit>();
        commitIdsQueue.offer(revCommit);
        while (!commitIdsQueue.isEmpty()) {
            GitLog gitLog;
            String cId;
            RevCommit rc = (RevCommit)commitIdsQueue.poll();
            if (!Objects.nonNull(rc) || toRet.contains(cId = rc.getName()) || !Objects.isNull(gitLog = this.contentRepositoryV2.getGitLog(siteId, cId))) continue;
            RevCommit[] parents = rc.getParents();
            if (Objects.nonNull(parents) && parents.length > 0) {
                for (int i = 0; i < parents.length; ++i) {
                    commitIdsQueue.offer(parents[i]);
                }
            }
            toRet.add(cId);
        }
        return toRet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean pushToRemote(String siteId, String remoteName, String remoteBranch, boolean force) throws CryptoException, ServiceLayerException, InvalidRemoteUrlException {
        logger.debug("Get remote data from database for remote " + remoteName + " and site " + siteId, new Object[0]);
        RemoteRepository remoteRepository = this.getRemoteRepository(siteId, remoteName);
        logger.debug("Prepare push command.", new Object[0]);
        GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
        Repository repo = helper.getRepository(siteId, GitRepositories.SANDBOX);
        try (Git git = new Git(repo);){
            Iterable pushResultIterable = null;
            PushCommand pushCommand = git.push();
            logger.debug("Set remote " + remoteName, new Object[0]);
            pushCommand.setRemote(remoteRepository.getRemoteName());
            logger.debug("Set branch to be " + remoteBranch, new Object[0]);
            RefSpec r = new RefSpec();
            r = r.setSourceDestination("refs/heads/" + repo.getBranch(), "refs/heads/" + remoteBranch);
            pushCommand.setRefSpecs(new RefSpec[]{r});
            Path tempKey = Files.createTempFile(UUID.randomUUID().toString(), ".tmp", new FileAttribute[0]);
            pushCommand = helper.setAuthenticationForCommand(pushCommand, remoteRepository.getAuthenticationType(), remoteRepository.getRemoteUsername(), remoteRepository.getRemotePassword(), remoteRepository.getRemoteToken(), remoteRepository.getRemotePrivateKey(), tempKey, true);
            pushCommand.setForce(force);
            pushResultIterable = (Iterable)this.retryingRepositoryOperationFacade.call(pushCommand);
            Files.delete(tempKey);
            boolean toRet = true;
            Iterator iterator = pushResultIterable.iterator();
            block18: while (true) {
                PushResult pushResult;
                if (iterator.hasNext()) {
                    pushResult = (PushResult)iterator.next();
                    String pushResultMessage = pushResult.getMessages();
                    if (StringUtils.isNotEmpty((CharSequence)pushResultMessage)) {
                        logger.info(pushResultMessage, new Object[0]);
                    }
                } else {
                    boolean bl = toRet;
                    return bl;
                }
                Collection updates = pushResult.getRemoteUpdates();
                Iterator iterator2 = updates.iterator();
                block19: while (true) {
                    if (!iterator2.hasNext()) continue block18;
                    RemoteRefUpdate remoteRefUpdate = (RemoteRefUpdate)iterator2.next();
                    switch (remoteRefUpdate.getStatus()) {
                        case REJECTED_NODELETE: {
                            toRet = false;
                            logger.error("Remote ref " + remoteRefUpdate.getSrcRef() + " update was rejected, because remote side doesn't support/allow deleting refs.\n" + remoteRefUpdate.getMessage(), new Object[0]);
                        }
                        case REJECTED_NONFASTFORWARD: {
                            toRet = false;
                            logger.error("Remote ref " + remoteRefUpdate.getSrcRef() + " update was rejected, as it would cause non fast-forward update.\n" + remoteRefUpdate.getMessage(), new Object[0]);
                        }
                        case REJECTED_REMOTE_CHANGED: {
                            toRet = false;
                            logger.error("Remote ref " + remoteRefUpdate.getSrcRef() + " update was rejected, because old object id on remote repository " + remoteRefUpdate.getRemoteName() + " wasn't the same as defined expected old object. \n" + remoteRefUpdate.getMessage(), new Object[0]);
                        }
                        case REJECTED_OTHER_REASON: {
                            toRet = false;
                            logger.error("Remote ref " + remoteRefUpdate.getSrcRef() + " update was rejected for other reason.\n" + remoteRefUpdate.getMessage(), new Object[0]);
                            continue block19;
                        }
                    }
                }
                break;
            }
        }
        catch (InvalidRemoteException e) {
            logger.error("Remote is invalid " + remoteName, (Exception)((Object)e), new Object[0]);
            throw new InvalidRemoteUrlException();
        }
        catch (IOException | CryptoException | GitAPIException | JGitInternalException e) {
            logger.error("Error while pushing to remote " + remoteName + " branch " + remoteBranch + " for site " + siteId, (Exception)e, new Object[0]);
            throw new ServiceLayerException("Error while pushing to remote " + remoteName + " branch " + remoteBranch + " for site " + siteId, (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RetryingOperation
    public boolean removeRemote(String siteId, String remoteName) throws CryptoException, RemoteNotRemovableException {
        if (!this.isRemovableRemote(siteId, remoteName)) {
            throw new RemoteNotRemovableException("Remote repository " + remoteName + " is not removable");
        }
        logger.debug("Remove remote " + remoteName + " from the sandbox repo for the site " + siteId, new Object[0]);
        GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
        Repository repo = helper.getRepository(siteId, GitRepositories.SANDBOX);
        String gitLockKey = "{site}_SANDBOX_REPOSITORY_GIT_LOCK".replaceAll("\\{site\\}", siteId);
        this.generalLockService.lock(gitLockKey);
        try (Git git = new Git(repo);){
            RemoteRemoveCommand remoteRemoveCommand = git.remoteRemove();
            remoteRemoveCommand.setRemoteName(remoteName);
            this.retryingRepositoryOperationFacade.call(remoteRemoveCommand);
            List resultRemoteBranches = git.branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call();
            ArrayList<String> branchesToDelete = new ArrayList<String>();
            for (Ref remoteBranchRef : resultRemoteBranches) {
                if (!remoteBranchRef.getName().startsWith("refs/remotes/" + remoteName)) continue;
                branchesToDelete.add(remoteBranchRef.getName());
            }
            if (CollectionUtils.isNotEmpty(branchesToDelete)) {
                DeleteBranchCommand delBranch = git.branchDelete();
                String[] array = new String[branchesToDelete.size()];
                delBranch.setBranchNames(branchesToDelete.toArray(array));
                delBranch.setForce(true);
                this.retryingRepositoryOperationFacade.call(delBranch);
            }
        }
        catch (GitAPIException e) {
            logger.error("Failed to remove remote " + remoteName + " for site " + siteId, (Exception)((Object)e), new Object[0]);
            boolean bl = false;
            return bl;
        }
        finally {
            this.generalLockService.unlock(gitLockKey);
        }
        logger.debug("Remove remote record from database for remote " + remoteName + " and site " + siteId, new Object[0]);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("siteId", siteId);
        params.put("remoteName", remoteName);
        this.remoteRepositoryDao.deleteRemoteRepository(params);
        return true;
    }

    private boolean isRemovableRemote(String siteId, String remoteName) {
        boolean toRet = true;
        if (StringUtils.startsWith((CharSequence)remoteName, (CharSequence)"cluster_node_")) {
            RemoteRepository remoteRepository = this.getRemoteRepository(siteId, remoteName);
            List<ClusterMember> clusterMembers = this.getClusterMembersByRemoteName(remoteName);
            toRet = !Objects.isNull(remoteRepository) || !CollectionUtils.isNotEmpty(clusterMembers);
        }
        return toRet;
    }

    private List<ClusterMember> getClusterMembersByRemoteName(String remoteName) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("remoteName", remoteName);
        return this.clusterDao.getMemberByRemoteName(params);
    }

    @Override
    public RepositoryStatus getRepositoryStatus(String siteId) throws CryptoException, ServiceLayerException {
        GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
        Repository repo = helper.getRepository(siteId, GitRepositories.SANDBOX);
        RepositoryStatus repositoryStatus = new RepositoryStatus();
        logger.debug("Execute git status and return conflicting paths and uncommitted changes", new Object[0]);
        try (Git git = new Git(repo);){
            Status status = git.status().call();
            repositoryStatus.setClean(status.isClean());
            repositoryStatus.setConflicting(status.getConflicting());
            repositoryStatus.setUncommittedChanges(status.getUncommittedChanges());
        }
        catch (GitAPIException e) {
            logger.error("Error while getting repository status for site " + siteId, (Exception)((Object)e), new Object[0]);
            throw new ServiceLayerException("Error getting repository status for site " + siteId, (Exception)((Object)e));
        }
        return repositoryStatus;
    }

    @Override
    public boolean resolveConflict(String siteId, String path, String resolution) throws CryptoException, ServiceLayerException {
        GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
        Repository repo = helper.getRepository(siteId, GitRepositories.SANDBOX);
        String gitLockKey = "{site}_SANDBOX_REPOSITORY_GIT_LOCK".replaceAll("\\{site\\}", siteId);
        this.generalLockService.lock(gitLockKey);
        try (Git git = new Git(repo);){
            switch (resolution.toLowerCase()) {
                case "ours": {
                    logger.debug("Resolve conflict using OURS strategy for site " + siteId + " and path " + path, new Object[0]);
                    logger.debug("Reset merge conflict in git index", new Object[0]);
                    ResetCommand resetCommand = git.reset().addPath(helper.getGitPath(path));
                    this.retryingRepositoryOperationFacade.call(resetCommand);
                    logger.debug("Checkout content from HEAD of studio repository", new Object[0]);
                    CheckoutCommand checkoutCommand = git.checkout().addPath(helper.getGitPath(path)).setStartPoint("HEAD");
                    this.retryingRepositoryOperationFacade.call(checkoutCommand);
                    break;
                }
                case "theirs": {
                    logger.debug("Resolve conflict using THEIRS strategy for site " + siteId + " and path " + path, new Object[0]);
                    logger.debug("Reset merge conflict in git index", new Object[0]);
                    ResetCommand resetCommand = git.reset().addPath(helper.getGitPath(path));
                    this.retryingRepositoryOperationFacade.call(resetCommand);
                    logger.debug("Checkout content from merge HEAD of remote repository", new Object[0]);
                    List mergeHeads = repo.readMergeHeads();
                    ObjectId mergeCommitId = (ObjectId)mergeHeads.get(0);
                    CheckoutCommand checkoutCommand = git.checkout().addPath(helper.getGitPath(path)).setStartPoint(mergeCommitId.getName());
                    this.retryingRepositoryOperationFacade.call(checkoutCommand);
                    break;
                }
                default: {
                    throw new ServiceLayerException("Unsupported resolution strategy for repository conflicts");
                }
            }
            if (repo.getRepositoryState() == RepositoryState.MERGING_RESOLVED) {
                logger.debug("Merge resolved. Check if there are no uncommitted changes (repo is clean)", new Object[0]);
                Status status = git.status().call();
                if (!status.hasUncommittedChanges()) {
                    logger.debug("Repository is clean. Committing to complete merge", new Object[0]);
                    String userName = this.securityService.getCurrentUser();
                    User user = this.userServiceInternal.getUserByIdOrUsername(-1L, userName);
                    PersonIdent personIdent = helper.getAuthorIdent(user);
                    CommitCommand commitCommand = git.commit().setAllowEmpty(true).setMessage("Merge resolved. Repo is clean (no changes)").setAuthor(personIdent);
                    this.retryingRepositoryOperationFacade.call(commitCommand);
                }
            }
        }
        catch (IOException | ServiceLayerException | UserNotFoundException | GitAPIException e) {
            logger.error("Error while resolving conflict for site " + siteId + " using " + resolution + " resolution strategy", (Exception)e, new Object[0]);
            throw new ServiceLayerException("Error while resolving conflict for site " + siteId + " using " + resolution + " resolution strategy", (Exception)e);
        }
        finally {
            this.generalLockService.unlock(gitLockKey);
        }
        return true;
    }

    @Override
    public DiffConflictedFile getDiffForConflictedFile(String siteId, String path) throws ServiceLayerException, CryptoException {
        DiffConflictedFile diffResult = new DiffConflictedFile();
        GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
        Repository repo = helper.getRepository(siteId, GitRepositories.SANDBOX);
        try (Git git = new Git(repo);){
            List mergeHeads = repo.readMergeHeads();
            ObjectId mergeCommitId = (ObjectId)mergeHeads.get(0);
            logger.debug("Get content for studio version of conflicted file " + path + " for site " + siteId, new Object[0]);
            InputStream studioVersionIs = this.contentRepository.getContentVersion(siteId, path, "HEAD");
            diffResult.setStudioVersion(IOUtils.toString((InputStream)studioVersionIs));
            logger.debug("Get content for remote version of conflicted file " + path + " for site " + siteId, new Object[0]);
            InputStream remoteVersionIs = this.contentRepository.getContentVersion(siteId, path, mergeCommitId.getName());
            diffResult.setRemoteVersion(IOUtils.toString((InputStream)remoteVersionIs));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            logger.debug("Get diff between studio and remote version of conflicted file " + path + " for site " + siteId, new Object[0]);
            RevTree headTree = helper.getTreeForCommit(repo, "HEAD");
            RevTree remoteTree = helper.getTreeForCommit(repo, mergeCommitId.getName());
            try (ObjectReader reader = repo.newObjectReader();){
                CanonicalTreeParser headCommitTreeParser = new CanonicalTreeParser();
                CanonicalTreeParser remoteCommitTreeParser = new CanonicalTreeParser();
                headCommitTreeParser.reset(reader, (AnyObjectId)headTree.getId());
                remoteCommitTreeParser.reset(reader, (AnyObjectId)remoteTree.getId());
                DiffCommand diffCommand = git.diff().setPathFilter((TreeFilter)PathFilter.create((String)helper.getGitPath(path))).setOldTree((AbstractTreeIterator)headCommitTreeParser).setNewTree((AbstractTreeIterator)remoteCommitTreeParser).setOutputStream((OutputStream)baos);
                this.retryingRepositoryOperationFacade.call(diffCommand);
                diffResult.setDiff(baos.toString());
            }
        }
        catch (IOException | GitAPIException e) {
            logger.error("Error while getting diff for conflicting file " + path + " site " + siteId, new Object[0]);
            throw new ServiceLayerException("Error while getting diff for conflicting file " + path + " site " + siteId);
        }
        return diffResult;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean commitResolution(String siteId, String commitMessage) throws CryptoException, ServiceLayerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean cancelFailedPull(String siteId) throws ServiceLayerException, CryptoException {
        logger.debug("To cancel failed pull, reset hard needs to be executed", new Object[0]);
        GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
        Repository repo = helper.getRepository(siteId, GitRepositories.SANDBOX);
        String gitLockKey = "{site}_SANDBOX_REPOSITORY_GIT_LOCK".replaceAll("\\{site\\}", siteId);
        this.generalLockService.lock(gitLockKey);
        try (Git git = new Git(repo);){
            ResetCommand resetCommand = git.reset().setMode(ResetCommand.ResetType.HARD);
            this.retryingRepositoryOperationFacade.call(resetCommand);
        }
        catch (GitAPIException e) {
            logger.error("Error while canceling failed pull for site " + siteId, (Exception)((Object)e), new Object[0]);
            throw new ServiceLayerException("Reset hard failed for site " + siteId, (Exception)((Object)e));
        }
        finally {
            this.generalLockService.unlock(gitLockKey);
        }
        return true;
    }

    private boolean conflictNotificationEnabled() {
        return Boolean.parseBoolean(this.studioConfiguration.getProperty("studio.repo.pullFromRemote.conflict.notificationEnabled"));
    }

    @Override
    public boolean unlockRepository(String siteId, GitRepositories repositoryType) throws CryptoException {
        boolean toRet = false;
        GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
        Repository repo = helper.getRepository(siteId, repositoryType);
        if (Objects.nonNull(repo)) {
            toRet = FileUtils.deleteQuietly((File)Paths.get(repo.getDirectory().getAbsolutePath(), "index.lock").toFile());
        }
        return toRet;
    }

    private static /* synthetic */ void lambda$pullFromRemote$0(List conflictFiles, String m, int[][] v) {
        conflictFiles.add(m);
    }
}

