/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.search;

import java.io.IOException;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.craftercms.search.elasticsearch.impl.AbstractElasticsearchWrapper;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class PermissionAwareSearchService
extends AbstractElasticsearchWrapper {
    protected String indexSuffix;
    protected String pathFieldName;

    public PermissionAwareSearchService(RestHighLevelClient client, String indexSuffix, String pathFieldName) {
        super(client);
        this.indexSuffix = indexSuffix;
        this.pathFieldName = pathFieldName;
    }

    public SearchResponse search(String siteId, List<String> allowedPaths, SearchRequest request) throws IOException {
        return this.search(siteId, allowedPaths, request, RequestOptions.DEFAULT);
    }

    public SearchResponse search(String siteId, List<String> allowedPaths, SearchRequest request, RequestOptions options) throws IOException {
        request.indices(new String[]{siteId + this.indexSuffix});
        if (CollectionUtils.isNotEmpty(allowedPaths)) {
            this.updateFilters(request, allowedPaths);
        }
        return this.client.search(request, options);
    }

    protected void updateFilters(SearchRequest request, List<String> allowedPaths) {
        QueryBuilder query = request.source().query();
        BoolQueryBuilder boolQuery = query instanceof BoolQueryBuilder ? (BoolQueryBuilder)query : QueryBuilders.boolQuery().must(query);
        allowedPaths.forEach(path -> boolQuery.filter((QueryBuilder)QueryBuilders.regexpQuery((String)this.pathFieldName, (String)(path + ".*"))));
        request.source().query((QueryBuilder)boolQuery);
    }

    protected void updateIndex(SearchRequest request) {
    }

    public SearchResponse search(SearchRequest request, RequestOptions options) {
        throw new UnsupportedOperationException();
    }
}

