/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.search;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.security.AuthenticationException;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v2.service.search.SearchService;
import org.craftercms.studio.api.v2.service.search.internal.SearchServiceInternal;
import org.craftercms.studio.model.search.SearchParams;
import org.craftercms.studio.model.search.SearchResult;
import org.springframework.beans.factory.annotation.Required;

public class SearchServiceImpl
implements SearchService {
    protected SecurityService securityService;
    protected SearchServiceInternal searchServiceInternal;

    @Required
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Required
    public void setSearchServiceInternal(SearchServiceInternal searchServiceInternal) {
        this.searchServiceInternal = searchServiceInternal;
    }

    @Override
    public SearchResult search(String siteId, SearchParams params) throws AuthenticationException, ServiceLayerException {
        String user = this.securityService.getCurrentUser();
        if (StringUtils.isNotEmpty((CharSequence)user)) {
            List<String> allowedPaths = Collections.emptyList();
            return this.searchServiceInternal.search(siteId, allowedPaths, params);
        }
        throw new AuthenticationException("User is not authenticated");
    }
}

