/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.search.internal;

import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.to.FacetRangeTO;
import org.craftercms.studio.api.v1.to.FacetTO;
import org.craftercms.studio.api.v2.service.search.internal.SearchServiceInternal;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.impl.v2.service.search.PermissionAwareSearchService;
import org.craftercms.studio.model.search.SearchFacet;
import org.craftercms.studio.model.search.SearchFacetRange;
import org.craftercms.studio.model.search.SearchParams;
import org.craftercms.studio.model.search.SearchResult;
import org.craftercms.studio.model.search.SearchResultItem;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.search.MatchQuery;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.range.DateRangeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.range.Range;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Required;

public class SearchServiceInternalImpl
implements SearchServiceInternal {
    public static final String CONFIG_KEY_FACETS = "studio.search.facets";
    public static final String CONFIG_KEY_TYPES = "studio.search.types";
    public static final String CONFIG_KEY_FACET_NAME = "name";
    public static final String CONFIG_KEY_FACET_FIELD = "field";
    public static final String CONFIG_KEY_FACET_DATE = "date";
    public static final String CONFIG_KEY_FACET_MULTIPLE = "multiple";
    public static final String CONFIG_KEY_FACET_RANGES = "ranges";
    public static final String CONFIG_KEY_FACET_RANGE_LABEL = "label";
    public static final String CONFIG_KEY_FACET_RANGE_FROM = "from";
    public static final String CONFIG_KEY_FACET_RANGE_TO = "to";
    public static final String CONFIG_KEY_TYPE_FIELD = "field";
    public static final String CONFIG_KEY_TYPE_NAME = "name";
    public static final String CONFIG_KEY_TYPE_MATCHES = "matches";
    public static final String FACET_RANGE_MIN = "min";
    public static final String FACET_RANGE_MAX = "max";
    public static final String DEFAULT_MIME_TYPE = "application/xml";
    protected String pathFieldName;
    protected String internalNameFieldName;
    protected String lastEditFieldName;
    protected String lastEditorFieldName;
    protected String sizeFieldName;
    protected String mimeTypeName;
    protected String[] searchFields;
    protected String[] highlightFields;
    protected int snippetSize;
    protected int numberOfSnippets;
    protected String defaultType;
    protected PermissionAwareSearchService elasticsearchService;
    protected StudioConfiguration studioConfiguration;
    protected ServicesConfig servicesConfig;
    protected Map<String, FacetTO> facets;
    protected Map<String, HierarchicalConfiguration<ImmutableNode>> types;

    @Required
    public void setPathFieldName(String pathFieldName) {
        this.pathFieldName = pathFieldName;
    }

    @Required
    public void setInternalNameFieldName(String internalNameFieldName) {
        this.internalNameFieldName = internalNameFieldName;
    }

    @Required
    public void setLastEditFieldName(String lastEditFieldName) {
        this.lastEditFieldName = lastEditFieldName;
    }

    @Required
    public void setLastEditorFieldName(String lastEditorFieldName) {
        this.lastEditorFieldName = lastEditorFieldName;
    }

    @Required
    public void setSizeFieldName(String sizeFieldName) {
        this.sizeFieldName = sizeFieldName;
    }

    @Required
    public void setMimeTypeName(String mimeTypeName) {
        this.mimeTypeName = mimeTypeName;
    }

    @Required
    public void setDefaultType(String defaultType) {
        this.defaultType = defaultType;
    }

    @Required
    public void setSearchFields(String[] searchFields) {
        this.searchFields = searchFields;
    }

    @Required
    public void setHighlightFields(String[] highlightFields) {
        this.highlightFields = highlightFields;
    }

    @Required
    public void setSnippetSize(int snippetSize) {
        this.snippetSize = snippetSize;
    }

    @Required
    public void setNumberOfSnippets(int numberOfSnippets) {
        this.numberOfSnippets = numberOfSnippets;
    }

    @Required
    public void setElasticsearchService(PermissionAwareSearchService elasticsearchService) {
        this.elasticsearchService = elasticsearchService;
    }

    @Required
    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    @Required
    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    public void init() {
        this.loadTypesFromGlobalConfiguration();
        this.loadFacetsFromGlobalConfiguration();
    }

    protected void loadFacetsFromGlobalConfiguration() {
        this.facets = new HashMap<String, FacetTO>();
        List<HierarchicalConfiguration<ImmutableNode>> facetsConfig = this.studioConfiguration.getSubConfigs(CONFIG_KEY_FACETS);
        if (CollectionUtils.isNotEmpty(facetsConfig)) {
            facetsConfig.forEach(facetConfig -> {
                FacetTO facet = new FacetTO();
                facet.setName(facetConfig.getString("name"));
                facet.setField(facetConfig.getString("field"));
                facet.setDate(facetConfig.getBoolean(CONFIG_KEY_FACET_DATE, false));
                facet.setMultiple(facetConfig.getBoolean(CONFIG_KEY_FACET_MULTIPLE, false));
                List ranges = facetConfig.configurationsAt(CONFIG_KEY_FACET_RANGES);
                if (CollectionUtils.isNotEmpty((Collection)ranges)) {
                    facet.setRanges(ranges.stream().map(rangeConfig -> {
                        FacetRangeTO range = new FacetRangeTO();
                        range.setLabel(rangeConfig.getString(CONFIG_KEY_FACET_RANGE_LABEL));
                        if (rangeConfig.containsKey(CONFIG_KEY_FACET_RANGE_FROM) && rangeConfig.containsKey(CONFIG_KEY_FACET_RANGE_TO)) {
                            range.setFrom(rangeConfig.getString(CONFIG_KEY_FACET_RANGE_FROM));
                            range.setTo(rangeConfig.getString(CONFIG_KEY_FACET_RANGE_TO));
                        } else if (rangeConfig.containsKey(CONFIG_KEY_FACET_RANGE_FROM)) {
                            range.setFrom(rangeConfig.getString(CONFIG_KEY_FACET_RANGE_FROM));
                        } else {
                            range.setTo(rangeConfig.getString(CONFIG_KEY_FACET_RANGE_TO));
                        }
                        return range;
                    }).collect(Collectors.toList()));
                }
                this.facets.put(facet.getName(), facet);
            });
        }
    }

    protected void loadTypesFromGlobalConfiguration() {
        this.types = new LinkedHashMap<String, HierarchicalConfiguration<ImmutableNode>>();
        List<HierarchicalConfiguration<ImmutableNode>> typesConfig = this.studioConfiguration.getSubConfigs(CONFIG_KEY_TYPES);
        typesConfig.forEach(type -> this.types.put(type.getString("name"), (HierarchicalConfiguration<ImmutableNode>)type));
    }

    protected SearchResultItem processSearchHit(Map<String, Object> source, Map<String, HighlightField> highlights) {
        SearchResultItem item = new SearchResultItem();
        item.setPath((String)source.get(this.pathFieldName));
        item.setName((String)source.get(this.internalNameFieldName));
        item.setLastModified(Instant.parse((String)source.get(this.lastEditFieldName)));
        item.setLastModifier(source.get(this.lastEditorFieldName).toString());
        item.setSize(Long.parseLong(source.get(this.sizeFieldName).toString()));
        item.setType(this.getItemType(source));
        item.setMimeType(this.getMimeType(source));
        item.setSnippets(this.getItemSnippets(highlights));
        return item;
    }

    protected void updateFilters(BoolQueryBuilder query, SearchParams params, Map<String, FacetTO> siteFacets) {
        params.getFilters().forEach((filter, value) -> {
            FacetTO facetConfig = MapUtils.isNotEmpty((Map)siteFacets) ? siteFacets.getOrDefault(filter, this.facets.get(filter)) : this.facets.get(filter);
            if (Objects.nonNull(facetConfig)) {
                String fieldName = facetConfig.getField();
                if (facetConfig.isRange()) {
                    RangeQueryBuilder rangeQuery = QueryBuilders.rangeQuery((String)fieldName);
                    Map range = (Map)value;
                    rangeQuery.gte(range.get(FACET_RANGE_MIN)).lt(range.get(FACET_RANGE_MAX));
                    query.filter((QueryBuilder)rangeQuery);
                } else if (facetConfig.isMultiple() && value instanceof List) {
                    List values = (List)value;
                    BoolQueryBuilder orQuery = QueryBuilders.boolQuery();
                    values.forEach(val -> orQuery.should((QueryBuilder)QueryBuilders.matchQuery((String)fieldName, (Object)val)));
                    query.filter((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)orQuery));
                } else {
                    query.filter((QueryBuilder)QueryBuilders.matchQuery((String)fieldName, (Object)value));
                }
            }
        });
    }

    protected void updateHighlighting(SearchSourceBuilder builder) {
        HighlightBuilder highlight = SearchSourceBuilder.highlight();
        for (String field : this.highlightFields) {
            highlight.field(field, this.snippetSize, this.numberOfSnippets);
        }
        builder.highlighter(highlight);
    }

    protected SearchResult processResults(SearchResponse response, Map<String, FacetTO> siteFacets) {
        SearchResult result = new SearchResult();
        result.setTotal(response.getHits().getTotalHits());
        List<SearchResultItem> items = Stream.of(response.getHits().getHits()).map(hit -> this.processSearchHit(hit.getSourceAsMap(), hit.getHighlightFields())).collect(Collectors.toList());
        result.setItems(items);
        result.setFacets(this.processAggregations(response, siteFacets));
        return result;
    }

    @Override
    public SearchResult search(String siteId, List<String> allowedPaths, SearchParams params) throws ServiceLayerException {
        String rawKeywords;
        Map<String, FacetTO> siteFacets = this.servicesConfig.getFacets(siteId);
        BoolQueryBuilder query = QueryBuilders.boolQuery();
        if (StringUtils.isNotEmpty((CharSequence)params.getQuery())) {
            query.must((QueryBuilder)QueryBuilders.queryStringQuery((String)params.getQuery()));
        }
        if (StringUtils.isNotEmpty((CharSequence)(rawKeywords = params.getKeywords()))) {
            rawKeywords = rawKeywords.replaceAll("[^\\p{IsAlphabetic}\\p{Digit}\\s]", "").trim();
            BoolQueryBuilder keywordsQuery = QueryBuilders.boolQuery();
            Object[] keywords = rawKeywords.split(" ");
            if (ArrayUtils.isNotEmpty((Object[])keywords)) {
                keywordsQuery.should((QueryBuilder)QueryBuilders.multiMatchQuery((Object)rawKeywords, (String[])this.searchFields).type((Object)MatchQuery.Type.PHRASE_PREFIX));
                for (Object keyword : keywords) {
                    keywordsQuery.should((QueryBuilder)QueryBuilders.regexpQuery((String)this.pathFieldName, (String)(".*" + (String)keyword + ".*"))).should((QueryBuilder)QueryBuilders.multiMatchQuery((Object)keyword, (String[])this.searchFields));
                }
            }
            query.must((QueryBuilder)keywordsQuery);
        }
        if (StringUtils.isNotEmpty((CharSequence)params.getPath())) {
            query.filter((QueryBuilder)QueryBuilders.regexpQuery((String)this.pathFieldName, (String)params.getPath()));
        }
        if (MapUtils.isNotEmpty(params.getFilters())) {
            this.updateFilters(query, params, siteFacets);
        }
        SearchSourceBuilder builder = new SearchSourceBuilder().query((QueryBuilder)query).from(params.getOffset()).size(params.getLimit()).sort(this.getSortFieldName(params.getSortBy()), SortOrder.fromString((String)params.getSortOrder()));
        if (ArrayUtils.isNotEmpty((Object[])this.highlightFields)) {
            this.updateHighlighting(builder);
        }
        this.buildAggregations(builder, siteFacets);
        SearchRequest request = new SearchRequest().source(builder);
        try {
            SearchResponse response = this.elasticsearchService.search(siteId, allowedPaths, request);
            return this.processResults(response, siteFacets);
        }
        catch (IOException e) {
            throw new ServiceLayerException("Error connecting to Elasticsearch", e);
        }
        catch (Exception e) {
            throw new ServiceLayerException("Error executing search in Elasticsearch", e);
        }
    }

    protected void buildAggregations(SearchSourceBuilder builder, Map<String, FacetTO> siteFacets) {
        HashMap<String, FacetTO> mergedFacets = new HashMap<String, FacetTO>(this.facets);
        if (MapUtils.isNotEmpty(siteFacets)) {
            mergedFacets.putAll(siteFacets);
        }
        mergedFacets.forEach((name, facet) -> {
            if (facet.isRange() && facet.isDate()) {
                DateRangeAggregationBuilder aggregation = (DateRangeAggregationBuilder)((DateRangeAggregationBuilder)AggregationBuilders.dateRange((String)name).field(facet.getField())).keyed(true);
                for (FacetRangeTO range : facet.getRanges()) {
                    if (Objects.nonNull(range.getFrom()) && Objects.nonNull(range.getTo())) {
                        aggregation.addRange(range.getLabel(), range.getFrom(), range.getTo());
                        continue;
                    }
                    if (Objects.nonNull(range.getFrom())) {
                        aggregation.addUnboundedFrom(range.getLabel(), range.getFrom());
                        continue;
                    }
                    aggregation.addUnboundedTo(range.getLabel(), range.getTo());
                }
                builder.aggregation((AggregationBuilder)aggregation);
            } else if (facet.isRange()) {
                RangeAggregationBuilder aggregation = (RangeAggregationBuilder)((RangeAggregationBuilder)AggregationBuilders.range((String)name).field(facet.getField())).keyed(true);
                for (FacetRangeTO range : facet.getRanges()) {
                    if (Objects.nonNull(range.getFrom()) && Objects.nonNull(range.getTo())) {
                        aggregation.addRange(range.getLabel(), Double.parseDouble(range.getFrom()), Double.parseDouble(range.getTo()));
                        continue;
                    }
                    if (Objects.nonNull(range.getFrom())) {
                        aggregation.addUnboundedFrom(range.getLabel(), Double.parseDouble(range.getFrom()));
                        continue;
                    }
                    aggregation.addUnboundedTo(range.getLabel(), Double.parseDouble(range.getTo()));
                }
                builder.aggregation((AggregationBuilder)aggregation);
            } else {
                builder.aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)facet.getName()).field(facet.getField())).minDocCount(1L).size(1000));
            }
        });
    }

    protected String getSortFieldName(String name) {
        String field = name;
        if (this.facets.containsKey(field)) {
            field = this.facets.get(field).getField();
        }
        return field;
    }

    private List<SearchFacet> processAggregations(SearchResponse response, Map<String, FacetTO> siteFacets) {
        HashMap<String, FacetTO> mergedFacets = new HashMap<String, FacetTO>(this.facets);
        if (MapUtils.isNotEmpty(siteFacets)) {
            mergedFacets.putAll(siteFacets);
        }
        LinkedList<SearchFacet> facets = new LinkedList<SearchFacet>();
        Aggregations aggregations = response.getAggregations();
        if (aggregations != null) {
            aggregations.getAsMap().forEach((name, aggregation) -> {
                SearchFacet facet = new SearchFacet();
                facet.setName((String)name);
                facet.setMultiple(((FacetTO)mergedFacets.get(name)).isMultiple());
                LinkedHashMap<Object, Object> values = new LinkedHashMap<Object, Object>();
                if (aggregation instanceof Terms) {
                    Terms terms = (Terms)aggregation;
                    for (Terms.Bucket bucket : terms.getBuckets()) {
                        values.put(bucket.getKey(), bucket.getDocCount());
                    }
                } else if (aggregation instanceof Range) {
                    Range range = (Range)aggregation;
                    for (Range.Bucket bucket : range.getBuckets()) {
                        LocalDate date;
                        Instant instant;
                        SearchFacetRange rangeValues = new SearchFacetRange();
                        rangeValues.setCount(bucket.getDocCount());
                        try {
                            instant = Instant.parse(bucket.getFromAsString());
                            date = LocalDateTime.ofInstant(instant, ZoneOffset.UTC).toLocalDate();
                            rangeValues.setFrom(date.toString());
                            facet.setDate(true);
                        }
                        catch (Exception e) {
                            rangeValues.setFrom(bucket.getFrom());
                        }
                        try {
                            instant = Instant.parse(bucket.getToAsString());
                            date = LocalDateTime.ofInstant(instant, ZoneOffset.UTC).toLocalDate();
                            rangeValues.setTo(date.toString());
                            facet.setDate(true);
                        }
                        catch (Exception e) {
                            rangeValues.setTo(bucket.getTo());
                        }
                        values.put(bucket.getKey(), rangeValues);
                    }
                    facet.setRange(true);
                }
                if (MapUtils.isNotEmpty(values)) {
                    facet.setValues(values);
                    facets.add(facet);
                }
            });
        }
        return facets;
    }

    protected String getItemType(Map<String, Object> source) {
        if (MapUtils.isNotEmpty(this.types)) {
            for (HierarchicalConfiguration<ImmutableNode> typeConfig : this.types.values()) {
                String fieldValue;
                String fieldName = typeConfig.getString("field");
                if (!source.containsKey(fieldName) || !StringUtils.isNotEmpty((CharSequence)(fieldValue = source.get(fieldName).toString())) || !fieldValue.matches(typeConfig.getString(CONFIG_KEY_TYPE_MATCHES))) continue;
                return typeConfig.getString("name");
            }
        }
        return this.defaultType;
    }

    protected List<String> getItemSnippets(Map<String, HighlightField> highlights) {
        if (MapUtils.isNotEmpty(highlights)) {
            LinkedList<String> snippets = new LinkedList<String>();
            highlights.values().forEach(highlight -> {
                for (Text text : highlight.getFragments()) {
                    snippets.add(text.string());
                }
            });
            return snippets;
        }
        return null;
    }

    protected String getMimeType(Map<String, Object> source) {
        if (source.containsKey(this.mimeTypeName)) {
            return source.get(this.mimeTypeName).toString();
        }
        return DEFAULT_MIME_TYPE;
    }
}

