/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.security;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.dal.SiteFeed;
import org.craftercms.studio.api.v1.exception.security.AuthenticationSystemException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v2.dal.AuditLog;
import org.craftercms.studio.api.v2.dal.GroupDAO;
import org.craftercms.studio.api.v2.dal.UserDAO;
import org.craftercms.studio.api.v2.service.audit.internal.AuditServiceInternal;
import org.craftercms.studio.api.v2.service.security.AuthenticationChain;
import org.craftercms.studio.api.v2.service.security.AuthenticationProvider;
import org.craftercms.studio.api.v2.service.security.internal.UserServiceInternal;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.impl.v2.service.security.AuthenticationProviderFactory;

public class AuthenticationChainImpl
implements AuthenticationChain {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationChainImpl.class);
    private List<AuthenticationProvider> authenticationChain;
    private UserServiceInternal userServiceInternal;
    private StudioConfiguration studioConfiguration;
    private UserDAO userDao;
    private GroupDAO groupDao;
    private AuditServiceInternal auditServiceInternal;
    private SiteService siteService;

    public void init() {
        List<HierarchicalConfiguration<ImmutableNode>> chainConfig = this.studioConfiguration.getSubConfigs("studio.authentication.chain");
        this.authenticationChain = new ArrayList<AuthenticationProvider>();
        chainConfig.forEach(providerConfig -> {
            AuthenticationProvider provider = AuthenticationProviderFactory.getAuthenticationProvider((HierarchicalConfiguration<ImmutableNode>)providerConfig);
            if (provider != null && provider.isEnabled()) {
                this.authenticationChain.add(provider);
            }
        });
    }

    @Override
    public boolean doAuthenticate(HttpServletRequest request, HttpServletResponse response, String username, String password) throws Exception {
        boolean authenticated = false;
        Iterator<AuthenticationProvider> iterator = this.authenticationChain.iterator();
        Exception lastError = null;
        while (iterator.hasNext()) {
            AuthenticationProvider authProvider = iterator.next();
            if (!authProvider.isEnabled()) continue;
            try {
                authenticated = authProvider.doAuthenticate(request, response, this, username, password);
            }
            catch (Exception e) {
                lastError = e;
            }
            if (!authenticated) continue;
            break;
        }
        String ipAddress = request.getRemoteAddr();
        SiteFeed siteFeed = this.siteService.getSite(this.studioConfiguration.getProperty("studio.configuration.global.systemSite"));
        if (!authenticated) {
            AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
            auditLog.setOperation("LOGIN_FAILED");
            auditLog.setActorId(username);
            auditLog.setSiteId(siteFeed.getId());
            auditLog.setPrimaryTargetId(StringUtils.isEmpty((CharSequence)username) ? "" : username);
            auditLog.setPrimaryTargetType("User");
            auditLog.setPrimaryTargetValue(username);
            this.auditServiceInternal.insertAuditLog(auditLog);
            logger.info("Failed to authenticate user " + username + " logging in from IP: " + ipAddress, new Object[0]);
            if (lastError == null) {
                lastError = new AuthenticationSystemException("Unknown service error");
            }
            throw lastError;
        }
        AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
        auditLog.setOperation("LOGIN");
        auditLog.setActorId(username);
        auditLog.setSiteId(siteFeed.getId());
        auditLog.setPrimaryTargetId(username);
        auditLog.setPrimaryTargetType("User");
        auditLog.setPrimaryTargetValue(username);
        this.auditServiceInternal.insertAuditLog(auditLog);
        logger.info("User " + username + " logged in from IP: " + ipAddress, new Object[0]);
        return authenticated;
    }

    public String getSystemSite() {
        return this.studioConfiguration.getProperty("studio.configuration.global.systemSite");
    }

    @Override
    public UserServiceInternal getUserServiceInternal() {
        return this.userServiceInternal;
    }

    public void setUserServiceInternal(UserServiceInternal userServiceInternal) {
        this.userServiceInternal = userServiceInternal;
    }

    @Override
    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    @Override
    public UserDAO getUserDao() {
        return this.userDao;
    }

    public void setUserDao(UserDAO userDao) {
        this.userDao = userDao;
    }

    @Override
    public GroupDAO getGroupDao() {
        return this.groupDao;
    }

    public void setGroupDao(GroupDAO groupDao) {
        this.groupDao = groupDao;
    }

    @Override
    public AuditServiceInternal getAuditServiceInternal() {
        return this.auditServiceInternal;
    }

    public void setAuditServiceInternal(AuditServiceInternal auditServiceInternal) {
        this.auditServiceInternal = auditServiceInternal;
    }

    @Override
    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }
}

