/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.security;

import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.craftercms.studio.api.v2.service.security.AuthenticationProvider;
import org.craftercms.studio.api.v2.service.security.BaseAuthenticationProvider;
import org.craftercms.studio.impl.v2.service.security.DbAuthenticationProvider;
import org.craftercms.studio.impl.v2.service.security.HeadersAuthenticationProvider;
import org.craftercms.studio.impl.v2.service.security.LdapAuthenticationProvider;

public class AuthenticationProviderFactory {
    private AuthenticationProviderFactory() {
    }

    public static AuthenticationProvider getAuthenticationProvider(HierarchicalConfiguration<ImmutableNode> providerConfig) {
        BaseAuthenticationProvider provider;
        switch (providerConfig.getString("provider").toUpperCase()) {
            case "DB": {
                provider = AuthenticationProviderFactory.createDbAuthenticationProvider(providerConfig);
                break;
            }
            case "LDAP": {
                provider = AuthenticationProviderFactory.createLdapAuthenticationProvider(providerConfig);
                break;
            }
            case "HEADERS": {
                provider = AuthenticationProviderFactory.createHeadersAuthenticationProvider(providerConfig);
                break;
            }
            default: {
                provider = null;
            }
        }
        return provider;
    }

    private static DbAuthenticationProvider createDbAuthenticationProvider(HierarchicalConfiguration<ImmutableNode> providerConfig) {
        DbAuthenticationProvider provider = new DbAuthenticationProvider();
        boolean enabled = providerConfig.getBoolean("enabled");
        provider.setEnabled(enabled);
        return provider;
    }

    private static LdapAuthenticationProvider createLdapAuthenticationProvider(HierarchicalConfiguration<ImmutableNode> providerConfig) {
        LdapAuthenticationProvider provider = new LdapAuthenticationProvider();
        boolean enabled = providerConfig.getBoolean("enabled");
        provider.setEnabled(enabled);
        provider.setLdapUrl(providerConfig.getString("ldapUrl"));
        provider.setLdapUsername(providerConfig.getString("ldapUsername"));
        provider.setLdapPassword(providerConfig.getString("ldapPassword"));
        provider.setLdapBaseContext(providerConfig.getString("ldapBaseContext"));
        provider.setUsernameLdapAttribute(providerConfig.getString("usernameLdapAttribute"));
        provider.setFirstNameLdapAttribute(providerConfig.getString("firstNameLdapAttribute"));
        provider.setLastNameLdapAttribute(providerConfig.getString("lastNameLdapAttribute"));
        provider.setEmailLdapAttribute(providerConfig.getString("emailLdapAttribute"));
        provider.setGroupNameLdapAttribute(providerConfig.getString("groupNameLdapAttribute"));
        provider.setGroupNameLdapAttributeRegex(providerConfig.getString("groupNameLdapAttributeRegex"));
        provider.setGroupNameLdapAttributeMatchIndex(Integer.parseInt(providerConfig.getString("groupNameLdapAttributeMatchIndex")));
        return provider;
    }

    private static HeadersAuthenticationProvider createHeadersAuthenticationProvider(HierarchicalConfiguration<ImmutableNode> providerConfig) {
        HeadersAuthenticationProvider provider = new HeadersAuthenticationProvider();
        boolean enabled = providerConfig.getBoolean("enabled");
        provider.setEnabled(enabled);
        provider.setSecureKeyHeader(providerConfig.getString("secureKeyHeader"));
        provider.setSecureKeyHeaderValue(providerConfig.getString("secureKeyHeaderValue"));
        provider.setUsernameHeader(providerConfig.getString("usernameHeader"));
        provider.setFirstNameHeader(providerConfig.getString("firstNameHeader"));
        provider.setLastNameHeader(providerConfig.getString("lastNameHeader"));
        provider.setEmailHeader(providerConfig.getString("emailHeader"));
        provider.setGroupsHeader(providerConfig.getString("groupsHeader"));
        provider.setLogoutEnabled(providerConfig.getBoolean("logoutEnabled"));
        provider.setLogoutUrl(providerConfig.getString("logoutUrl"));
        return provider;
    }
}

