/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.security;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.craftercms.commons.crypto.CryptoUtils;
import org.craftercms.studio.api.v1.exception.security.AuthenticationSystemException;
import org.craftercms.studio.api.v1.exception.security.BadCredentialsException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.dal.User;
import org.craftercms.studio.api.v2.dal.UserDAO;
import org.craftercms.studio.api.v2.service.security.AuthenticationChain;
import org.craftercms.studio.api.v2.service.security.BaseAuthenticationProvider;
import org.craftercms.studio.impl.v2.service.security.Authentication;
import org.craftercms.studio.model.AuthenticationType;

public class DbAuthenticationProvider
extends BaseAuthenticationProvider {
    private static final Logger logger = LoggerFactory.getLogger(DbAuthenticationProvider.class);

    @Override
    public boolean doAuthenticate(HttpServletRequest request, HttpServletResponse response, AuthenticationChain authenticationChain, String username, String password) throws AuthenticationSystemException, BadCredentialsException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", -1);
        params.put("username", username);
        User user = null;
        UserDAO userDao = authenticationChain.getUserDao();
        try {
            user = userDao.getUserByIdOrUsername(params);
        }
        catch (Exception e) {
            logger.debug("Unknown database error", e);
            throw new AuthenticationSystemException("Unknown database error", e);
        }
        if (user != null && !user.isDeleted() && user.isEnabled() && CryptoUtils.matchPassword((String)user.getPassword(), (String)password)) {
            String token = this.createToken(user, authenticationChain);
            this.storeAuthentication(new Authentication(username, token, AuthenticationType.DB));
            return true;
        }
        throw new BadCredentialsException();
    }
}

