/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.craftercms.commons.security.permissions.DefaultPermission;
import org.craftercms.commons.security.permissions.annotations.HasPermission;
import org.craftercms.studio.api.v1.dal.SiteFeed;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.security.AuthenticationException;
import org.craftercms.studio.api.v1.exception.security.GroupAlreadyExistsException;
import org.craftercms.studio.api.v1.exception.security.GroupNotFoundException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.api.v1.service.GeneralLockService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v2.dal.AuditLog;
import org.craftercms.studio.api.v2.dal.AuditLogParameter;
import org.craftercms.studio.api.v2.dal.Group;
import org.craftercms.studio.api.v2.dal.User;
import org.craftercms.studio.api.v2.exception.OrganizationNotFoundException;
import org.craftercms.studio.api.v2.service.audit.internal.AuditServiceInternal;
import org.craftercms.studio.api.v2.service.config.ConfigurationService;
import org.craftercms.studio.api.v2.service.security.GroupService;
import org.craftercms.studio.api.v2.service.security.UserService;
import org.craftercms.studio.api.v2.service.security.internal.GroupServiceInternal;
import org.craftercms.studio.api.v2.service.security.internal.OrganizationServiceInternal;
import org.craftercms.studio.api.v2.service.security.internal.UserServiceInternal;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;

public class GroupServiceImpl
implements GroupService {
    private ConfigurationService configurationService;
    private GroupServiceInternal groupServiceInternal;
    private OrganizationServiceInternal organizationServiceInternal;
    private UserServiceInternal userServiceInternal;
    private GeneralLockService generalLockService;
    private StudioConfiguration studioConfiguration;
    private UserService userService;
    private AuditServiceInternal auditServiceInternal;
    private SiteService siteService;

    @Override
    @HasPermission(type=DefaultPermission.class, action="read_groups")
    public List<Group> getAllGroups(long orgId, int offset, int limit, String sort) throws ServiceLayerException, OrganizationNotFoundException {
        if (this.organizationServiceInternal.organizationExists(orgId)) {
            return this.groupServiceInternal.getAllGroups(orgId, offset, limit, sort);
        }
        throw new OrganizationNotFoundException();
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="read_groups")
    public int getAllGroupsTotal(long orgId) throws ServiceLayerException, OrganizationNotFoundException {
        if (this.organizationServiceInternal.organizationExists(orgId)) {
            return this.groupServiceInternal.getAllGroupsTotal(orgId);
        }
        throw new OrganizationNotFoundException();
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="create_groups")
    public Group createGroup(long orgId, String groupName, String groupDescription) throws GroupAlreadyExistsException, ServiceLayerException, AuthenticationException {
        Group toRet = this.groupServiceInternal.createGroup(orgId, groupName, groupDescription);
        SiteFeed siteFeed = this.siteService.getSite(this.studioConfiguration.getProperty("studio.configuration.global.systemSite"));
        AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
        auditLog.setOperation("CREATE");
        auditLog.setSiteId(siteFeed.getId());
        auditLog.setActorId(this.userService.getCurrentUser().getUsername());
        auditLog.setPrimaryTargetId(groupName);
        auditLog.setPrimaryTargetType("Group");
        auditLog.setPrimaryTargetValue(groupName);
        this.auditServiceInternal.insertAuditLog(auditLog);
        return toRet;
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="update_groups")
    public Group updateGroup(long orgId, Group group) throws ServiceLayerException, GroupNotFoundException, AuthenticationException {
        Group toRet = this.groupServiceInternal.updateGroup(orgId, group);
        SiteFeed siteFeed = this.siteService.getSite(this.studioConfiguration.getProperty("studio.configuration.global.systemSite"));
        AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
        auditLog.setOperation("UPDATE");
        auditLog.setSiteId(siteFeed.getId());
        auditLog.setActorId(this.userService.getCurrentUser().getUsername());
        auditLog.setPrimaryTargetId(group.getGroupName());
        auditLog.setPrimaryTargetType("Group");
        auditLog.setPrimaryTargetValue(group.getGroupName());
        this.auditServiceInternal.insertAuditLog(auditLog);
        return toRet;
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="delete_groups")
    public void deleteGroup(List<Long> groupIds) throws ServiceLayerException, GroupNotFoundException, AuthenticationException {
        Group sysAdminGroup;
        try {
            sysAdminGroup = this.groupServiceInternal.getGroupByName("system_admin");
        }
        catch (GroupNotFoundException e) {
            throw new ServiceLayerException("The System Admin group is not found", e);
        }
        if (CollectionUtils.isNotEmpty(groupIds) && groupIds.contains(sysAdminGroup.getId())) {
            throw new ServiceLayerException("Deleting the System Admin group is not allowed.");
        }
        List<Group> groups = this.groupServiceInternal.getGroups(groupIds);
        this.groupServiceInternal.deleteGroup(groupIds);
        SiteFeed siteFeed = this.siteService.getSite(this.studioConfiguration.getProperty("studio.configuration.global.systemSite"));
        AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
        auditLog.setOperation("DELETE");
        auditLog.setActorId(this.userService.getCurrentUser().getUsername());
        auditLog.setSiteId(siteFeed.getId());
        auditLog.setPrimaryTargetId(this.studioConfiguration.getProperty("studio.configuration.global.systemSite"));
        auditLog.setPrimaryTargetType("Group");
        auditLog.setPrimaryTargetValue(this.studioConfiguration.getProperty("studio.configuration.global.systemSite"));
        ArrayList<AuditLogParameter> paramters = new ArrayList<AuditLogParameter>();
        for (Group g : groups) {
            AuditLogParameter paramter = new AuditLogParameter();
            paramter.setTargetId(Long.toString(g.getId()));
            paramter.setTargetType("Group");
            paramter.setTargetValue(g.getGroupName());
            paramters.add(paramter);
        }
        auditLog.setParameters(paramters);
        this.auditServiceInternal.insertAuditLog(auditLog);
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="read_groups")
    public Group getGroup(long groupId) throws ServiceLayerException, GroupNotFoundException {
        return this.groupServiceInternal.getGroup(groupId);
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="read_groups")
    public List<User> getGroupMembers(long groupId, int offset, int limit, String sort) throws ServiceLayerException, GroupNotFoundException {
        return this.groupServiceInternal.getGroupMembers(groupId, offset, limit, sort);
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="read_groups")
    public int getGroupMembersTotal(long groupId) throws ServiceLayerException, GroupNotFoundException {
        return this.groupServiceInternal.getGroupMembersTotal(groupId);
    }

    @Override
    @HasPermission(type=DefaultPermission.class, action="update_groups")
    public List<User> addGroupMembers(long groupId, List<Long> userIds, List<String> usernames) throws ServiceLayerException, UserNotFoundException, GroupNotFoundException, AuthenticationException {
        List<User> users = this.groupServiceInternal.addGroupMembers(groupId, userIds, usernames);
        Group group = this.groupServiceInternal.getGroup(groupId);
        SiteFeed siteFeed = this.siteService.getSite(this.studioConfiguration.getProperty("studio.configuration.global.systemSite"));
        AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
        ArrayList<AuditLogParameter> parameters = new ArrayList<AuditLogParameter>();
        for (User user : users) {
            AuditLogParameter parameter = new AuditLogParameter();
            parameter.setTargetId(Long.toString(user.getId()));
            parameter.setTargetType("User");
            parameter.setTargetValue(user.getUsername());
            parameters.add(parameter);
        }
        auditLog.setParameters(parameters);
        auditLog.setOperation("ADD_MEMBERS");
        auditLog.setSiteId(siteFeed.getId());
        auditLog.setActorId(this.userService.getCurrentUser().getUsername());
        auditLog.setPrimaryTargetId(Long.toString(groupId));
        auditLog.setPrimaryTargetType("Group");
        auditLog.setPrimaryTargetValue(group.getGroupName());
        this.auditServiceInternal.insertAuditLog(auditLog);
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @HasPermission(type=DefaultPermission.class, action="update_groups")
    public void removeGroupMembers(long groupId, List<Long> userIds, List<String> usernames) throws ServiceLayerException, UserNotFoundException, GroupNotFoundException, AuthenticationException {
        Group group = this.getGroup(groupId);
        this.generalLockService.lock("remove_system_admin_member_lock");
        try {
            List<User> members;
            if (group.getGroupName().equals("system_admin") && CollectionUtils.isNotEmpty(members = this.getGroupMembers(groupId, 0, Integer.MAX_VALUE, ""))) {
                ArrayList<User> membersAfterRemove = new ArrayList<User>();
                membersAfterRemove.addAll(members);
                members.forEach(m -> {
                    if (CollectionUtils.isNotEmpty((Collection)userIds) && userIds.contains(m.getId())) {
                        membersAfterRemove.remove(m);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)usernames) && usernames.contains(m.getUsername())) {
                        membersAfterRemove.remove(m);
                    }
                });
                if (CollectionUtils.isEmpty(membersAfterRemove)) {
                    throw new ServiceLayerException("Removing all members of the System Admin group is not allowed. We must have at least one system administrator.");
                }
            }
            List<User> users = this.userServiceInternal.getUsersByIdOrUsername(userIds, usernames);
            this.groupServiceInternal.removeGroupMembers(groupId, userIds, usernames);
            SiteFeed siteFeed = this.siteService.getSite(this.studioConfiguration.getProperty("studio.configuration.global.systemSite"));
            AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
            auditLog.setOperation("REMOVE_MEMBERS");
            auditLog.setActorId(this.userService.getCurrentUser().getUsername());
            auditLog.setSiteId(siteFeed.getId());
            auditLog.setPrimaryTargetId(Long.toString(group.getId()));
            auditLog.setPrimaryTargetType("User");
            auditLog.setPrimaryTargetValue(group.getGroupName());
            ArrayList<AuditLogParameter> paramters = new ArrayList<AuditLogParameter>();
            for (User user : users) {
                AuditLogParameter paramter = new AuditLogParameter();
                paramter.setTargetId(Long.toString(user.getId()));
                paramter.setTargetType("User");
                paramter.setTargetValue(user.getUsername());
                paramters.add(paramter);
            }
            auditLog.setParameters(paramters);
            this.auditServiceInternal.insertAuditLog(auditLog);
        }
        finally {
            this.generalLockService.unlock("remove_system_admin_member_lock");
        }
    }

    public GroupServiceInternal getGroupServiceInternal() {
        return this.groupServiceInternal;
    }

    public void setGroupServiceInternal(GroupServiceInternal groupServiceInternal) {
        this.groupServiceInternal = groupServiceInternal;
    }

    public OrganizationServiceInternal getOrganizationServiceInternal() {
        return this.organizationServiceInternal;
    }

    public void setOrganizationServiceInternal(OrganizationServiceInternal organizationServiceInternal) {
        this.organizationServiceInternal = organizationServiceInternal;
    }

    public UserServiceInternal getUserServiceInternal() {
        return this.userServiceInternal;
    }

    public void setUserServiceInternal(UserServiceInternal userServiceInternal) {
        this.userServiceInternal = userServiceInternal;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public GeneralLockService getGeneralLockService() {
        return this.generalLockService;
    }

    public void setGeneralLockService(GeneralLockService generalLockService) {
        this.generalLockService = generalLockService;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public AuditServiceInternal getAuditServiceInternal() {
        return this.auditServiceInternal;
    }

    public void setAuditServiceInternal(AuditServiceInternal auditServiceInternal) {
        this.auditServiceInternal = auditServiceInternal;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }
}

