/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.security;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.studio.api.v1.dal.SiteFeed;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.exception.security.AuthenticationSystemException;
import org.craftercms.studio.api.v1.exception.security.UserAlreadyExistsException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v2.dal.AuditLog;
import org.craftercms.studio.api.v2.dal.Group;
import org.craftercms.studio.api.v2.dal.GroupDAO;
import org.craftercms.studio.api.v2.dal.User;
import org.craftercms.studio.api.v2.dal.UserDAO;
import org.craftercms.studio.api.v2.dal.UserGroup;
import org.craftercms.studio.api.v2.service.audit.internal.AuditServiceInternal;
import org.craftercms.studio.api.v2.service.security.AuthenticationChain;
import org.craftercms.studio.api.v2.service.security.BaseAuthenticationProvider;
import org.craftercms.studio.api.v2.service.security.internal.UserServiceInternal;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.impl.v2.service.security.Authentication;
import org.craftercms.studio.model.AuthenticationType;

public class HeadersAuthenticationProvider
extends BaseAuthenticationProvider {
    private static final Logger logger = LoggerFactory.getLogger(HeadersAuthenticationProvider.class);
    private String secureKeyHeader;
    private String secureKeyHeaderValue;
    private String usernameHeader;
    private String firstNameHeader;
    private String lastNameHeader;
    private String emailHeader;
    private String groupsHeader;
    private boolean logoutEnabled;
    private String logoutUrl;

    @Override
    public boolean doAuthenticate(HttpServletRequest request, HttpServletResponse response, AuthenticationChain authenticationChain, String username, String password) throws AuthenticationSystemException, UserNotFoundException {
        if (this.isEnabled()) {
            logger.debug("Authenticating user using authentication headers.", new Object[0]);
            RequestContext requestContext = RequestContext.getCurrent();
            if (requestContext != null) {
                String securekeyHeader = request.getHeader(this.secureKeyHeader);
                logger.debug("Verifying authentication header secure key.", new Object[0]);
                if (StringUtils.equals((CharSequence)securekeyHeader, (CharSequence)this.secureKeyHeaderValue)) {
                    String groups;
                    String email;
                    String lastName;
                    String firstName;
                    String usernameHeaderValue;
                    block16: {
                        usernameHeaderValue = request.getHeader(this.usernameHeader);
                        firstName = request.getHeader(this.firstNameHeader);
                        lastName = request.getHeader(this.lastNameHeader);
                        email = request.getHeader(this.emailHeader);
                        groups = request.getHeader(this.groupsHeader);
                        try {
                            AuditLog auditLog;
                            User user;
                            UserServiceInternal userServiceInternal = authenticationChain.getUserServiceInternal();
                            AuditServiceInternal auditServiceInternal = authenticationChain.getAuditServiceInternal();
                            StudioConfiguration studioConfiguration = authenticationChain.getStudioConfiguration();
                            SiteService siteService = authenticationChain.getSiteService();
                            SiteFeed siteFeed = siteService.getSite(studioConfiguration.getProperty("studio.configuration.global.systemSite"));
                            if (userServiceInternal.userExists(-1L, usernameHeaderValue)) {
                                user = userServiceInternal.getUserByIdOrUsername(-1L, usernameHeaderValue);
                                user.setFirstName(firstName);
                                user.setLastName(lastName);
                                user.setEmail(email);
                                if (!StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{firstName, lastName, email})) break block16;
                                logger.debug("If user already exists in studio DB, update details.", new Object[0]);
                                try {
                                    userServiceInternal.updateUser(user);
                                    auditLog = auditServiceInternal.createAuditLogEntry();
                                    auditLog.setOperation("UPDATE");
                                    auditLog.setActorId(usernameHeaderValue);
                                    auditLog.setSiteId(siteFeed.getId());
                                    auditLog.setPrimaryTargetId(usernameHeaderValue);
                                    auditLog.setPrimaryTargetType("User");
                                    auditLog.setPrimaryTargetValue(user.getUsername());
                                    auditServiceInternal.insertAuditLog(auditLog);
                                    break block16;
                                }
                                catch (Exception e) {
                                    logger.debug("Error updating user " + usernameHeaderValue + " with data from authentication headers", e);
                                    throw new AuthenticationSystemException("Error updating user " + usernameHeaderValue + " with data from external authentication provider", e);
                                }
                            }
                            logger.debug("User does not exist in studio db. Adding user " + this.usernameHeader, new Object[0]);
                            try {
                                user = new User();
                                user.setUsername(usernameHeaderValue);
                                user.setPassword(UUID.randomUUID().toString());
                                user.setFirstName(firstName);
                                user.setLastName(lastName);
                                user.setEmail(email);
                                user.setExternallyManaged(true);
                                user.setEnabled(true);
                                userServiceInternal.createUser(user);
                                auditLog = auditServiceInternal.createAuditLogEntry();
                                auditLog.setOperation("CREATE");
                                auditLog.setSiteId(siteFeed.getId());
                                auditLog.setActorId(usernameHeaderValue);
                                auditLog.setPrimaryTargetId(usernameHeaderValue);
                                auditLog.setPrimaryTargetType("User");
                                auditLog.setPrimaryTargetValue(user.getUsername());
                                auditServiceInternal.insertAuditLog(auditLog);
                            }
                            catch (ServiceLayerException | UserAlreadyExistsException e) {
                                logger.debug("Error adding user " + usernameHeaderValue + " from authentication headers", e);
                                throw new AuthenticationSystemException("Error adding user " + usernameHeaderValue + " from external authentication provider", e);
                            }
                        }
                        catch (ServiceLayerException e) {
                            logger.debug("Unknown service error", e);
                            throw new AuthenticationSystemException("Unknown service error", e);
                        }
                    }
                    User user = new User();
                    user.setUsername(usernameHeaderValue);
                    user.setFirstName(firstName);
                    user.setLastName(lastName);
                    user.setEmail(email);
                    user.setGroups(new ArrayList<UserGroup>());
                    logger.debug("Update user groups in database.", new Object[0]);
                    if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{groups})) {
                        String[] groupsArray = groups.split(",");
                        for (int i = 0; i < groupsArray.length; ++i) {
                            Group g = new Group();
                            try {
                                g.setGroupName(StringUtils.trim((String)groupsArray[i]));
                                g.setGroupDescription("Externally managed group");
                                g.setOrganization(null);
                                UserGroup ug = new UserGroup();
                                ug.setGroup(g);
                                user.getGroups().add(ug);
                                this.upsertUserGroup(g.getGroupName(), usernameHeaderValue, authenticationChain);
                                continue;
                            }
                            catch (Exception e) {
                                logger.debug("Error updating user group " + g.getGroupName() + " with data from authentication headers", e);
                            }
                        }
                    }
                    String token = this.createToken(user, authenticationChain);
                    if (this.isLogoutEnabled()) {
                        this.storeAuthentication(new Authentication(usernameHeaderValue, token, AuthenticationType.AUTH_HEADERS, this.logoutUrl));
                    } else {
                        this.storeAuthentication(new Authentication(usernameHeaderValue, token, AuthenticationType.AUTH_HEADERS));
                    }
                    return true;
                }
            }
            logger.debug("Unable to authenticate user using authentication headers", new Object[0]);
            return false;
        }
        logger.debug("Authentication using headers disabled", new Object[0]);
        return false;
    }

    protected boolean upsertUserGroup(String groupName, String username, AuthenticationChain authenticationChain) throws SiteNotFoundException {
        HashMap<String, Object> params;
        GroupDAO groupDao = authenticationChain.getGroupDao();
        UserDAO userDao = authenticationChain.getUserDao();
        AuditServiceInternal auditServiceInternal = authenticationChain.getAuditServiceInternal();
        SiteService siteService = authenticationChain.getSiteService();
        StudioConfiguration studioConfiguration = authenticationChain.getStudioConfiguration();
        SiteFeed siteFeed = siteService.getSite(studioConfiguration.getProperty("studio.configuration.global.systemSite"));
        try {
            params = new HashMap<String, Object>();
            params.put("orgId", 1);
            params.put("groupName", groupName);
            params.put("groupDescription", "Externally managed group - " + groupName);
            groupDao.createGroup(params);
        }
        catch (Exception e) {
            logger.debug("Error creating group", e);
        }
        params = new HashMap();
        params.put("groupName", groupName);
        Group group = groupDao.getGroupByName(params);
        if (group != null) {
            ArrayList usernames = new ArrayList();
            params = new HashMap();
            params.put("userId", -1);
            params.put("username", username);
            User user = userDao.getUserByIdOrUsername(params);
            ArrayList<Long> users = new ArrayList<Long>();
            users.add(user.getId());
            params = new HashMap();
            params.put("userIds", users);
            params.put("groupId", group.getId());
            try {
                groupDao.addGroupMembers(params);
                AuditLog auditLog = auditServiceInternal.createAuditLogEntry();
                auditLog.setOperation("ADD_MEMBERS");
                auditLog.setSiteId(siteFeed.getId());
                auditLog.setActorId(username);
                auditLog.setPrimaryTargetId(group.getGroupName() + ":" + user.getUsername());
                auditLog.setPrimaryTargetType("User");
                auditLog.setPrimaryTargetValue(user.getUsername());
                auditServiceInternal.insertAuditLog(auditLog);
            }
            catch (Exception e) {
                logger.debug("Unknown database error", e);
            }
        }
        return true;
    }

    public String getSecureKeyHeader() {
        return this.secureKeyHeader;
    }

    public void setSecureKeyHeader(String secureKeyHeader) {
        this.secureKeyHeader = secureKeyHeader;
    }

    public String getSecureKeyHeaderValue() {
        return this.secureKeyHeaderValue;
    }

    public void setSecureKeyHeaderValue(String secureKeyHeaderValue) {
        this.secureKeyHeaderValue = secureKeyHeaderValue;
    }

    public String getUsernameHeader() {
        return this.usernameHeader;
    }

    public void setUsernameHeader(String usernameHeader) {
        this.usernameHeader = usernameHeader;
    }

    public String getFirstNameHeader() {
        return this.firstNameHeader;
    }

    public void setFirstNameHeader(String firstNameHeader) {
        this.firstNameHeader = firstNameHeader;
    }

    public String getLastNameHeader() {
        return this.lastNameHeader;
    }

    public void setLastNameHeader(String lastNameHeader) {
        this.lastNameHeader = lastNameHeader;
    }

    public String getEmailHeader() {
        return this.emailHeader;
    }

    public void setEmailHeader(String emailHeader) {
        this.emailHeader = emailHeader;
    }

    public String getGroupsHeader() {
        return this.groupsHeader;
    }

    public void setGroupsHeader(String groupsHeader) {
        this.groupsHeader = groupsHeader;
    }

    public boolean isLogoutEnabled() {
        return this.logoutEnabled;
    }

    public void setLogoutEnabled(boolean logoutEnabled) {
        this.logoutEnabled = logoutEnabled;
    }

    public String geLogoutUrl() {
        return this.logoutUrl;
    }

    public void setLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
    }
}

