/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.security;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.dal.SiteFeed;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.security.AuthenticationSystemException;
import org.craftercms.studio.api.v1.exception.security.BadCredentialsException;
import org.craftercms.studio.api.v1.exception.security.UserAlreadyExistsException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v2.dal.AuditLog;
import org.craftercms.studio.api.v2.dal.Group;
import org.craftercms.studio.api.v2.dal.GroupDAO;
import org.craftercms.studio.api.v2.dal.User;
import org.craftercms.studio.api.v2.dal.UserDAO;
import org.craftercms.studio.api.v2.dal.UserGroup;
import org.craftercms.studio.api.v2.service.audit.internal.AuditServiceInternal;
import org.craftercms.studio.api.v2.service.security.AuthenticationChain;
import org.craftercms.studio.api.v2.service.security.BaseAuthenticationProvider;
import org.craftercms.studio.api.v2.service.security.internal.UserServiceInternal;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.impl.v2.service.security.Authentication;
import org.craftercms.studio.model.AuthenticationType;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.ldap.AuthenticationException;
import org.springframework.ldap.CommunicationException;
import org.springframework.ldap.core.AuthenticatedLdapEntryContextMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.DefaultDirObjectFactory;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.query.ContainerCriteria;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;

public class LdapAuthenticationProvider
extends BaseAuthenticationProvider {
    private static final Logger logger = LoggerFactory.getLogger(LdapAuthenticationProvider.class);
    private String ldapUrl;
    private String ldapPassword;
    private String ldapUsername;
    private String ldapBaseContext;
    private String usernameLdapAttribute;
    private String firstNameLdapAttribute;
    private String lastNameLdapAttribute;
    private String groupNameLdapAttribute;
    private String groupNameLdapAttributeRegex;
    private int groupNameLdapAttributeMatchIndex;
    private String emailLdapAttribute;

    @Override
    public boolean doAuthenticate(HttpServletRequest request, HttpServletResponse response, AuthenticationChain authenticationChain, String username, String password) throws AuthenticationSystemException, BadCredentialsException {
        User user;
        LdapContextSource lcs = new LdapContextSource();
        lcs.setUrl(this.ldapUrl);
        lcs.setUserDn(this.ldapUsername);
        lcs.setPassword(this.ldapPassword);
        lcs.setBase(this.ldapBaseContext);
        lcs.setDirObjectFactory(DefaultDirObjectFactory.class);
        lcs.afterPropertiesSet();
        LdapTemplate ldapTemplate = new LdapTemplate((ContextSource)lcs);
        AuthenticatedLdapEntryContextMapper mapper = (dirContext, ldapEntryIdentification) -> {
            try {
                DirContextOperations dirContextOperations = (DirContextOperations)dirContext.lookup(ldapEntryIdentification.getRelativeName());
                Attributes attributes = dirContextOperations.getAttributes();
                Attribute emailAttrib = attributes.get(this.emailLdapAttribute);
                Attribute firstNameAttrib = attributes.get(this.firstNameLdapAttribute);
                Attribute lastNameAttrib = attributes.get(this.lastNameLdapAttribute);
                Attribute groupNameAttrib = attributes.get(this.groupNameLdapAttribute);
                User user = new User();
                user.setEnabled(true);
                user.setExternallyManaged(true);
                user.setUsername(username);
                user.setPassword(UUID.randomUUID().toString());
                if (emailAttrib == null || emailAttrib.get() == null) {
                    logger.warn("No LDAP attribute " + this.emailLdapAttribute + " found for username " + username + ". User will not be imported into DB.", new Object[0]);
                    return null;
                }
                user.setEmail(emailAttrib.get().toString());
                if (firstNameAttrib != null && firstNameAttrib.get() != null) {
                    user.setFirstName(firstNameAttrib.get().toString());
                } else {
                    logger.warn("No LDAP attribute " + this.firstNameLdapAttribute + " found for username " + username, new Object[0]);
                }
                if (lastNameAttrib != null && lastNameAttrib.get() != null) {
                    user.setLastName(lastNameAttrib.get().toString());
                } else {
                    logger.warn("No LDAP attribute " + this.lastNameLdapAttribute + " found for username " + username, new Object[0]);
                }
                this.extractGroupsFromAttribute(user, this.groupNameLdapAttribute, groupNameAttrib);
                return user;
            }
            catch (NamingException e) {
                logger.debug("Error getting details from LDAP for username " + username, e);
                return null;
            }
        };
        ContainerCriteria ldapQuery = LdapQueryBuilder.query().where(this.usernameLdapAttribute).is(username);
        try {
            user = (User)ldapTemplate.authenticate((LdapQuery)ldapQuery, password, mapper);
        }
        catch (EmptyResultDataAccessException e) {
            logger.debug("User " + username + " not found with external security provider.", new Object[0]);
            return false;
        }
        catch (CommunicationException e) {
            logger.debug("Failed to connect with external security provider", new Object[]{e});
            return false;
        }
        catch (AuthenticationException e) {
            logger.debug("Authentication failed with the LDAP system (bad credentials)", new Object[]{e});
            throw new BadCredentialsException();
        }
        catch (Exception e) {
            logger.debug("Unexpected exception when authenticating with the LDAP system", e);
            return false;
        }
        if (user != null) {
            block14: {
                UserServiceInternal userServiceInternal = authenticationChain.getUserServiceInternal();
                AuditServiceInternal auditServiceInternal = authenticationChain.getAuditServiceInternal();
                StudioConfiguration studioConfiguration = authenticationChain.getStudioConfiguration();
                SiteService siteService = authenticationChain.getSiteService();
                try {
                    AuditLog auditLog;
                    SiteFeed siteFeed = siteService.getSite(studioConfiguration.getProperty("studio.configuration.global.systemSite"));
                    if (userServiceInternal.userExists(-1L, username)) {
                        try {
                            userServiceInternal.updateUser(user);
                        }
                        catch (UserNotFoundException e) {
                            throw new IllegalStateException(e);
                        }
                        auditLog = auditServiceInternal.createAuditLogEntry();
                        auditLog.setOperation("UPDATE");
                        auditLog.setSiteId(siteFeed.getId());
                        auditLog.setActorId(user.getUsername());
                        auditLog.setPrimaryTargetId(user.getUsername());
                        auditLog.setPrimaryTargetType("User");
                        auditLog.setPrimaryTargetValue(user.getUsername());
                        auditServiceInternal.insertAuditLog(auditLog);
                        break block14;
                    }
                    try {
                        userServiceInternal.createUser(user);
                        auditLog = auditServiceInternal.createAuditLogEntry();
                        auditLog.setOperation("CREATE");
                        auditLog.setSiteId(siteFeed.getId());
                        auditLog.setActorId(user.getUsername());
                        auditLog.setPrimaryTargetId(user.getUsername());
                        auditLog.setPrimaryTargetType("User");
                        auditLog.setPrimaryTargetValue(user.getUsername());
                        auditServiceInternal.insertAuditLog(auditLog);
                    }
                    catch (UserAlreadyExistsException e) {
                        logger.debug("Error adding user " + username + " from external authentication provider", e);
                        throw new AuthenticationSystemException("Error adding user " + username + " from external authentication provider", e);
                    }
                }
                catch (ServiceLayerException e) {
                    logger.debug("Unknown service error", e);
                    throw new AuthenticationSystemException("Unknown service error", e);
                }
            }
            for (UserGroup userGroup : user.getGroups()) {
                this.upsertUserGroup(userGroup.getGroup().getGroupName(), user.getUsername(), authenticationChain);
            }
            String token = this.createToken(user, authenticationChain);
            this.storeAuthentication(new Authentication(username, token, AuthenticationType.LDAP));
            return true;
        }
        logger.debug("Failed to retrieve LDAP user details", new Object[0]);
        throw new AuthenticationSystemException("Failed to retrieve LDAP user details");
    }

    private void extractGroupsFromAttribute(User user, String groupNameAttribName, Attribute groupNameAttrib) throws NamingException {
        if (groupNameAttrib != null && groupNameAttrib.size() > 0) {
            NamingEnumeration<?> groupAttribValues = groupNameAttrib.getAll();
            while (groupAttribValues.hasMore()) {
                String groupName;
                Object groupNameObj = groupAttribValues.next();
                if (groupNameObj == null || !StringUtils.isNotEmpty((CharSequence)(groupName = this.extractGroupNameFromAttributeValue(groupNameObj.toString())))) continue;
                this.addGroupToUser(user, groupName);
            }
        } else {
            logger.debug("No LDAP attribute " + groupNameAttribName + " found for username " + user.getUsername(), new Object[0]);
        }
    }

    private String extractGroupNameFromAttributeValue(String groupAttributeValue) {
        Pattern pattern = Pattern.compile(this.groupNameLdapAttributeRegex);
        Matcher matcher = pattern.matcher(groupAttributeValue);
        if (matcher.matches()) {
            return matcher.group(this.groupNameLdapAttributeMatchIndex);
        }
        return "";
    }

    private void addGroupToUser(User user, String groupName) {
        Group group = new Group();
        group.setGroupName(groupName);
        group.setGroupDescription("Externally managed group");
        group.setOrganization(null);
        UserGroup userGroup = new UserGroup();
        userGroup.setGroup(group);
        if (user.getGroups() == null) {
            user.setGroups(new ArrayList<UserGroup>());
        }
        user.getGroups().add(userGroup);
    }

    protected boolean upsertUserGroup(String groupName, String username, AuthenticationChain authenticationChain) {
        HashMap<String, Object> params;
        UserDAO userDao = authenticationChain.getUserDao();
        GroupDAO groupDao = authenticationChain.getGroupDao();
        AuditServiceInternal auditServiceInternal = authenticationChain.getAuditServiceInternal();
        SiteService siteService = authenticationChain.getSiteService();
        StudioConfiguration studioConfiguration = authenticationChain.getStudioConfiguration();
        try {
            params = new HashMap<String, Object>();
            params.put("orgId", 1);
            params.put("groupName", groupName);
            params.put("groupDescription", "Externally managed group - " + groupName);
            groupDao.createGroup(params);
        }
        catch (Exception e) {
            logger.warn("Error creating group", e);
        }
        params = new HashMap();
        params.put("groupName", groupName);
        Group group = groupDao.getGroupByName(params);
        if (group != null) {
            params = new HashMap();
            params.put("userId", -1);
            params.put("username", username);
            User user = userDao.getUserByIdOrUsername(params);
            ArrayList<Long> users = new ArrayList<Long>();
            users.add(user.getId());
            params = new HashMap();
            params.put("userIds", users);
            params.put("groupId", group.getId());
            try {
                groupDao.addGroupMembers(params);
                SiteFeed siteFeed = siteService.getSite(studioConfiguration.getProperty("studio.configuration.global.systemSite"));
                AuditLog auditLog = auditServiceInternal.createAuditLogEntry();
                auditLog.setOperation("ADD_MEMBERS");
                auditLog.setActorId(user.getUsername());
                auditLog.setSiteId(siteFeed.getId());
                auditLog.setPrimaryTargetId(group.getGroupName() + ":" + user.getUsername());
                auditLog.setPrimaryTargetType("User");
                auditLog.setPrimaryTargetValue(user.getUsername());
                auditServiceInternal.insertAuditLog(auditLog);
            }
            catch (Exception e) {
                logger.debug("Unknown database error", e);
            }
        }
        return true;
    }

    public String getLdapUrl() {
        return this.ldapUrl;
    }

    public void setLdapUrl(String ldapUrl) {
        this.ldapUrl = ldapUrl;
    }

    public String getLdapPassword() {
        return this.ldapPassword;
    }

    public void setLdapPassword(String ldapPassword) {
        this.ldapPassword = ldapPassword;
    }

    public String getLdapUsername() {
        return this.ldapUsername;
    }

    public void setLdapUsername(String ldapUsername) {
        this.ldapUsername = ldapUsername;
    }

    public String getLdapBaseContext() {
        return this.ldapBaseContext;
    }

    public void setLdapBaseContext(String ldapBaseContext) {
        this.ldapBaseContext = ldapBaseContext;
    }

    public String getUsernameLdapAttribute() {
        return this.usernameLdapAttribute;
    }

    public void setUsernameLdapAttribute(String usernameLdapAttribute) {
        this.usernameLdapAttribute = usernameLdapAttribute;
    }

    public String getFirstNameLdapAttribute() {
        return this.firstNameLdapAttribute;
    }

    public void setFirstNameLdapAttribute(String firstNameLdapAttribute) {
        this.firstNameLdapAttribute = firstNameLdapAttribute;
    }

    public String getLastNameLdapAttribute() {
        return this.lastNameLdapAttribute;
    }

    public void setLastNameLdapAttribute(String lastNameLdapAttribute) {
        this.lastNameLdapAttribute = lastNameLdapAttribute;
    }

    public String getGroupNameLdapAttribute() {
        return this.groupNameLdapAttribute;
    }

    public void setGroupNameLdapAttribute(String groupNameLdapAttribute) {
        this.groupNameLdapAttribute = groupNameLdapAttribute;
    }

    public String getGroupNameLdapAttributeRegex() {
        return this.groupNameLdapAttributeRegex;
    }

    public void setGroupNameLdapAttributeRegex(String groupNameLdapAttributeRegex) {
        this.groupNameLdapAttributeRegex = groupNameLdapAttributeRegex;
    }

    public int getGroupNameLdapAttributeMatchIndex() {
        return this.groupNameLdapAttributeMatchIndex;
    }

    public void setGroupNameLdapAttributeMatchIndex(int groupNameLdapAttributeMatchIndex) {
        this.groupNameLdapAttributeMatchIndex = groupNameLdapAttributeMatchIndex;
    }

    public String getEmailLdapAttribute() {
        return this.emailLdapAttribute;
    }

    public void setEmailLdapAttribute(String emailLdapAttribute) {
        this.emailLdapAttribute = emailLdapAttribute;
    }
}

