/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.service.security;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v2.dal.Group;
import org.craftercms.studio.api.v2.dal.User;
import org.craftercms.studio.api.v2.dal.UserGroup;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.schema.XSString;
import org.opensaml.xml.schema.impl.XSAnyImpl;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.saml.SAMLCredential;
import org.springframework.security.saml.userdetails.SAMLUserDetailsService;

public class StudioSAMLUserDetailsServiceImpl
implements SAMLUserDetailsService {
    private String emailAttributeName = "email";
    private String firstNameAttributeName = "givenName";
    private String lastNameAttributeName = "surname";
    private String groupAttributeName = "Role";

    public Object loadUserBySAML(SAMLCredential samlCredential) throws UsernameNotFoundException {
        User user = new User();
        user.setUsername(samlCredential.getNameID().getValue());
        user.setGroups(new ArrayList<UserGroup>());
        samlCredential.getAttributes().forEach(attrib -> {
            if (StringUtils.equalsIgnoreCase((CharSequence)attrib.getFriendlyName(), (CharSequence)this.firstNameAttributeName) || StringUtils.equalsIgnoreCase((CharSequence)attrib.getName(), (CharSequence)this.firstNameAttributeName)) {
                user.setFirstName(this.getAttributeValue((Attribute)attrib));
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)attrib.getFriendlyName(), (CharSequence)this.lastNameAttributeName) || StringUtils.equalsIgnoreCase((CharSequence)attrib.getName(), (CharSequence)this.lastNameAttributeName)) {
                user.setLastName(this.getAttributeValue((Attribute)attrib));
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)attrib.getFriendlyName(), (CharSequence)this.emailAttributeName) || StringUtils.equalsIgnoreCase((CharSequence)attrib.getName(), (CharSequence)this.emailAttributeName)) {
                user.setEmail(this.getAttributeValue((Attribute)attrib));
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)attrib.getFriendlyName(), (CharSequence)this.groupAttributeName) || StringUtils.equalsIgnoreCase((CharSequence)attrib.getName(), (CharSequence)this.groupAttributeName)) {
                Group g = new Group();
                g.setGroupName(this.getAttributeValue((Attribute)attrib));
                g.setGroupDescription("Externally managed group");
                g.setOrganization(null);
                UserGroup ug = new UserGroup();
                ug.setGroup(g);
                user.getGroups().add(ug);
            }
        });
        user.setExternallyManaged(true);
        user.setEnabled(true);
        return user;
    }

    private String getAttributeValue(Attribute attribute) {
        XMLObject attributeValue;
        List attributeValues = attribute.getAttributeValues();
        String toRet = null;
        if (!attributeValues.isEmpty() && (attributeValue = (XMLObject)attributeValues.get(0)) != null) {
            toRet = attributeValue instanceof XSString ? this.getStringAttributeValue((XSString)attributeValue) : (attributeValue instanceof XSAnyImpl ? this.getAnyAttributeValue((XSAnyImpl)attributeValue) : attributeValue.toString());
        }
        return toRet;
    }

    private String getStringAttributeValue(XSString attributeValue) {
        return attributeValue.getValue();
    }

    private String getAnyAttributeValue(XSAnyImpl attributeValue) {
        return attributeValue.getTextContent();
    }

    public String getEmailAttributeName() {
        return this.emailAttributeName;
    }

    public void setEmailAttributeName(String emailAttributeName) {
        this.emailAttributeName = emailAttributeName;
    }

    public String getFirstNameAttributeName() {
        return this.firstNameAttributeName;
    }

    public void setFirstNameAttributeName(String firstNameAttributeName) {
        this.firstNameAttributeName = firstNameAttributeName;
    }

    public String getLastNameAttributeName() {
        return this.lastNameAttributeName;
    }

    public void setLastNameAttributeName(String lastNameAttributeName) {
        this.lastNameAttributeName = lastNameAttributeName;
    }

    public String getGroupAttributeName() {
        return this.groupAttributeName;
    }

    public void setGroupAttributeName(String groupAttributeName) {
        this.groupAttributeName = groupAttributeName;
    }
}

